/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules;

import com.intellij.internal.statistic.eventLog.validator.rules.ValidationError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class EventContext {
    public final String eventId;
    public final Map<String, Object> eventData;
    public final Map<String, Object> myPayload = new HashMap<String, Object>();
    private List<ValidationError> myErrors = null;
    private final boolean myCollectErrors;

    private EventContext(@NotNull String eventId, @NotNull Map<String, Object> eventData, boolean myCollectErrors) {
        this.eventId = eventId;
        this.eventData = EventContext.unmodifiableOrEmptyMap(eventData);
        this.myCollectErrors = myCollectErrors;
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, Object> unmodifiableOrEmptyMap(@NotNull Map<String, Object> original) {
        int size = original.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(original);
    }

    public static EventContext create(@NotNull String eventId, @NotNull Map<String, Object> eventData) {
        return EventContext.create(eventId, eventData, false);
    }

    public static EventContext create(@NotNull String eventId, @NotNull Map<String, Object> eventData, boolean collectErrors) {
        return new EventContext(eventId, eventData, collectErrors);
    }

    public void addError(@NotNull ValidationError validationError) {
        if (!this.myCollectErrors) {
            return;
        }
        if (this.myErrors == null) {
            this.myErrors = new ArrayList<ValidationError>();
        }
        this.myErrors.add(validationError);
    }
}

