/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.validator.GroupValidators;
import com.intellij.internal.statistic.eventLog.validator.ValidationRuleStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRulesFactory;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public class SimpleValidationRuleStorage<T extends Comparable<? super T>>
implements ValidationRuleStorage<T> {
    @NotNull
    private final EventLogBuildParser<T> buildParser;
    @NotNull
    private final List<String> excludedFields;
    @NotNull
    private final ValidationSimpleRuleFactory validationRuleFactory;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<String, EventGroupRules> eventsValidators;
    private EventGroupsFilterRules<T> filterRules;
    private RecorderDataValidationRule clientDataValidators;
    private RecorderDataValidationRule systemDataValidators;
    private RecorderDataValidationRule idsValidators;

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser, @NotNull List<String> excludedFields, @NotNull UtilRuleProducer utilRulesProducer) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        Intrinsics.checkNotNullParameter(excludedFields, (String)"excludedFields");
        Intrinsics.checkNotNullParameter((Object)utilRulesProducer, (String)"utilRulesProducer");
        this.buildParser = buildParser;
        this.excludedFields = excludedFields;
        this.validationRuleFactory = new ValidationSimpleRuleFactory(utilRulesProducer);
        this.lock = new Object();
        this.eventsValidators = new HashMap();
        this.internalUpdate(initialMetadata);
    }

    public /* synthetic */ SimpleValidationRuleStorage(EventGroupRemoteDescriptors eventGroupRemoteDescriptors, EventLogBuildParser eventLogBuildParser, List list2, UtilRuleProducer utilRuleProducer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            UtilRuleProducer utilRuleProducer2 = ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER;
            Intrinsics.checkNotNullExpressionValue((Object)utilRuleProducer2, (String)"REJECTING_UTIL_URL_PRODUCER");
            utilRuleProducer = utilRuleProducer2;
        }
        this(eventGroupRemoteDescriptors, eventLogBuildParser, list2, utilRuleProducer);
    }

    public void update(@NotNull EventGroupRemoteDescriptors metadata2) {
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        this.internalUpdate(metadata2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GroupValidators<T> getGroupValidators(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            EventGroupsFilterRules<T> eventGroupsFilterRules = this.filterRules;
            if (eventGroupsFilterRules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filterRules");
                eventGroupsFilterRules = null;
            }
            GroupValidators<T> groupValidators = new GroupValidators<T>(this.eventsValidators.get(groupId), eventGroupsFilterRules);
            return groupValidators;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalUpdate(EventGroupRemoteDescriptors descriptors) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.eventsValidators.clear();
            this.eventsValidators.putAll(this.createValidators(descriptors, this.validationRuleFactory, this.excludedFields));
            EventGroupsFilterRules<T> eventGroupsFilterRules = EventGroupsFilterRules.create(descriptors, this.buildParser);
            Intrinsics.checkNotNullExpressionValue(eventGroupsFilterRules, (String)"create(descriptors, buildParser)");
            this.filterRules = eventGroupsFilterRules;
            this.clientDataValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, descriptors.client_data, descriptors.rules);
            this.systemDataValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, descriptors.system_data, descriptors.rules);
            this.idsValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, descriptors.ids, descriptors.rules);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isUnreachable() {
        return false;
    }
}

