/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.CoroutineDumperKt;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JobRepresentation {
    @Nullable
    private final String coroutineName;
    @NotNull
    private final String job;
    @Nullable
    private final String state;
    @Nullable
    private final String context;
    @NotNull
    private final List<StackTraceElement> trace;

    public JobRepresentation(@Nullable String coroutineName, @NotNull String job2, @Nullable String state2, @Nullable String context2, @NotNull List<StackTraceElement> trace) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        Intrinsics.checkNotNullParameter(trace, (String)"trace");
        this.coroutineName = coroutineName;
        this.job = job2;
        this.state = state2;
        this.context = context2;
        this.trace = trace;
    }

    @Nullable
    public final String getCoroutineName() {
        return this.coroutineName;
    }

    @NotNull
    public final String getJob() {
        return this.job;
    }

    @Nullable
    public final String getState() {
        return this.state;
    }

    @Nullable
    public final String getContext() {
        return this.context;
    }

    @NotNull
    public final List<StackTraceElement> getTrace() {
        return this.trace;
    }

    private final void indent(Appendable out, int level) {
        out.append(StringsKt.repeat((CharSequence)"\t", (int)level));
    }

    private final void writeHeader(Appendable out, int level, String additionalInfo) {
        String it;
        this.indent(out, level);
        out.append('-' + additionalInfo + ' ');
        String string = this.coroutineName;
        if (string != null) {
            it = string;
            boolean bl = false;
            out.append('\"' + it + "\":");
        }
        out.append(this.job);
        String string2 = this.state;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            out.append(", state: " + it);
        }
        String string3 = this.context;
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            out.append(" [" + it + ']');
        }
        CoroutineDumperKt.access$appendOsLine(out);
    }

    private final void writeTrace(Appendable out, int level) {
        for (StackTraceElement stackFrame : this.trace) {
            this.indent(out, level);
            CoroutineDumperKt.access$appendOsLine(out, "\tat " + stackFrame);
        }
    }

    public final void write(@NotNull Appendable out, int level, @NotNull String additionalInfo) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)additionalInfo, (String)"additionalInfo");
        this.writeHeader(out, level, additionalInfo);
        this.writeTrace(out, level);
    }

    @NotNull
    public String toString() {
        return "JobRepresentation(coroutineName=" + this.coroutineName + ", job=" + this.job + ", state=" + this.state + ", context=" + this.context + ", trace=" + this.trace + ')';
    }

    public int hashCode() {
        int result2 = this.coroutineName == null ? 0 : this.coroutineName.hashCode();
        result2 = result2 * 31 + this.job.hashCode();
        result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
        result2 = result2 * 31 + (this.context == null ? 0 : this.context.hashCode());
        result2 = result2 * 31 + ((Object)this.trace).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JobRepresentation)) {
            return false;
        }
        JobRepresentation jobRepresentation = (JobRepresentation)other;
        if (!Intrinsics.areEqual((Object)this.coroutineName, (Object)jobRepresentation.coroutineName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.job, (Object)jobRepresentation.job)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)jobRepresentation.state)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.context, (Object)jobRepresentation.context)) {
            return false;
        }
        return Intrinsics.areEqual(this.trace, jobRepresentation.trace);
    }
}

