/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormat;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class UnknownFieldSet
implements MessageLite {
    private final TreeMap<Integer, Field> fields;
    private static final UnknownFieldSet defaultInstance = new UnknownFieldSet(new TreeMap<Integer, Field>());
    private static final Parser PARSER = new Parser();

    private UnknownFieldSet(TreeMap<Integer, Field> fields2) {
        this.fields = fields2;
    }

    public static Builder newBuilder() {
        return Builder.create();
    }

    public static Builder newBuilder(UnknownFieldSet copyFrom) {
        return UnknownFieldSet.newBuilder().mergeFrom(copyFrom);
    }

    public static UnknownFieldSet getDefaultInstance() {
        return defaultInstance;
    }

    @Override
    public UnknownFieldSet getDefaultInstanceForType() {
        return defaultInstance;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnknownFieldSet && this.fields.equals(((UnknownFieldSet)other).fields);
    }

    public int hashCode() {
        if (this.fields.isEmpty()) {
            return 0;
        }
        return this.fields.hashCode();
    }

    public Map<Integer, Field> asMap() {
        return (Map)this.fields.clone();
    }

    @Override
    public void writeTo(CodedOutputStream output2) throws IOException {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            Field field = entry.getValue();
            field.writeTo(entry.getKey(), output2);
        }
    }

    public String toString() {
        return TextFormat.printer().printToString(this);
    }

    @Override
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder out = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(out.getCodedOutput());
            return out.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", e);
        }
    }

    @Override
    public int getSerializedSize() {
        int result2 = 0;
        if (!this.fields.isEmpty()) {
            for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
                result2 += entry.getValue().getSerializedSize(entry.getKey());
            }
        }
        return result2;
    }

    public void writeAsMessageSetTo(CodedOutputStream output2) throws IOException {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            entry.getValue().writeAsMessageSetExtensionTo(entry.getKey(), output2);
        }
    }

    public int getSerializedSizeAsMessageSet() {
        int result2 = 0;
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            result2 += entry.getValue().getSerializedSizeAsMessageSetExtension(entry.getKey());
        }
        return result2;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    public static UnknownFieldSet parseFrom(ByteString data2) throws InvalidProtocolBufferException {
        return UnknownFieldSet.newBuilder().mergeFrom(data2).build();
    }

    @Override
    public Builder newBuilderForType() {
        return UnknownFieldSet.newBuilder();
    }

    @Override
    public Builder toBuilder() {
        return UnknownFieldSet.newBuilder().mergeFrom(this);
    }

    public final Parser getParserForType() {
        return PARSER;
    }

    public static final class Parser
    extends AbstractParser<UnknownFieldSet> {
        @Override
        public UnknownFieldSet parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = UnknownFieldSet.newBuilder();
            try {
                builder.mergeFrom(input);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    }

    public static final class Field {
        private static final Field fieldDefaultInstance = Field.newBuilder().build();
        private List<Long> varint;
        private List<Integer> fixed32;
        private List<Long> fixed64;
        private List<ByteString> lengthDelimited;
        private List<UnknownFieldSet> group;

        private Field() {
        }

        public static Builder newBuilder() {
            return Builder.create();
        }

        public static Builder newBuilder(Field copyFrom) {
            return Field.newBuilder().mergeFrom(copyFrom);
        }

        public List<Long> getVarintList() {
            return this.varint;
        }

        public List<Integer> getFixed32List() {
            return this.fixed32;
        }

        public List<Long> getFixed64List() {
            return this.fixed64;
        }

        public List<ByteString> getLengthDelimitedList() {
            return this.lengthDelimited;
        }

        public List<UnknownFieldSet> getGroupList() {
            return this.group;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            return Arrays.equals(this.getIdentityArray(), ((Field)other).getIdentityArray());
        }

        public int hashCode() {
            return Arrays.hashCode(this.getIdentityArray());
        }

        private Object[] getIdentityArray() {
            return new Object[]{this.varint, this.fixed32, this.fixed64, this.lengthDelimited, this.group};
        }

        public void writeTo(int fieldNumber, CodedOutputStream output2) throws IOException {
            Iterator<Object> iterator2 = this.varint.iterator();
            while (iterator2.hasNext()) {
                long value2 = iterator2.next();
                output2.writeUInt64(fieldNumber, value2);
            }
            iterator2 = this.fixed32.iterator();
            while (iterator2.hasNext()) {
                int value3 = (Integer)iterator2.next();
                output2.writeFixed32(fieldNumber, value3);
            }
            iterator2 = this.fixed64.iterator();
            while (iterator2.hasNext()) {
                long value4 = (Long)iterator2.next();
                output2.writeFixed64(fieldNumber, value4);
            }
            for (ByteString value5 : this.lengthDelimited) {
                output2.writeBytes(fieldNumber, value5);
            }
            for (UnknownFieldSet value6 : this.group) {
                output2.writeGroup(fieldNumber, value6);
            }
        }

        public int getSerializedSize(int fieldNumber) {
            int result2 = 0;
            Iterator<Object> iterator2 = this.varint.iterator();
            while (iterator2.hasNext()) {
                long value2 = iterator2.next();
                result2 += CodedOutputStream.computeUInt64Size(fieldNumber, value2);
            }
            iterator2 = this.fixed32.iterator();
            while (iterator2.hasNext()) {
                int value3 = (Integer)iterator2.next();
                result2 += CodedOutputStream.computeFixed32Size(fieldNumber, value3);
            }
            iterator2 = this.fixed64.iterator();
            while (iterator2.hasNext()) {
                long value4 = (Long)iterator2.next();
                result2 += CodedOutputStream.computeFixed64Size(fieldNumber, value4);
            }
            for (ByteString value5 : this.lengthDelimited) {
                result2 += CodedOutputStream.computeBytesSize(fieldNumber, value5);
            }
            for (UnknownFieldSet value6 : this.group) {
                result2 += CodedOutputStream.computeGroupSize(fieldNumber, value6);
            }
            return result2;
        }

        public void writeAsMessageSetExtensionTo(int fieldNumber, CodedOutputStream output2) throws IOException {
            for (ByteString value2 : this.lengthDelimited) {
                output2.writeRawMessageSetExtension(fieldNumber, value2);
            }
        }

        public int getSerializedSizeAsMessageSetExtension(int fieldNumber) {
            int result2 = 0;
            for (ByteString value2 : this.lengthDelimited) {
                result2 += CodedOutputStream.computeRawMessageSetExtensionSize(fieldNumber, value2);
            }
            return result2;
        }

        public static final class Builder {
            private Field result = new Field();

            private Builder() {
            }

            private static Builder create() {
                Builder builder = new Builder();
                return builder;
            }

            public Builder clone() {
                Field copy2 = new Field();
                if (this.result.varint == null) {
                    copy2.varint = null;
                } else {
                    copy2.varint = new ArrayList(this.result.varint);
                }
                if (this.result.fixed32 == null) {
                    copy2.fixed32 = null;
                } else {
                    copy2.fixed32 = new ArrayList(this.result.fixed32);
                }
                if (this.result.fixed64 == null) {
                    copy2.fixed64 = null;
                } else {
                    copy2.fixed64 = new ArrayList(this.result.fixed64);
                }
                if (this.result.lengthDelimited == null) {
                    copy2.lengthDelimited = null;
                } else {
                    copy2.lengthDelimited = new ArrayList(this.result.lengthDelimited);
                }
                if (this.result.group == null) {
                    copy2.group = null;
                } else {
                    copy2.group = new ArrayList(this.result.group);
                }
                Builder clone = new Builder();
                clone.result = copy2;
                return clone;
            }

            public Field build() {
                Field built = new Field();
                if (this.result.varint == null) {
                    built.varint = Collections.emptyList();
                } else {
                    built.varint = Collections.unmodifiableList(new ArrayList(this.result.varint));
                }
                if (this.result.fixed32 == null) {
                    built.fixed32 = Collections.emptyList();
                } else {
                    built.fixed32 = Collections.unmodifiableList(new ArrayList(this.result.fixed32));
                }
                if (this.result.fixed64 == null) {
                    built.fixed64 = Collections.emptyList();
                } else {
                    built.fixed64 = Collections.unmodifiableList(new ArrayList(this.result.fixed64));
                }
                if (this.result.lengthDelimited == null) {
                    built.lengthDelimited = Collections.emptyList();
                } else {
                    built.lengthDelimited = Collections.unmodifiableList(new ArrayList(this.result.lengthDelimited));
                }
                if (this.result.group == null) {
                    built.group = Collections.emptyList();
                } else {
                    built.group = Collections.unmodifiableList(new ArrayList(this.result.group));
                }
                return built;
            }

            public Builder mergeFrom(Field other) {
                if (!other.varint.isEmpty()) {
                    if (this.result.varint == null) {
                        this.result.varint = new ArrayList();
                    }
                    this.result.varint.addAll(other.varint);
                }
                if (!other.fixed32.isEmpty()) {
                    if (this.result.fixed32 == null) {
                        this.result.fixed32 = new ArrayList();
                    }
                    this.result.fixed32.addAll(other.fixed32);
                }
                if (!other.fixed64.isEmpty()) {
                    if (this.result.fixed64 == null) {
                        this.result.fixed64 = new ArrayList();
                    }
                    this.result.fixed64.addAll(other.fixed64);
                }
                if (!other.lengthDelimited.isEmpty()) {
                    if (this.result.lengthDelimited == null) {
                        this.result.lengthDelimited = new ArrayList();
                    }
                    this.result.lengthDelimited.addAll(other.lengthDelimited);
                }
                if (!other.group.isEmpty()) {
                    if (this.result.group == null) {
                        this.result.group = new ArrayList();
                    }
                    this.result.group.addAll(other.group);
                }
                return this;
            }

            public Builder addVarint(long value2) {
                if (this.result.varint == null) {
                    this.result.varint = new ArrayList();
                }
                this.result.varint.add(value2);
                return this;
            }

            public Builder addFixed32(int value2) {
                if (this.result.fixed32 == null) {
                    this.result.fixed32 = new ArrayList();
                }
                this.result.fixed32.add(value2);
                return this;
            }

            public Builder addFixed64(long value2) {
                if (this.result.fixed64 == null) {
                    this.result.fixed64 = new ArrayList();
                }
                this.result.fixed64.add(value2);
                return this;
            }

            public Builder addLengthDelimited(ByteString value2) {
                if (this.result.lengthDelimited == null) {
                    this.result.lengthDelimited = new ArrayList();
                }
                this.result.lengthDelimited.add(value2);
                return this;
            }

            public Builder addGroup(UnknownFieldSet value2) {
                if (this.result.group == null) {
                    this.result.group = new ArrayList();
                }
                this.result.group.add(value2);
                return this;
            }
        }
    }

    public static final class Builder
    implements MessageLite.Builder {
        private TreeMap<Integer, Field.Builder> fieldBuilders = new TreeMap();

        private Builder() {
        }

        private static Builder create() {
            return new Builder();
        }

        private Field.Builder getFieldBuilder(int number) {
            if (number == 0) {
                return null;
            }
            Field.Builder builder = this.fieldBuilders.get(number);
            if (builder == null) {
                builder = Field.newBuilder();
                this.fieldBuilders.put(number, builder);
            }
            return builder;
        }

        @Override
        public UnknownFieldSet build() {
            UnknownFieldSet result2;
            if (this.fieldBuilders.isEmpty()) {
                result2 = UnknownFieldSet.getDefaultInstance();
            } else {
                TreeMap<Integer, Field> fields2 = new TreeMap<Integer, Field>();
                for (Map.Entry<Integer, Field.Builder> entry : this.fieldBuilders.entrySet()) {
                    fields2.put(entry.getKey(), entry.getValue().build());
                }
                result2 = new UnknownFieldSet(fields2);
            }
            return result2;
        }

        @Override
        public UnknownFieldSet buildPartial() {
            return this.build();
        }

        public Builder clone() {
            Builder clone = UnknownFieldSet.newBuilder();
            for (Map.Entry<Integer, Field.Builder> entry : this.fieldBuilders.entrySet()) {
                Integer key = entry.getKey();
                Field.Builder value2 = entry.getValue();
                clone.fieldBuilders.put(key, value2.clone());
            }
            return clone;
        }

        @Override
        public UnknownFieldSet getDefaultInstanceForType() {
            return UnknownFieldSet.getDefaultInstance();
        }

        public Builder mergeFrom(UnknownFieldSet other) {
            if (other != UnknownFieldSet.getDefaultInstance()) {
                for (Map.Entry entry : other.fields.entrySet()) {
                    this.mergeField((Integer)entry.getKey(), (Field)entry.getValue());
                }
            }
            return this;
        }

        public Builder mergeField(int number, Field field) {
            if (number <= 0) {
                throw new IllegalArgumentException(number + " is not a valid field number.");
            }
            if (this.hasField(number)) {
                this.getFieldBuilder(number).mergeFrom(field);
            } else {
                this.addField(number, field);
            }
            return this;
        }

        public Builder mergeVarintField(int number, int value2) {
            if (number <= 0) {
                throw new IllegalArgumentException(number + " is not a valid field number.");
            }
            this.getFieldBuilder(number).addVarint(value2);
            return this;
        }

        public boolean hasField(int number) {
            return this.fieldBuilders.containsKey(number);
        }

        public Builder addField(int number, Field field) {
            if (number <= 0) {
                throw new IllegalArgumentException(number + " is not a valid field number.");
            }
            this.fieldBuilders.put(number, Field.newBuilder(field));
            return this;
        }

        public Builder mergeFrom(CodedInputStream input) throws IOException {
            int tag;
            while ((tag = input.readTag()) != 0 && this.mergeFieldFrom(tag, input)) {
            }
            return this;
        }

        public boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
            int number = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.getFieldBuilder(number).addVarint(input.readInt64());
                    return true;
                }
                case 1: {
                    this.getFieldBuilder(number).addFixed64(input.readFixed64());
                    return true;
                }
                case 2: {
                    this.getFieldBuilder(number).addLengthDelimited(input.readBytes());
                    return true;
                }
                case 3: {
                    Builder subBuilder = UnknownFieldSet.newBuilder();
                    input.readGroup(number, subBuilder, ExtensionRegistry.getEmptyRegistry());
                    this.getFieldBuilder(number).addGroup(subBuilder.build());
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.getFieldBuilder(number).addFixed32(input.readFixed32());
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        public Builder mergeFrom(ByteString data2) throws InvalidProtocolBufferException {
            try {
                CodedInputStream input = data2.newCodedInput();
                this.mergeFrom(input);
                input.checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException e) {
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", e);
            }
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return this.mergeFrom(input);
        }

        @Override
        public boolean isInitialized() {
            return true;
        }
    }
}

