/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.TextFormatParseInfoTree;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());
    private static final Parser PARSER = Parser.newBuilder().build();

    private TextFormat() {
    }

    public static Printer printer() {
        return Printer.DEFAULT;
    }

    public static String unsignedToString(int value2) {
        if (value2 >= 0) {
            return Integer.toString(value2);
        }
        return Long.toString((long)value2 & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long value2) {
        if (value2 >= 0L) {
            return Long.toString(value2);
        }
        return BigInteger.valueOf(value2 & Long.MAX_VALUE).setBit(63).toString();
    }

    private static TextGenerator multiLineOutput(Appendable output2) {
        return new TextGenerator(output2, false);
    }

    public static String escapeBytes(ByteString input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    public static String escapeBytes(byte[] input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    public static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        ByteString input = ByteString.copyFromUtf8(charString.toString());
        byte[] result2 = new byte[input.size()];
        int pos = 0;
        block16: for (int i2 = 0; i2 < input.size(); ++i2) {
            byte c = input.byteAt(i2);
            if (c == 92) {
                if (i2 + 1 < input.size()) {
                    int code;
                    if (TextFormat.isOctal(c = input.byteAt(++i2))) {
                        code = TextFormat.digitValue(c);
                        if (i2 + 1 < input.size() && TextFormat.isOctal(input.byteAt(i2 + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i2));
                        }
                        if (i2 + 1 < input.size() && TextFormat.isOctal(input.byteAt(i2 + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i2));
                        }
                        result2[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 97: {
                            result2[pos++] = 7;
                            continue block16;
                        }
                        case 98: {
                            result2[pos++] = 8;
                            continue block16;
                        }
                        case 102: {
                            result2[pos++] = 12;
                            continue block16;
                        }
                        case 110: {
                            result2[pos++] = 10;
                            continue block16;
                        }
                        case 114: {
                            result2[pos++] = 13;
                            continue block16;
                        }
                        case 116: {
                            result2[pos++] = 9;
                            continue block16;
                        }
                        case 118: {
                            result2[pos++] = 11;
                            continue block16;
                        }
                        case 92: {
                            result2[pos++] = 92;
                            continue block16;
                        }
                        case 39: {
                            result2[pos++] = 39;
                            continue block16;
                        }
                        case 34: {
                            result2[pos++] = 34;
                            continue block16;
                        }
                        case 63: {
                            result2[pos++] = 63;
                            continue block16;
                        }
                        case 120: {
                            code = 0;
                            if (i2 + 1 >= input.size() || !TextFormat.isHex(input.byteAt(i2 + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(input.byteAt(++i2));
                            if (i2 + 1 < input.size() && TextFormat.isHex(input.byteAt(i2 + 1))) {
                                code = code * 16 + TextFormat.digitValue(input.byteAt(++i2));
                            }
                            result2[pos++] = (byte)code;
                            continue block16;
                        }
                        case 117: {
                            if (++i2 + 3 < input.size() && TextFormat.isHex(input.byteAt(i2)) && TextFormat.isHex(input.byteAt(i2 + 1)) && TextFormat.isHex(input.byteAt(i2 + 2)) && TextFormat.isHex(input.byteAt(i2 + 3))) {
                                char ch = (char)(TextFormat.digitValue(input.byteAt(i2)) << 12 | TextFormat.digitValue(input.byteAt(i2 + 1)) << 8 | TextFormat.digitValue(input.byteAt(i2 + 2)) << 4 | TextFormat.digitValue(input.byteAt(i2 + 3)));
                                if (ch >= '\ud800' && ch <= '\udfff') {
                                    throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\u' refers to a surrogate");
                                }
                                byte[] chUtf8 = Character.toString(ch).getBytes(Internal.UTF_8);
                                System.arraycopy(chUtf8, 0, result2, pos, chUtf8.length);
                                pos += chUtf8.length;
                                i2 += 3;
                                continue block16;
                            }
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\u' with too few hex chars");
                        }
                        case 85: {
                            if (++i2 + 7 >= input.size()) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U' with too few hex chars");
                            }
                            int codepoint = 0;
                            for (int offset = i2; offset < i2 + 8; ++offset) {
                                byte b = input.byteAt(offset);
                                if (!TextFormat.isHex(b)) {
                                    throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U' with too few hex chars");
                                }
                                codepoint = codepoint << 4 | TextFormat.digitValue(b);
                            }
                            if (!Character.isValidCodePoint(codepoint)) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U" + input.substring(i2, i2 + 8).toStringUtf8() + "' is not a valid code point value");
                            }
                            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codepoint);
                            if (unicodeBlock != null && (unicodeBlock.equals(Character.UnicodeBlock.LOW_SURROGATES) || unicodeBlock.equals(Character.UnicodeBlock.HIGH_SURROGATES) || unicodeBlock.equals(Character.UnicodeBlock.HIGH_PRIVATE_USE_SURROGATES))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\U" + input.substring(i2, i2 + 8).toStringUtf8() + "' refers to a surrogate code unit");
                            }
                            int[] codepoints = new int[]{codepoint};
                            byte[] chUtf8 = new String(codepoints, 0, 1).getBytes(Internal.UTF_8);
                            System.arraycopy(chUtf8, 0, result2, pos, chUtf8.length);
                            pos += chUtf8.length;
                            i2 += 7;
                            continue block16;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)c + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result2[pos++] = c;
        }
        return result2.length == pos ? ByteString.wrap(result2) : ByteString.copyFrom(result2, 0, pos);
    }

    public static String escapeDoubleQuotesAndBackslashes(String input) {
        return TextFormatEscaper.escapeDoubleQuotesAndBackslashes(input);
    }

    private static boolean isOctal(byte c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isHex(byte c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static int digitValue(byte c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, true, false);
    }

    static int parseUInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, false, false);
    }

    static long parseInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, true, true);
    }

    static long parseUInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, false, true);
    }

    private static long parseInteger(String text2, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text2.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text2);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text2.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text2.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text2.substring(pos);
        long result2 = 0L;
        if (numberText.length() < 16) {
            result2 = Long.parseLong(numberText, radix);
            if (negative) {
                result2 = -result2;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text2);
                    }
                } else if (result2 >= 0x100000000L || result2 < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text2);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text2);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text2);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text2);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text2);
            }
            result2 = bigValue.longValue();
        }
        return result2;
    }

    public static class InvalidEscapeSequenceException
    extends IOException {
        InvalidEscapeSequenceException(String description2) {
            super(description2);
        }
    }

    public static class Parser {
        private final TypeRegistry typeRegistry;
        private final boolean allowUnknownFields;
        private final boolean allowUnknownEnumValues;
        private final boolean allowUnknownExtensions;
        private final SingularOverwritePolicy singularOverwritePolicy;
        private TextFormatParseInfoTree.Builder parseInfoTreeBuilder;
        private final int recursionLimit;

        private Parser(TypeRegistry typeRegistry, boolean allowUnknownFields, boolean allowUnknownEnumValues, boolean allowUnknownExtensions, SingularOverwritePolicy singularOverwritePolicy, TextFormatParseInfoTree.Builder parseInfoTreeBuilder, int recursionLimit) {
            this.typeRegistry = typeRegistry;
            this.allowUnknownFields = allowUnknownFields;
            this.allowUnknownEnumValues = allowUnknownEnumValues;
            this.allowUnknownExtensions = allowUnknownExtensions;
            this.singularOverwritePolicy = singularOverwritePolicy;
            this.parseInfoTreeBuilder = parseInfoTreeBuilder;
            this.recursionLimit = recursionLimit;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private boolean allowUnknownFields = false;
            private boolean allowUnknownEnumValues = false;
            private boolean allowUnknownExtensions = false;
            private SingularOverwritePolicy singularOverwritePolicy = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES;
            private TextFormatParseInfoTree.Builder parseInfoTreeBuilder = null;
            private TypeRegistry typeRegistry = TypeRegistry.getEmptyTypeRegistry();
            private int recursionLimit = 100;

            public Parser build() {
                return new Parser(this.typeRegistry, this.allowUnknownFields, this.allowUnknownEnumValues, this.allowUnknownExtensions, this.singularOverwritePolicy, this.parseInfoTreeBuilder, this.recursionLimit);
            }
        }

        public static final class SingularOverwritePolicy
        extends Enum<SingularOverwritePolicy> {
            public static final /* enum */ SingularOverwritePolicy ALLOW_SINGULAR_OVERWRITES = new SingularOverwritePolicy();
            public static final /* enum */ SingularOverwritePolicy FORBID_SINGULAR_OVERWRITES = new SingularOverwritePolicy();
            private static final /* synthetic */ SingularOverwritePolicy[] $VALUES;

            static {
                $VALUES = new SingularOverwritePolicy[]{ALLOW_SINGULAR_OVERWRITES, FORBID_SINGULAR_OVERWRITES};
            }
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private final boolean singleLineMode;
        private boolean atStartOfLine = false;

        private TextGenerator(Appendable output2, boolean singleLineMode) {
            this.output = output2;
            this.singleLineMode = singleLineMode;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int length = this.indent.length();
            if (length == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.setLength(length - 2);
        }

        public void print(CharSequence text2) throws IOException {
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.singleLineMode ? " " : this.indent);
            }
            this.output.append(text2);
        }

        public void eol() throws IOException {
            if (!this.singleLineMode) {
                this.output.append("\n");
            }
            this.atStartOfLine = true;
        }
    }

    public static final class Printer {
        private static final Printer DEFAULT = new Printer(true, TypeRegistry.getEmptyTypeRegistry());
        private final boolean escapeNonAscii;
        private final TypeRegistry typeRegistry;

        private Printer(boolean escapeNonAscii, TypeRegistry typeRegistry) {
            this.escapeNonAscii = escapeNonAscii;
            this.typeRegistry = typeRegistry;
        }

        public void print(MessageOrBuilder message2, Appendable output2) throws IOException {
            this.print(message2, TextFormat.multiLineOutput(output2));
        }

        public void print(UnknownFieldSet fields2, Appendable output2) throws IOException {
            Printer.printUnknownFields(fields2, TextFormat.multiLineOutput(output2));
        }

        private void print(MessageOrBuilder message2, TextGenerator generator) throws IOException {
            if (message2.getDescriptorForType().getFullName().equals("google.protobuf.Any") && this.printAny(message2, generator)) {
                return;
            }
            this.printMessage(message2, generator);
        }

        private boolean printAny(MessageOrBuilder message2, TextGenerator generator) throws IOException {
            Descriptors.Descriptor messageType = message2.getDescriptorForType();
            Descriptors.FieldDescriptor typeUrlField = messageType.findFieldByNumber(1);
            Descriptors.FieldDescriptor valueField = messageType.findFieldByNumber(2);
            if (typeUrlField == null || typeUrlField.getType() != Descriptors.FieldDescriptor.Type.STRING || valueField == null || valueField.getType() != Descriptors.FieldDescriptor.Type.BYTES) {
                return false;
            }
            String typeUrl = (String)message2.getField(typeUrlField);
            if (typeUrl.isEmpty()) {
                return false;
            }
            Object value2 = message2.getField(valueField);
            DynamicMessage.Builder contentBuilder = null;
            try {
                Descriptors.Descriptor contentType = this.typeRegistry.getDescriptorForTypeUrl(typeUrl);
                if (contentType == null) {
                    return false;
                }
                contentBuilder = DynamicMessage.getDefaultInstance(contentType).newBuilderForType();
                contentBuilder.mergeFrom((ByteString)value2);
            }
            catch (InvalidProtocolBufferException e) {
                return false;
            }
            generator.print("[");
            generator.print(typeUrl);
            generator.print("] {");
            generator.eol();
            generator.indent();
            this.print((MessageOrBuilder)contentBuilder, generator);
            generator.outdent();
            generator.print("}");
            generator.eol();
            return true;
        }

        private void printField(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            if (field.isMapField()) {
                ArrayList<MapEntryAdapter> adapters = new ArrayList<MapEntryAdapter>();
                for (Object entry : (List)value2) {
                    adapters.add(new MapEntryAdapter(entry, field));
                }
                Collections.sort(adapters);
                for (MapEntryAdapter adapter2 : adapters) {
                    this.printSingleField(field, adapter2.getEntry(), generator);
                }
            } else if (field.isRepeated()) {
                for (Object element : (List)value2) {
                    this.printSingleField(field, element, generator);
                }
            } else {
                this.printSingleField(field, value2, generator);
            }
        }

        private void printFieldValue(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            switch (field.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value2).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value2).toString());
                    break;
                }
                case BOOL: {
                    generator.print(((Boolean)value2).toString());
                    break;
                }
                case FLOAT: {
                    generator.print(((Float)value2).toString());
                    break;
                }
                case DOUBLE: {
                    generator.print(((Double)value2).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value2));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value2));
                    break;
                }
                case STRING: {
                    generator.print("\"");
                    generator.print(this.escapeNonAscii ? TextFormatEscaper.escapeText((String)value2) : TextFormat.escapeDoubleQuotesAndBackslashes((String)value2).replace("\n", "\\n"));
                    generator.print("\"");
                    break;
                }
                case BYTES: {
                    generator.print("\"");
                    if (value2 instanceof ByteString) {
                        generator.print(TextFormat.escapeBytes((ByteString)value2));
                    } else {
                        generator.print(TextFormat.escapeBytes((byte[])value2));
                    }
                    generator.print("\"");
                    break;
                }
                case ENUM: {
                    generator.print(((Descriptors.EnumValueDescriptor)value2).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((MessageOrBuilder)value2, generator);
                }
            }
        }

        public String printToString(MessageOrBuilder message2) {
            try {
                StringBuilder text2 = new StringBuilder();
                this.print(message2, (Appendable)text2);
                return text2.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String printToString(UnknownFieldSet fields2) {
            try {
                StringBuilder text2 = new StringBuilder();
                this.print(fields2, (Appendable)text2);
                return text2.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private static void printUnknownFieldValue(int tag, Object value2, TextGenerator generator) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    generator.print(TextFormat.unsignedToString((Long)value2));
                    break;
                }
                case 5: {
                    generator.print(String.format((Locale)null, "0x%08x", (Integer)value2));
                    break;
                }
                case 1: {
                    generator.print(String.format((Locale)null, "0x%016x", (Long)value2));
                    break;
                }
                case 2: {
                    try {
                        UnknownFieldSet message2 = UnknownFieldSet.parseFrom((ByteString)value2);
                        generator.print("{");
                        generator.eol();
                        generator.indent();
                        Printer.printUnknownFields(message2, generator);
                        generator.outdent();
                        generator.print("}");
                    }
                    catch (InvalidProtocolBufferException e) {
                        generator.print("\"");
                        generator.print(TextFormat.escapeBytes((ByteString)value2));
                        generator.print("\"");
                    }
                    break;
                }
                case 3: {
                    Printer.printUnknownFields((UnknownFieldSet)value2, generator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag: " + tag);
                }
            }
        }

        private void printMessage(MessageOrBuilder message2, TextGenerator generator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message2.getAllFields().entrySet()) {
                this.printField(field.getKey(), field.getValue(), generator);
            }
            Printer.printUnknownFields(message2.getUnknownFields(), generator);
        }

        private void printSingleField(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            if (field.isExtension()) {
                generator.print("[");
                if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                    generator.print(field.getMessageType().getFullName());
                } else {
                    generator.print(field.getFullName());
                }
                generator.print("]");
            } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.print(" {");
                generator.eol();
                generator.indent();
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field, value2, generator);
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.outdent();
                generator.print("}");
            }
            generator.eol();
        }

        private static void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
                int number = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                Printer.printUnknownField(number, 0, field.getVarintList(), generator);
                Printer.printUnknownField(number, 5, field.getFixed32List(), generator);
                Printer.printUnknownField(number, 1, field.getFixed64List(), generator);
                Printer.printUnknownField(number, 2, field.getLengthDelimitedList(), generator);
                for (UnknownFieldSet value2 : field.getGroupList()) {
                    generator.print(entry.getKey().toString());
                    generator.print(" {");
                    generator.eol();
                    generator.indent();
                    Printer.printUnknownFields(value2, generator);
                    generator.outdent();
                    generator.print("}");
                    generator.eol();
                }
            }
        }

        private static void printUnknownField(int number, int wireType, List<?> values, TextGenerator generator) throws IOException {
            for (Object value2 : values) {
                generator.print(String.valueOf(number));
                generator.print(": ");
                Printer.printUnknownFieldValue(wireType, value2, generator);
                generator.eol();
            }
        }

        private static class MapEntryAdapter
        implements Comparable<MapEntryAdapter> {
            private Object entry;
            private MapEntry mapEntry;
            private final Descriptors.FieldDescriptor.JavaType fieldType;

            MapEntryAdapter(Object entry, Descriptors.FieldDescriptor fieldDescriptor) {
                if (entry instanceof MapEntry) {
                    this.mapEntry = (MapEntry)entry;
                } else {
                    this.entry = entry;
                }
                this.fieldType = MapEntryAdapter.extractFieldType(fieldDescriptor);
            }

            private static Descriptors.FieldDescriptor.JavaType extractFieldType(Descriptors.FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getMessageType().getFields().get(0).getJavaType();
            }

            Object getKey() {
                if (this.mapEntry != null) {
                    return this.mapEntry.getKey();
                }
                return null;
            }

            Object getEntry() {
                if (this.mapEntry != null) {
                    return this.mapEntry;
                }
                return this.entry;
            }

            @Override
            public int compareTo(MapEntryAdapter b) {
                if (this.getKey() == null || b.getKey() == null) {
                    logger.info("Invalid key for map field.");
                    return -1;
                }
                switch (this.fieldType) {
                    case BOOLEAN: {
                        return Boolean.valueOf((Boolean)this.getKey()).compareTo((boolean)((Boolean)b.getKey()));
                    }
                    case LONG: {
                        return Long.valueOf((Long)this.getKey()).compareTo((long)((Long)b.getKey()));
                    }
                    case INT: {
                        return Integer.valueOf((Integer)this.getKey()).compareTo((int)((Integer)b.getKey()));
                    }
                    case STRING: {
                        String aString = (String)this.getKey();
                        String bString = (String)b.getKey();
                        if (aString == null && bString == null) {
                            return 0;
                        }
                        if (aString == null && bString != null) {
                            return -1;
                        }
                        if (aString != null && bString == null) {
                            return 1;
                        }
                        return aString.compareTo(bString);
                    }
                }
                return 0;
            }
        }
    }
}

