/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import com.google.protobuf.ManifestSchemaFactory;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public <T> Schema<T> schemaFor(Class<T> messageType) {
        Schema<?> previous;
        Internal.checkNotNull(messageType, "messageType");
        Schema<Object> schema = (Schema<T>)this.schemaCache.get(messageType);
        if (schema == null && (previous = this.registerSchema(messageType, schema = this.schemaFactory.createSchema(messageType))) != null) {
            schema = previous;
        }
        return schema;
    }

    public <T> Schema<T> schemaFor(T message2) {
        return this.schemaFor((T)message2.getClass());
    }

    public Schema<?> registerSchema(Class<?> messageType, Schema<?> schema) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.putIfAbsent(messageType, schema);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }
}

