/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldInfo;
import com.google.protobuf.FieldSet;
import com.google.protobuf.FieldType;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.ListFieldSchema;
import com.google.protobuf.MapFieldSchema;
import com.google.protobuf.MessageInfo;
import com.google.protobuf.MessageLite;
import com.google.protobuf.NewInstanceSchema;
import com.google.protobuf.OneofInfo;
import com.google.protobuf.ProtoSyntax;
import com.google.protobuf.Protobuf;
import com.google.protobuf.RawMessageInfo;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.StructuralMessageInfo;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnsafeUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import sun.misc.Unsafe;

final class MessageSchema<T>
implements Schema<T> {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private final int[] buffer;
    private final Object[] objects;
    private final int minFieldNumber;
    private final int maxFieldNumber;
    private final MessageLite defaultInstance;
    private final boolean hasExtensions;
    private final boolean lite;
    private final ProtoSyntax syntax;
    private final boolean useCachedSizeField;
    private final int[] intArray;
    private final int checkInitializedCount;
    private final int repeatedFieldOffsetStart;
    private final NewInstanceSchema newInstanceSchema;
    private final ListFieldSchema listFieldSchema;
    private final UnknownFieldSchema<?, ?> unknownFieldSchema;
    private final ExtensionSchema<?> extensionSchema;
    private final MapFieldSchema mapFieldSchema;

    private MessageSchema(int[] buffer, Object[] objects, int minFieldNumber, int maxFieldNumber, MessageLite defaultInstance, ProtoSyntax syntax, boolean useCachedSizeField, int[] intArray, int checkInitialized, int mapFieldPositions, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        this.buffer = buffer;
        this.objects = objects;
        this.minFieldNumber = minFieldNumber;
        this.maxFieldNumber = maxFieldNumber;
        this.lite = defaultInstance instanceof GeneratedMessageLite;
        this.syntax = syntax;
        this.hasExtensions = extensionSchema != null && extensionSchema.hasExtensions(defaultInstance);
        this.useCachedSizeField = useCachedSizeField;
        this.intArray = intArray;
        this.checkInitializedCount = checkInitialized;
        this.repeatedFieldOffsetStart = mapFieldPositions;
        this.newInstanceSchema = newInstanceSchema;
        this.listFieldSchema = listFieldSchema;
        this.unknownFieldSchema = unknownFieldSchema;
        this.extensionSchema = extensionSchema;
        this.defaultInstance = defaultInstance;
        this.mapFieldSchema = mapFieldSchema;
    }

    static <T> MessageSchema<T> newSchema(Class<T> messageClass, MessageInfo messageInfo, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        if (messageInfo instanceof RawMessageInfo) {
            return MessageSchema.newSchemaForRawMessageInfo((RawMessageInfo)messageInfo, newInstanceSchema, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
        }
        return MessageSchema.newSchemaForMessageInfo((StructuralMessageInfo)messageInfo, newInstanceSchema, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
    }

    static <T> MessageSchema<T> newSchemaForRawMessageInfo(RawMessageInfo messageInfo, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        int objectsPosition;
        int[] intArray;
        int checkInitialized;
        int repeatedFieldCount;
        int mapFieldCount;
        int numEntries;
        int maxFieldNumber;
        int minFieldNumber;
        int hasBitsCount;
        int oneofCount;
        int fieldCount;
        int next2;
        String info = messageInfo.getStringInfo();
        int length = info.length();
        int i2 = 0;
        if ((next2 = info.charAt(i2++)) >= 55296) {
            int result2 = next2 & 0x1FFF;
            int shift = 13;
            while ((next2 = info.charAt(i2++)) >= 55296) {
                result2 |= (next2 & 0x1FFF) << shift;
                shift += 13;
            }
            next2 = result2 | next2 << shift;
        }
        int unusedFlags = next2;
        if ((next2 = info.charAt(i2++)) >= 55296) {
            int result3 = next2 & 0x1FFF;
            int shift = 13;
            while (true) {
                char c = info.charAt(i2++);
                next2 = c;
                if (c < '\ud800') break;
                result3 |= (next2 & 0x1FFF) << shift;
                shift += 13;
            }
            next2 = result3 | next2 << shift;
        }
        if ((fieldCount = next2) == 0) {
            oneofCount = 0;
            hasBitsCount = 0;
            minFieldNumber = 0;
            maxFieldNumber = 0;
            numEntries = 0;
            mapFieldCount = 0;
            repeatedFieldCount = 0;
            checkInitialized = 0;
            intArray = EMPTY_INT_ARRAY;
            objectsPosition = 0;
        } else {
            int shift;
            int result4;
            if ((next2 = info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            oneofCount = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            hasBitsCount = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            minFieldNumber = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            maxFieldNumber = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            numEntries = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            mapFieldCount = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            repeatedFieldCount = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result4 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result4 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result4 | next2 << shift;
            }
            checkInitialized = next2;
            intArray = new int[checkInitialized + mapFieldCount + repeatedFieldCount];
            objectsPosition = oneofCount * 2 + hasBitsCount;
        }
        Unsafe unsafe = UNSAFE;
        Object[] messageInfoObjects = messageInfo.getObjects();
        int checkInitializedPosition = 0;
        Class<?> messageClass = messageInfo.getDefaultInstance().getClass();
        int[] buffer = new int[numEntries * 3];
        Object[] objects = new Object[numEntries * 2];
        int mapFieldIndex = checkInitialized;
        int repeatedFieldIndex = checkInitialized + mapFieldCount;
        int bufferIndex = 0;
        while (i2 < length) {
            int presenceMaskShift;
            int presenceFieldOffset;
            int fieldOffset;
            int shift;
            int result5;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result5 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result5 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result5 | next2 << shift;
            }
            int fieldNumber = next2;
            if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                result5 = next2 & 0x1FFF;
                shift = 13;
                while (true) {
                    char c = info.charAt(i2++);
                    next2 = c;
                    if (c < '\ud800') break;
                    result5 |= (next2 & 0x1FFF) << shift;
                    shift += 13;
                }
                next2 = result5 | next2 << shift;
            }
            int fieldTypeWithExtraBits = next2;
            int fieldType = fieldTypeWithExtraBits & 0xFF;
            if ((fieldTypeWithExtraBits & 0x400) != 0) {
                intArray[checkInitializedPosition++] = bufferIndex;
            }
            if (fieldType >= 51) {
                Field oneofCaseField;
                Field oneofField;
                if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                    int result6 = next2 & 0x1FFF;
                    int shift2 = 13;
                    while (true) {
                        char c = info.charAt(i2++);
                        next2 = c;
                        if (c < '\ud800') break;
                        result6 |= (next2 & 0x1FFF) << shift2;
                        shift2 += 13;
                    }
                    next2 = result6 | next2 << shift2;
                }
                int oneofIndex = next2;
                int oneofFieldType = fieldType - 51;
                if (oneofFieldType == 9 || oneofFieldType == 17) {
                    objects[bufferIndex / 3 * 2 + 1] = messageInfoObjects[objectsPosition++];
                } else if (oneofFieldType == 12 && (messageInfo.getSyntax().equals((Object)ProtoSyntax.PROTO2) || (fieldTypeWithExtraBits & 0x800) != 0)) {
                    objects[bufferIndex / 3 * 2 + 1] = messageInfoObjects[objectsPosition++];
                }
                int index = oneofIndex * 2;
                Object o = messageInfoObjects[index];
                if (o instanceof Field) {
                    oneofField = (Field)o;
                } else {
                    oneofField = MessageSchema.reflectField(messageClass, (String)o);
                    messageInfoObjects[index] = oneofField;
                }
                fieldOffset = (int)unsafe.objectFieldOffset(oneofField);
                o = messageInfoObjects[++index];
                if (o instanceof Field) {
                    oneofCaseField = (Field)o;
                } else {
                    oneofCaseField = MessageSchema.reflectField(messageClass, (String)o);
                    messageInfoObjects[index] = oneofCaseField;
                }
                presenceFieldOffset = (int)unsafe.objectFieldOffset(oneofCaseField);
                presenceMaskShift = 0;
            } else {
                boolean hasHasBit;
                Field field = MessageSchema.reflectField(messageClass, (String)messageInfoObjects[objectsPosition++]);
                if (fieldType == 9 || fieldType == 17) {
                    objects[bufferIndex / 3 * 2 + 1] = field.getType();
                } else if (fieldType == 27 || fieldType == 49) {
                    objects[bufferIndex / 3 * 2 + 1] = messageInfoObjects[objectsPosition++];
                } else if (fieldType == 12 || fieldType == 30 || fieldType == 44) {
                    if (messageInfo.getSyntax() == ProtoSyntax.PROTO2 || (fieldTypeWithExtraBits & 0x800) != 0) {
                        objects[bufferIndex / 3 * 2 + 1] = messageInfoObjects[objectsPosition++];
                    }
                } else if (fieldType == 50) {
                    intArray[mapFieldIndex++] = bufferIndex;
                    objects[bufferIndex / 3 * 2] = messageInfoObjects[objectsPosition++];
                    if ((fieldTypeWithExtraBits & 0x800) != 0) {
                        objects[bufferIndex / 3 * 2 + 1] = messageInfoObjects[objectsPosition++];
                    }
                }
                fieldOffset = (int)unsafe.objectFieldOffset(field);
                boolean bl = hasHasBit = (fieldTypeWithExtraBits & 0x1000) != 0;
                if (hasHasBit && fieldType <= 17) {
                    Field hasBitsField;
                    int hasBitsIndex;
                    int index;
                    Object o;
                    if ((next2 = (int)info.charAt(i2++)) >= 55296) {
                        int result7 = next2 & 0x1FFF;
                        int shift3 = 13;
                        while (true) {
                            char c = info.charAt(i2++);
                            next2 = c;
                            if (c < '\ud800') break;
                            result7 |= (next2 & 0x1FFF) << shift3;
                            shift3 += 13;
                        }
                        next2 = result7 | next2 << shift3;
                    }
                    if ((o = messageInfoObjects[index = oneofCount * 2 + (hasBitsIndex = next2) / 32]) instanceof Field) {
                        hasBitsField = (Field)o;
                    } else {
                        hasBitsField = MessageSchema.reflectField(messageClass, (String)o);
                        messageInfoObjects[index] = hasBitsField;
                    }
                    presenceFieldOffset = (int)unsafe.objectFieldOffset(hasBitsField);
                    presenceMaskShift = hasBitsIndex % 32;
                } else {
                    presenceFieldOffset = 1048575;
                    presenceMaskShift = 0;
                }
                if (fieldType >= 18 && fieldType <= 49) {
                    intArray[repeatedFieldIndex++] = fieldOffset;
                }
            }
            buffer[bufferIndex++] = fieldNumber;
            buffer[bufferIndex++] = ((fieldTypeWithExtraBits & 0x200) != 0 ? 0x20000000 : 0) | ((fieldTypeWithExtraBits & 0x100) != 0 ? 0x10000000 : 0) | ((fieldTypeWithExtraBits & 0x800) != 0 ? Integer.MIN_VALUE : 0) | fieldType << 20 | fieldOffset;
            buffer[bufferIndex++] = presenceMaskShift << 20 | presenceFieldOffset;
        }
        return new MessageSchema<T>(buffer, objects, minFieldNumber, maxFieldNumber, messageInfo.getDefaultInstance(), messageInfo.getSyntax(), false, intArray, checkInitialized, checkInitialized + mapFieldCount, newInstanceSchema, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
    }

    private static Field reflectField(Class<?> messageClass, String fieldName) {
        try {
            return messageClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Object[] fields2;
            for (Field field : fields2 = messageClass.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
            throw new RuntimeException("Field " + fieldName + " for " + messageClass.getName() + " not found. Known fields are " + Arrays.toString(fields2));
        }
    }

    static <T> MessageSchema<T> newSchemaForMessageInfo(StructuralMessageInfo messageInfo, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        int maxFieldNumber;
        int minFieldNumber;
        FieldInfo[] fis = messageInfo.getFields();
        if (fis.length == 0) {
            minFieldNumber = 0;
            maxFieldNumber = 0;
        } else {
            minFieldNumber = fis[0].getFieldNumber();
            maxFieldNumber = fis[fis.length - 1].getFieldNumber();
        }
        int numEntries = fis.length;
        int[] buffer = new int[numEntries * 3];
        Object[] objects = new Object[numEntries * 2];
        int mapFieldCount = 0;
        int repeatedFieldCount = 0;
        for (FieldInfo fi : fis) {
            if (fi.getType() == FieldType.MAP) {
                ++mapFieldCount;
                continue;
            }
            if (fi.getType().id() < 18 || fi.getType().id() > 49) continue;
            ++repeatedFieldCount;
        }
        int[] mapFieldPositions = mapFieldCount > 0 ? new int[mapFieldCount] : null;
        int[] repeatedFieldOffsets = repeatedFieldCount > 0 ? new int[repeatedFieldCount] : null;
        mapFieldCount = 0;
        repeatedFieldCount = 0;
        int[] checkInitialized = messageInfo.getCheckInitialized();
        if (checkInitialized == null) {
            checkInitialized = EMPTY_INT_ARRAY;
        }
        int checkInitializedIndex = 0;
        int fieldIndex = 0;
        int bufferIndex = 0;
        while (fieldIndex < fis.length) {
            FieldInfo fi = fis[fieldIndex];
            int fieldNumber = fi.getFieldNumber();
            MessageSchema.storeFieldData(fi, buffer, bufferIndex, objects);
            if (checkInitializedIndex < checkInitialized.length && checkInitialized[checkInitializedIndex] == fieldNumber) {
                checkInitialized[checkInitializedIndex++] = bufferIndex;
            }
            if (fi.getType() == FieldType.MAP) {
                mapFieldPositions[mapFieldCount++] = bufferIndex;
            } else if (fi.getType().id() >= 18 && fi.getType().id() <= 49) {
                repeatedFieldOffsets[repeatedFieldCount++] = (int)UnsafeUtil.objectFieldOffset(fi.getField());
            }
            ++fieldIndex;
            bufferIndex += 3;
        }
        if (mapFieldPositions == null) {
            mapFieldPositions = EMPTY_INT_ARRAY;
        }
        if (repeatedFieldOffsets == null) {
            repeatedFieldOffsets = EMPTY_INT_ARRAY;
        }
        int[] combined = new int[checkInitialized.length + mapFieldPositions.length + repeatedFieldOffsets.length];
        System.arraycopy(checkInitialized, 0, combined, 0, checkInitialized.length);
        System.arraycopy(mapFieldPositions, 0, combined, checkInitialized.length, mapFieldPositions.length);
        System.arraycopy(repeatedFieldOffsets, 0, combined, checkInitialized.length + mapFieldPositions.length, repeatedFieldOffsets.length);
        return new MessageSchema<T>(buffer, objects, minFieldNumber, maxFieldNumber, messageInfo.getDefaultInstance(), messageInfo.getSyntax(), true, combined, checkInitialized.length, checkInitialized.length + mapFieldPositions.length, newInstanceSchema, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
    }

    private static void storeFieldData(FieldInfo fi, int[] buffer, int bufferIndex, Object[] objects) {
        int presenceMaskShift;
        int presenceFieldOffset;
        int fieldOffset;
        int typeId;
        OneofInfo oneof = fi.getOneof();
        if (oneof != null) {
            typeId = fi.getType().id() + 51;
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(oneof.getValueField());
            presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(oneof.getCaseField());
            presenceMaskShift = 0;
        } else {
            FieldType type2 = fi.getType();
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(fi.getField());
            typeId = type2.id();
            if (!type2.isList() && !type2.isMap()) {
                Field presenceField = fi.getPresenceField();
                presenceFieldOffset = presenceField == null ? 1048575 : (int)UnsafeUtil.objectFieldOffset(presenceField);
                presenceMaskShift = Integer.numberOfTrailingZeros(fi.getPresenceMask());
            } else if (fi.getCachedSizeField() == null) {
                presenceFieldOffset = 0;
                presenceMaskShift = 0;
            } else {
                presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(fi.getCachedSizeField());
                presenceMaskShift = 0;
            }
        }
        buffer[bufferIndex] = fi.getFieldNumber();
        buffer[bufferIndex + 1] = (fi.isEnforceUtf8() ? 0x20000000 : 0) | (fi.isRequired() ? 0x10000000 : 0) | typeId << 20 | fieldOffset;
        buffer[bufferIndex + 2] = presenceMaskShift << 20 | presenceFieldOffset;
        Class<?> messageFieldClass = fi.getMessageFieldClass();
        if (fi.getMapDefaultEntry() != null) {
            objects[bufferIndex / 3 * 2] = fi.getMapDefaultEntry();
            if (messageFieldClass != null) {
                objects[bufferIndex / 3 * 2 + 1] = messageFieldClass;
            } else if (fi.getEnumVerifier() != null) {
                objects[bufferIndex / 3 * 2 + 1] = fi.getEnumVerifier();
            }
        } else if (messageFieldClass != null) {
            objects[bufferIndex / 3 * 2 + 1] = messageFieldClass;
        } else if (fi.getEnumVerifier() != null) {
            objects[bufferIndex / 3 * 2 + 1] = fi.getEnumVerifier();
        }
    }

    @Override
    public T newInstance() {
        return (T)this.newInstanceSchema.newInstance(this.defaultInstance);
    }

    @Override
    public boolean equals(T message2, T other) {
        Object otherUnknown;
        int bufferLength = this.buffer.length;
        for (int pos = 0; pos < bufferLength; pos += 3) {
            if (this.equals(message2, other, pos)) continue;
            return false;
        }
        Object messageUnknown = this.unknownFieldSchema.getFromMessage(message2);
        if (!messageUnknown.equals(otherUnknown = this.unknownFieldSchema.getFromMessage(other))) {
            return false;
        }
        if (this.hasExtensions) {
            FieldSet<?> messageExtensions = this.extensionSchema.getExtensions(message2);
            FieldSet<?> otherExtensions = this.extensionSchema.getExtensions(other);
            return messageExtensions.equals(otherExtensions);
        }
        return true;
    }

    private boolean equals(T message2, T other, int pos) {
        int typeAndOffset = this.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        switch (MessageSchema.type(typeAndOffset)) {
            case 0: {
                return this.arePresentForEquals(message2, other, pos) && Double.doubleToLongBits(UnsafeUtil.getDouble(message2, offset)) == Double.doubleToLongBits(UnsafeUtil.getDouble(other, offset));
            }
            case 1: {
                return this.arePresentForEquals(message2, other, pos) && Float.floatToIntBits(UnsafeUtil.getFloat(message2, offset)) == Float.floatToIntBits(UnsafeUtil.getFloat(other, offset));
            }
            case 2: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getLong(message2, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 3: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getLong(message2, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 4: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getInt(message2, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 5: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getLong(message2, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 6: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getInt(message2, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 7: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getBoolean(message2, offset) == UnsafeUtil.getBoolean(other, offset);
            }
            case 8: {
                return this.arePresentForEquals(message2, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(other, offset));
            }
            case 9: {
                return this.arePresentForEquals(message2, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(other, offset));
            }
            case 10: {
                return this.arePresentForEquals(message2, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(other, offset));
            }
            case 11: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getInt(message2, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 12: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getInt(message2, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 13: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getInt(message2, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 14: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getLong(message2, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 15: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getInt(message2, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 16: {
                return this.arePresentForEquals(message2, other, pos) && UnsafeUtil.getLong(message2, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 17: {
                return this.arePresentForEquals(message2, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(other, offset));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                return SchemaUtil.safeEquals(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(other, offset));
            }
            case 50: {
                return SchemaUtil.safeEquals(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(other, offset));
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return this.isOneofCaseEqual(message2, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message2, offset), UnsafeUtil.getObject(other, offset));
            }
        }
        return true;
    }

    @Override
    public int hashCode(T message2) {
        int hashCode = 0;
        int bufferLength = this.buffer.length;
        block40: for (int pos = 0; pos < bufferLength; pos += 3) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            int entryNumber = this.numberAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    hashCode = hashCode * 53 + Internal.hashLong(Double.doubleToLongBits(UnsafeUtil.getDouble(message2, offset)));
                    continue block40;
                }
                case 1: {
                    hashCode = hashCode * 53 + Float.floatToIntBits(UnsafeUtil.getFloat(message2, offset));
                    continue block40;
                }
                case 2: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message2, offset));
                    continue block40;
                }
                case 3: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message2, offset));
                    continue block40;
                }
                case 4: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message2, offset);
                    continue block40;
                }
                case 5: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message2, offset));
                    continue block40;
                }
                case 6: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message2, offset);
                    continue block40;
                }
                case 7: {
                    hashCode = hashCode * 53 + Internal.hashBoolean(UnsafeUtil.getBoolean(message2, offset));
                    continue block40;
                }
                case 8: {
                    hashCode = hashCode * 53 + ((String)UnsafeUtil.getObject(message2, offset)).hashCode();
                    continue block40;
                }
                case 9: {
                    int protoHash = 37;
                    Object submessage = UnsafeUtil.getObject(message2, offset);
                    if (submessage != null) {
                        protoHash = submessage.hashCode();
                    }
                    hashCode = 53 * hashCode + protoHash;
                    continue block40;
                }
                case 10: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message2, offset).hashCode();
                    continue block40;
                }
                case 11: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message2, offset);
                    continue block40;
                }
                case 12: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message2, offset);
                    continue block40;
                }
                case 13: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message2, offset);
                    continue block40;
                }
                case 14: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message2, offset));
                    continue block40;
                }
                case 15: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message2, offset);
                    continue block40;
                }
                case 16: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message2, offset));
                    continue block40;
                }
                case 17: {
                    int protoHash = 37;
                    Object submessage = UnsafeUtil.getObject(message2, offset);
                    if (submessage != null) {
                        protoHash = submessage.hashCode();
                    }
                    hashCode = 53 * hashCode + protoHash;
                    continue block40;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message2, offset).hashCode();
                    continue block40;
                }
                case 50: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message2, offset).hashCode();
                    continue block40;
                }
                case 51: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(Double.doubleToLongBits(MessageSchema.oneofDoubleAt(message2, offset)));
                    continue block40;
                }
                case 52: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Float.floatToIntBits(MessageSchema.oneofFloatAt(message2, offset));
                    continue block40;
                }
                case 53: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message2, offset));
                    continue block40;
                }
                case 54: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message2, offset));
                    continue block40;
                }
                case 55: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message2, offset);
                    continue block40;
                }
                case 56: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message2, offset));
                    continue block40;
                }
                case 57: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message2, offset);
                    continue block40;
                }
                case 58: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashBoolean(MessageSchema.oneofBooleanAt(message2, offset));
                    continue block40;
                }
                case 59: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + ((String)UnsafeUtil.getObject(message2, offset)).hashCode();
                    continue block40;
                }
                case 60: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    Object submessage = UnsafeUtil.getObject(message2, offset);
                    hashCode = 53 * hashCode + submessage.hashCode();
                    continue block40;
                }
                case 61: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message2, offset).hashCode();
                    continue block40;
                }
                case 62: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message2, offset);
                    continue block40;
                }
                case 63: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message2, offset);
                    continue block40;
                }
                case 64: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message2, offset);
                    continue block40;
                }
                case 65: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message2, offset));
                    continue block40;
                }
                case 66: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message2, offset);
                    continue block40;
                }
                case 67: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message2, offset));
                    continue block40;
                }
                case 68: {
                    if (!this.isOneofPresent(message2, entryNumber, pos)) continue block40;
                    Object submessage = UnsafeUtil.getObject(message2, offset);
                    hashCode = 53 * hashCode + submessage.hashCode();
                    continue block40;
                }
            }
        }
        hashCode = hashCode * 53 + this.unknownFieldSchema.getFromMessage(message2).hashCode();
        if (this.hasExtensions) {
            hashCode = hashCode * 53 + this.extensionSchema.getExtensions(message2).hashCode();
        }
        return hashCode;
    }

    @Override
    public void mergeFrom(T message2, T other) {
        MessageSchema.checkMutable(message2);
        if (other == null) {
            throw new NullPointerException();
        }
        for (int i2 = 0; i2 < this.buffer.length; i2 += 3) {
            this.mergeSingleField(message2, other, i2);
        }
        SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, message2, other);
        if (this.hasExtensions) {
            SchemaUtil.mergeExtensions(this.extensionSchema, message2, other);
        }
    }

    private void mergeSingleField(T message2, T other, int pos) {
        int typeAndOffset = this.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        int number = this.numberAt(pos);
        switch (MessageSchema.type(typeAndOffset)) {
            case 0: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putDouble(message2, offset, UnsafeUtil.getDouble(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 1: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putFloat(message2, offset, UnsafeUtil.getFloat(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 2: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message2, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 3: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message2, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 4: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message2, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 5: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message2, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 6: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message2, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 7: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putBoolean(message2, offset, UnsafeUtil.getBoolean(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 8: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putObject(message2, offset, UnsafeUtil.getObject(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 9: {
                this.mergeMessage(message2, other, pos);
                break;
            }
            case 10: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putObject(message2, offset, UnsafeUtil.getObject(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 11: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message2, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 12: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message2, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 13: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message2, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 14: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message2, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 15: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message2, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 16: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message2, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message2, pos);
                break;
            }
            case 17: {
                this.mergeMessage(message2, other, pos);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                this.listFieldSchema.mergeListsAt(message2, other, offset);
                break;
            }
            case 50: {
                SchemaUtil.mergeMap(this.mapFieldSchema, message2, other, offset);
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                if (!this.isOneofPresent(other, number, pos)) break;
                UnsafeUtil.putObject(message2, offset, UnsafeUtil.getObject(other, offset));
                this.setOneofPresent(message2, number, pos);
                break;
            }
            case 60: {
                this.mergeOneofMessage(message2, other, pos);
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                if (!this.isOneofPresent(other, number, pos)) break;
                UnsafeUtil.putObject(message2, offset, UnsafeUtil.getObject(other, offset));
                this.setOneofPresent(message2, number, pos);
                break;
            }
            case 68: {
                this.mergeOneofMessage(message2, other, pos);
                break;
            }
        }
    }

    private void mergeMessage(T targetParent, T sourceParent, int pos) {
        if (!this.isFieldPresent(sourceParent, pos)) {
            return;
        }
        int typeAndOffset = this.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        Object source = UNSAFE.getObject(sourceParent, offset);
        if (source == null) {
            throw new IllegalStateException("Source subfield " + this.numberAt(pos) + " is present but null: " + sourceParent);
        }
        Schema fieldSchema = this.getMessageFieldSchema(pos);
        if (!this.isFieldPresent(targetParent, pos)) {
            if (!MessageSchema.isMutable(source)) {
                UNSAFE.putObject(targetParent, offset, source);
            } else {
                Object copyOfSource = fieldSchema.newInstance();
                fieldSchema.mergeFrom(copyOfSource, source);
                UNSAFE.putObject(targetParent, offset, copyOfSource);
            }
            this.setFieldPresent(targetParent, pos);
            return;
        }
        Object target = UNSAFE.getObject(targetParent, offset);
        if (!MessageSchema.isMutable(target)) {
            Object newInstance2 = fieldSchema.newInstance();
            fieldSchema.mergeFrom(newInstance2, target);
            UNSAFE.putObject(targetParent, offset, newInstance2);
            target = newInstance2;
        }
        fieldSchema.mergeFrom(target, source);
    }

    private void mergeOneofMessage(T targetParent, T sourceParent, int pos) {
        int number = this.numberAt(pos);
        if (!this.isOneofPresent(sourceParent, number, pos)) {
            return;
        }
        long offset = MessageSchema.offset(this.typeAndOffsetAt(pos));
        Object source = UNSAFE.getObject(sourceParent, offset);
        if (source == null) {
            throw new IllegalStateException("Source subfield " + this.numberAt(pos) + " is present but null: " + sourceParent);
        }
        Schema fieldSchema = this.getMessageFieldSchema(pos);
        if (!this.isOneofPresent(targetParent, number, pos)) {
            if (!MessageSchema.isMutable(source)) {
                UNSAFE.putObject(targetParent, offset, source);
            } else {
                Object copyOfSource = fieldSchema.newInstance();
                fieldSchema.mergeFrom(copyOfSource, source);
                UNSAFE.putObject(targetParent, offset, copyOfSource);
            }
            this.setOneofPresent(targetParent, number, pos);
            return;
        }
        Object target = UNSAFE.getObject(targetParent, offset);
        if (!MessageSchema.isMutable(target)) {
            Object newInstance2 = fieldSchema.newInstance();
            fieldSchema.mergeFrom(newInstance2, target);
            UNSAFE.putObject(targetParent, offset, newInstance2);
            target = newInstance2;
        }
        fieldSchema.mergeFrom(target, source);
    }

    private Schema getMessageFieldSchema(int pos) {
        int index = pos / 3 * 2;
        Schema<Class> schema = (Schema<Class>)this.objects[index];
        if (schema != null) {
            return schema;
        }
        this.objects[index] = schema = Protobuf.getInstance().schemaFor((Class)this.objects[index + 1]);
        return schema;
    }

    @Override
    public void makeImmutable(T message2) {
        if (!MessageSchema.isMutable(message2)) {
            return;
        }
        if (message2 instanceof GeneratedMessageLite) {
            GeneratedMessageLite generatedMessage = (GeneratedMessageLite)message2;
            generatedMessage.clearMemoizedSerializedSize();
            generatedMessage.clearMemoizedHashCode();
            generatedMessage.markImmutable();
        }
        int bufferLength = this.buffer.length;
        block6: for (int pos = 0; pos < bufferLength; pos += 3) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 9: 
                case 17: {
                    if (!this.isFieldPresent(message2, pos)) continue block6;
                    this.getMessageFieldSchema(pos).makeImmutable(UNSAFE.getObject(message2, offset));
                    continue block6;
                }
                case 60: 
                case 68: {
                    if (!this.isOneofPresent(message2, this.numberAt(pos), pos)) continue block6;
                    this.getMessageFieldSchema(pos).makeImmutable(UNSAFE.getObject(message2, offset));
                    continue block6;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    this.listFieldSchema.makeImmutableListAt(message2, offset);
                    continue block6;
                }
                case 50: {
                    Object mapField = UNSAFE.getObject(message2, offset);
                    if (mapField == null) continue block6;
                    UNSAFE.putObject(message2, offset, this.mapFieldSchema.toImmutable(mapField));
                }
            }
        }
        this.unknownFieldSchema.makeImmutable(message2);
        if (this.hasExtensions) {
            this.extensionSchema.makeImmutable(message2);
        }
    }

    private int numberAt(int pos) {
        return this.buffer[pos];
    }

    private int typeAndOffsetAt(int pos) {
        return this.buffer[pos + 1];
    }

    private int presenceMaskAndOffsetAt(int pos) {
        return this.buffer[pos + 2];
    }

    private static int type(int value2) {
        return (value2 & 0xFF00000) >>> 20;
    }

    private static long offset(int value2) {
        return value2 & 0xFFFFF;
    }

    private static boolean isMutable(Object message2) {
        if (message2 == null) {
            return false;
        }
        if (message2 instanceof GeneratedMessageLite) {
            return ((GeneratedMessageLite)message2).isMutable();
        }
        return true;
    }

    private static void checkMutable(Object message2) {
        if (!MessageSchema.isMutable(message2)) {
            throw new IllegalArgumentException("Mutating immutable message: " + message2);
        }
    }

    private static <T> double oneofDoubleAt(T message2, long offset) {
        return (Double)UnsafeUtil.getObject(message2, offset);
    }

    private static <T> float oneofFloatAt(T message2, long offset) {
        return ((Float)UnsafeUtil.getObject(message2, offset)).floatValue();
    }

    private static <T> int oneofIntAt(T message2, long offset) {
        return (Integer)UnsafeUtil.getObject(message2, offset);
    }

    private static <T> long oneofLongAt(T message2, long offset) {
        return (Long)UnsafeUtil.getObject(message2, offset);
    }

    private static <T> boolean oneofBooleanAt(T message2, long offset) {
        return (Boolean)UnsafeUtil.getObject(message2, offset);
    }

    private boolean arePresentForEquals(T message2, T other, int pos) {
        return this.isFieldPresent(message2, pos) == this.isFieldPresent(other, pos);
    }

    private boolean isFieldPresent(T message2, int pos) {
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        long presenceFieldOffset = presenceMaskAndOffset & 0xFFFFF;
        if (presenceFieldOffset == 1048575L) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    return Double.doubleToRawLongBits(UnsafeUtil.getDouble(message2, offset)) != 0L;
                }
                case 1: {
                    return Float.floatToRawIntBits(UnsafeUtil.getFloat(message2, offset)) != 0;
                }
                case 2: {
                    return UnsafeUtil.getLong(message2, offset) != 0L;
                }
                case 3: {
                    return UnsafeUtil.getLong(message2, offset) != 0L;
                }
                case 4: {
                    return UnsafeUtil.getInt(message2, offset) != 0;
                }
                case 5: {
                    return UnsafeUtil.getLong(message2, offset) != 0L;
                }
                case 6: {
                    return UnsafeUtil.getInt(message2, offset) != 0;
                }
                case 7: {
                    return UnsafeUtil.getBoolean(message2, offset);
                }
                case 8: {
                    Object value2 = UnsafeUtil.getObject(message2, offset);
                    if (value2 instanceof String) {
                        return !((String)value2).isEmpty();
                    }
                    if (value2 instanceof ByteString) {
                        return !ByteString.EMPTY.equals(value2);
                    }
                    throw new IllegalArgumentException();
                }
                case 9: {
                    return UnsafeUtil.getObject(message2, offset) != null;
                }
                case 10: {
                    return !ByteString.EMPTY.equals(UnsafeUtil.getObject(message2, offset));
                }
                case 11: {
                    return UnsafeUtil.getInt(message2, offset) != 0;
                }
                case 12: {
                    return UnsafeUtil.getInt(message2, offset) != 0;
                }
                case 13: {
                    return UnsafeUtil.getInt(message2, offset) != 0;
                }
                case 14: {
                    return UnsafeUtil.getLong(message2, offset) != 0L;
                }
                case 15: {
                    return UnsafeUtil.getInt(message2, offset) != 0;
                }
                case 16: {
                    return UnsafeUtil.getLong(message2, offset) != 0L;
                }
                case 17: {
                    return UnsafeUtil.getObject(message2, offset) != null;
                }
            }
            throw new IllegalArgumentException();
        }
        int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
        return (UnsafeUtil.getInt(message2, presenceMaskAndOffset & 0xFFFFF) & presenceMask) != 0;
    }

    private void setFieldPresent(T message2, int pos) {
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        long presenceFieldOffset = presenceMaskAndOffset & 0xFFFFF;
        if (presenceFieldOffset == 1048575L) {
            return;
        }
        int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
        UnsafeUtil.putInt(message2, presenceFieldOffset, UnsafeUtil.getInt(message2, presenceFieldOffset) | presenceMask);
    }

    private boolean isOneofPresent(T message2, int fieldNumber, int pos) {
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        return UnsafeUtil.getInt(message2, presenceMaskAndOffset & 0xFFFFF) == fieldNumber;
    }

    private boolean isOneofCaseEqual(T message2, T other, int pos) {
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        return UnsafeUtil.getInt(message2, presenceMaskAndOffset & 0xFFFFF) == UnsafeUtil.getInt(other, presenceMaskAndOffset & 0xFFFFF);
    }

    private void setOneofPresent(T message2, int fieldNumber, int pos) {
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        UnsafeUtil.putInt(message2, presenceMaskAndOffset & 0xFFFFF, fieldNumber);
    }
}

