/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.LazyField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class MessageReflection {
    static void writeMessageTo(Message message2, Map<Descriptors.FieldDescriptor, Object> fields2, CodedOutputStream output2, boolean alwaysWriteRequiredFields) throws IOException {
        boolean isMessageSet = message2.getDescriptorForType().getOptions().getMessageSetWireFormat();
        if (alwaysWriteRequiredFields) {
            fields2 = new TreeMap<Descriptors.FieldDescriptor, Object>(fields2);
            for (Descriptors.FieldDescriptor field : message2.getDescriptorForType().getFields()) {
                if (!field.isRequired() || fields2.containsKey(field)) continue;
                fields2.put(field, message2.getField(field));
            }
        }
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields2.entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value2 = entry.getValue();
            if (isMessageSet && field.isExtension() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field.isRepeated()) {
                output2.writeMessageSetExtension(field.getNumber(), (Message)value2);
                continue;
            }
            FieldSet.writeField(field, value2, output2);
        }
        UnknownFieldSet unknownFields = message2.getUnknownFields();
        if (isMessageSet) {
            unknownFields.writeAsMessageSetTo(output2);
        } else {
            unknownFields.writeTo(output2);
        }
    }

    static int getSerializedSize(Message message2, Map<Descriptors.FieldDescriptor, Object> fields2) {
        int size = 0;
        boolean isMessageSet = message2.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields2.entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value2 = entry.getValue();
            if (isMessageSet && field.isExtension() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field.isRepeated()) {
                size += CodedOutputStream.computeMessageSetExtensionSize(field.getNumber(), (Message)value2);
                continue;
            }
            size += FieldSet.computeFieldSize(field, value2);
        }
        UnknownFieldSet unknownFields = message2.getUnknownFields();
        size = isMessageSet ? (size += unknownFields.getSerializedSizeAsMessageSet()) : (size += unknownFields.getSerializedSize());
        return size;
    }

    static boolean isInitialized(MessageOrBuilder message2) {
        for (Descriptors.FieldDescriptor fieldDescriptor : message2.getDescriptorForType().getFields()) {
            if (!fieldDescriptor.isRequired() || message2.hasField(fieldDescriptor)) continue;
            return false;
        }
        for (Map.Entry entry : message2.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)entry.getKey();
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field.isRepeated()) {
                for (Message element : (List)entry.getValue()) {
                    if (element.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((Message)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    private static String subMessagePrefix(String prefix, Descriptors.FieldDescriptor field, int index) {
        StringBuilder result2 = new StringBuilder(prefix);
        if (field.isExtension()) {
            result2.append('(').append(field.getFullName()).append(')');
        } else {
            result2.append(field.getName());
        }
        if (index != -1) {
            result2.append('[').append(index).append(']');
        }
        result2.append('.');
        return result2.toString();
    }

    private static void findMissingFields(MessageOrBuilder message2, String prefix, List<String> results) {
        for (Descriptors.FieldDescriptor fieldDescriptor : message2.getDescriptorForType().getFields()) {
            if (!fieldDescriptor.isRequired() || message2.hasField(fieldDescriptor)) continue;
            results.add(prefix + fieldDescriptor.getName());
        }
        for (Map.Entry entry : message2.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)entry.getKey();
            Object value2 = entry.getValue();
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field.isRepeated()) {
                int i2 = 0;
                for (Object element : (List)value2) {
                    MessageReflection.findMissingFields((MessageOrBuilder)element, MessageReflection.subMessagePrefix(prefix, field, i2++), results);
                }
                continue;
            }
            if (!message2.hasField(field)) continue;
            MessageReflection.findMissingFields((MessageOrBuilder)value2, MessageReflection.subMessagePrefix(prefix, field, -1), results);
        }
    }

    static List<String> findMissingFields(MessageOrBuilder message2) {
        ArrayList<String> results = new ArrayList<String>();
        MessageReflection.findMissingFields(message2, "", results);
        return results;
    }

    static boolean mergeFieldFrom(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type2, MergeTarget target, int tag) throws IOException {
        Descriptors.FieldDescriptor field;
        if (type2.getOptions().getMessageSetWireFormat() && tag == WireFormat.MESSAGE_SET_ITEM_TAG) {
            MessageReflection.mergeMessageSetExtensionFromCodedStream(input, unknownFields, extensionRegistry, type2, target);
            return true;
        }
        int wireType = WireFormat.getTagWireType(tag);
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        Message defaultInstance = null;
        if (type2.isExtensionNumber(fieldNumber)) {
            if (extensionRegistry instanceof ExtensionRegistry) {
                ExtensionRegistry.ExtensionInfo extension2 = target.findExtensionByNumber((ExtensionRegistry)extensionRegistry, type2, fieldNumber);
                if (extension2 == null) {
                    field = null;
                } else {
                    field = extension2.descriptor;
                    defaultInstance = extension2.defaultInstance;
                    if (defaultInstance == null && field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        throw new IllegalStateException("Message-typed extension lacked default instance: " + field.getFullName());
                    }
                }
            } else {
                field = null;
            }
        } else {
            field = target.getContainerType() == MergeTarget.ContainerType.MESSAGE ? type2.findFieldByNumber(fieldNumber) : null;
        }
        boolean unknown = false;
        boolean packed = false;
        if (field == null) {
            unknown = true;
        } else if (wireType == FieldSet.getWireFormatForFieldType(field.getLiteType(), false)) {
            packed = false;
        } else if (field.isPackable() && wireType == FieldSet.getWireFormatForFieldType(field.getLiteType(), true)) {
            packed = true;
        } else {
            unknown = true;
        }
        if (unknown) {
            if (unknownFields != null) {
                return unknownFields.mergeFieldFrom(tag, input);
            }
            return input.skipField(tag);
        }
        if (packed) {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (field.getLiteType() == WireFormat.FieldType.ENUM) {
                while (input.getBytesUntilLimit() > 0) {
                    int rawValue = input.readEnum();
                    if (field.legacyEnumFieldTreatedAsClosed()) {
                        Descriptors.EnumValueDescriptor value2 = field.getEnumType().findValueByNumber(rawValue);
                        if (value2 == null) {
                            if (unknownFields == null) continue;
                            unknownFields.mergeVarintField(fieldNumber, rawValue);
                            continue;
                        }
                        target.addRepeatedField(field, value2);
                        continue;
                    }
                    target.addRepeatedField(field, field.getEnumType().findValueByNumberCreatingIfUnknown(rawValue));
                }
            } else {
                while (input.getBytesUntilLimit() > 0) {
                    Object value3 = WireFormat.readPrimitiveField(input, field.getLiteType(), target.getUtf8Validation(field));
                    target.addRepeatedField(field, value3);
                }
            }
            input.popLimit(limit);
        } else {
            Object value4;
            switch (field.getType()) {
                case GROUP: {
                    target.mergeGroup(input, extensionRegistry, field, defaultInstance);
                    return true;
                }
                case MESSAGE: {
                    target.mergeMessage(input, extensionRegistry, field, defaultInstance);
                    return true;
                }
                case ENUM: {
                    int rawValue = input.readEnum();
                    if (field.legacyEnumFieldTreatedAsClosed()) {
                        value4 = field.getEnumType().findValueByNumber(rawValue);
                        if (value4 != null) break;
                        if (unknownFields != null) {
                            unknownFields.mergeVarintField(fieldNumber, rawValue);
                        }
                        return true;
                    }
                    value4 = field.getEnumType().findValueByNumberCreatingIfUnknown(rawValue);
                    break;
                }
                default: {
                    value4 = WireFormat.readPrimitiveField(input, field.getLiteType(), target.getUtf8Validation(field));
                }
            }
            if (field.isRepeated()) {
                target.addRepeatedField(field, value4);
            } else {
                target.setField(field, value4);
            }
        }
        return true;
    }

    static void mergeMessageFrom(Message.Builder target, UnknownFieldSet.Builder unknownFields, CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        int tag;
        BuilderAdapter builderAdapter = new BuilderAdapter(target);
        Descriptors.Descriptor descriptorForType = target.getDescriptorForType();
        while ((tag = input.readTag()) != 0 && MessageReflection.mergeFieldFrom(input, unknownFields, extensionRegistry, descriptorForType, builderAdapter, tag)) {
        }
    }

    private static void mergeMessageSetExtensionFromCodedStream(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type2, MergeTarget target) throws IOException {
        int tag;
        int typeId = 0;
        ByteString rawBytes = null;
        ExtensionRegistry.ExtensionInfo extension2 = null;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                typeId = input.readUInt32();
                if (typeId == 0 || !(extensionRegistry instanceof ExtensionRegistry)) continue;
                extension2 = target.findExtensionByNumber((ExtensionRegistry)extensionRegistry, type2, typeId);
                continue;
            }
            if (tag == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                if (typeId != 0 && extension2 != null && ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                    MessageReflection.eagerlyMergeMessageSetExtension(input, extension2, extensionRegistry, target);
                    rawBytes = null;
                    continue;
                }
                rawBytes = input.readBytes();
                continue;
            }
            if (input.skipField(tag)) continue;
            break;
        }
        input.checkLastTagWas(WireFormat.MESSAGE_SET_ITEM_END_TAG);
        if (rawBytes != null && typeId != 0) {
            if (extension2 != null) {
                MessageReflection.mergeMessageSetExtensionFromBytes(rawBytes, extension2, extensionRegistry, target);
            } else if (rawBytes != null && unknownFields != null) {
                unknownFields.mergeField(typeId, UnknownFieldSet.Field.newBuilder().addLengthDelimited(rawBytes).build());
            }
        }
    }

    private static void mergeMessageSetExtensionFromBytes(ByteString rawBytes, ExtensionRegistry.ExtensionInfo extension2, ExtensionRegistryLite extensionRegistry, MergeTarget target) throws IOException {
        Descriptors.FieldDescriptor field = extension2.descriptor;
        boolean hasOriginalValue = target.hasField(field);
        if (hasOriginalValue || ExtensionRegistryLite.isEagerlyParseMessageSets()) {
            Object value2 = target.parseMessageFromBytes(rawBytes, extensionRegistry, field, extension2.defaultInstance);
            target.setField(field, value2);
        } else {
            LazyField lazyField = new LazyField(extension2.defaultInstance, extensionRegistry, rawBytes);
            target.setField(field, lazyField);
        }
    }

    private static void eagerlyMergeMessageSetExtension(CodedInputStream input, ExtensionRegistry.ExtensionInfo extension2, ExtensionRegistryLite extensionRegistry, MergeTarget target) throws IOException {
        Descriptors.FieldDescriptor field = extension2.descriptor;
        Object value2 = target.parseMessage(input, extensionRegistry, field, extension2.defaultInstance);
        target.setField(field, value2);
    }

    static class ExtensionBuilderAdapter
    implements MergeTarget {
        private final FieldSet.Builder<Descriptors.FieldDescriptor> extensions;

        ExtensionBuilderAdapter(FieldSet.Builder<Descriptors.FieldDescriptor> extensions) {
            this.extensions = extensions;
        }

        public Object getField(Descriptors.FieldDescriptor field) {
            return this.extensions.getField(field);
        }

        @Override
        public boolean hasField(Descriptors.FieldDescriptor field) {
            return this.extensions.hasField(field);
        }

        @Override
        public MergeTarget setField(Descriptors.FieldDescriptor field, Object value2) {
            this.extensions.setField(field, value2);
            return this;
        }

        @Override
        public MergeTarget addRepeatedField(Descriptors.FieldDescriptor field, Object value2) {
            this.extensions.addRepeatedField(field, value2);
            return this;
        }

        @Override
        public MergeTarget.ContainerType getContainerType() {
            return MergeTarget.ContainerType.EXTENSION_SET;
        }

        @Override
        public ExtensionRegistry.ExtensionInfo findExtensionByNumber(ExtensionRegistry registry, Descriptors.Descriptor containingType, int fieldNumber) {
            return registry.findImmutableExtensionByNumber(containingType, fieldNumber);
        }

        @Override
        public Object parseMessage(CodedInputStream input, ExtensionRegistryLite registry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance.newBuilderForType();
            if (!field.isRepeated() && (originalMessage = (Message)this.getField(field)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            input.readMessage(subBuilder, registry);
            return subBuilder.buildPartial();
        }

        @Override
        public void mergeGroup(CodedInputStream input, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            if (!field.isRepeated()) {
                if (this.hasField(field)) {
                    MessageLite.Builder subBuilder;
                    Object fieldOrBuilder = this.extensions.getFieldAllowBuilders(field);
                    if (fieldOrBuilder instanceof MessageLite.Builder) {
                        subBuilder = (MessageLite.Builder)fieldOrBuilder;
                    } else {
                        subBuilder = ((MessageLite)fieldOrBuilder).toBuilder();
                        this.extensions.setField(field, subBuilder);
                    }
                    input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                    return;
                }
                Message.Builder subBuilder = defaultInstance.newBuilderForType();
                input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.setField(field, subBuilder);
            } else {
                Message.Builder subBuilder = defaultInstance.newBuilderForType();
                input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.addRepeatedField(field, subBuilder.buildPartial());
            }
        }

        @Override
        public void mergeMessage(CodedInputStream input, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            if (!field.isRepeated()) {
                if (this.hasField(field)) {
                    MessageLite.Builder subBuilder;
                    Object fieldOrBuilder = this.extensions.getFieldAllowBuilders(field);
                    if (fieldOrBuilder instanceof MessageLite.Builder) {
                        subBuilder = (MessageLite.Builder)fieldOrBuilder;
                    } else {
                        subBuilder = ((MessageLite)fieldOrBuilder).toBuilder();
                        this.extensions.setField(field, subBuilder);
                    }
                    input.readMessage(subBuilder, extensionRegistry);
                    return;
                }
                Message.Builder subBuilder = defaultInstance.newBuilderForType();
                input.readMessage(subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.setField(field, subBuilder);
            } else {
                Message.Builder subBuilder = defaultInstance.newBuilderForType();
                input.readMessage(subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.addRepeatedField(field, subBuilder.buildPartial());
            }
        }

        @Override
        public Object parseMessageFromBytes(ByteString bytes2, ExtensionRegistryLite registry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance.newBuilderForType();
            if (!field.isRepeated() && (originalMessage = (Message)this.getField(field)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            subBuilder.mergeFrom(bytes2, registry);
            return subBuilder.buildPartial();
        }

        @Override
        public WireFormat.Utf8Validation getUtf8Validation(Descriptors.FieldDescriptor descriptor) {
            if (descriptor.needsUtf8Check()) {
                return WireFormat.Utf8Validation.STRICT;
            }
            return WireFormat.Utf8Validation.LOOSE;
        }
    }

    static class BuilderAdapter
    implements MergeTarget {
        private final Message.Builder builder;
        private boolean hasNestedBuilders = true;

        public BuilderAdapter(Message.Builder builder) {
            this.builder = builder;
        }

        public Object getField(Descriptors.FieldDescriptor field) {
            return this.builder.getField(field);
        }

        private Message.Builder getFieldBuilder(Descriptors.FieldDescriptor field) {
            if (this.hasNestedBuilders) {
                try {
                    return this.builder.getFieldBuilder(field);
                }
                catch (UnsupportedOperationException e) {
                    this.hasNestedBuilders = false;
                }
            }
            return null;
        }

        @Override
        public boolean hasField(Descriptors.FieldDescriptor field) {
            return this.builder.hasField(field);
        }

        @Override
        public MergeTarget setField(Descriptors.FieldDescriptor field, Object value2) {
            if (!field.isRepeated() && value2 instanceof MessageLite.Builder) {
                if (value2 != this.getFieldBuilder(field)) {
                    this.builder.setField(field, ((MessageLite.Builder)value2).buildPartial());
                }
                return this;
            }
            this.builder.setField(field, value2);
            return this;
        }

        @Override
        public MergeTarget addRepeatedField(Descriptors.FieldDescriptor field, Object value2) {
            if (value2 instanceof MessageLite.Builder) {
                value2 = ((MessageLite.Builder)value2).buildPartial();
            }
            this.builder.addRepeatedField(field, value2);
            return this;
        }

        @Override
        public MergeTarget.ContainerType getContainerType() {
            return MergeTarget.ContainerType.MESSAGE;
        }

        @Override
        public ExtensionRegistry.ExtensionInfo findExtensionByNumber(ExtensionRegistry registry, Descriptors.Descriptor containingType, int fieldNumber) {
            return registry.findImmutableExtensionByNumber(containingType, fieldNumber);
        }

        @Override
        public Object parseMessage(CodedInputStream input, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : this.builder.newBuilderForField(field);
            if (!field.isRepeated() && (originalMessage = (Message)this.getField(field)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            input.readMessage(subBuilder, extensionRegistry);
            return subBuilder.buildPartial();
        }

        @Override
        public Object parseMessageFromBytes(ByteString bytes2, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : this.builder.newBuilderForField(field);
            if (!field.isRepeated() && (originalMessage = (Message)this.getField(field)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            subBuilder.mergeFrom(bytes2, extensionRegistry);
            return subBuilder.buildPartial();
        }

        @Override
        public void mergeGroup(CodedInputStream input, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            if (!field.isRepeated()) {
                Message.Builder subBuilder;
                if (this.hasField(field)) {
                    subBuilder = this.getFieldBuilder(field);
                    if (subBuilder != null) {
                        input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                        return;
                    }
                    subBuilder = this.newMessageFieldInstance(field, defaultInstance);
                    subBuilder.mergeFrom((Message)this.getField(field));
                } else {
                    subBuilder = this.newMessageFieldInstance(field, defaultInstance);
                }
                input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.setField(field, subBuilder.buildPartial());
            } else {
                Message.Builder subBuilder = this.newMessageFieldInstance(field, defaultInstance);
                input.readGroup(field.getNumber(), subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.addRepeatedField(field, subBuilder.buildPartial());
            }
        }

        @Override
        public void mergeMessage(CodedInputStream input, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field, Message defaultInstance) throws IOException {
            if (!field.isRepeated()) {
                Message.Builder subBuilder;
                if (this.hasField(field)) {
                    subBuilder = this.getFieldBuilder(field);
                    if (subBuilder != null) {
                        input.readMessage(subBuilder, extensionRegistry);
                        return;
                    }
                    subBuilder = this.newMessageFieldInstance(field, defaultInstance);
                    subBuilder.mergeFrom((Message)this.getField(field));
                } else {
                    subBuilder = this.newMessageFieldInstance(field, defaultInstance);
                }
                input.readMessage(subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.setField(field, subBuilder.buildPartial());
            } else {
                Message.Builder subBuilder = this.newMessageFieldInstance(field, defaultInstance);
                input.readMessage(subBuilder, extensionRegistry);
                MergeTarget mergeTarget = this.addRepeatedField(field, subBuilder.buildPartial());
            }
        }

        private Message.Builder newMessageFieldInstance(Descriptors.FieldDescriptor field, Message defaultInstance) {
            if (defaultInstance != null) {
                return defaultInstance.newBuilderForType();
            }
            return this.builder.newBuilderForField(field);
        }

        @Override
        public WireFormat.Utf8Validation getUtf8Validation(Descriptors.FieldDescriptor descriptor) {
            if (descriptor.needsUtf8Check()) {
                return WireFormat.Utf8Validation.STRICT;
            }
            if (!descriptor.isRepeated() && this.builder instanceof GeneratedMessage.Builder) {
                return WireFormat.Utf8Validation.LAZY;
            }
            return WireFormat.Utf8Validation.LOOSE;
        }
    }

    static interface MergeTarget {
        public ContainerType getContainerType();

        public ExtensionRegistry.ExtensionInfo findExtensionByNumber(ExtensionRegistry var1, Descriptors.Descriptor var2, int var3);

        public boolean hasField(Descriptors.FieldDescriptor var1);

        public MergeTarget setField(Descriptors.FieldDescriptor var1, Object var2);

        public MergeTarget addRepeatedField(Descriptors.FieldDescriptor var1, Object var2);

        public Object parseMessage(CodedInputStream var1, ExtensionRegistryLite var2, Descriptors.FieldDescriptor var3, Message var4) throws IOException;

        public Object parseMessageFromBytes(ByteString var1, ExtensionRegistryLite var2, Descriptors.FieldDescriptor var3, Message var4) throws IOException;

        public void mergeGroup(CodedInputStream var1, ExtensionRegistryLite var2, Descriptors.FieldDescriptor var3, Message var4) throws IOException;

        public void mergeMessage(CodedInputStream var1, ExtensionRegistryLite var2, Descriptors.FieldDescriptor var3, Message var4) throws IOException;

        public WireFormat.Utf8Validation getUtf8Validation(Descriptors.FieldDescriptor var1);

        public static final class ContainerType
        extends Enum<ContainerType> {
            public static final /* enum */ ContainerType MESSAGE = new ContainerType();
            public static final /* enum */ ContainerType EXTENSION_SET = new ContainerType();
            private static final /* synthetic */ ContainerType[] $VALUES;

            static {
                $VALUES = new ContainerType[]{MESSAGE, EXTENSION_SET};
            }
        }
    }
}

