/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyField;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.SmallSortedMap;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy2) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    private FieldSet(SmallSortedMap<T, Object> fields2) {
        this.fields = fields2;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder();
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            if (!(entry.getValue() instanceof GeneratedMessageLite)) continue;
            ((GeneratedMessageLite)entry.getValue()).makeImmutable();
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        return this.fields.equals(other.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet<T> clone() {
        FieldSet<FieldDescriptorLite> clone = FieldSet.newFieldSet();
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        clone.hasLazyField = this.hasLazyField;
        return clone;
    }

    public Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap<T, Object> result2 = FieldSet.cloneAllFieldsMap(this.fields, false);
            if (this.fields.isImmutable()) {
                result2.makeImmutable();
            }
            return result2;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> fields2, boolean copyList) {
        SmallSortedMap result2 = SmallSortedMap.newFieldMap(16);
        for (int i2 = 0; i2 < fields2.getNumArrayEntries(); ++i2) {
            FieldSet.cloneFieldEntry(result2, fields2.getArrayEntryAt(i2), copyList);
        }
        for (Map.Entry<T, Object> entry : fields2.getOverflowEntries()) {
            FieldSet.cloneFieldEntry(result2, entry, copyList);
        }
        return result2;
    }

    private static <T extends FieldDescriptorLite<T>> void cloneFieldEntry(Map<T, Object> map2, Map.Entry<T, Object> entry, boolean copyList) {
        FieldDescriptorLite key = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (value2 instanceof LazyField) {
            map2.put(key, ((LazyField)value2).getValue());
        } else if (copyList && value2 instanceof List) {
            map2.put(key, new ArrayList((List)value2));
        } else {
            map2.put(key, value2);
        }
    }

    public Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    public boolean hasField(T descriptor) {
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(descriptor) != null;
    }

    public Object getField(T descriptor) {
        Object o = this.fields.get(descriptor);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return o;
    }

    public void setField(T descriptor, Object value2) {
        if (descriptor.isRepeated()) {
            if (!(value2 instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll(value2);
            for (Object element : newList) {
                this.verifyType(descriptor, element);
            }
            value2 = newList;
        } else {
            this.verifyType(descriptor, value2);
        }
        if (value2 instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(descriptor, (Object)value2);
    }

    private void verifyType(T descriptor, Object value2) {
        if (!FieldSet.isValidType(descriptor.getLiteType(), value2)) {
            throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), descriptor.getLiteType().getJavaType(), value2.getClass().getName()}));
        }
    }

    private static boolean isValidType(WireFormat.FieldType type2, Object value2) {
        Internal.checkNotNull(value2);
        switch (type2.getJavaType()) {
            case INT: {
                return value2 instanceof Integer;
            }
            case LONG: {
                return value2 instanceof Long;
            }
            case FLOAT: {
                return value2 instanceof Float;
            }
            case DOUBLE: {
                return value2 instanceof Double;
            }
            case BOOLEAN: {
                return value2 instanceof Boolean;
            }
            case STRING: {
                return value2 instanceof String;
            }
            case BYTE_STRING: {
                return value2 instanceof ByteString || value2 instanceof byte[];
            }
            case ENUM: {
                return value2 instanceof Integer || value2 instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                return value2 instanceof MessageLite || value2 instanceof LazyField;
            }
        }
        return false;
    }

    public boolean isInitialized() {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (descriptor.isRepeated()) {
                for (Object element : (List)entry.getValue()) {
                    if (FieldSet.isMessageFieldValueInitialized(element)) continue;
                    return false;
                }
            } else {
                return FieldSet.isMessageFieldValueInitialized(entry.getValue());
            }
        }
        return true;
    }

    private static boolean isMessageFieldValueInitialized(Object value2) {
        if (value2 instanceof MessageLiteOrBuilder) {
            return ((MessageLiteOrBuilder)value2).isInitialized();
        }
        if (value2 instanceof LazyField) {
            return true;
        }
        throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type2, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type2.getWireType();
    }

    public void mergeFrom(FieldSet<T> other) {
        for (int i2 = 0; i2 < other.fields.getNumArrayEntries(); ++i2) {
            this.mergeFromField(other.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<T, Object> entry : other.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private static Object cloneIfMutable(Object value2) {
        if (value2 instanceof byte[]) {
            byte[] bytes2 = (byte[])value2;
            byte[] copy2 = new byte[bytes2.length];
            System.arraycopy(bytes2, 0, copy2, 0, bytes2.length);
            return copy2;
        }
        return value2;
    }

    private void mergeFromField(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object otherValue = entry.getValue();
        if (otherValue instanceof LazyField) {
            otherValue = ((LazyField)otherValue).getValue();
        }
        if (descriptor.isRepeated()) {
            ArrayList value2 = this.getField(descriptor);
            if (value2 == null) {
                value2 = new ArrayList();
            }
            for (Object element : (List)otherValue) {
                ((List)value2).add(FieldSet.cloneIfMutable(element));
            }
            this.fields.put((T)descriptor, (Object)value2);
        } else if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object value3 = this.getField(descriptor);
            if (value3 == null) {
                this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
            } else {
                value3 = descriptor.internalMergeFrom(((MessageLite)value3).toBuilder(), (MessageLite)otherValue).build();
                this.fields.put((T)descriptor, value3);
            }
        } else {
            this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
        }
    }

    public void writeTo(CodedOutputStream output2) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output2);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output2);
        }
    }

    public void writeMessageSetTo(CodedOutputStream output2) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i2), output2);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, output2);
        }
    }

    private void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream output2) throws IOException {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Object value2 = entry.getValue();
            if (value2 instanceof LazyField) {
                ByteString valueBytes = ((LazyField)value2).toByteString();
                output2.writeRawMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), valueBytes);
            } else {
                output2.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
            }
        } else {
            FieldSet.writeField(descriptor, entry.getValue(), output2);
        }
    }

    static void writeElement(CodedOutputStream output2, WireFormat.FieldType type2, int number, Object value2) throws IOException {
        if (type2 == WireFormat.FieldType.GROUP) {
            output2.writeGroup(number, (MessageLite)value2);
        } else {
            output2.writeTag(number, FieldSet.getWireFormatForFieldType(type2, false));
            FieldSet.writeElementNoTag(output2, type2, value2);
        }
    }

    static void writeElementNoTag(CodedOutputStream output2, WireFormat.FieldType type2, Object value2) throws IOException {
        switch (type2) {
            case DOUBLE: {
                output2.writeDoubleNoTag((Double)value2);
                break;
            }
            case FLOAT: {
                output2.writeFloatNoTag(((Float)value2).floatValue());
                break;
            }
            case INT64: {
                output2.writeInt64NoTag((Long)value2);
                break;
            }
            case UINT64: {
                output2.writeUInt64NoTag((Long)value2);
                break;
            }
            case INT32: {
                output2.writeInt32NoTag((Integer)value2);
                break;
            }
            case FIXED64: {
                output2.writeFixed64NoTag((Long)value2);
                break;
            }
            case FIXED32: {
                output2.writeFixed32NoTag((Integer)value2);
                break;
            }
            case BOOL: {
                output2.writeBoolNoTag((Boolean)value2);
                break;
            }
            case GROUP: {
                output2.writeGroupNoTag((MessageLite)value2);
                break;
            }
            case MESSAGE: {
                output2.writeMessageNoTag((MessageLite)value2);
                break;
            }
            case STRING: {
                if (value2 instanceof ByteString) {
                    output2.writeBytesNoTag((ByteString)value2);
                    break;
                }
                output2.writeStringNoTag((String)value2);
                break;
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    output2.writeBytesNoTag((ByteString)value2);
                    break;
                }
                output2.writeByteArrayNoTag((byte[])value2);
                break;
            }
            case UINT32: {
                output2.writeUInt32NoTag((Integer)value2);
                break;
            }
            case SFIXED32: {
                output2.writeSFixed32NoTag((Integer)value2);
                break;
            }
            case SFIXED64: {
                output2.writeSFixed64NoTag((Long)value2);
                break;
            }
            case SINT32: {
                output2.writeSInt32NoTag((Integer)value2);
                break;
            }
            case SINT64: {
                output2.writeSInt64NoTag((Long)value2);
                break;
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    output2.writeEnumNoTag(((Internal.EnumLite)value2).getNumber());
                    break;
                }
                output2.writeEnumNoTag((Integer)value2);
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> descriptor, Object value2, CodedOutputStream output2) throws IOException {
        WireFormat.FieldType type2 = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List valueList = (List)value2;
            if (descriptor.isPacked()) {
                if (valueList.isEmpty()) {
                    return;
                }
                output2.writeTag(number, 2);
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                output2.writeUInt32NoTag(dataSize);
                for (Object element : valueList) {
                    FieldSet.writeElementNoTag(output2, type2, element);
                }
            } else {
                for (Object element : valueList) {
                    FieldSet.writeElement(output2, type2, number, element);
                }
            }
        } else if (value2 instanceof LazyField) {
            FieldSet.writeElement(output2, type2, number, ((LazyField)value2).getValue());
        } else {
            FieldSet.writeElement(output2, type2, number, value2);
        }
    }

    public int getSerializedSize() {
        int size = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return size;
    }

    public int getMessageSetSerializedSize() {
        int size = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            size += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            size += this.getMessageSetSerializedSize(entry);
        }
        return size;
    }

    private int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            if (value2 instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value2);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
        }
        return FieldSet.computeFieldSize(descriptor, value2);
    }

    static int computeElementSize(WireFormat.FieldType type2, int number, Object value2) {
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type2 == WireFormat.FieldType.GROUP) {
            tagSize *= 2;
        }
        return tagSize + FieldSet.computeElementSizeNoTag(type2, value2);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType type2, Object value2) {
        switch (type2) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value2);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value2).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value2);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value2);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value2);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value2);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value2);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value2);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value2);
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value2);
            }
            case STRING: {
                if (value2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value2);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value2);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value2);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value2);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value2);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value2);
            }
            case MESSAGE: {
                if (value2 instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value2);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value2);
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value2).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)value2);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value2) {
        WireFormat.FieldType type2 = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List valueList = (List)value2;
            if (descriptor.isPacked()) {
                if (valueList.isEmpty()) {
                    return 0;
                }
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(dataSize);
            }
            int size = 0;
            for (Object element : valueList) {
                size += FieldSet.computeElementSize(type2, number, element);
            }
            return size;
        }
        return FieldSet.computeElementSize(type2, number, value2);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap(16));
        }

        private Builder(SmallSortedMap<T, Object> fields2) {
            this.fields = fields2;
            this.isMutable = true;
        }

        public FieldSet<T> build() {
            return this.buildImpl(false);
        }

        public FieldSet<T> buildPartial() {
            return this.buildImpl(true);
        }

        private FieldSet<T> buildImpl(boolean partial) {
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap fieldsForBuild = this.fields;
            if (this.hasNestedBuilders) {
                fieldsForBuild = FieldSet.cloneAllFieldsMap(this.fields, false);
                Builder.replaceBuilders(fieldsForBuild, partial);
            }
            FieldSet fieldSet = new FieldSet(fieldsForBuild);
            fieldSet.hasLazyField = this.hasLazyField;
            return fieldSet;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> fieldMap, boolean partial) {
            for (int i2 = 0; i2 < fieldMap.getNumArrayEntries(); ++i2) {
                Builder.replaceBuilders(fieldMap.getArrayEntryAt(i2), partial);
            }
            for (Map.Entry<T, Object> entry : fieldMap.getOverflowEntries()) {
                Builder.replaceBuilders(entry, partial);
            }
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry, boolean partial) {
            entry.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry.getKey(), entry.getValue(), partial));
        }

        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T descriptor, Object value2, boolean partial) {
            if (value2 == null) {
                return value2;
            }
            if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                if (descriptor.isRepeated()) {
                    if (!(value2 instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + value2.getClass());
                    }
                    ArrayList<Object> list2 = (ArrayList<Object>)value2;
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        Object oldElement = list2.get(i2);
                        Object newElement = Builder.replaceBuilder(oldElement, partial);
                        if (newElement == oldElement) continue;
                        if (list2 == value2) {
                            list2 = new ArrayList<Object>(list2);
                        }
                        list2.set(i2, newElement);
                    }
                    return list2;
                }
                return Builder.replaceBuilder(value2, partial);
            }
            return value2;
        }

        private static Object replaceBuilder(Object value2, boolean partial) {
            if (!(value2 instanceof MessageLite.Builder)) {
                return value2;
            }
            MessageLite.Builder builder = (MessageLite.Builder)value2;
            if (partial) {
                return builder.buildPartial();
            }
            return builder.build();
        }

        public Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                SmallSortedMap result2 = FieldSet.cloneAllFieldsMap(this.fields, false);
                if (this.fields.isImmutable()) {
                    result2.makeImmutable();
                } else {
                    Builder.replaceBuilders(result2, true);
                }
                return result2;
            }
            return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
        }

        public boolean hasField(T descriptor) {
            if (descriptor.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(descriptor) != null;
        }

        public Object getField(T descriptor) {
            Object value2 = this.getFieldAllowBuilders(descriptor);
            return Builder.replaceBuilders(descriptor, value2, true);
        }

        Object getFieldAllowBuilders(T descriptor) {
            Object o = this.fields.get(descriptor);
            if (o instanceof LazyField) {
                return ((LazyField)o).getValue();
            }
            return o;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.cloneAllFieldsMap(this.fields, true);
                this.isMutable = true;
            }
        }

        public void setField(T descriptor, Object value2) {
            this.ensureIsMutable();
            if (descriptor.isRepeated()) {
                if (!(value2 instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList newList = new ArrayList(value2);
                for (Object element : newList) {
                    this.verifyType(descriptor, element);
                    this.hasNestedBuilders = this.hasNestedBuilders || element instanceof MessageLite.Builder;
                }
                value2 = newList;
            } else {
                this.verifyType(descriptor, value2);
            }
            if (value2 instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value2 instanceof MessageLite.Builder;
            this.fields.put(descriptor, (Object)value2);
        }

        public void clearField(T descriptor) {
            this.ensureIsMutable();
            this.fields.remove(descriptor);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        public void addRepeatedField(T descriptor, Object value2) {
            ArrayList<Object> list2;
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value2 instanceof MessageLite.Builder;
            this.verifyType(descriptor, value2);
            Object existingValue = this.getFieldAllowBuilders(descriptor);
            if (existingValue == null) {
                list2 = new ArrayList<Object>();
                this.fields.put(descriptor, (Object)list2);
            } else {
                list2 = (ArrayList<Object>)existingValue;
            }
            list2.add(value2);
        }

        private void verifyType(T descriptor, Object value2) {
            if (!FieldSet.isValidType(descriptor.getLiteType(), value2)) {
                if (descriptor.getLiteType().getJavaType() == WireFormat.JavaType.MESSAGE && value2 instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), descriptor.getLiteType().getJavaType(), value2.getClass().getName()}));
            }
        }

        public boolean isInitialized() {
            for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        public void mergeFrom(FieldSet<T> other) {
            this.ensureIsMutable();
            for (int i2 = 0; i2 < ((FieldSet)other).fields.getNumArrayEntries(); ++i2) {
                this.mergeFromField(((FieldSet)other).fields.getArrayEntryAt(i2));
            }
            for (Map.Entry entry : ((FieldSet)other).fields.getOverflowEntries()) {
                this.mergeFromField(entry);
            }
        }

        private void mergeFromField(Map.Entry<T, Object> entry) {
            FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
            Object otherValue = entry.getValue();
            if (otherValue instanceof LazyField) {
                otherValue = ((LazyField)otherValue).getValue();
            }
            if (descriptor.isRepeated()) {
                ArrayList<Object> value2 = (ArrayList<Object>)this.getFieldAllowBuilders(descriptor);
                if (value2 == null) {
                    value2 = new ArrayList<Object>();
                    this.fields.put((T)descriptor, (Object)value2);
                }
                for (Object element : (List)otherValue) {
                    value2.add(FieldSet.cloneIfMutable(element));
                }
            } else if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                Object value3 = this.getFieldAllowBuilders(descriptor);
                if (value3 == null) {
                    this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
                } else if (value3 instanceof MessageLite.Builder) {
                    descriptor.internalMergeFrom((MessageLite.Builder)value3, (MessageLite)otherValue);
                } else {
                    value3 = descriptor.internalMergeFrom(((MessageLite)value3).toBuilder(), (MessageLite)otherValue).build();
                    this.fields.put((T)descriptor, value3);
                }
            } else {
                this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
            }
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

