/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();

    public static CodedOutputStream newInstance(byte[] flatArray) {
        return CodedOutputStream.newInstance(flatArray, 0, flatArray.length);
    }

    public static CodedOutputStream newInstance(byte[] flatArray, int offset, int length) {
        return new ArrayEncoder(flatArray, offset, length);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeUInt32(int var1, int var2) throws IOException;

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    public final void writeInt64(int fieldNumber, long value2) throws IOException {
        this.writeUInt64(fieldNumber, value2);
    }

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    public final void writeDouble(int fieldNumber, double value2) throws IOException {
        this.writeFixed64(fieldNumber, Double.doubleToRawLongBits(value2));
    }

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    public final void writeEnum(int fieldNumber, int value2) throws IOException {
        this.writeInt32(fieldNumber, value2);
    }

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    public abstract void writeMessage(int var1, MessageLite var2) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    public final void writeSInt32NoTag(int value2) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(value2));
    }

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    public final void writeSFixed32NoTag(int value2) throws IOException {
        this.writeFixed32NoTag(value2);
    }

    public final void writeInt64NoTag(long value2) throws IOException {
        this.writeUInt64NoTag(value2);
    }

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    public final void writeSInt64NoTag(long value2) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(value2));
    }

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    public final void writeSFixed64NoTag(long value2) throws IOException {
        this.writeFixed64NoTag(value2);
    }

    public final void writeFloatNoTag(float value2) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(value2));
    }

    public final void writeDoubleNoTag(double value2) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(value2));
    }

    public final void writeBoolNoTag(boolean value2) throws IOException {
        this.write((byte)(value2 ? 1 : 0));
    }

    public final void writeEnumNoTag(int value2) throws IOException {
        this.writeInt32NoTag(value2);
    }

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    public final void writeByteArrayNoTag(byte[] value2) throws IOException {
        this.writeByteArrayNoTag(value2, 0, value2.length);
    }

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    public abstract void write(byte var1) throws IOException;

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    public static int computeInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeUInt32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt32SizeNoTag(value2);
    }

    public static int computeFixed32Size(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed32SizeNoTag(value2);
    }

    public static int computeInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt64SizeNoTag(value2);
    }

    public static int computeUInt64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag(value2);
    }

    public static int computeFixed64Size(int fieldNumber, long value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed64SizeNoTag(value2);
    }

    public static int computeDoubleSize(int fieldNumber, double value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeDoubleSizeNoTag(value2);
    }

    public static int computeBoolSize(int fieldNumber, boolean value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBoolSizeNoTag(value2);
    }

    public static int computeEnumSize(int fieldNumber, int value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeEnumSizeNoTag(value2);
    }

    public static int computeStringSize(int fieldNumber, String value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeStringSizeNoTag(value2);
    }

    public static int computeBytesSize(int fieldNumber, ByteString value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBytesSizeNoTag(value2);
    }

    public static int computeLazyFieldSize(int fieldNumber, LazyFieldLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLazyFieldSizeNoTag(value2);
    }

    public static int computeMessageSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag(value2);
    }

    public static int computeMessageSetExtensionSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeMessageSize(3, value2);
    }

    public static int computeRawMessageSetExtensionSize(int fieldNumber, ByteString value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeBytesSize(3, value2);
    }

    public static int computeLazyFieldMessageSetExtensionSize(int fieldNumber, LazyFieldLite value2) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, fieldNumber) + CodedOutputStream.computeLazyFieldSize(3, value2);
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    public static int computeInt32SizeNoTag(int value2) {
        if (value2 >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(value2);
        }
        return 10;
    }

    public static int computeUInt32SizeNoTag(int value2) {
        if ((value2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeSInt32SizeNoTag(int value2) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value2));
    }

    public static int computeFixed32SizeNoTag(int unused) {
        return 4;
    }

    public static int computeSFixed32SizeNoTag(int unused) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeUInt64SizeNoTag(value2);
    }

    public static int computeUInt64SizeNoTag(long value2) {
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value2 < 0L) {
            return 10;
        }
        int n = 2;
        if ((value2 & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value2 >>>= 28;
        }
        if ((value2 & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value2 >>>= 14;
        }
        if ((value2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int computeSInt64SizeNoTag(long value2) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value2));
    }

    public static int computeFixed64SizeNoTag(long unused) {
        return 8;
    }

    public static int computeSFixed64SizeNoTag(long unused) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float unused) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double unused) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean unused) {
        return 1;
    }

    public static int computeEnumSizeNoTag(int value2) {
        return CodedOutputStream.computeInt32SizeNoTag(value2);
    }

    public static int computeStringSizeNoTag(String value2) {
        int length;
        try {
            length = Utf8.encodedLength(value2);
        }
        catch (Utf8.UnpairedSurrogateException e) {
            byte[] bytes2 = value2.getBytes(Internal.UTF_8);
            length = bytes2.length;
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize(length);
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.getSerializedSize());
    }

    public static int computeBytesSizeNoTag(ByteString value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.size());
    }

    public static int computeByteArraySizeNoTag(byte[] value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.length);
    }

    public static int computeMessageSizeNoTag(MessageLite value2) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value2.getSerializedSize());
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        return CodedOutputStream.computeUInt32SizeNoTag(fieldLength) + fieldLength;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public abstract int spaceLeft();

    public final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    final void inefficientWriteStringNoTag(String value2, Utf8.UnpairedSurrogateException cause) throws IOException {
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", cause);
        byte[] bytes2 = value2.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(bytes2.length);
            this.writeLazy(bytes2, 0, bytes2.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new OutOfSpaceException(e);
        }
    }

    @Deprecated
    public final void writeGroup(int fieldNumber, MessageLite value2) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value2);
        this.writeTag(fieldNumber, 4);
    }

    @Deprecated
    public final void writeGroupNoTag(MessageLite value2) throws IOException {
        value2.writeTo(this);
    }

    @Deprecated
    public static int computeGroupSize(int fieldNumber, MessageLite value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) * 2 + value2.getSerializedSize();
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite value2) {
        return value2.getSerializedSize();
    }

    private static class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        ArrayEncoder(byte[] buffer, int offset, int length) {
            if (buffer == null) {
                throw new NullPointerException("buffer");
            }
            if ((offset | length | buffer.length - (offset + length)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", buffer.length, offset, length));
            }
            this.buffer = buffer;
            this.offset = offset;
            this.position = offset;
            this.limit = offset + length;
        }

        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
        }

        @Override
        public final void writeInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeInt32NoTag(value2);
        }

        @Override
        public final void writeUInt32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt32NoTag(value2);
        }

        @Override
        public final void writeFixed32(int fieldNumber, int value2) throws IOException {
            this.writeTag(fieldNumber, 5);
            this.writeFixed32NoTag(value2);
        }

        @Override
        public final void writeUInt64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.writeUInt64NoTag(value2);
        }

        @Override
        public final void writeFixed64(int fieldNumber, long value2) throws IOException {
            this.writeTag(fieldNumber, 1);
            this.writeFixed64NoTag(value2);
        }

        @Override
        public final void writeBool(int fieldNumber, boolean value2) throws IOException {
            this.writeTag(fieldNumber, 0);
            this.write((byte)(value2 ? 1 : 0));
        }

        @Override
        public final void writeString(int fieldNumber, String value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeStringNoTag(value2);
        }

        @Override
        public final void writeBytes(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeBytesNoTag(value2);
        }

        @Override
        public final void writeBytesNoTag(ByteString value2) throws IOException {
            this.writeUInt32NoTag(value2.size());
            value2.writeTo(this);
        }

        @Override
        public final void writeByteArrayNoTag(byte[] value2, int offset, int length) throws IOException {
            this.writeUInt32NoTag(length);
            this.write(value2, offset, length);
        }

        @Override
        public final void writeMessage(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(fieldNumber, 2);
            this.writeMessageNoTag(value2);
        }

        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeMessage(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value2) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, fieldNumber);
            this.writeBytes(3, value2);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeMessageNoTag(MessageLite value2) throws IOException {
            this.writeUInt32NoTag(value2.getSerializedSize());
            value2.writeTo(this);
        }

        @Override
        public final void write(byte value2) throws IOException {
            try {
                this.buffer[this.position++] = value2;
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void writeInt32NoTag(int value2) throws IOException {
            if (value2 >= 0) {
                this.writeUInt32NoTag(value2);
            } else {
                this.writeUInt64NoTag(value2);
            }
        }

        @Override
        public final void writeUInt32NoTag(int value2) throws IOException {
            try {
                while (true) {
                    if ((value2 & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)value2;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(value2 & 0x7F | 0x80);
                    value2 >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void writeFixed32NoTag(int value2) throws IOException {
            try {
                this.buffer[this.position++] = (byte)(value2 & 0xFF);
                this.buffer[this.position++] = (byte)(value2 >> 8 & 0xFF);
                this.buffer[this.position++] = (byte)(value2 >> 16 & 0xFF);
                this.buffer[this.position++] = (byte)(value2 >> 24 & 0xFF);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void writeUInt64NoTag(long value2) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && this.spaceLeft() >= 10) {
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.buffer, this.position++, (byte)value2);
                        return;
                    }
                    UnsafeUtil.putByte(this.buffer, this.position++, (byte)((int)value2 & 0x7F | 0x80));
                    value2 >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)value2;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)value2 & 0x7F | 0x80);
                    value2 >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        @Override
        public final void writeFixed64NoTag(long value2) throws IOException {
            try {
                this.buffer[this.position++] = (byte)((int)value2 & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 8) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 16) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 24) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 32) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 40) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 48) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(value2 >> 56) & 0xFF);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), e);
            }
        }

        public final void write(byte[] value2, int offset, int length) throws IOException {
            try {
                System.arraycopy(value2, offset, this.buffer, this.position, length);
                this.position += length;
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, length), e);
            }
        }

        @Override
        public final void writeLazy(byte[] value2, int offset, int length) throws IOException {
            this.write(value2, offset, length);
        }

        public final void write(ByteBuffer value2) throws IOException {
            int length = value2.remaining();
            try {
                value2.get(this.buffer, this.position, length);
                this.position += length;
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, length), e);
            }
        }

        @Override
        public final void writeLazy(ByteBuffer value2) throws IOException {
            this.write(value2);
        }

        @Override
        public final void writeStringNoTag(String value2) throws IOException {
            int oldPosition = this.position;
            try {
                int maxLength = value2.length() * 3;
                int maxLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(maxLength);
                int minLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(value2.length());
                if (minLengthVarIntSize == maxLengthVarIntSize) {
                    this.position = oldPosition + minLengthVarIntSize;
                    int newPosition = Utf8.encode(value2, this.buffer, this.position, this.spaceLeft());
                    this.position = oldPosition;
                    int length = newPosition - oldPosition - minLengthVarIntSize;
                    this.writeUInt32NoTag(length);
                    this.position = newPosition;
                } else {
                    int length = Utf8.encodedLength(value2);
                    this.writeUInt32NoTag(length);
                    this.position = Utf8.encode(value2, this.buffer, this.position, this.spaceLeft());
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                this.position = oldPosition;
                this.inefficientWriteStringNoTag(value2, e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        OutOfSpaceException(Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", cause);
        }

        OutOfSpaceException(String explanationMessage, Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + explanationMessage, cause);
        }
    }
}

