/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import java.nio.ByteBuffer;

public abstract class AbstractParser<MessageType extends MessageLite>
implements Parser<MessageType> {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();

    private UninitializedMessageException newUninitializedMessageException(MessageType message2) {
        if (message2 instanceof AbstractMessageLite) {
            return ((AbstractMessageLite)message2).newUninitializedMessageException();
        }
        return new UninitializedMessageException((MessageLite)message2);
    }

    private MessageType checkMessageInitialized(MessageType message2) throws InvalidProtocolBufferException {
        if (message2 != null && !message2.isInitialized()) {
            throw this.newUninitializedMessageException(message2).asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)message2);
        }
        return message2;
    }

    public MessageType parsePartialFrom(ByteString data2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        CodedInputStream input = data2.newCodedInput();
        MessageLite message2 = (MessageLite)this.parsePartialFrom(input, extensionRegistry);
        try {
            input.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(message2);
        }
        return (MessageType)message2;
    }

    @Override
    public MessageType parseFrom(ByteString data2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialFrom(data2, extensionRegistry));
    }

    public MessageType parseFrom(ByteBuffer data2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        CodedInputStream input = CodedInputStream.newInstance(data2);
        MessageLite message2 = (MessageLite)this.parsePartialFrom(input, extensionRegistry);
        try {
            input.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(message2);
        }
        return (MessageType)this.checkMessageInitialized(message2);
    }

    @Override
    public MessageType parseFrom(ByteBuffer data2) throws InvalidProtocolBufferException {
        return this.parseFrom(data2, EMPTY_REGISTRY);
    }

    public MessageType parsePartialFrom(byte[] data2, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        CodedInputStream input = CodedInputStream.newInstance(data2, off, len);
        MessageLite message2 = (MessageLite)this.parsePartialFrom(input, extensionRegistry);
        try {
            input.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(message2);
        }
        return (MessageType)message2;
    }

    public MessageType parseFrom(byte[] data2, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialFrom(data2, off, len, extensionRegistry));
    }

    public MessageType parseFrom(byte[] data2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.parseFrom(data2, 0, data2.length, extensionRegistry);
    }

    @Override
    public MessageType parseFrom(byte[] data2) throws InvalidProtocolBufferException {
        return this.parseFrom(data2, EMPTY_REGISTRY);
    }
}

