/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.j2objc.annotations.Weak;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CollectSpliterators {
    static <InElementT, OutElementT> Spliterator<OutElementT> flatMap(Spliterator<InElementT> fromSpliterator, Function<? super InElementT, @Nullable Spliterator<OutElementT>> function, int topCharacteristics, long topSize) {
        Preconditions.checkArgument((topCharacteristics & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((topCharacteristics & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(fromSpliterator);
        Preconditions.checkNotNull(function);
        return new FlatMapSpliteratorOfObject<InElementT, OutElementT>(null, fromSpliterator, function, topCharacteristics, topSize);
    }

    static final class FlatMapSpliteratorOfObject<InElementT, OutElementT>
    extends FlatMapSpliterator<InElementT, OutElementT, Spliterator<OutElementT>> {
        FlatMapSpliteratorOfObject(Spliterator<OutElementT> prefix, Spliterator<InElementT> from, Function<? super InElementT, @Nullable Spliterator<OutElementT>> function, int characteristics, long estimatedSize) {
            super(prefix, from, function, FlatMapSpliteratorOfObject::new, characteristics, estimatedSize);
        }
    }

    static abstract class FlatMapSpliterator<InElementT, OutElementT, OutSpliteratorT extends Spliterator<OutElementT>>
    implements Spliterator<OutElementT> {
        @Weak
        OutSpliteratorT prefix;
        final Spliterator<InElementT> from;
        final Function<? super InElementT, @Nullable OutSpliteratorT> function;
        final Factory<InElementT, OutSpliteratorT> factory;
        int characteristics;
        long estimatedSize;

        FlatMapSpliterator(OutSpliteratorT prefix, Spliterator<InElementT> from, Function<? super InElementT, @Nullable OutSpliteratorT> function, Factory<InElementT, OutSpliteratorT> factory2, int characteristics, long estimatedSize) {
            this.prefix = prefix;
            this.from = from;
            this.function = function;
            this.factory = factory2;
            this.characteristics = characteristics;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super OutElementT> action2) {
            do {
                if (this.prefix != null && this.prefix.tryAdvance(action2)) {
                    if (this.estimatedSize != Long.MAX_VALUE) {
                        --this.estimatedSize;
                    }
                    return true;
                }
                this.prefix = null;
            } while (this.from.tryAdvance((? super T fromElement) -> {
                this.prefix = (Spliterator)this.function.apply(fromElement);
            }));
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super OutElementT> action2) {
            if (this.prefix != null) {
                this.prefix.forEachRemaining(action2);
                this.prefix = null;
            }
            this.from.forEachRemaining((? super T fromElement) -> {
                Spliterator elements = (Spliterator)this.function.apply(fromElement);
                if (elements != null) {
                    elements.forEachRemaining(action2);
                }
            });
            this.estimatedSize = 0L;
        }

        public final OutSpliteratorT trySplit() {
            Spliterator<InElementT> fromSplit = this.from.trySplit();
            if (fromSplit != null) {
                int splitCharacteristics = this.characteristics & 0xFFFFFFBF;
                long estSplitSize = this.estimateSize();
                if (estSplitSize < Long.MAX_VALUE) {
                    this.estimatedSize -= (estSplitSize /= 2L);
                    this.characteristics = splitCharacteristics;
                }
                OutSpliteratorT result2 = this.factory.newFlatMapSpliterator(this.prefix, fromSplit, this.function, splitCharacteristics, estSplitSize);
                this.prefix = null;
                return result2;
            }
            if (this.prefix != null) {
                OutSpliteratorT result3 = this.prefix;
                this.prefix = null;
                return result3;
            }
            return null;
        }

        @Override
        public final long estimateSize() {
            if (this.prefix != null) {
                this.estimatedSize = Math.max(this.estimatedSize, this.prefix.estimateSize());
            }
            return Math.max(this.estimatedSize, 0L);
        }

        @Override
        public final int characteristics() {
            return this.characteristics;
        }

        @FunctionalInterface
        static interface Factory<InElementT, OutSpliteratorT extends Spliterator<?>> {
            public OutSpliteratorT newFlatMapSpliterator(OutSpliteratorT var1, Spliterator<InElementT> var2, Function<? super InElementT, @Nullable OutSpliteratorT> var3, int var4, long var5);
        }
    }
}

