/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetSelectionCommand
implements EditCommand {
    private final int start;
    private final int end;

    public SetSelectionCommand(int start2, int end) {
        this.start = start2;
        this.end = end;
    }

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int clampedStart = RangesKt.coerceIn((int)this.start, (int)0, (int)buffer.getLength$ui_text());
        int clampedEnd = RangesKt.coerceIn((int)this.end, (int)0, (int)buffer.getLength$ui_text());
        if (clampedStart < clampedEnd) {
            buffer.setSelection$ui_text(clampedStart, clampedEnd);
        } else {
            buffer.setSelection$ui_text(clampedEnd, clampedStart);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetSelectionCommand)) {
            return false;
        }
        if (this.start != ((SetSelectionCommand)other).start) {
            return false;
        }
        return this.end == ((SetSelectionCommand)other).end;
    }

    public int hashCode() {
        int result2 = this.start;
        result2 = 31 * result2 + this.end;
        return result2;
    }

    @NotNull
    public String toString() {
        return "SetSelectionCommand(start=" + this.start + ", end=" + this.end + ")";
    }
}

