/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.annotation.RestrictTo;
import androidx.compose.ui.text.input.GapBuffer;
import androidx.compose.ui.text.input.GapBufferKt;
import androidx.compose.ui.text.input.GapBuffer_jvmKt;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/PartialGapBuffer\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,318:1\n118#2,4:319\n118#2,4:323\n*S KotlinDebug\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/PartialGapBuffer\n*L\n242#1:319,4\n245#1:323,4\n*E\n"})
public final class PartialGapBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String text;
    @Nullable
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int $stable = 8;

    public PartialGapBuffer(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    public final int getLength() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer buffer = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + buffer.length();
    }

    public final void replace(int start2, int end, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean value$iv = start2 <= end;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start index must be less than or equal to end index: " + start2 + " > " + end);
        }
        value$iv = start2 >= 0;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start must be non-negative, but was " + start2);
        }
        GapBuffer buffer = this.buffer;
        if (buffer == null) {
            char[] charArray = new char[Math.max(255, text2.length() + 128)];
            int leftCopyCount = Math.min(start2, 64);
            int rightCopyCount = Math.min(this.text.length() - end, 64);
            GapBuffer_jvmKt.toCharArray(this.text, charArray, 0, start2 - leftCopyCount, start2);
            GapBuffer_jvmKt.toCharArray(this.text, charArray, charArray.length - rightCopyCount, end, end + rightCopyCount);
            GapBufferKt.access$toCharArray(text2, charArray, leftCopyCount);
            this.buffer = new GapBuffer(charArray, leftCopyCount + text2.length(), charArray.length - rightCopyCount);
            this.bufStart = start2 - leftCopyCount;
            this.bufEnd = end + rightCopyCount;
            return;
        }
        int bufferStart = start2 - this.bufStart;
        int bufferEnd = end - this.bufStart;
        if (bufferStart < 0 || bufferEnd > buffer.length()) {
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
            this.replace(start2, end, text2);
            return;
        }
        buffer.replace(bufferStart, bufferEnd, text2);
    }

    public final char get(int index) {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(index);
        }
        GapBuffer buffer = gapBuffer;
        if (index < this.bufStart) {
            return this.text.charAt(index);
        }
        int gapBufLength = buffer.length();
        if (index < gapBufLength + this.bufStart) {
            return buffer.get(index - this.bufStart);
        }
        return this.text.charAt(index - (gapBufLength - this.bufEnd + this.bufStart));
    }

    @NotNull
    public String toString() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text;
        }
        GapBuffer b = gapBuffer;
        StringBuilder sb = new StringBuilder();
        sb.append(this.text, 0, this.bufStart);
        b.append(sb);
        sb.append(this.text, this.bufEnd, this.text.length());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

