/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.collection.IntList;
import androidx.collection.IntListKt;
import androidx.collection.MutableIntList;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SaversKt;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.StringAnnotation;
import androidx.compose.ui.text.StringAnnotationKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.unit.TextUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IntList.kt\nandroidx/collection/IntList\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1607:1\n35#2,5:1608\n251#2,2:1625\n35#2,5:1627\n253#2:1632\n103#2:1633\n35#2,5:1634\n104#2:1639\n251#2,2:1640\n35#2,5:1642\n253#2:1647\n231#2,2:1648\n35#2,5:1650\n233#2:1655\n231#2,2:1656\n35#2,5:1658\n233#2:1663\n231#2,2:1664\n35#2,5:1666\n233#2:1671\n103#2:1672\n35#2,5:1673\n104#2:1678\n1053#3:1613\n366#4:1614\n70#4:1615\n118#5,4:1616\n118#5,4:1621\n1#6:1620\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n121#1:1608,5\n221#1:1625,2\n221#1:1627,5\n221#1:1632\n231#1:1633\n231#1:1634,5\n231#1:1639\n246#1:1640,2\n246#1:1642,5\n246#1:1647\n263#1:1648,2\n263#1:1650,5\n263#1:1655\n281#1:1656,2\n281#1:1658,5\n281#1:1663\n297#1:1664,2\n297#1:1666,5\n297#1:1671\n306#1:1672\n306#1:1673,5\n306#1:1678\n137#1:1613\n148#1:1614\n151#1:1615\n153#1:1616,4\n177#1:1621,4\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final List<Range<? extends Annotation>> annotations;
    @NotNull
    private final String text;
    @Nullable
    private final List<Range<SpanStyle>> spanStylesOrNull;
    @Nullable
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    @NotNull
    private static final Saver<AnnotatedString, ?> Saver = SaversKt.getAnnotatedStringSaver();

    public AnnotatedString(@Nullable List<? extends Range<? extends Annotation>> annotations, @NotNull String text2) {
        List list2;
        Collection<Range<Annotation>> $this$fastForEach$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.annotations = annotations;
        this.text = text2;
        List spanStyles = null;
        List paragraphStyles = null;
        List<Range<? extends Annotation>> list3 = this.annotations;
        if (list3 != null) {
            $this$fastForEach$iv = list3;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Range<? extends Annotation> item$iv;
                Range<? extends Annotation> annotation = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                if (annotation.getItem() instanceof SpanStyle) {
                    if (spanStyles == null) {
                        spanStyles = new ArrayList();
                    }
                    Intrinsics.checkNotNull(annotation, (String)"null cannot be cast to non-null type androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.SpanStyle>");
                    spanStyles.add(annotation);
                    continue;
                }
                if (!(annotation.getItem() instanceof ParagraphStyle)) continue;
                if (paragraphStyles == null) {
                    paragraphStyles = new ArrayList();
                }
                Intrinsics.checkNotNull(annotation, (String)"null cannot be cast to non-null type androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.ParagraphStyle>");
                paragraphStyles.add(annotation);
            }
        }
        this.spanStylesOrNull = spanStyles;
        List<Range<ParagraphStyle>> list4 = this.paragraphStylesOrNull = paragraphStyles;
        if (list4 != null) {
            Iterable $this$sortedBy$iv = list4;
            boolean $i$f$sortedBy = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Range it = (Range)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStart());
                    it = (Range)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                }
            });
        } else {
            list2 = null;
        }
        List sorted = list2;
        $this$fastForEach$iv = sorted;
        if (!($this$fastForEach$iv == null || $this$fastForEach$iv.isEmpty())) {
            MutableIntList previousEnds = IntListKt.mutableIntListOf((int)((Range)CollectionsKt.first((List)sorted)).getEnd());
            int n = sorted.size();
            for (int i2 = 1; i2 < n; ++i2) {
                Range current;
                block11: {
                    int previousEnd;
                    current = (Range)sorted.get(i2);
                    while (true) {
                        IntList this_$iv = (IntList)previousEnds;
                        boolean $i$f$isNotEmpty = false;
                        if (!(this_$iv._size != 0)) break block11;
                        previousEnd = previousEnds.last();
                        if (current.getStart() < previousEnd) break;
                        IntList this_$iv2 = (IntList)previousEnds;
                        boolean $i$f$getLastIndex = false;
                        previousEnds.removeAt(this_$iv2._size - 1);
                    }
                    boolean value$iv = current.getEnd() <= previousEnd;
                    boolean $i$f$requirePrecondition = false;
                    if (!value$iv) {
                        boolean bl = false;
                        InlineClassHelperKt.throwIllegalArgumentException("Paragraph overlap not allowed, end " + current.getEnd() + " should be less than or equal to " + previousEnd);
                    }
                }
                previousEnds.add(current.getEnd());
            }
        }
    }

    @Nullable
    public final List<Range<? extends Annotation>> getAnnotations$ui_text() {
        return this.annotations;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<Range<SpanStyle>> getSpanStyles() {
        List list2 = this.spanStylesOrNull;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text() {
        return this.paragraphStylesOrNull;
    }

    @NotNull
    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        List list2 = this.paragraphStylesOrNull;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public AnnotatedString(@NotNull String text2, @NotNull List<Range<SpanStyle>> spanStyles, @NotNull List<Range<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, (String)"paragraphStyles");
        this(AnnotatedStringKt.access$constructAnnotationsFromSpansAndParagraphs(spanStyles, paragraphStyles), text2);
    }

    public AnnotatedString(@NotNull String text2, @NotNull List<? extends Range<? extends Annotation>> annotations) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        AnnotatedString annotatedString = this;
        Collection collection2 = annotations;
        if (collection2.isEmpty()) {
            AnnotatedString annotatedString2 = annotatedString;
            boolean bl = false;
            collection = null;
            annotatedString = annotatedString2;
        } else {
            collection = collection2;
        }
        annotatedString((List)collection, text2);
    }

    public /* synthetic */ AnnotatedString(String string, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, list2);
    }

    public int getLength() {
        return this.text.length();
    }

    public char get(int index) {
        return this.text.charAt(index);
    }

    @Override
    @NotNull
    public AnnotatedString subSequence(int startIndex, int endIndex) {
        boolean value$iv = startIndex <= endIndex;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start (" + startIndex + ") should be less or equal to end (" + endIndex + ")");
        }
        if (startIndex == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text2 = string;
        List list2 = AnnotatedStringKt.access$filterRanges(this.annotations, startIndex, endIndex);
        return new AnnotatedString(list2, text2);
    }

    @NotNull
    public final AnnotatedString subSequence-5zc-tL8(long range) {
        return this.subSequence(TextRange.getMin-impl(range), TextRange.getMax-impl(range));
    }

    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Builder $this$plus_u24lambda_u245 = new Builder(this);
        boolean bl = false;
        $this$plus_u24lambda_u245.append(other);
        return $this$plus_u24lambda_u245.toAnnotatedString();
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(@NotNull String tag, int start2, int end) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<Range<? extends Annotation>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Annotation>> $this$fastFilteredMap$iv = list3;
            boolean $i$f$fastFilteredMap = false;
            ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilteredMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof StringAnnotation && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start2, end, it.getStart(), it.getEnd()))) continue;
                it = it$iv;
                Collection collection = target$iv;
                boolean bl3 = false;
                collection.add(StringAnnotationKt.unbox(it));
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean hasStringAnnotations(@NotNull String tag, int start2, int end) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            List<Range<? extends Annotation>> list2 = this.annotations;
            if (list2 != null) {
                List<Range<? extends Annotation>> $this$fastAny$iv = list2;
                boolean $i$f$fastAny = false;
                List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Annotation> item$iv$iv;
                    Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Annotation> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof StringAnnotation && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start2, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(int start2, int end) {
        List list2;
        List<Range<? extends Annotation>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Annotation>> $this$fastFilteredMap$iv = list3;
            boolean $i$f$fastFilteredMap = false;
            ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilteredMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof StringAnnotation && AnnotatedStringKt.intersect(start2, end, it.getStart(), it.getEnd()))) continue;
                it = it$iv;
                Collection collection = target$iv;
                boolean bl3 = false;
                collection.add(StringAnnotationKt.unbox(it));
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<Range<LinkAnnotation>> getLinkAnnotations(int start2, int end) {
        List list2;
        List<Range<? extends Annotation>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Annotation>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Annotation> item$iv$iv;
                Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Annotation> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start2, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.LinkAnnotation>>");
        return list2;
    }

    public final boolean hasLinkAnnotations(int start2, int end) {
        boolean bl;
        block3: {
            List<Range<? extends Annotation>> list2 = this.annotations;
            if (list2 != null) {
                List<Range<? extends Annotation>> $this$fastAny$iv = list2;
                boolean $i$f$fastAny = false;
                List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Annotation> item$iv$iv;
                    Range<? extends Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Annotation> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start2, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)other).annotations);
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        List<Range<? extends Annotation>> list2 = this.annotations;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        return result2;
    }

    @Override
    @NotNull
    public String toString() {
        return this.text;
    }

    public final boolean hasEqualAnnotations(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual(this.annotations, other.annotations);
    }

    @NotNull
    public final AnnotatedString mapAnnotations(@NotNull Function1<? super Range<? extends Annotation>, ? extends Range<? extends Annotation>> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        Builder builder = new Builder(this);
        builder.mapAnnotations$ui_text(transform2);
        return builder.toAnnotatedString();
    }

    @NotNull
    public final AnnotatedString flatMapAnnotations(@NotNull Function1<? super Range<? extends Annotation>, ? extends List<? extends Range<? extends Annotation>>> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        Builder builder = new Builder(this);
        builder.flatMapAnnotations$ui_text(transform2);
        return builder.toAnnotatedString();
    }

    public static interface Annotation {
    }

    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1607:1\n35#2,5:1608\n35#2,5:1613\n151#2,2:1630\n35#2,5:1632\n153#2:1637\n530#2,2:1638\n35#2,3:1640\n532#2:1643\n151#2,2:1644\n35#2,5:1646\n153#2:1651\n533#2,2:1652\n39#2:1654\n535#2:1655\n81#3,4:1618\n81#3,4:1622\n81#3,4:1626\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n540#1:1608,5\n558#1:1613,5\n964#1:1630,2\n964#1:1632,5\n964#1:1637\n981#1:1638,2\n981#1:1640,3\n981#1:1643\n982#1:1644,2\n982#1:1646,5\n982#1:1651\n981#1:1652,2\n981#1:1654\n981#1:1655\n823#1:1618,4\n935#1:1622,4\n952#1:1626,4\n*E\n"})
    public static final class Builder
    implements Appendable {
        @NotNull
        private final StringBuilder text;
        @NotNull
        private final List<MutableRange<? extends Object>> styleStack;
        @NotNull
        private final List<MutableRange<? extends Annotation>> annotations;
        @NotNull
        private final BulletScope bulletScope;
        public static final int $stable = 8;

        public Builder(int capacity) {
            this.text = new StringBuilder(capacity);
            this.styleStack = new ArrayList();
            this.annotations = new ArrayList();
            this.bulletScope = new BulletScope(this);
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        public Builder(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this(0, 1, null);
            this.append(text2);
        }

        public Builder(@NotNull AnnotatedString text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this(0, 1, null);
            this.append(text2);
        }

        public final void append(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text.append(text2);
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text2) {
            if (text2 instanceof AnnotatedString) {
                this.append((AnnotatedString)text2);
            } else {
                this.text.append(text2);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text2, int start2, int end) {
            if (text2 instanceof AnnotatedString) {
                this.append((AnnotatedString)text2, start2, end);
            } else {
                this.text.append(text2, start2, end);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(char c) {
            this.text.append(c);
            return this;
        }

        public final void append(@NotNull AnnotatedString text2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                int start2 = this.text.length();
                this.text.append(text2.getText());
                List<Range<? extends Annotation>> list2 = text2.getAnnotations$ui_text();
                if (list2 == null) break block1;
                List<Range<? extends Annotation>> $this$fastForEach$iv = list2;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Range<? extends Annotation> item$iv;
                    Range<? extends Annotation> it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.annotations.add(new MutableRange<Annotation>(it.getItem(), start2 + it.getStart(), start2 + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void append(@NotNull AnnotatedString text2, int start2, int end) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                int insertionStart = this.text.length();
                this.text.append(text2.getText(), start2, end);
                List list2 = AnnotatedStringKt.getLocalAnnotations$default(text2, start2, end, null, 4, null);
                if (list2 == null) break block1;
                List $this$fastForEach$iv = list2;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Object item$iv = $this$fastForEach$iv.get(index$iv);
                    Range it = (Range)item$iv;
                    boolean bl = false;
                    this.annotations.add(new MutableRange(it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void addStyle(@NotNull SpanStyle style, int start2, int end) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.annotations.add(new MutableRange(style, start2, end, null, 8, null));
        }

        public final int pushStyle(@NotNull SpanStyle style) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStringAnnotation(@NotNull String tag, @NotNull String annotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            MutableRange it = mutableRange = new MutableRange(StringAnnotation.box-impl(StringAnnotation.constructor-impl(annotation)), this.text.length(), 0, tag, 4, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushLink(@NotNull LinkAnnotation link) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            MutableRange it = mutableRange = new MutableRange(link, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            boolean value$iv = !((Collection)this.styleStack).isEmpty();
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("Nothing to pop.");
            }
            MutableRange<? extends Object> item2 = this.styleStack.remove(this.styleStack.size() - 1);
            item2.setEnd(this.text.length());
        }

        public final void pop(int index) {
            boolean value$iv = index < this.styleStack.size();
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException(index + " should be less than " + this.styleStack.size());
            }
            while (this.styleStack.size() - 1 >= index) {
                this.pop();
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AnnotatedString toAnnotatedString() {
            void $this$fastMap$iv;
            String string = this.text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            List<MutableRange<? extends Annotation>> list2 = this.annotations;
            String string2 = string;
            boolean $i$f$fastMap = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            void $this$fastForEach$iv$iv = $this$fastMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                void it;
                Object item$iv$iv;
                Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                MutableRange mutableRange = (MutableRange)it$iv;
                Collection collection = target$iv;
                boolean bl2 = false;
                collection.add(it.toRange(this.text.length()));
            }
            List list3 = target$iv;
            String string3 = string2;
            return new AnnotatedString(string3, list3);
        }

        public final void mapAnnotations$ui_text(@NotNull Function1<? super Range<? extends Annotation>, ? extends Range<? extends Annotation>> transform2) {
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            int n = ((Collection)this.annotations).size();
            for (int i2 = 0; i2 < n; ++i2) {
                Range newAnnotation = (Range)transform2.invoke((Object)MutableRange.toRange$default(this.annotations.get(i2), 0, 1, null));
                this.annotations.set(i2, MutableRange.Companion.fromRange(newAnnotation));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void flatMapAnnotations$ui_text(@NotNull Function1<? super Range<? extends Annotation>, ? extends List<? extends Range<? extends Annotation>>> transform2) {
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            List<MutableRange<? extends Annotation>> $this$fastFlatMap$iv = this.annotations;
            boolean $i$f$fastFlatMap = false;
            ArrayList target$iv = new ArrayList($this$fastFlatMap$iv.size());
            List<MutableRange<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFlatMap$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                MutableRange<? extends Annotation> item$iv$iv;
                MutableRange<? extends Annotation> e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                MutableRange<? extends Annotation> annotation = e$iv;
                boolean bl2 = false;
                List $this$fastMap$iv = (List)transform2.invoke((Object)MutableRange.toRange$default(annotation, 0, 1, null));
                boolean $i$f$fastMap = false;
                ArrayList target$iv2 = new ArrayList($this$fastMap$iv.size());
                List $this$fastForEach$iv$iv2 = $this$fastMap$iv;
                boolean $i$f$fastForEach2 = false;
                int n2 = ((Collection)$this$fastForEach$iv$iv2).size();
                for (int index$iv$iv2 = 0; index$iv$iv2 < n2; ++index$iv$iv2) {
                    void it;
                    Object item$iv$iv2;
                    Object it$iv = item$iv$iv2 = $this$fastForEach$iv$iv2.get(index$iv$iv2);
                    boolean bl3 = false;
                    Range range = (Range)it$iv;
                    Collection collection = target$iv2;
                    boolean bl4 = false;
                    collection.add(MutableRange.Companion.fromRange(it));
                }
                Iterable list$iv = target$iv2;
                CollectionsKt.addAll((Collection)target$iv, (Iterable)list$iv);
            }
            List replacedAnnotations = target$iv;
            this.annotations.clear();
            this.annotations.addAll(replacedAnnotations);
        }

        public Builder() {
            this(0, 1, null);
        }

        public static final class BulletScope {
            @NotNull
            private final Builder builder;
            @NotNull
            private final List<Pair<TextUnit, Object>> bulletListSettingStack;
            public static final int $stable = 8;

            public BulletScope(@NotNull Builder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                this.builder = builder;
                this.bulletListSettingStack = new ArrayList();
            }
        }

        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1607:1\n81#2,4:1608\n81#2,4:1612\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n*L\n417#1:1608,4\n428#1:1612,4\n*E\n"})
        private static final class MutableRange<T> {
            @NotNull
            public static final Companion Companion = new Companion(null);
            private final T item;
            private final int start;
            private int end;
            @NotNull
            private final String tag;

            public MutableRange(T item2, int start2, int end, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.item = item2;
                this.start = start2;
                this.end = end;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            @NotNull
            public final Range<T> toRange(int defaultEnd) {
                int end = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                boolean value$iv = end != Integer.MIN_VALUE;
                boolean $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("Item.end should be set first");
                }
                return new Range<T>(this.item, this.start, end, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            @NotNull
            public String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ")";
            }

            public int hashCode() {
                int result2 = this.item == null ? 0 : this.item.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.start);
                result2 = result2 * 31 + Integer.hashCode(this.end);
                result2 = result2 * 31 + this.tag.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                MutableRange mutableRange = (MutableRange)other;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }

            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final <T> MutableRange<T> fromRange(@NotNull Range<T> range) {
                    Intrinsics.checkNotNullParameter(range, (String)"range");
                    return new MutableRange<T>(range.getItem(), range.getStart(), range.getEnd(), range.getTag());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1607:1\n118#2,4:1608\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n*L\n386#1:1608,4\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        @NotNull
        private final String tag;

        public Range(T item2, int start2, int end, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.item = item2;
            this.start = start2;
            this.end = end;
            this.tag = tag;
            boolean value$iv = this.start <= this.end;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalArgumentException("Reversed range is not supported");
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public Range(T item2, int start2, int end) {
            this(item2, start2, end, "");
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final Range<T> copy(T item2, int start2, int end, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new Range<T>(item2, start2, end, tag);
        }

        public static /* synthetic */ Range copy$default(Range range, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range.item;
            }
            if ((n3 & 2) != 0) {
                n = range.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range.end;
            }
            if ((n3 & 8) != 0) {
                string = range.tag;
            }
            return range.copy(object, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ")";
        }

        public int hashCode() {
            int result2 = this.item == null ? 0 : this.item.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            result2 = result2 * 31 + this.tag.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range.tag);
        }
    }
}

