/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.collection.MutableScatterMap;
import androidx.collection.ScatterMap;
import androidx.collection.ScatterMapKt;
import androidx.compose.ui.platform.DebugUtils_jvmKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import java.util.Iterator;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSemanticsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsConfiguration.kt\nandroidx/compose/ui/semantics/SemanticsConfiguration\n+ 2 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,198:1\n320#2:199\n320#2:200\n320#2:201\n385#2:203\n357#2,4:204\n329#2,6:208\n339#2,3:215\n342#2,9:219\n361#2:228\n386#2:229\n357#2,4:230\n329#2,6:234\n339#2,3:241\n342#2,9:245\n361#2:254\n357#2,4:255\n329#2,6:259\n339#2,3:266\n342#2,9:270\n361#2:279\n357#2,4:280\n329#2,6:284\n339#2,3:291\n342#2,9:295\n361#2:304\n1#3:202\n1399#4:214\n1270#4:218\n1399#4:240\n1270#4:244\n1399#4:265\n1270#4:269\n1399#4:290\n1270#4:294\n*S KotlinDebug\n*F\n+ 1 SemanticsConfiguration.kt\nandroidx/compose/ui/semantics/SemanticsConfiguration\n*L\n41#1:199\n49#1:200\n55#1:201\n78#1:203\n78#1:204,4\n78#1:208,6\n78#1:215,3\n78#1:219,9\n78#1:228\n78#1:229\n100#1:230,4\n100#1:234,6\n100#1:241,3\n100#1:245,9\n100#1:254\n127#1:255,4\n127#1:259,6\n127#1:266,3\n127#1:270,9\n127#1:279\n184#1:280,4\n184#1:284,6\n184#1:291,3\n184#1:295,9\n184#1:304\n78#1:214\n78#1:218\n100#1:240\n100#1:244\n127#1:265\n127#1:269\n184#1:290\n184#1:294\n*E\n"})
public final class SemanticsConfiguration
implements SemanticsPropertyReceiver,
Iterable<Map.Entry<? extends SemanticsPropertyKey<?>, ? extends Object>>,
KMappedMarker {
    @NotNull
    private final MutableScatterMap<SemanticsPropertyKey<?>, Object> props = ScatterMapKt.mutableScatterMapOf();
    @Nullable
    private Map<SemanticsPropertyKey<?>, ? extends Object> mapWrapper;
    private boolean isMergingSemanticsOfDescendants;
    private boolean isClearingSemantics;
    public static final int $stable = 8;

    @Nullable
    public final <T> T getOrElseNullable(@NotNull SemanticsPropertyKey<T> key, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        ScatterMap this_$iv = (ScatterMap)this.props;
        boolean $i$f$getOrElse = false;
        Object object = this_$iv.get(key);
        if (object == null) {
            object = defaultValue.invoke();
        }
        return (T)object;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<SemanticsPropertyKey<?>, Object>> iterator() {
        Map map2 = this.mapWrapper;
        if (map2 == null) {
            Map map3;
            Map $this$iterator_u24lambda_u241 = map3 = this.props.asMap();
            boolean bl = false;
            this.mapWrapper = $this$iterator_u24lambda_u241;
            map2 = map3;
        }
        Map mapWrapper = map2;
        return mapWrapper.entrySet().iterator();
    }

    @Override
    public <T> void set(@NotNull SemanticsPropertyKey<T> key, T value2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (value2 instanceof AccessibilityAction && this.contains(key)) {
            Object t2;
            Object object = this.props.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.AccessibilityAction<*>");
            AccessibilityAction prev = (AccessibilityAction)object;
            String string = ((AccessibilityAction)value2).getLabel();
            if (string == null) {
                string = prev.getLabel();
            }
            if ((t2 = ((AccessibilityAction)value2).getAction()) == null) {
                t2 = prev.getAction();
            }
            this.props.set(key, new AccessibilityAction(string, t2));
        } else {
            this.props.set(key, value2);
        }
    }

    public final <T> boolean contains(@NotNull SemanticsPropertyKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.props.containsKey(key);
    }

    public final boolean isMergingSemanticsOfDescendants() {
        return this.isMergingSemanticsOfDescendants;
    }

    public final void setMergingSemanticsOfDescendants(boolean bl) {
        this.isMergingSemanticsOfDescendants = bl;
    }

    public final boolean isClearingSemantics() {
        return this.isClearingSemantics;
    }

    public final void setClearingSemantics(boolean bl) {
        this.isClearingSemantics = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeChild$ui(@NotNull SemanticsConfiguration child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
        ScatterMap this_$iv = (ScatterMap)child2.props;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        ScatterMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void nextValue;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Object object = v$iv[index$iv];
                            SemanticsPropertyKey key = (SemanticsPropertyKey)k$iv[index$iv];
                            boolean bl2 = false;
                            Object existingValue = this.props.get((Object)key);
                            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.SemanticsPropertyKey<kotlin.Any?>");
                            void mergeResult = key.merge(existingValue, nextValue);
                            if (mergeResult != null) {
                                this.props.set((Object)key, (Object)mergeResult);
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void collapsePeer$ui(@NotNull SemanticsConfiguration peer) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        if (peer.isMergingSemanticsOfDescendants) {
            this.isMergingSemanticsOfDescendants = true;
        }
        if (peer.isClearingSemantics) {
            this.isClearingSemantics = true;
        }
        ScatterMap this_$iv = (ScatterMap)peer.props;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        ScatterMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void nextValue;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Object object = v$iv[index$iv];
                            SemanticsPropertyKey key = (SemanticsPropertyKey)k$iv[index$iv];
                            boolean bl2 = false;
                            if (!this.props.contains((Object)key)) {
                                this.props.set((Object)key, (Object)nextValue);
                            } else if (nextValue instanceof AccessibilityAction) {
                                Object t2;
                                Object object2 = this.props.get((Object)key);
                                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.AccessibilityAction<*>");
                                AccessibilityAction value2 = (AccessibilityAction)object2;
                                String string = value2.getLabel();
                                if (string == null) {
                                    string = ((AccessibilityAction)nextValue).getLabel();
                                }
                                if ((t2 = value2.getAction()) == null) {
                                    t2 = ((AccessibilityAction)nextValue).getAction();
                                }
                                this.props.set((Object)key, new AccessibilityAction(string, t2));
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    @NotNull
    public final SemanticsConfiguration copy() {
        SemanticsConfiguration copy2 = new SemanticsConfiguration();
        copy2.isMergingSemanticsOfDescendants = this.isMergingSemanticsOfDescendants;
        copy2.isClearingSemantics = this.isClearingSemantics;
        copy2.props.putAll((ScatterMap)this.props);
        return copy2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticsConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.props, ((SemanticsConfiguration)other).props)) {
            return false;
        }
        if (this.isMergingSemanticsOfDescendants != ((SemanticsConfiguration)other).isMergingSemanticsOfDescendants) {
            return false;
        }
        return this.isClearingSemantics == ((SemanticsConfiguration)other).isClearingSemantics;
    }

    public int hashCode() {
        int result2 = this.props.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.isMergingSemanticsOfDescendants);
        result2 = 31 * result2 + Boolean.hashCode(this.isClearingSemantics);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder propsString = new StringBuilder();
        String nextSeparator = null;
        nextSeparator = "";
        if (this.isMergingSemanticsOfDescendants) {
            propsString.append(nextSeparator);
            propsString.append("mergeDescendants=true");
            nextSeparator = ", ";
        }
        if (this.isClearingSemantics) {
            propsString.append(nextSeparator);
            propsString.append("isClearingSemantics=true");
            nextSeparator = ", ";
        }
        ScatterMap this_$iv = (ScatterMap)this.props;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        ScatterMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value2;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Object object = v$iv[index$iv];
                            SemanticsPropertyKey key = (SemanticsPropertyKey)k$iv[index$iv];
                            boolean bl2 = false;
                            propsString.append(nextSeparator);
                            propsString.append(key.getName());
                            propsString.append(" : ");
                            propsString.append(value2);
                            nextSeparator = ", ";
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        return DebugUtils_jvmKt.simpleIdentityToString(this, null) + "{ " + propsString + " }";
    }
}

