/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.scene.skia;

import androidx.compose.ui.awt.RenderSettings;
import androidx.compose.ui.platform.PlatformWindowContext;
import androidx.compose.ui.scene.ComposeSceneMediator;
import androidx.compose.ui.scene.skia.SkiaLayerComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.im.InputMethodRequests;
import java.util.List;
import javax.accessibility.Accessible;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoRenderDelegate;

public final class WindowSkiaLayerComponent
implements SkiaLayerComponent {
    @NotNull
    private final ComposeSceneMediator mediator;
    @NotNull
    private final PlatformWindowContext windowContext;
    @NotNull
    private final RenderSettings renderSettings;
    @NotNull
    private final SkiaLayer contentComponent;
    @NotNull
    private final SkiaLayer renderApi$receiver;
    @NotNull
    private final SkiaLayer clipComponents$receiver;
    @NotNull
    private final SkiaLayer fullscreen$receiver;
    @NotNull
    private final SkiaLayer windowHandle$receiver;
    public static final int $stable = 8;

    public WindowSkiaLayerComponent(@NotNull ComposeSceneMediator mediator2, @NotNull PlatformWindowContext windowContext, @NotNull SkikoRenderDelegate renderDelegate2, @NotNull SkiaLayerAnalytics skiaLayerAnalytics, @NotNull RenderSettings renderSettings) {
        Intrinsics.checkNotNullParameter((Object)mediator2, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)windowContext, (String)"windowContext");
        Intrinsics.checkNotNullParameter((Object)renderDelegate2, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"skiaLayerAnalytics");
        Intrinsics.checkNotNullParameter((Object)renderSettings, (String)"renderSettings");
        this.mediator = mediator2;
        this.windowContext = windowContext;
        this.renderSettings = renderSettings;
        Function1 function1 = arg_0 -> WindowSkiaLayerComponent.contentComponent$lambda$0(this, arg_0);
        SkiaLayer.Companion companion = SkiaLayer.Companion;
        WindowSkiaLayerComponent windowSkiaLayerComponent = this;
        boolean bl = false;
        SkiaLayerProperties defaultProperties = new SkiaLayerProperties(false, false, null, null, null, 31, null);
        Boolean bl2 = this.renderSettings.isVsyncEnabled();
        SkiaLayerProperties skiaLayerProperties = new SkiaLayerProperties(bl2 != null ? bl2.booleanValue() : defaultProperties.isVsyncEnabled(), false, null, null, null, 30, null);
        windowSkiaLayerComponent.contentComponent = new SkiaLayer(skiaLayerAnalytics, this, (Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties){
            final /* synthetic */ WindowSkiaLayerComponent this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $skiaLayerAnalytics, null, 8, null);
            }

            public void paint(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                ComposeSceneMediator.onChangeDensity$default(WindowSkiaLayerComponent.access$getMediator$p(this.this$0), null, 1, null);
                super.paint(g);
            }

            public InputMethodRequests getInputMethodRequests() {
                return WindowSkiaLayerComponent.access$getMediator$p(this.this$0).getCurrentInputMethodRequests();
            }

            public void doLayout() {
                super.doLayout();
                WindowSkiaLayerComponent.access$getMediator$p(this.this$0).onComponentSizeChanged();
            }

            public Dimension getPreferredSize() {
                Dimension dimension;
                if (this.isPreferredSizeSet()) {
                    Dimension dimension2 = super.getPreferredSize();
                    Intrinsics.checkNotNull((Object)dimension2);
                    dimension = dimension2;
                } else {
                    dimension = WindowSkiaLayerComponent.access$getMediator$p(this.this$0).getPreferredSize();
                }
                return dimension;
            }
        };
        this.renderApi$receiver = this.getContentComponent();
        this.clipComponents$receiver = this.getContentComponent();
        this.fullscreen$receiver = this.getContentComponent();
        this.windowHandle$receiver = this.getContentComponent();
        this.getContentComponent().setRenderDelegate(renderDelegate2);
    }

    @NotNull
    public SkiaLayer getContentComponent() {
        return this.contentComponent;
    }

    @Override
    @NotNull
    public GraphicsApi getRenderApi() {
        return this.renderApi$receiver.getRenderApi();
    }

    @Override
    public boolean getInteropBlendingSupported() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getRenderApi().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public List<ClipRectangle> getClipComponents() {
        return this.clipComponents$receiver.getClipComponents();
    }

    @Override
    public void setTransparency(boolean value2) {
        this.getContentComponent().setTransparency(value2);
        if (value2 && !this.windowContext.isWindowTransparent() && this.getRenderApi() == GraphicsApi.METAL) {
            this.getContentComponent().setBackground(null);
        }
    }

    @Override
    public boolean getFullscreen() {
        return this.fullscreen$receiver.getFullscreen();
    }

    @Override
    public void setFullscreen(boolean bl) {
        this.fullscreen$receiver.setFullscreen(bl);
    }

    @Override
    public long getWindowHandle() {
        return this.windowHandle$receiver.getWindowHandle();
    }

    @Override
    public void dispose() {
        this.getContentComponent().dispose();
    }

    @Override
    public void requestNativeFocusOnAccessible(@NotNull Accessible accessible) {
        Intrinsics.checkNotNullParameter((Object)accessible, (String)"accessible");
        this.getContentComponent().requestNativeFocusOnAccessible(accessible);
    }

    @Override
    public void onComposeInvalidation() {
        this.getContentComponent().needRedraw();
    }

    @Override
    public void onRenderApiChanged(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.getContentComponent().onStateChanged(SkiaLayer.PropertyKind.Renderer, arg_0 -> WindowSkiaLayerComponent.onRenderApiChanged$lambda$2(action2, arg_0));
    }

    private static final Accessible contentComponent$lambda$0(WindowSkiaLayerComponent this$0, Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Accessible accessible = this$0.mediator.getAccessible();
        if (accessible == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return accessible;
    }

    private static final Unit onRenderApiChanged$lambda$2(Function0 $action, SkiaLayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $action.invoke();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ComposeSceneMediator access$getMediator$p(WindowSkiaLayerComponent $this) {
        return $this.mediator;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GraphicsApi.values().length];
            try {
                nArray[GraphicsApi.DIRECT3D.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GraphicsApi.METAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

