/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.scene;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionContext;
import androidx.compose.runtime.CompositionLocalContext;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.ui.ComposeFeatureFlags;
import androidx.compose.ui.LayerType;
import androidx.compose.ui.awt.AwtEventFilter;
import androidx.compose.ui.awt.AwtEventListener;
import androidx.compose.ui.awt.AwtEventListeners;
import androidx.compose.ui.awt.RenderSettings;
import androidx.compose.ui.backhandler.DesktopBackGestureDispatcher;
import androidx.compose.ui.platform.PlatformContext;
import androidx.compose.ui.platform.PlatformWindowContext;
import androidx.compose.ui.scene.CanvasLayersComposeScene_skikoKt;
import androidx.compose.ui.scene.ComposeContainer;
import androidx.compose.ui.scene.ComposeContainer_desktopKt;
import androidx.compose.ui.scene.ComposeScene;
import androidx.compose.ui.scene.ComposeSceneContext;
import androidx.compose.ui.scene.ComposeSceneLayer;
import androidx.compose.ui.scene.ComposeSceneMediator;
import androidx.compose.ui.scene.DesktopComposeSceneLayer;
import androidx.compose.ui.scene.PlatformLayersComposeScene_skikoKt;
import androidx.compose.ui.scene.SwingComposeSceneLayer;
import androidx.compose.ui.scene.WindowComposeSceneLayer;
import androidx.compose.ui.scene.skia.SkiaLayerComponent;
import androidx.compose.ui.scene.skia.SwingSkiaLayerComponent;
import androidx.compose.ui.scene.skia.WindowSkiaLayerComponent;
import androidx.compose.ui.skiko.OverlayRenderDecorator;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.window.LayoutConfiguration_desktopKt;
import androidx.compose.ui.window.WindowExceptionHandler;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.AbstractCoroutineContextElement;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;

@SourceDebugExtension(value={"SMAP\nComposeContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeContainer.desktop.kt\nandroidx/compose/ui/scene/ComposeContainer\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,538:1\n35#2,5:539\n35#2,5:544\n35#2,5:549\n35#2,5:554\n35#2,5:559\n35#2,5:564\n*S KotlinDebug\n*F\n+ 1 ComposeContainer.desktop.kt\nandroidx/compose/ui/scene/ComposeContainer\n*L\n205#1:539,5\n229#1:544,5\n237#1:549,5\n245#1:554,5\n257#1:559,5\n440#1:564,5\n*E\n"})
public final class ComposeContainer
implements LifecycleOwner,
ViewModelStoreOwner,
WindowFocusListener,
WindowListener {
    @NotNull
    private final JLayeredPane container;
    @NotNull
    private final SkiaLayerAnalytics skiaLayerAnalytics;
    private final boolean useSwingGraphics;
    @NotNull
    private final LayerType layerType;
    @NotNull
    private final RenderSettings renderSettings;
    @NotNull
    private final PlatformWindowContext windowContext;
    @Nullable
    private Window window;
    @NotNull
    private LayoutDirection layoutDirection;
    @NotNull
    private final List<DesktopComposeSceneLayer> layers;
    @Nullable
    private JLayeredPane _windowContainer;
    @NotNull
    private final DesktopCoroutineExceptionHandler coroutineExceptionHandler;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final ComposeSceneMediator mediator;
    @NotNull
    private final windowContainerComponentListener.1 windowContainerComponentListener;
    @NotNull
    private final windowSizeListener.1 windowSizeListener;
    @Nullable
    private WindowExceptionHandler exceptionHandler;
    @NotNull
    private final LifecycleRegistry lifecycle;
    @NotNull
    private final ViewModelStore viewModelStore;
    @NotNull
    private final DesktopBackGestureDispatcher backGestureDispatcher;
    private boolean isDisposed;
    private boolean isDetached;
    private boolean isMinimized;
    private boolean isFocused;
    public static final int $stable = 8;

    public ComposeContainer(@NotNull JLayeredPane container2, @NotNull SkiaLayerAnalytics skiaLayerAnalytics, @Nullable Window window, @NotNull JLayeredPane windowContainer, boolean useSwingGraphics, @NotNull LayerType layerType, @NotNull RenderSettings renderSettings) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"skiaLayerAnalytics");
        Intrinsics.checkNotNullParameter((Object)windowContainer, (String)"windowContainer");
        Intrinsics.checkNotNullParameter((Object)((Object)layerType), (String)"layerType");
        Intrinsics.checkNotNullParameter((Object)renderSettings, (String)"renderSettings");
        this.container = container2;
        this.skiaLayerAnalytics = skiaLayerAnalytics;
        this.useSwingGraphics = useSwingGraphics;
        this.layerType = layerType;
        this.renderSettings = renderSettings;
        this.windowContext = new PlatformWindowContext();
        Container container3 = window;
        if (container3 == null) {
            container3 = this.container;
        }
        this.layoutDirection = LayoutConfiguration_desktopKt.layoutDirectionFor(container3);
        this.layers = new ArrayList();
        this.coroutineExceptionHandler = new DesktopCoroutineExceptionHandler();
        this.coroutineContext = MainUIDispatcher_awtKt.getMainUIDispatcher().plus((CoroutineContext)this.coroutineExceptionHandler);
        AwtEventListener[] awtEventListenerArray = new AwtEventListener[]{new DetectEventOutsideLayer(), new FocusableLayerEventFilter()};
        this.mediator = new ComposeSceneMediator(this.container, this.windowContext, arg_0 -> ComposeContainer.mediator$lambda$0(this, arg_0), new AwtEventListeners(awtEventListenerArray), false, this.coroutineContext, (Function1)new Function1<ComposeSceneMediator, SkiaLayerComponent>((Object)this){

            public final SkiaLayerComponent invoke(ComposeSceneMediator p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ComposeContainer.access$createSkiaLayerComponent((ComposeContainer)this.receiver, p0);
            }
        }, (Function1)new Function1<ComposeSceneMediator, ComposeScene>((Object)this){

            public final ComposeScene invoke(ComposeSceneMediator p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ComposeContainer.access$createComposeScene((ComposeContainer)this.receiver, p0);
            }
        }, 16, null);
        this.windowContainerComponentListener = new ComponentAdapter(this){
            final /* synthetic */ ComposeContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                ComposeContainer.access$onWindowContainerSizeChanged(this.this$0);
            }

            public void componentMoved(ComponentEvent e) {
                ComposeContainer.access$onWindowContainerPositionChanged(this.this$0);
            }
        };
        this.windowSizeListener = new ComponentAdapter(this){
            final /* synthetic */ ComposeContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                ComposeContainer.access$onWindowContainerSizeChanged(this.this$0);
            }
        };
        this.lifecycle = new LifecycleRegistry((LifecycleOwner)this);
        this.viewModelStore = new ViewModelStore();
        this.backGestureDispatcher = new DesktopBackGestureDispatcher();
        this.isDetached = true;
        this.setWindow(window);
        this.setWindowContainer(windowContainer);
        if (this.layerType == LayerType.OnComponent && !this.useSwingGraphics) {
            throw new IllegalStateException("LayerType.OnComponent can only be used with rendering via Swing graphics".toString());
        }
    }

    public /* synthetic */ ComposeContainer(JLayeredPane jLayeredPane, SkiaLayerAnalytics skiaLayerAnalytics, Window window, JLayeredPane jLayeredPane2, boolean bl, LayerType layerType, RenderSettings renderSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            window = null;
        }
        if ((n & 8) != 0) {
            jLayeredPane2 = jLayeredPane;
        }
        if ((n & 0x10) != 0) {
            bl = ComposeFeatureFlags.INSTANCE.getUseSwingGraphics();
        }
        if ((n & 0x20) != 0) {
            layerType = ComposeFeatureFlags.INSTANCE.getLayerType();
        }
        this(jLayeredPane, skiaLayerAnalytics, window, jLayeredPane2, bl, layerType, renderSettings);
    }

    @NotNull
    public final PlatformWindowContext getWindowContext() {
        return this.windowContext;
    }

    @Nullable
    public final Window getWindow() {
        return this.window;
    }

    @NotNull
    public final JLayeredPane getWindowContainer() {
        JLayeredPane jLayeredPane = this._windowContainer;
        if (jLayeredPane == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return jLayeredPane;
    }

    public final void setWindowContainer(@NotNull JLayeredPane value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (Intrinsics.areEqual((Object)this._windowContainer, (Object)value2)) {
            return;
        }
        if (this.layerType == LayerType.OnSameCanvas && !Intrinsics.areEqual((Object)value2, (Object)this.container)) {
            throw new IllegalStateException("Customizing windowContainer cannot be used with LayerType.OnSameCanvas".toString());
        }
        JLayeredPane jLayeredPane = this._windowContainer;
        if (jLayeredPane != null) {
            jLayeredPane.removeComponentListener(this.windowContainerComponentListener);
        }
        value2.addComponentListener(this.windowContainerComponentListener);
        this._windowContainer = value2;
        this.windowContext.setWindowContainer(value2);
        this.onWindowContainerSizeChanged();
        this.onWindowContainerPositionChanged();
    }

    @NotNull
    public final JComponent getContentComponent() {
        return this.mediator.getContentComponent();
    }

    public final void setRootForTestListener(@Nullable PlatformContext.RootForTestListener rootForTestListener) {
        this.mediator.setRootForTestListener(rootForTestListener);
    }

    public final boolean getFullscreen() {
        return this.mediator.getFullscreen();
    }

    public final void setFullscreen(boolean bl) {
        this.mediator.setFullscreen(bl);
    }

    public final void setCompositionLocalContext(@Nullable CompositionLocalContext compositionLocalContext) {
        this.mediator.setCompositionLocalContext(compositionLocalContext);
    }

    @Nullable
    public final WindowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void setExceptionHandler(@Nullable WindowExceptionHandler windowExceptionHandler) {
        this.exceptionHandler = windowExceptionHandler;
    }

    public final long getWindowHandle() {
        return this.mediator.getWindowHandle();
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        return this.mediator.getRenderApi();
    }

    @NotNull
    public final Dimension getPreferredSize() {
        return this.mediator.getPreferredSize();
    }

    @NotNull
    public LifecycleRegistry getLifecycle() {
        return this.lifecycle;
    }

    @NotNull
    public ViewModelStore getViewModelStore() {
        return this.viewModelStore;
    }

    public final void dispose() {
        this.isDisposed = true;
        this.updateLifecycleState();
        this.getViewModelStore().clear();
        JLayeredPane jLayeredPane = this._windowContainer;
        if (jLayeredPane != null) {
            jLayeredPane.removeComponentListener(this.windowContainerComponentListener);
        }
        this.mediator.dispose();
        List<DesktopComposeSceneLayer> $this$fastForEach$iv = this.layers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            DesktopComposeSceneLayer item$iv;
            DesktopComposeSceneLayer p0 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            p0.close();
        }
    }

    @Override
    public void windowGainedFocus(@NotNull WindowEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onWindowFocusChanged();
    }

    @Override
    public void windowLostFocus(@NotNull WindowEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onWindowFocusChanged();
    }

    @Override
    public void windowOpened(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void windowClosing(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void windowClosed(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void windowIconified(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.isMinimized = true;
        this.updateLifecycleState();
    }

    @Override
    public void windowDeiconified(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.isMinimized = false;
        this.updateLifecycleState();
    }

    @Override
    public void windowActivated(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void windowDeactivated(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    private final void onWindowFocusChanged() {
        Window window = this.window;
        this.isFocused = window != null ? window.isFocused() : false;
        this.windowContext.setWindowFocused(this.isFocused);
        this.mediator.onChangeWindowFocus();
        List<DesktopComposeSceneLayer> $this$fastForEach$iv = this.layers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            DesktopComposeSceneLayer item$iv;
            DesktopComposeSceneLayer p0 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            p0.onWindowFocusChanged();
        }
        this.updateLifecycleState();
    }

    private final void onWindowContainerPositionChanged() {
        if (!this.container.isDisplayable()) {
            return;
        }
        this.mediator.onComponentPositionChanged();
        List<DesktopComposeSceneLayer> $this$fastForEach$iv = this.layers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            DesktopComposeSceneLayer item$iv;
            DesktopComposeSceneLayer p0 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            p0.onWindowContainerPositionChanged();
        }
    }

    private final void onWindowContainerSizeChanged() {
        if (!this.container.isDisplayable()) {
            return;
        }
        this.windowContext.setContainerSize-uvyYCjk(LayoutConfiguration_desktopKt.getSizeInPx(this.getWindowContainer()));
        this.mediator.onComponentSizeChanged();
        List<DesktopComposeSceneLayer> $this$fastForEach$iv = this.layers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            DesktopComposeSceneLayer item$iv;
            DesktopComposeSceneLayer p0 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            p0.onWindowContainerSizeChanged();
        }
        this.container.validate();
        this.container.repaint();
    }

    private final void onRenderOverlay(Canvas canvas, int width, int height) {
        List<DesktopComposeSceneLayer> $this$fastForEach$iv = this.layers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            DesktopComposeSceneLayer item$iv;
            DesktopComposeSceneLayer it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            it.onRenderOverlay(canvas, width, height, this.windowContext.isWindowTransparent());
        }
    }

    public final void onWindowTransparencyChanged(boolean value2) {
        this.windowContext.setWindowTransparent(value2);
        this.mediator.onWindowTransparencyChanged(value2);
    }

    public final void onLayoutDirectionChanged(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.layoutDirection = LayoutConfiguration_desktopKt.layoutDirectionFor(component);
        this.mediator.onLayoutDirectionChanged(this.layoutDirection);
    }

    public final void addNotify() {
        this.mediator.onComponentAttached();
        this.setWindow(SwingUtilities.getWindowAncestor(this.container));
        this.onWindowContainerSizeChanged();
        this.onWindowContainerPositionChanged();
        this.isDetached = false;
        this.updateLifecycleState();
    }

    public final void removeNotify() {
        this.isDetached = true;
        this.updateLifecycleState();
        this.setWindow(null);
    }

    public final void setBounds(int x, int y, int width, int height) {
        this.mediator.getContentComponent().setSize(width, height);
        this.onWindowContainerSizeChanged();
        this.onWindowContainerPositionChanged();
    }

    private final void setWindow(Window window) {
        if (Intrinsics.areEqual((Object)this.window, (Object)window)) {
            return;
        }
        Window window2 = this.window;
        if (window2 != null) {
            Window it = window2;
            boolean bl = false;
            it.removeWindowFocusListener(this);
            it.removeWindowListener(this);
            it.removeComponentListener(this.windowSizeListener);
        }
        Window window3 = window;
        if (window3 != null) {
            Window it = window3;
            boolean bl = false;
            it.addWindowFocusListener(this);
            it.addWindowListener(this);
            it.addComponentListener(this.windowSizeListener);
        }
        this.window = window;
        this.onWindowFocusChanged();
    }

    public final void setKeyEventListeners(@NotNull Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean> onPreviewKeyEvent2, @NotNull Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean> onKeyEvent2) {
        Intrinsics.checkNotNullParameter(onPreviewKeyEvent2, (String)"onPreviewKeyEvent");
        Intrinsics.checkNotNullParameter(onKeyEvent2, (String)"onKeyEvent");
        this.mediator.setKeyEventListeners(onPreviewKeyEvent2, (Function1<? super androidx.compose.ui.input.key.KeyEvent, Boolean>)((Function1)new Function1<androidx.compose.ui.input.key.KeyEvent, Boolean>(onKeyEvent2, this){
            final /* synthetic */ Function1<androidx.compose.ui.input.key.KeyEvent, Boolean> $onKeyEvent;
            final /* synthetic */ ComposeContainer this$0;
            {
                this.$onKeyEvent = $onKeyEvent;
                this.this$0 = $receiver;
            }

            public final Boolean invoke-ZmokQxo(Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$onKeyEvent.invoke((Object)androidx.compose.ui.input.key.KeyEvent.box-impl(it)) != false || ComposeContainer.access$getBackGestureDispatcher$p(this.this$0).onKeyEvent-ZmokQxo(it);
            }
        }));
    }

    public final void setContent(@NotNull Function2<? super Composer, ? super Integer, Unit> content2) {
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        this.mediator.setContent((Function2<? super Composer, ? super Integer, Unit>)((Function2)ComposableLambdaKt.composableLambdaInstance(-337356885, true, new Function2<Composer, Integer, Unit>(this, content2){
            final /* synthetic */ ComposeContainer this$0;
            final /* synthetic */ Function2<Composer, Integer, Unit> $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
            }

            public final void invoke(Composer $composer, int $changed) {
                ComposerKt.sourceInformation($composer, "C338@12783L41,338@12720L104:ComposeContainer.desktop.kt#bazzlf");
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart(-337356885, $changed, -1, "androidx.compose.ui.scene.ComposeContainer.setContent.<anonymous> (ComposeContainer.desktop.kt:338)");
                    }
                    ComposeContainer_desktopKt.access$ProvideContainerCompositionLocals(this.this$0, ComposeContainer.access$getBackGestureDispatcher$p(this.this$0), ComposableLambdaKt.rememberComposableLambda(1146962096, true, new Function2<Composer, Integer, Unit>(this.$content){
                        final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                        {
                            this.$content = $content;
                        }

                        public final void invoke(Composer $composer, int $changed) {
                            ComposerKt.sourceInformation($composer, "C339@12801L9:ComposeContainer.desktop.kt#bazzlf");
                            if (($changed & 3) != 2 || !$composer.getSkipping()) {
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventStart(1146962096, $changed, -1, "androidx.compose.ui.scene.ComposeContainer.setContent.<anonymous>.<anonymous> (ComposeContainer.desktop.kt:339)");
                                }
                                this.$content.invoke((Object)$composer, (Object)0);
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventEnd();
                                }
                            } else {
                                $composer.skipToGroupEnd();
                            }
                        }
                    }, $composer, 54), $composer, 384);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        })));
    }

    private final SkiaLayerComponent createSkiaLayerComponent(ComposeSceneMediator mediator2) {
        SkikoRenderDelegate renderDelegate2 = WhenMappings.$EnumSwitchMapping$0[this.layerType.ordinal()] == 1 ? (SkikoRenderDelegate)new OverlayRenderDecorator(mediator2, (Function3<? super Canvas, ? super Integer, ? super Integer, Unit>)((Function3)new Function3<Canvas, Integer, Integer, Unit>((Object)this){

            public final void invoke(Canvas p0, int p1, int p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ComposeContainer.access$onRenderOverlay((ComposeContainer)this.receiver, p0, p1, p2);
            }
        })) : (SkikoRenderDelegate)mediator2;
        return this.useSwingGraphics ? (SkiaLayerComponent)new SwingSkiaLayerComponent(mediator2, renderDelegate2, this.skiaLayerAnalytics) : (SkiaLayerComponent)new WindowSkiaLayerComponent(mediator2, this.windowContext, renderDelegate2, this.skiaLayerAnalytics, this.renderSettings);
    }

    private final ComposeScene createComposeScene(ComposeSceneMediator mediator2) {
        Density density = LayoutConfiguration_desktopKt.getDensity(this.container);
        return WhenMappings.$EnumSwitchMapping$0[this.layerType.ordinal()] == 2 ? CanvasLayersComposeScene_skikoKt.CanvasLayersComposeScene-3tKcejY$default(density, this.layoutDirection, null, mediator2.getCoroutineContext(), mediator2.getPlatformContext(), (Function0)new Function0<Unit>((Object)mediator2){

            public final void invoke() {
                ((ComposeSceneMediator)this.receiver).onComposeInvalidation();
            }
        }, 4, null) : PlatformLayersComposeScene_skikoKt.PlatformLayersComposeScene-3tKcejY$default(density, this.layoutDirection, null, mediator2.getCoroutineContext(), this.createComposeSceneContext(mediator2.getPlatformContext()), (Function0)new Function0<Unit>((Object)mediator2){

            public final void invoke() {
                ((ComposeSceneMediator)this.receiver).onComposeInvalidation();
            }
        }, 4, null);
    }

    private final ComposeSceneLayer createPlatformLayer(Density density, LayoutDirection layoutDirection, boolean focusable, CompositionContext compositionContext) {
        ComposeSceneLayer composeSceneLayer;
        switch (WhenMappings.$EnumSwitchMapping$0[this.layerType.ordinal()]) {
            case 1: {
                composeSceneLayer = new WindowComposeSceneLayer(this, this.skiaLayerAnalytics, true, density, layoutDirection, focusable, compositionContext, this.renderSettings);
                break;
            }
            case 3: {
                composeSceneLayer = new SwingComposeSceneLayer(this, this.skiaLayerAnalytics, density, layoutDirection, focusable, compositionContext);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected LayerType".toString());
            }
        }
        return composeSceneLayer;
    }

    @NotNull
    public final Sequence<DesktopComposeSceneLayer> layersAbove(@NotNull DesktopComposeSceneLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super DesktopComposeSceneLayer>, Continuation<? super Unit>, Object>(this, layer, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ComposeContainer this$0;
            final /* synthetic */ DesktopComposeSceneLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object object) {
                Object object2;
                Iterator<E> iterator2;
                int isAbove;
                SequenceScope $this$sequence;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        $this$sequence = (SequenceScope)this.L$0;
                        isAbove = 0;
                        iterator2 = ComposeContainer.access$getLayers$p(this.this$0).iterator();
                        break;
                    }
                    case 1: {
                        void $result;
                        isAbove = this.I$0;
                        iterator2 = (Iterator<E>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator2.hasNext()) {
                    DesktopComposeSceneLayer i2 = (DesktopComposeSceneLayer)iterator2.next();
                    if (Intrinsics.areEqual((Object)i2, (Object)this.$layer)) {
                        isAbove = 1;
                        continue;
                    }
                    if (isAbove == 0) continue;
                    this.L$0 = $this$sequence;
                    this.L$1 = iterator2;
                    this.I$0 = isAbove;
                    this.label = 1;
                    object2 = $this$sequence.yield((Object)i2, (Continuation)this);
                    if (object2 != object3) continue;
                    return object3;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super DesktopComposeSceneLayer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void onLayersChange(DesktopComposeSceneLayer layer) {
        List<DesktopComposeSceneLayer> $this$fastForEach$iv = this.layers;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            DesktopComposeSceneLayer item$iv;
            DesktopComposeSceneLayer it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)layer)) continue;
            it.onLayersChange();
        }
    }

    public final void attachLayer(@NotNull DesktopComposeSceneLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.layers.add(layer);
        this.onLayersChange(layer);
    }

    public final void detachLayer(@NotNull DesktopComposeSceneLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.layers.remove(layer);
        this.onLayersChange(layer);
    }

    @NotNull
    public final ComposeSceneContext createComposeSceneContext(@NotNull PlatformContext platformContext) {
        Intrinsics.checkNotNullParameter((Object)platformContext, (String)"platformContext");
        return new ComposeSceneContextImpl(platformContext);
    }

    private final void updateLifecycleState() {
        this.getLifecycle().setCurrentState(this.isDisposed ? Lifecycle.State.DESTROYED : (this.isDetached || this.isMinimized ? Lifecycle.State.CREATED : (!this.isDetached && !this.isMinimized && this.isFocused ? Lifecycle.State.RESUMED : Lifecycle.State.STARTED)));
    }

    private static final void mediator$lambda$0(ComposeContainer this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WindowExceptionHandler windowExceptionHandler = this$0.exceptionHandler;
        if (windowExceptionHandler == null) {
            throw it;
        }
        windowExceptionHandler.onException(it);
    }

    public static final /* synthetic */ DesktopBackGestureDispatcher access$getBackGestureDispatcher$p(ComposeContainer $this) {
        return $this.backGestureDispatcher;
    }

    public static final /* synthetic */ void access$onRenderOverlay(ComposeContainer $this, Canvas canvas, int width, int height) {
        $this.onRenderOverlay(canvas, width, height);
    }

    public static final /* synthetic */ SkiaLayerComponent access$createSkiaLayerComponent(ComposeContainer $this, ComposeSceneMediator mediator2) {
        return $this.createSkiaLayerComponent(mediator2);
    }

    public static final /* synthetic */ ComposeScene access$createComposeScene(ComposeContainer $this, ComposeSceneMediator mediator2) {
        return $this.createComposeScene(mediator2);
    }

    public static final /* synthetic */ void access$onWindowContainerSizeChanged(ComposeContainer $this) {
        $this.onWindowContainerSizeChanged();
    }

    public static final /* synthetic */ void access$onWindowContainerPositionChanged(ComposeContainer $this) {
        $this.onWindowContainerPositionChanged();
    }

    private final class ComposeSceneContextImpl
    implements ComposeSceneContext {
        @NotNull
        private final PlatformContext platformContext;

        public ComposeSceneContextImpl(PlatformContext platformContext) {
            Intrinsics.checkNotNullParameter((Object)platformContext, (String)"platformContext");
            this.platformContext = platformContext;
        }

        @Override
        @NotNull
        public PlatformContext getPlatformContext() {
            return this.platformContext;
        }

        @Override
        @NotNull
        public ComposeSceneLayer createLayer(@NotNull Density density, @NotNull LayoutDirection layoutDirection, boolean focusable, @NotNull CompositionContext compositionContext) {
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)compositionContext, (String)"compositionContext");
            return ComposeContainer.this.createPlatformLayer(density, layoutDirection, focusable, compositionContext);
        }
    }

    private final class DesktopCoroutineExceptionHandler
    extends AbstractCoroutineContextElement
    implements CoroutineExceptionHandler {
        public DesktopCoroutineExceptionHandler() {
            super((CoroutineContext.Key)CoroutineExceptionHandler.Key);
        }

        public void handleException(@NotNull CoroutineContext context2, @NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            WindowExceptionHandler windowExceptionHandler = ComposeContainer.this.getExceptionHandler();
            if (windowExceptionHandler == null) {
                throw exception;
            }
            windowExceptionHandler.onException(exception);
        }
    }

    @SourceDebugExtension(value={"SMAP\nComposeContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeContainer.desktop.kt\nandroidx/compose/ui/scene/ComposeContainer$DetectEventOutsideLayer\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,538:1\n53#2,5:539\n*S KotlinDebug\n*F\n+ 1 ComposeContainer.desktop.kt\nandroidx/compose/ui/scene/ComposeContainer$DetectEventOutsideLayer\n*L\n508#1:539,5\n*E\n"})
    private final class DetectEventOutsideLayer
    implements AwtEventListener {
        @Override
        public boolean onMouseEvent(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List $this$fastForEachReversed$iv = ComposeContainer.this.layers;
            boolean $i$f$fastForEachReversed = false;
            int n = ((Collection)$this$fastForEachReversed$iv).size() + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    Object item$iv = $this$fastForEachReversed$iv.get(index$iv);
                    DesktopComposeSceneLayer it = (DesktopComposeSceneLayer)item$iv;
                    boolean bl = false;
                    it.onMouseEventOutside(event);
                    if (!it.getFocusable()) continue;
                    return false;
                } while (0 <= n);
            }
            return false;
        }
    }

    @SourceDebugExtension(value={"SMAP\nComposeContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeContainer.desktop.kt\nandroidx/compose/ui/scene/ComposeContainer$FocusableLayerEventFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,538:1\n1734#2,3:539\n*S KotlinDebug\n*F\n+ 1 ComposeContainer.desktop.kt\nandroidx/compose/ui/scene/ComposeContainer$FocusableLayerEventFilter\n*L\n519#1:539,3\n*E\n"})
    private final class FocusableLayerEventFilter
    extends AwtEventFilter {
        private final boolean getNoFocusableLayers() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = ComposeContainer.this.layers;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        DesktopComposeSceneLayer it = (DesktopComposeSceneLayer)element$iv;
                        boolean bl2 = false;
                        if (!it.getFocusable()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public boolean shouldSendMouseEvent(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return this.getNoFocusableLayers();
        }

        @Override
        public boolean shouldSendKeyEvent(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return this.getNoFocusableLayers();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayerType.values().length];
            try {
                nArray[LayerType.OnWindow.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LayerType.OnSameCanvas.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LayerType.OnComponent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

