/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.ui.platform.a11y.ComposeAccessible;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import javax.accessibility.AccessibleValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProgressBarAccessibleValue
implements AccessibleValue {
    @NotNull
    private final ComposeAccessible.ComposeAccessibleComponent component;

    public ProgressBarAccessibleValue(@NotNull ComposeAccessible.ComposeAccessibleComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
    }

    private final ProgressBarRangeInfo getRangeInfo() {
        return this.component.getProgressBarRangeInfo();
    }

    @Override
    @NotNull
    public Number getCurrentAccessibleValue() {
        ProgressBarRangeInfo progressBarRangeInfo = this.getRangeInfo();
        return progressBarRangeInfo != null ? (Number)Float.valueOf(progressBarRangeInfo.getCurrent()) : (Number)Float.valueOf(0.0f);
    }

    @Override
    public boolean setCurrentAccessibleValue(@Nullable Number n) {
        return false;
    }

    @Override
    @NotNull
    public Number getMinimumAccessibleValue() {
        ClosedFloatingPointRange<Float> closedFloatingPointRange = this.getRangeInfo();
        return closedFloatingPointRange != null && (closedFloatingPointRange = closedFloatingPointRange.getRange()) != null ? (Number)Float.valueOf(((Number)((Object)closedFloatingPointRange.getStart())).floatValue()) : (Number)Float.valueOf(0.0f);
    }

    @Override
    @NotNull
    public Number getMaximumAccessibleValue() {
        ClosedFloatingPointRange<Float> closedFloatingPointRange = this.getRangeInfo();
        return closedFloatingPointRange != null && (closedFloatingPointRange = closedFloatingPointRange.getRange()) != null ? (Number)Float.valueOf(((Number)((Object)closedFloatingPointRange.getEndInclusive())).floatValue()) : (Number)Float.valueOf(1.0f);
    }
}

