/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.node.LookaheadCapablePlaceable;
import androidx.compose.ui.node.OwnerScope;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PlaceableResult
implements OwnerScope {
    @NotNull
    private final MeasureResult result;
    @NotNull
    private final LookaheadCapablePlaceable placeable;

    public PlaceableResult(@NotNull MeasureResult result2, @NotNull LookaheadCapablePlaceable placeable) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
        this.result = result2;
        this.placeable = placeable;
    }

    @NotNull
    public final MeasureResult getResult() {
        return this.result;
    }

    @NotNull
    public final LookaheadCapablePlaceable getPlaceable() {
        return this.placeable;
    }

    @Override
    public boolean isValidOwnerScope() {
        return this.placeable.getCoordinates().isAttached();
    }

    @NotNull
    public String toString() {
        return "PlaceableResult(result=" + this.result + ", placeable=" + this.placeable + ")";
    }

    public int hashCode() {
        int result2 = this.result.hashCode();
        result2 = result2 * 31 + this.placeable.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlaceableResult)) {
            return false;
        }
        PlaceableResult placeableResult = (PlaceableResult)other;
        if (!Intrinsics.areEqual((Object)this.result, (Object)placeableResult.result)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.placeable, (Object)placeableResult.placeable);
    }
}

