/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BufferedImagePainter;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.BitmapPainter;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nDesktopImageConverters.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/PainterImage\n+ 2 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 6 CanvasDrawScope.kt\nandroidx/compose/ui/graphics/drawscope/CanvasDrawScope\n*L\n1#1,266:1\n57#2:267\n61#2:270\n60#3:268\n70#3:271\n53#3,3:274\n22#4:269\n22#4:272\n33#5:273\n536#6,17:277\n*S KotlinDebug\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/PainterImage\n*L\n137#1:267\n138#1:270\n137#1:268\n138#1:271\n162#1:274,3\n137#1:269\n138#1:272\n162#1:273\n164#1:277,17\n*E\n"})
final class PainterImage
extends Image
implements MultiResolutionImage {
    @NotNull
    private final Painter painter;
    @NotNull
    private final Density density;
    @NotNull
    private final LayoutDirection layoutDirection;
    private final int width;
    private final int height;
    @NotNull
    private final Lazy defaultImage$delegate;
    @NotNull
    private final Lazy scaledImage$delegate;

    private PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long size) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        this.painter = painter;
        this.density = density;
        this.layoutDirection = layoutDirection;
        boolean bl = false;
        long value$iv$iv = size;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        this.width = (int)Float.intBitsToFloat(bits$iv$iv$iv);
        boolean bl2 = false;
        value$iv$iv = size;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        this.height = (int)Float.intBitsToFloat(bits$iv$iv$iv);
        this.defaultImage$delegate = LazyKt.lazy(() -> PainterImage.defaultImage_delegate$lambda$2(this));
        this.scaledImage$delegate = LazyKt.lazy(() -> PainterImage.scaledImage_delegate$lambda$3(this));
    }

    @Override
    public int getWidth(@Nullable ImageObserver observer) {
        return this.width;
    }

    @Override
    public int getHeight(@Nullable ImageObserver observer) {
        return this.height;
    }

    @Override
    @NotNull
    public Image getResolutionVariant(double destImageWidth, double destImageHeight) {
        int width = (int)destImageWidth;
        int height = (int)destImageHeight;
        return this.painter instanceof BufferedImagePainter && ((BufferedImagePainter)this.painter).getImage().getWidth() == width && ((BufferedImagePainter)this.painter).getImage().getHeight() == height ? (Image)((BufferedImagePainter)this.painter).getImage() : (Image)DesktopImageConverters_desktopKt.toAwtImage(this.asBitmap(width, height));
    }

    /*
     * WARNING - void declaration
     */
    private final ImageBitmap asBitmap(int width, int height) {
        void layoutDirection$iv;
        void density$iv;
        CanvasDrawScope.DrawParams drawParams;
        void this_$iv;
        void width$iv22;
        ImageBitmap bitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(width, height, 0, false, null, 28, null);
        Canvas canvas = CanvasKt.Canvas(bitmap);
        float f = width;
        float height$iv22 = height;
        boolean $i$f$Size22 = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)width$iv22);
        long v2$iv$iv = Float.floatToRawIntBits(height$iv22);
        long floatSize = Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        CanvasDrawScope width$iv22 = new CanvasDrawScope();
        Density height$iv22 = this.density;
        LayoutDirection $i$f$Size22 = this.layoutDirection;
        boolean bl = false;
        CanvasDrawScope.DrawParams drawParams2 = this_$iv.getDrawParams();
        Density prevDensity$iv = drawParams2.component1();
        LayoutDirection prevLayoutDirection$iv = drawParams2.component2();
        Canvas prevCanvas$iv = drawParams2.component3();
        long prevSize$iv = drawParams2.component4-NH-jbRc();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u240$iv = drawParams = this_$iv.getDrawParams();
        boolean bl2 = false;
        $this$draw_yzxVdVo_u24lambda_u240$iv.setDensity((Density)density$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setLayoutDirection((LayoutDirection)layoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setCanvas(canvas);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setSize-uvyYCjk(floatSize);
        canvas.save();
        DrawScope $this$asBitmap_u24lambda_u241 = (DrawScope)this_$iv;
        boolean bl3 = false;
        Painter $this$asBitmap_u24lambda_u241_u24lambda_u240 = this.painter;
        boolean bl4 = false;
        Painter.draw-x_KDEd0$default($this$asBitmap_u24lambda_u241_u24lambda_u240, $this$asBitmap_u24lambda_u241, floatSize, 0.0f, null, 6, null);
        canvas.restore();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u241$iv = drawParams = this_$iv.getDrawParams();
        boolean bl5 = false;
        $this$draw_yzxVdVo_u24lambda_u241$iv.setDensity(prevDensity$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setLayoutDirection(prevLayoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setCanvas(prevCanvas$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setSize-uvyYCjk(prevSize$iv);
        return bitmap;
    }

    @Override
    @NotNull
    public Object getProperty(@NotNull String name2, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object object = Image.UndefinedProperty;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UndefinedProperty");
        return object;
    }

    @Override
    @NotNull
    public ImageProducer getSource() {
        ImageProducer imageProducer = this.getDefaultImage().getSource();
        Intrinsics.checkNotNullExpressionValue((Object)imageProducer, (String)"getSource(...)");
        return imageProducer;
    }

    @Override
    @NotNull
    public Graphics getGraphics() {
        Graphics graphics = this.getDefaultImage().getGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"getGraphics(...)");
        return graphics;
    }

    private final BufferedImage getDefaultImage() {
        Lazy lazy = this.defaultImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    private final BufferedImage getScaledImage() {
        Lazy lazy = this.scaledImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    @NotNull
    public List<BufferedImage> getResolutionVariants() {
        List list2;
        Painter painter = this.painter;
        if (painter instanceof BufferedImagePainter || painter instanceof BitmapPainter) {
            list2 = CollectionsKt.listOf((Object)this.getDefaultImage());
        } else {
            Object[] objectArray = new BufferedImage[]{this.getDefaultImage(), this.getScaledImage()};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return list2;
    }

    private static final BufferedImage defaultImage_delegate$lambda$2(PainterImage this$0) {
        return this$0.painter instanceof BufferedImagePainter ? ((BufferedImagePainter)this$0.painter).getImage() : DesktopImageConverters_desktopKt.toAwtImage(this$0.asBitmap(this$0.width, this$0.height));
    }

    private static final BufferedImage scaledImage_delegate$lambda$3(PainterImage this$0) {
        return DesktopImageConverters_desktopKt.toAwtImage(this$0.asBitmap(MathKt.roundToInt((float)((float)this$0.width * this$0.density.getDensity())), MathKt.roundToInt((float)((float)this$0.height * this$0.density.getDensity()))));
    }

    public /* synthetic */ PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long size, DefaultConstructorMarker $constructor_marker) {
        this(painter, density, layoutDirection, size);
    }
}

