/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.focus.FocusTraversalKt;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import java.util.Comparator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nOneDimensionalFocusSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1#1,280:1\n44#2:281\n472#2:282\n472#2:283\n1101#3:284\n1083#3,2:285\n*S KotlinDebug\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n*L\n259#1:281\n263#1:282\n264#1:283\n271#1:284\n271#1:285,2\n*E\n"})
final class FocusableChildrenComparator
implements Comparator<FocusTargetNode> {
    @NotNull
    public static final FocusableChildrenComparator INSTANCE = new FocusableChildrenComparator();

    private FocusableChildrenComparator() {
    }

    @Override
    public int compare(@NotNull FocusTargetNode a, @NotNull FocusTargetNode b) {
        LayoutNode layoutNode2;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!FocusTraversalKt.isEligibleForFocusSearch(a) || !FocusTraversalKt.isEligibleForFocusSearch(b)) {
            if (FocusTraversalKt.isEligibleForFocusSearch(a)) {
                return -1;
            }
            if (FocusTraversalKt.isEligibleForFocusSearch(b)) {
                return 1;
            }
            return 0;
        }
        LayoutNode layoutNode1 = DelegatableNodeKt.requireLayoutNode(a);
        if (Intrinsics.areEqual((Object)layoutNode1, (Object)(layoutNode2 = DelegatableNodeKt.requireLayoutNode(b)))) {
            return 0;
        }
        MutableVector<LayoutNode> pathFromRoot1 = this.pathFromRoot(layoutNode1);
        MutableVector<LayoutNode> pathFromRoot2 = this.pathFromRoot(layoutNode2);
        int depth = 0;
        MutableVector<LayoutNode> this_$iv22 = pathFromRoot1;
        boolean $i$f$getLastIndex = false;
        int this_$iv22 = this_$iv22.getSize() - 1;
        MutableVector<LayoutNode> this_$iv32 = pathFromRoot2;
        boolean $i$f$getLastIndex2 = false;
        int this_$iv32 = this_$iv32.getSize() - 1;
        int n = Math.min(this_$iv22, this_$iv32);
        if (depth <= n) {
            while (true) {
                MutableVector<LayoutNode> this_$iv = pathFromRoot1;
                boolean $i$f$get = false;
                this_$iv = pathFromRoot2;
                $i$f$get = false;
                if (!Intrinsics.areEqual(this_$iv.content[depth], this_$iv.content[depth])) {
                    this_$iv = pathFromRoot1;
                    $i$f$get = false;
                    this_$iv = pathFromRoot2;
                    $i$f$get = false;
                    return Intrinsics.compare((int)((LayoutNode)this_$iv.content[depth]).getPlaceOrder$ui(), (int)((LayoutNode)this_$iv.content[depth]).getPlaceOrder$ui());
                }
                if (depth == n) break;
                ++depth;
            }
        }
        throw new IllegalStateException("Could not find a common ancestor between the two FocusModifiers.".toString());
    }

    private final MutableVector<LayoutNode> pathFromRoot(LayoutNode layoutNode) {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        MutableVector<LayoutNode> path2 = new MutableVector<LayoutNode>(new LayoutNode[capacity$iv$iv], 0);
        for (LayoutNode current = layoutNode; current != null; current = current.getParent$ui()) {
            path2.add(0, current);
        }
        return path2;
    }
}

