/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.compose.runtime.DataSource;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.collection.ExtensionsKt;
import androidx.compose.runtime.collection.ScatterSetWrapperKt;
import androidx.compose.runtime.internal.AtomicInt;
import androidx.compose.runtime.internal.SnapshotThreadLocal;
import androidx.compose.runtime.internal.Thread_jvmKt;
import androidx.compose.runtime.internal.WeakReference;
import androidx.compose.runtime.snapshots.GlobalSnapshot;
import androidx.compose.runtime.snapshots.MutableSnapshot;
import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.runtime.snapshots.SnapshotDoubleIndexHeap;
import androidx.compose.runtime.snapshots.SnapshotIdSet;
import androidx.compose.runtime.snapshots.SnapshotId_jvmKt;
import androidx.compose.runtime.snapshots.SnapshotKt;
import androidx.compose.runtime.snapshots.SnapshotWeakSet;
import androidx.compose.runtime.snapshots.StateObject;
import androidx.compose.runtime.snapshots.StateRecord;
import androidx.compose.runtime.snapshots.TransparentObserverMutableSnapshot;
import androidx.compose.runtime.snapshots.TransparentObserverSnapshot;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/SnapshotKt\n+ 2 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n+ 3 SnapshotId.jvm.kt\nandroidx/compose/runtime/snapshots/SnapshotId_jvmKt\n+ 4 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n+ 5 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 6 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 7 SnapshotWeakSet.kt\nandroidx/compose/runtime/snapshots/SnapshotWeakSet\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2623:1\n2031#1:2624\n2031#1:2628\n2031#1:2635\n2031#1:2662\n2031#1:2666\n2031#1:2668\n2349#1,4:2674\n2353#1,4:2679\n2031#1:2712\n2031#1:2714\n2031#1:2716\n2031#1:2719\n2031#1:2721\n2031#1:2723\n2031#1:2750\n2031#1:2752\n2031#1:2756\n26#2:2625\n26#2:2626\n26#2:2629\n26#2:2636\n26#2:2663\n26#2:2667\n26#2:2669\n26#2:2713\n26#2:2715\n26#2:2717\n26#2:2720\n26#2:2722\n26#2:2724\n26#2:2751\n26#2:2753\n26#2:2757\n21#2,5:2758\n36#3:2627\n31#3:2664\n31#3:2665\n40#3:2670\n31#3:2671\n31#3:2672\n31#3:2673\n31#3:2678\n31#3:2683\n31#3:2754\n36#3:2755\n36#3:2763\n36#3:2764\n34#4,5:2630\n231#5,3:2637\n200#5,7:2640\n211#5,3:2648\n214#5,9:2652\n234#5:2661\n231#5,3:2725\n200#5,7:2728\n211#5,3:2736\n214#5,9:2740\n234#5:2749\n1399#6:2647\n1270#6:2651\n1399#6:2735\n1270#6:2739\n125#7,28:2684\n1#8:2718\n*S KotlinDebug\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/SnapshotKt\n*L\n818#1:2624\n2105#1:2628\n2124#1:2635\n2152#1:2662\n2211#1:2666\n2233#1:2668\n2333#1:2674,4\n2333#1:2679,4\n2385#1:2712\n2413#1:2714\n2423#1:2716\n2491#1:2719\n2502#1:2721\n2529#1:2723\n2585#1:2750\n2596#1:2752\n2137#1:2756\n818#1:2625\n2031#1:2626\n2105#1:2629\n2124#1:2636\n2152#1:2663\n2211#1:2667\n2233#1:2669\n2385#1:2713\n2413#1:2715\n2423#1:2717\n2491#1:2720\n2502#1:2722\n2529#1:2724\n2585#1:2751\n2596#1:2753\n2137#1:2757\n2024#1:2758,5\n2082#1:2627\n2176#1:2664\n2193#1:2665\n2258#1:2670\n2273#1:2671\n2312#1:2672\n2321#1:2673\n2333#1:2678\n2353#1:2683\n2617#1:2754\n2619#1:2755\n2042#1:2763\n2066#1:2764\n2118#1:2630,5\n2126#1:2637,3\n2126#1:2640,7\n2126#1:2648,3\n2126#1:2652,9\n2126#1:2661\n2551#1:2725,3\n2551#1:2728,7\n2551#1:2736,3\n2551#1:2740,9\n2551#1:2749\n2126#1:2647\n2126#1:2651\n2551#1:2735\n2551#1:2739\n2360#1:2684,28\n*E\n"})
public final class SnapshotKt {
    @NotNull
    private static final snapshotDataSource.1 snapshotDataSource;
    @NotNull
    private static final Function1<SnapshotIdSet, Unit> emptyLambda;
    private static final long INVALID_SNAPSHOT;
    @NotNull
    private static final SnapshotThreadLocal<Snapshot> threadSnapshot;
    @NotNull
    private static final SynchronizedObject lock;
    @NotNull
    private static SnapshotIdSet openSnapshots;
    private static long nextSnapshotId;
    @NotNull
    private static final SnapshotDoubleIndexHeap pinningTable;
    @NotNull
    private static final SnapshotWeakSet<StateObject> extraStateObjects;
    @NotNull
    private static List<? extends Function2<? super Set<? extends Object>, ? super Snapshot, Unit>> applyObservers;
    @NotNull
    private static List<? extends Function1<Object, Unit>> globalWriteObservers;
    @NotNull
    private static final GlobalSnapshot globalSnapshot;
    @NotNull
    private static final Snapshot snapshotInitializer;
    @NotNull
    private static AtomicInt pendingApplyObserverCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int trackPinning(long snapshotId, @NotNull SnapshotIdSet invalid) {
        int n;
        Intrinsics.checkNotNullParameter((Object)invalid, (String)"invalid");
        long pinned = invalid.lowest(snapshotId);
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            n = pinningTable.add(pinned);
        }
        return n;
    }

    public static final void releasePinningLocked(int handle2) {
        pinningTable.remove(handle2);
    }

    @NotNull
    public static final Snapshot currentSnapshot() {
        Snapshot snapshot2 = threadSnapshot.get();
        if (snapshot2 == null) {
            snapshot2 = globalSnapshot;
        }
        return snapshot2;
    }

    private static final Snapshot createTransparentSnapshotWithNoParentReadObserver(Snapshot previousSnapshot, Function1<Object, Unit> readObserver, boolean ownsPreviousSnapshot) {
        Snapshot snapshot2;
        return previousSnapshot instanceof MutableSnapshot || previousSnapshot == null ? (Snapshot)new TransparentObserverMutableSnapshot((snapshot2 = previousSnapshot) instanceof MutableSnapshot ? (MutableSnapshot)snapshot2 : null, readObserver, null, false, ownsPreviousSnapshot) : (Snapshot)new TransparentObserverSnapshot(previousSnapshot, readObserver, false, ownsPreviousSnapshot);
    }

    static /* synthetic */ Snapshot createTransparentSnapshotWithNoParentReadObserver$default(Snapshot snapshot2, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return SnapshotKt.createTransparentSnapshotWithNoParentReadObserver(snapshot2, (Function1<Object, Unit>)function1, bl);
    }

    private static final Function1<Object, Unit> mergedReadObserver(Function1<Object, Unit> readObserver, Function1<Object, Unit> parentObserver, boolean mergeReadObserver) {
        Function1 function1;
        Function1<Object, Unit> parentObserver2;
        Object object = parentObserver2 = mergeReadObserver ? parentObserver : null;
        if (readObserver != null && parentObserver2 != null && readObserver != parentObserver2) {
            function1 = arg_0 -> SnapshotKt.mergedReadObserver$lambda$2(readObserver, parentObserver2, arg_0);
        } else {
            function1 = readObserver;
            if (function1 == null) {
                function1 = parentObserver2;
            }
        }
        return function1;
    }

    static /* synthetic */ Function1 mergedReadObserver$default(Function1 function1, Function1 function12, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return SnapshotKt.mergedReadObserver((Function1<Object, Unit>)function1, (Function1<Object, Unit>)function12, bl);
    }

    private static final Function1<Object, Unit> mergedWriteObserver(Function1<Object, Unit> writeObserver, Function1<Object, Unit> parentObserver) {
        Function1 function1;
        if (writeObserver != null && parentObserver != null && writeObserver != parentObserver) {
            function1 = arg_0 -> SnapshotKt.mergedWriteObserver$lambda$3(writeObserver, parentObserver, arg_0);
        } else {
            function1 = writeObserver;
            if (function1 == null) {
                function1 = parentObserver;
            }
        }
        return function1;
    }

    @NotNull
    public static final SynchronizedObject getLock() {
        return lock;
    }

    @NotNull
    public static final List<Function2<Set<? extends Object>, Snapshot, Unit>> getApplyObservers() {
        return applyObservers;
    }

    public static final void setApplyObservers(@NotNull List<? extends Function2<? super Set<? extends Object>, ? super Snapshot, Unit>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        applyObservers = list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> T resetGlobalSnapshotLocked(GlobalSnapshot globalSnapshot, Function1<? super SnapshotIdSet, ? extends T> block) {
        void $this$plus$iv;
        long snapshotId = globalSnapshot.getSnapshotId();
        Object result2 = block.invoke((Object)openSnapshots.clear(snapshotId));
        long nextGlobalSnapshotId = nextSnapshotId;
        long l = nextSnapshotId;
        int other$iv = 1;
        boolean $i$f$plus = false;
        nextSnapshotId = $this$plus$iv + (long)other$iv;
        openSnapshots = openSnapshots.clear(snapshotId);
        globalSnapshot.setSnapshotId$runtime(nextGlobalSnapshotId);
        globalSnapshot.setInvalid$runtime(openSnapshots);
        globalSnapshot.setWriteCount$runtime(0);
        globalSnapshot.setModified$runtime(null);
        globalSnapshot.releasePinnedSnapshotLocked$runtime();
        openSnapshots = openSnapshots.set(nextGlobalSnapshotId);
        return (T)result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T advanceGlobalSnapshot(Function1<? super SnapshotIdSet, ? extends T> block) {
        T t2;
        GlobalSnapshot globalSnapshot = SnapshotKt.globalSnapshot;
        MutableScatterSet<StateObject> modified = null;
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            modified = globalSnapshot.getModified$runtime();
            if (modified != null) {
                pendingApplyObserverCount.add(1);
            }
            t2 = SnapshotKt.resetGlobalSnapshotLocked(globalSnapshot, block);
        }
        T result2 = t2;
        MutableScatterSet<StateObject> mutableScatterSet = modified;
        if (mutableScatterSet != null) {
            MutableScatterSet<StateObject> it = mutableScatterSet;
            boolean bl = false;
            try {
                List<? extends Function2<? super Set<? extends Object>, ? super Snapshot, Unit>> observers;
                List<? extends Function2<? super Set<? extends Object>, ? super Snapshot, Unit>> $this$fastForEach$iv = observers = applyObservers;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Function2<? super Set<? extends Object>, ? super Snapshot, Unit> item$iv;
                    Function2<? super Set<? extends Object>, ? super Snapshot, Unit> observer = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl2 = false;
                    observer.invoke(ScatterSetWrapperKt.wrapIntoSet((ScatterSet)it), (Object)globalSnapshot);
                }
            }
            finally {
                pendingApplyObserverCount.add(-1);
            }
        }
        $i$f$sync = false;
        lock$iv$iv = SnapshotKt.getLock();
        $i$f$synchronized = false;
        SynchronizedObject synchronizedObject2 = lock$iv$iv;
        synchronized (synchronizedObject2) {
            Unit unit;
            boolean bl = false;
            SnapshotKt.checkAndOverwriteUnusedRecordsLocked();
            MutableScatterSet<StateObject> mutableScatterSet2 = modified;
            if (mutableScatterSet2 != null) {
                ScatterSet this_$iv = (ScatterSet)mutableScatterSet2;
                boolean $i$f$forEach = false;
                Object[] elements$iv = this_$iv.elements;
                ScatterSet this_$iv$iv = this_$iv;
                boolean $i$f$forEachIndex = false;
                int i$iv$iv = 0;
                long[] m$iv$iv = this_$iv$iv.metadata;
                int lastIndex$iv$iv = m$iv$iv.length - 2;
                if (i$iv$iv <= lastIndex$iv$iv) {
                    while (true) {
                        long slot$iv$iv;
                        long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                        boolean $i$f$maskEmptyOrDeleted = false;
                        if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                            int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                            for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                                long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                                boolean $i$f$isFull = false;
                                if (value$iv$iv$iv < 128L) {
                                    int index$iv$iv;
                                    int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                    boolean bl3 = false;
                                    StateObject it = (StateObject)elements$iv[index$iv];
                                    boolean bl4 = false;
                                    SnapshotKt.processForUnusedRecordsLocked(it);
                                }
                                slot$iv$iv >>= 8;
                            }
                            if (bitCount$iv$iv != 8) break;
                        }
                        if (i$iv$iv == lastIndex$iv$iv) break;
                        ++i$iv$iv;
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        return result2;
    }

    private static final void advanceGlobalSnapshot() {
        SnapshotKt.advanceGlobalSnapshot(emptyLambda);
    }

    private static final <T extends Snapshot> T takeNewSnapshot(Function1<? super SnapshotIdSet, ? extends T> block) {
        return (T)((Snapshot)SnapshotKt.advanceGlobalSnapshot(arg_0 -> SnapshotKt.takeNewSnapshot$lambda$12(block, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateOpen(Snapshot snapshot2) {
        SnapshotIdSet openSnapshots = SnapshotKt.openSnapshots;
        if (!openSnapshots.get(snapshot2.getSnapshotId())) {
            Long l;
            MutableSnapshot mutableSnapshot = snapshot2 instanceof MutableSnapshot ? (MutableSnapshot)snapshot2 : null;
            Object object = mutableSnapshot != null ? Boolean.valueOf(mutableSnapshot.getApplied$runtime()) : "read-only";
            boolean bl = snapshot2.getDisposed$runtime();
            long l2 = snapshot2.getSnapshotId();
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl2 = false;
                l = pinningTable.lowestOrDefault(-1L);
            }
            Long l3 = l;
            String string = "Snapshot is not open: snapshotId=" + l2 + ", disposed=" + bl + ", applied=" + object + ", lowestPin=" + l3;
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean valid(long currentSnapshot, long candidateSnapshot, SnapshotIdSet invalid) {
        if (candidateSnapshot == INVALID_SNAPSHOT) return false;
        long $this$compareTo$iv = candidateSnapshot;
        boolean $i$f$compareTo = false;
        if (Intrinsics.compare((long)$this$compareTo$iv, (long)currentSnapshot) > 0) return false;
        if (invalid.get(candidateSnapshot)) return false;
        return true;
    }

    private static final boolean valid(StateRecord data2, long snapshot2, SnapshotIdSet invalid) {
        return SnapshotKt.valid(snapshot2, data2.getSnapshotId$runtime(), invalid);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends StateRecord> T readable(T r, long id, SnapshotIdSet invalid) {
        StateRecord candidate = null;
        for (Object current = r; current != null; current = ((StateRecord)current).getNext$runtime()) {
            Object object;
            if (!SnapshotKt.valid(current, id, invalid)) continue;
            if (candidate == null) {
                object = current;
            } else {
                void $this$compareTo$iv;
                long l = candidate.getSnapshotId$runtime();
                long other$iv = ((StateRecord)current).getSnapshotId$runtime();
                boolean $i$f$compareTo = false;
                object = Intrinsics.compare((long)$this$compareTo$iv, (long)other$iv) < 0 ? current : candidate;
            }
            candidate = object;
        }
        if (candidate != null) {
            return (T)candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final <T extends StateRecord> T readable(@NotNull T $this$readable, @NotNull StateObject state2) {
        Object object;
        Intrinsics.checkNotNullParameter($this$readable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Snapshot snapshot2 = Snapshot.Companion.getCurrent();
        Function1<Object, Unit> function1 = snapshot2.getReadObserver();
        if (function1 != null) {
            function1.invoke((Object)state2);
        }
        if ((object = SnapshotKt.readable($this$readable, snapshot2.getSnapshotId(), snapshot2.getInvalid$runtime())) == null) {
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                Snapshot syncSnapshot = Snapshot.Companion.getCurrent();
                StateRecord stateRecord = state2.getFirstStateRecord();
                Intrinsics.checkNotNull((Object)stateRecord, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.snapshots.SnapshotKt.readable");
                StateRecord stateRecord2 = SnapshotKt.readable(stateRecord, syncSnapshot.getSnapshotId(), syncSnapshot.getInvalid$runtime());
                if (stateRecord2 == null) {
                    SnapshotKt.readError();
                    throw new KotlinNothingValueException();
                }
                StateRecord stateRecord3 = stateRecord2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl26 : MonitorExitStatement: MONITOREXIT : var6_6
                object = stateRecord3;
            }
        }
        return object;
    }

    private static final Void readError() {
        throw new IllegalStateException("Reading a state that was created after the snapshot was taken or in a snapshot that has not yet been applied".toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final StateRecord usedLocked(StateObject state2) {
        void $this$minus$iv;
        StateRecord validRecord = null;
        long l = pinningTable.lowestOrDefault(nextSnapshotId);
        int other$iv = 1;
        boolean $i$f$minus2 = false;
        void reuseLimit = $this$minus$iv - (long)other$iv;
        SnapshotIdSet invalid = SnapshotIdSet.Companion.getEMPTY();
        for (StateRecord current = state2.getFirstStateRecord(); current != null; current = current.getNext$runtime()) {
            void $this$compareTo$iv;
            long currentId = current.getSnapshotId$runtime();
            if (currentId == INVALID_SNAPSHOT) {
                return current;
            }
            if (!SnapshotKt.valid(current, (long)reuseLimit, invalid)) continue;
            if (validRecord == null) {
                validRecord = current;
                continue;
            }
            long $i$f$minus2 = current.getSnapshotId$runtime();
            long other$iv2 = validRecord.getSnapshotId$runtime();
            boolean $i$f$compareTo = false;
            return Intrinsics.compare((long)$this$compareTo$iv, (long)other$iv2) < 0 ? current : validRecord;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean overwriteUnusedRecordsLocked(StateObject state2) {
        StateRecord overwriteRecord = null;
        StateRecord validRecord = null;
        long reuseLimit = pinningTable.lowestOrDefault(nextSnapshotId);
        int retainedRecords = 0;
        for (StateRecord current = state2.getFirstStateRecord(); current != null; current = current.getNext$runtime()) {
            long currentId = current.getSnapshotId$runtime();
            if (currentId == INVALID_SNAPSHOT) continue;
            long $this$compareTo$iv = currentId;
            boolean $i$f$compareTo = false;
            if (Intrinsics.compare((long)$this$compareTo$iv, (long)reuseLimit) < 0) {
                StateRecord recordToOverwrite;
                StateRecord stateRecord;
                void $this$compareTo$iv2;
                if (validRecord == null) {
                    validRecord = current;
                    ++retainedRecords;
                    continue;
                }
                long l = current.getSnapshotId$runtime();
                long other$iv = validRecord.getSnapshotId$runtime();
                boolean $i$f$compareTo2 = false;
                if (Intrinsics.compare((long)$this$compareTo$iv2, (long)other$iv) < 0) {
                    stateRecord = current;
                } else {
                    StateRecord result2 = validRecord;
                    validRecord = current;
                    stateRecord = recordToOverwrite = result2;
                }
                if (overwriteRecord == null) {
                    StateRecord stateRecord2;
                    block8: {
                        StateRecord $this$findYoungestOr$iv = state2.getFirstStateRecord();
                        boolean $i$f$findYoungestOr = false;
                        StateRecord youngest$iv = $this$findYoungestOr$iv;
                        for (StateRecord current$iv = $this$findYoungestOr$iv; current$iv != null; current$iv = current$iv.getNext$runtime()) {
                            void $this$compareTo$iv$iv;
                            StateRecord it = current$iv;
                            boolean bl = false;
                            long $this$compareTo$iv3 = it.getSnapshotId$runtime();
                            boolean $i$f$compareTo3 = false;
                            if (Intrinsics.compare((long)$this$compareTo$iv3, (long)reuseLimit) >= 0) {
                                stateRecord2 = current$iv;
                                break block8;
                            }
                            long l2 = youngest$iv.getSnapshotId$runtime();
                            long other$iv$iv = current$iv.getSnapshotId$runtime();
                            boolean $i$f$compareTo4 = false;
                            if (Intrinsics.compare((long)$this$compareTo$iv$iv, (long)other$iv$iv) >= 0) continue;
                            youngest$iv = current$iv;
                        }
                        stateRecord2 = youngest$iv;
                    }
                    overwriteRecord = stateRecord2;
                }
                recordToOverwrite.setSnapshotId$runtime(INVALID_SNAPSHOT);
                recordToOverwrite.assign(overwriteRecord);
                continue;
            }
            ++retainedRecords;
        }
        return retainedRecords > 1;
    }

    private static final void checkAndOverwriteUnusedRecordsLocked() {
        int i$iv;
        SnapshotWeakSet<StateObject> this_$iv = extraStateObjects;
        boolean $i$f$removeIf = false;
        int size$iv = this_$iv.getSize$runtime();
        int currentUsed$iv = 0;
        for (i$iv = 0; i$iv < size$iv; ++i$iv) {
            Object value$iv;
            WeakReference<StateObject> entry$iv;
            WeakReference<StateObject> weakReference = entry$iv = this_$iv.getValues$runtime()[i$iv];
            Object object = value$iv = weakReference != null ? weakReference.get() : null;
            if (value$iv == null) continue;
            StateObject it = (StateObject)value$iv;
            boolean bl = false;
            if (!SnapshotKt.overwriteUnusedRecordsLocked(it)) continue;
            if (currentUsed$iv != i$iv) {
                this_$iv.getValues$runtime()[currentUsed$iv] = entry$iv;
                this_$iv.getHashes$runtime()[currentUsed$iv] = this_$iv.getHashes$runtime()[i$iv];
            }
            ++currentUsed$iv;
        }
        for (i$iv = currentUsed$iv; i$iv < size$iv; ++i$iv) {
            this_$iv.getValues$runtime()[i$iv] = null;
            this_$iv.getHashes$runtime()[i$iv] = 0;
        }
        if (currentUsed$iv != size$iv) {
            this_$iv.setSize$runtime(currentUsed$iv);
        }
    }

    private static final void processForUnusedRecordsLocked(StateObject state2) {
        if (SnapshotKt.overwriteUnusedRecordsLocked(state2)) {
            extraStateObjects.add(state2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublishedApi
    @NotNull
    public static final <T extends StateRecord> T writableRecord(@NotNull T $this$writableRecord, @NotNull StateObject state2, @NotNull Snapshot snapshot2) {
        StateRecord stateRecord;
        Intrinsics.checkNotNullParameter($this$writableRecord, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
        if (snapshot2.getReadOnly()) {
            snapshot2.recordModified$runtime(state2);
        }
        long id = snapshot2.getSnapshotId();
        T t2 = SnapshotKt.readable($this$writableRecord, id, snapshot2.getInvalid$runtime());
        if (t2 == null) {
            SnapshotKt.readError();
            throw new KotlinNothingValueException();
        }
        T readData = t2;
        if (readData.getSnapshotId$runtime() == snapshot2.getSnapshotId()) {
            return readData;
        }
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            StateRecord stateRecord2 = SnapshotKt.readable(state2.getFirstStateRecord(), id, snapshot2.getInvalid$runtime());
            if (stateRecord2 == null) {
                SnapshotKt.readError();
                throw new KotlinNothingValueException();
            }
            StateRecord newReadData = stateRecord2;
            StateRecord stateRecord3 = newReadData.getSnapshotId$runtime() == id ? newReadData : SnapshotKt.newWritableRecordLocked(newReadData, state2, snapshot2);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl30 : MonitorExitStatement: MONITOREXIT : var10_8
            stateRecord = stateRecord3;
        }
        Intrinsics.checkNotNull((Object)stateRecord, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.snapshots.SnapshotKt.writableRecord");
        StateRecord newData = stateRecord;
        if (readData.getSnapshotId$runtime() != SnapshotId_jvmKt.toSnapshotId(1)) {
            snapshot2.recordModified$runtime(state2);
        }
        return (T)newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final <T extends StateRecord> T overwritableRecord(@NotNull T $this$overwritableRecord, @NotNull StateObject state2, @NotNull Snapshot snapshot2, @NotNull T candidate) {
        T t2;
        Intrinsics.checkNotNullParameter($this$overwritableRecord, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        if (snapshot2.getReadOnly()) {
            snapshot2.recordModified$runtime(state2);
        }
        long id = snapshot2.getSnapshotId();
        if (candidate.getSnapshotId$runtime() == id) {
            return candidate;
        }
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            t2 = SnapshotKt.newOverwritableRecordLocked($this$overwritableRecord, state2);
        }
        T newData = t2;
        newData.setSnapshotId$runtime(id);
        if (candidate.getSnapshotId$runtime() != SnapshotId_jvmKt.toSnapshotId(1)) {
            snapshot2.recordModified$runtime(state2);
        }
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final <T extends StateRecord> T newWritableRecord(@NotNull T $this$newWritableRecord, @NotNull StateObject state2, @NotNull Snapshot snapshot2) {
        T t2;
        Intrinsics.checkNotNullParameter($this$newWritableRecord, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            t2 = SnapshotKt.newWritableRecordLocked($this$newWritableRecord, state2, snapshot2);
        }
        return t2;
    }

    private static final <T extends StateRecord> T newWritableRecordLocked(T $this$newWritableRecordLocked, StateObject state2, Snapshot snapshot2) {
        T newData = SnapshotKt.newOverwritableRecordLocked($this$newWritableRecordLocked, state2);
        newData.assign($this$newWritableRecordLocked);
        newData.setSnapshotId$runtime(snapshot2.getSnapshotId());
        return newData;
    }

    @NotNull
    public static final <T extends StateRecord> T newOverwritableRecordLocked(@NotNull T $this$newOverwritableRecordLocked, @NotNull StateObject state2) {
        StateRecord stateRecord;
        Intrinsics.checkNotNullParameter($this$newOverwritableRecordLocked, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        StateRecord stateRecord2 = SnapshotKt.usedLocked(state2);
        if (stateRecord2 != null) {
            StateRecord stateRecord3;
            StateRecord $this$newOverwritableRecordLocked_u24lambda_u2421 = stateRecord3 = stateRecord2;
            boolean bl = false;
            $this$newOverwritableRecordLocked_u24lambda_u2421.setSnapshotId$runtime(Long.MAX_VALUE);
            stateRecord = stateRecord3;
        } else {
            StateRecord stateRecord4;
            StateRecord $this$newOverwritableRecordLocked_u24lambda_u2422 = stateRecord4 = $this$newOverwritableRecordLocked.create(Long.MAX_VALUE);
            boolean bl = false;
            $this$newOverwritableRecordLocked_u24lambda_u2422.setNext$runtime(state2.getFirstStateRecord());
            Intrinsics.checkNotNull((Object)$this$newOverwritableRecordLocked_u24lambda_u2422, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.snapshots.SnapshotKt.newOverwritableRecordLocked");
            state2.prependStateRecord($this$newOverwritableRecordLocked_u24lambda_u2422);
            StateRecord stateRecord5 = stateRecord4;
            stateRecord = stateRecord5;
            Intrinsics.checkNotNull((Object)stateRecord5, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.snapshots.SnapshotKt.newOverwritableRecordLocked");
        }
        return (T)stateRecord;
    }

    @PublishedApi
    public static final void notifyWrite(@NotNull Snapshot snapshot2, @NotNull StateObject state2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            snapshot2.setWriteCount$runtime(snapshot2.getWriteCount$runtime() + 1);
            Function1<Object, Unit> function1 = snapshot2.getWriteObserver$runtime();
            if (function1 == null) break block0;
            function1.invoke((Object)state2);
        }
    }

    private static final Map<StateRecord, StateRecord> optimisticMerges(long currentSnapshotId, MutableSnapshot applyingSnapshot, SnapshotIdSet invalidSnapshots) {
        MutableScatterSet<StateObject> modified = applyingSnapshot.getModified$runtime();
        if (modified == null) {
            return null;
        }
        SnapshotIdSet start2 = applyingSnapshot.getInvalid$runtime().set(applyingSnapshot.getSnapshotId()).or(applyingSnapshot.getPreviousIds$runtime());
        HashMap result2 = null;
        ScatterSet this_$iv = (ScatterSet)modified;
        boolean $i$f$forEach = false;
        Object[] elements$iv = this_$iv.elements;
        ScatterSet this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            StateRecord previous;
                            StateRecord current;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            StateObject state2 = (StateObject)elements$iv[index$iv];
                            boolean bl2 = false;
                            StateRecord first = state2.getFirstStateRecord();
                            if (SnapshotKt.readable(first, currentSnapshotId, invalidSnapshots) != null && SnapshotKt.readable(first, currentSnapshotId, start2) != null && !Intrinsics.areEqual((Object)current, (Object)previous)) {
                                StateRecord applied;
                                if (SnapshotKt.readable(first, applyingSnapshot.getSnapshotId(), applyingSnapshot.getInvalid$runtime()) == null) {
                                    SnapshotKt.readError();
                                    throw new KotlinNothingValueException();
                                }
                                StateRecord merged = state2.mergeRecords(previous, current, applied);
                                if (merged != null) {
                                    Map map2 = result2;
                                    if (map2 == null) {
                                        HashMap hashMap;
                                        HashMap it = hashMap = new HashMap();
                                        boolean bl3 = false;
                                        result2 = it;
                                        map2 = hashMap;
                                    }
                                    map2.put(current, merged);
                                } else {
                                    return null;
                                }
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        return result2;
    }

    private static final Void reportReadonlySnapshotWrite() {
        throw new IllegalStateException("Cannot modify a state object in a read-only snapshot".toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublishedApi
    @NotNull
    public static final <T extends StateRecord> T current(@NotNull T r, @NotNull Snapshot snapshot2) {
        Intrinsics.checkNotNullParameter(r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
        T t2 = SnapshotKt.readable(r, snapshot2.getSnapshotId(), snapshot2.getInvalid$runtime());
        if (t2 == null) {
            T t3;
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                T t4 = SnapshotKt.readable(r, snapshot2.getSnapshotId(), snapshot2.getInvalid$runtime());
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl14 : MonitorExitStatement: MONITOREXIT : var5_5
                t3 = t4;
            }
            t2 = t3;
            if (t3 == null) {
                SnapshotKt.readError();
                throw new KotlinNothingValueException();
            }
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublishedApi
    @NotNull
    public static final <T extends StateRecord> T current(@NotNull T r) {
        Intrinsics.checkNotNullParameter(r, (String)"r");
        Snapshot snapshot2 = Snapshot.Companion.getCurrent();
        boolean bl = false;
        T t2 = SnapshotKt.readable(r, snapshot2.getSnapshotId(), snapshot2.getInvalid$runtime());
        if (t2 == null) {
            T t3;
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl2 = false;
                Snapshot syncSnapshot = Snapshot.Companion.getCurrent();
                boolean bl3 = false;
                T t4 = SnapshotKt.readable(r, syncSnapshot.getSnapshotId(), syncSnapshot.getInvalid$runtime());
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var6_6
                t3 = t4;
            }
            t2 = t3;
            if (t3 == null) {
                SnapshotKt.readError();
                throw new KotlinNothingValueException();
            }
        }
        return t2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SnapshotIdSet addRange(@NotNull SnapshotIdSet $this$addRange, long from, long until) {
        Intrinsics.checkNotNullParameter((Object)$this$addRange, (String)"<this>");
        SnapshotIdSet result2 = $this$addRange;
        long invalidId = from;
        while (true) {
            void $this$plus$iv;
            long $this$compareTo$iv = invalidId;
            boolean $i$f$compareTo = false;
            if (Intrinsics.compare((long)$this$compareTo$iv, (long)until) >= 0) break;
            result2 = result2.set(invalidId);
            $this$compareTo$iv = invalidId;
            int other$iv = 1;
            boolean $i$f$plus = false;
            invalidId = $this$plus$iv + (long)other$iv;
        }
        return result2;
    }

    private static final Unit emptyLambda$lambda$1(SnapshotIdSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit mergedReadObserver$lambda$2(Function1 $readObserver, Function1 $parentObserver, Object state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        $readObserver.invoke(state2);
        $parentObserver.invoke(state2);
        return Unit.INSTANCE;
    }

    private static final Unit mergedWriteObserver$lambda$3(Function1 $writeObserver, Function1 $parentObserver, Object state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        $writeObserver.invoke(state2);
        $parentObserver.invoke(state2);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Snapshot takeNewSnapshot$lambda$12(Function1 $block, SnapshotIdSet invalid) {
        Intrinsics.checkNotNullParameter((Object)invalid, (String)"invalid");
        Snapshot result2 = (Snapshot)$block.invoke((Object)invalid);
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            openSnapshots = openSnapshots.set(result2.getSnapshotId());
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    public static final /* synthetic */ long access$getINVALID_SNAPSHOT$p() {
        return INVALID_SNAPSHOT;
    }

    public static final /* synthetic */ SnapshotThreadLocal access$getThreadSnapshot$p() {
        return threadSnapshot;
    }

    public static final /* synthetic */ void access$setOpenSnapshots$p(SnapshotIdSet snapshotIdSet) {
        openSnapshots = snapshotIdSet;
    }

    public static final /* synthetic */ SnapshotIdSet access$getOpenSnapshots$p() {
        return openSnapshots;
    }

    public static final /* synthetic */ Function1 access$mergedWriteObserver(Function1 writeObserver, Function1 parentObserver) {
        return SnapshotKt.mergedWriteObserver((Function1<Object, Unit>)writeObserver, (Function1<Object, Unit>)parentObserver);
    }

    public static final /* synthetic */ Object access$advanceGlobalSnapshot(Function1 block) {
        return SnapshotKt.advanceGlobalSnapshot(block);
    }

    public static final /* synthetic */ Function1 access$getEmptyLambda$p() {
        return emptyLambda;
    }

    public static final /* synthetic */ void access$advanceGlobalSnapshot() {
        SnapshotKt.advanceGlobalSnapshot();
    }

    public static final /* synthetic */ snapshotDataSource.1 access$getSnapshotDataSource$p() {
        return snapshotDataSource;
    }

    public static final /* synthetic */ void access$setGlobalWriteObservers$p(List list2) {
        globalWriteObservers = list2;
    }

    public static final /* synthetic */ List access$getGlobalWriteObservers$p() {
        return globalWriteObservers;
    }

    public static final /* synthetic */ GlobalSnapshot access$getGlobalSnapshot$p() {
        return globalSnapshot;
    }

    public static final /* synthetic */ Map access$optimisticMerges(long currentSnapshotId, MutableSnapshot applyingSnapshot, SnapshotIdSet invalidSnapshots) {
        return SnapshotKt.optimisticMerges(currentSnapshotId, applyingSnapshot, invalidSnapshots);
    }

    public static final /* synthetic */ long access$getNextSnapshotId$p() {
        return nextSnapshotId;
    }

    public static final /* synthetic */ void access$setNextSnapshotId$p(long l) {
        nextSnapshotId = l;
    }

    public static final /* synthetic */ void access$validateOpen(Snapshot snapshot2) {
        SnapshotKt.validateOpen(snapshot2);
    }

    public static final /* synthetic */ Object access$resetGlobalSnapshotLocked(GlobalSnapshot globalSnapshot, Function1 block) {
        return SnapshotKt.resetGlobalSnapshotLocked(globalSnapshot, block);
    }

    public static final /* synthetic */ void access$processForUnusedRecordsLocked(StateObject state2) {
        SnapshotKt.processForUnusedRecordsLocked(state2);
    }

    public static final /* synthetic */ void access$checkAndOverwriteUnusedRecordsLocked() {
        SnapshotKt.checkAndOverwriteUnusedRecordsLocked();
    }

    public static final /* synthetic */ StateRecord access$readable(StateRecord r, long id, SnapshotIdSet invalid) {
        return SnapshotKt.readable(r, id, invalid);
    }

    public static final /* synthetic */ Void access$readError() {
        return SnapshotKt.readError();
    }

    public static final /* synthetic */ Void access$reportReadonlySnapshotWrite() {
        return SnapshotKt.reportReadonlySnapshotWrite();
    }

    public static final /* synthetic */ Snapshot access$takeNewSnapshot(Function1 block) {
        return SnapshotKt.takeNewSnapshot(block);
    }

    public static final /* synthetic */ Function1 access$mergedReadObserver(Function1 readObserver, Function1 parentObserver, boolean mergeReadObserver) {
        return SnapshotKt.mergedReadObserver((Function1<Object, Unit>)readObserver, (Function1<Object, Unit>)parentObserver, mergeReadObserver);
    }

    public static final /* synthetic */ Snapshot access$createTransparentSnapshotWithNoParentReadObserver(Snapshot previousSnapshot, Function1 readObserver, boolean ownsPreviousSnapshot) {
        return SnapshotKt.createTransparentSnapshotWithNoParentReadObserver(previousSnapshot, (Function1<Object, Unit>)readObserver, ownsPreviousSnapshot);
    }

    /*
     * WARNING - void declaration
     */
    static {
        GlobalSnapshot globalSnapshot;
        void $this$plus$iv;
        long l;
        void $this$plus$iv2;
        snapshotDataSource = new DataSource<Snapshot, Snapshot>(){

            /*
             * Enabled aggressive block sorting
             */
            public Snapshot startObservation(Function1<Object, Boolean> recordDependency) {
                Snapshot snapshot2;
                Snapshot snapshot3;
                Intrinsics.checkNotNullParameter(recordDependency, (String)"recordDependency");
                Snapshot previous = (Snapshot)SnapshotKt.access$getThreadSnapshot$p().get();
                Function1 readObserver = arg_0 -> snapshotDataSource.1.startObservation$lambda$0(recordDependency, arg_0);
                if (previous instanceof TransparentObserverMutableSnapshot) {
                    Snapshot.Companion companion = Snapshot.Companion;
                    TransparentObserverMutableSnapshot $this$canBeReused$iv = (TransparentObserverMutableSnapshot)previous;
                    boolean $i$f$getCanBeReused$runtime = false;
                    if ($this$canBeReused$iv.getThreadId$runtime() == Thread_jvmKt.currentThreadId()) {
                        ((TransparentObserverMutableSnapshot)previous).getReadObserverStack$runtime().add((Object)SnapshotKt.mergedReadObserver$default(readObserver, ((TransparentObserverMutableSnapshot)previous).getReadObserver$runtime(), false, 4, null));
                        snapshot3 = previous;
                        return snapshot3;
                    }
                }
                Snapshot snapshot4 = previous == null || previous instanceof MutableSnapshot ? (Snapshot)new TransparentObserverMutableSnapshot((snapshot2 = previous) instanceof MutableSnapshot ? (MutableSnapshot)snapshot2 : null, (Function1<Object, Unit>)readObserver, null, true, false) : previous.takeNestedSnapshot((Function1<Object, Unit>)readObserver);
                snapshot3 = snapshot4.makeCurrent();
                return snapshot3;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void endObservation(Snapshot previousObservation) {
                if (previousObservation instanceof TransparentObserverMutableSnapshot && Intrinsics.areEqual((Object)Snapshot.Companion.getCurrent(), (Object)previousObservation)) {
                    Snapshot.Companion companion = Snapshot.Companion;
                    TransparentObserverMutableSnapshot $this$canBeReused$iv = (TransparentObserverMutableSnapshot)previousObservation;
                    boolean $i$f$getCanBeReused$runtime = false;
                    if ($this$canBeReused$iv.getThreadId$runtime() == Thread_jvmKt.currentThreadId()) {
                        boolean value$iv = ((TransparentObserverMutableSnapshot)previousObservation).getReadObserverStack$runtime().isNotEmpty();
                        boolean $i$f$checkPrecondition = false;
                        if (!value$iv) {
                            boolean bl = false;
                            PreconditionsKt.throwIllegalStateException("Expected at least one read observer left in TransparentObserverMutableSnapshot when reaching endObservation but found none");
                        }
                        ExtensionsKt.removeLast(((TransparentObserverMutableSnapshot)previousObservation).getReadObserverStack$runtime());
                        return;
                    }
                }
                Snapshot observation = Snapshot.Companion.getCurrent();
                observation.restoreCurrent(previousObservation);
                observation.dispose();
            }

            public Snapshot pauseCurrentObservation() {
                Snapshot previousSnapshot = Snapshot.Companion.getCurrentThreadSnapshot();
                Snapshot.Companion.makeCurrentNonObservable(previousSnapshot);
                return previousSnapshot;
            }

            public void resumeCurrentObservation(Snapshot pausedObservation) {
                Snapshot currentSnapshot = Snapshot.Companion.getCurrentThreadSnapshot();
                boolean value$iv = currentSnapshot != null;
                boolean $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl = false;
                    PreconditionsKt.throwIllegalStateException("The snapshot that was set up while pausing observation may not be exited before it is restored");
                }
                Snapshot.Companion.restoreNonObservable(pausedObservation, currentSnapshot);
            }

            public Snapshot startIsolation(Function1<Object, Unit> recordChange) {
                MutableSnapshot mutableSnapshot = Snapshot.Companion.takeMutableSnapshot$default(Snapshot.Companion, null, recordChange, 1, null);
                Snapshot previousSnapshot = mutableSnapshot.makeCurrent();
                return previousSnapshot;
            }

            public void endIsolation(Throwable throwable, Snapshot previousIsolation) {
                Snapshot isolation = Snapshot.Companion.getCurrent();
                isolation.restoreCurrent(previousIsolation);
                if (throwable == null && isolation instanceof MutableSnapshot) {
                    ((MutableSnapshot)isolation).apply().check();
                }
                isolation.dispose();
            }

            private static final Unit startObservation$lambda$0(Function1 $recordDependency, Object identifier) {
                Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                $recordDependency.invoke(identifier);
                return Unit.INSTANCE;
            }
        };
        emptyLambda = SnapshotKt::emptyLambda$lambda$1;
        threadSnapshot = new SnapshotThreadLocal();
        Object ref$iv22 = null;
        boolean $i$f$makeSynchronizedObject = false;
        lock = new SynchronizedObject();
        openSnapshots = SnapshotIdSet.Companion.getEMPTY();
        long ref$iv22 = SnapshotId_jvmKt.toSnapshotId(1);
        int other$iv = 1;
        boolean $i$f$plus = false;
        nextSnapshotId = $this$plus$iv2 + (long)other$iv;
        pinningTable = new SnapshotDoubleIndexHeap();
        extraStateObjects = new SnapshotWeakSet();
        applyObservers = CollectionsKt.emptyList();
        globalWriteObservers = CollectionsKt.emptyList();
        long it = l = nextSnapshotId;
        boolean bl = false;
        long l2 = nextSnapshotId;
        int other$iv2 = 1;
        boolean $i$f$plus2 = false;
        nextSnapshotId = $this$plus$iv + (long)other$iv2;
        SnapshotIdSet snapshotIdSet = SnapshotIdSet.Companion.getEMPTY();
        long l3 = l;
        GlobalSnapshot it2 = globalSnapshot = new GlobalSnapshot(l3, snapshotIdSet);
        boolean bl2 = false;
        openSnapshots = openSnapshots.set(it2.getSnapshotId());
        SnapshotKt.globalSnapshot = globalSnapshot;
        snapshotInitializer = SnapshotKt.globalSnapshot;
        pendingApplyObserverCount = new AtomicInt(0);
    }
}

