/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.DataSource;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.collection.ExtensionsKt;
import androidx.compose.runtime.internal.Thread_jvmKt;
import androidx.compose.runtime.snapshots.MutableSnapshot;
import androidx.compose.runtime.snapshots.ObserverHandle;
import androidx.compose.runtime.snapshots.SnapshotIdSet;
import androidx.compose.runtime.snapshots.SnapshotKt;
import androidx.compose.runtime.snapshots.StateObject;
import androidx.compose.runtime.snapshots.TransparentObserverMutableSnapshot;
import androidx.compose.runtime.snapshots.TransparentObserverSnapshot;
import java.util.Collection;
import java.util.Set;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot\n+ 2 SnapshotId.jvm.kt\nandroidx/compose/runtime/snapshots/SnapshotId_jvmKt\n+ 3 Snapshot.kt\nandroidx/compose/runtime/snapshots/SnapshotKt\n+ 4 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n+ 5 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2623:1\n46#2:2624\n2031#3:2625\n2031#3:2631\n26#4:2626\n26#4:2632\n49#5,4:2627\n34#5,4:2633\n1#6:2637\n*S KotlinDebug\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot\n*L\n87#1:2624\n119#1:2625\n251#1:2631\n119#1:2626\n251#1:2632\n196#1:2627,4\n280#1:2633,4\n*E\n"})
public abstract class Snapshot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SnapshotIdSet invalid;
    private long snapshotId;
    private boolean disposed;
    private int pinningTrackingHandle;
    public static final int $stable = 8;

    private Snapshot(long snapshotId, SnapshotIdSet invalid) {
        this.invalid = invalid;
        this.snapshotId = snapshotId;
        this.pinningTrackingHandle = snapshotId != SnapshotKt.access$getINVALID_SNAPSHOT$p() ? SnapshotKt.trackPinning(snapshotId, this.getInvalid$runtime()) : -1;
    }

    @NotNull
    public SnapshotIdSet getInvalid$runtime() {
        return this.invalid;
    }

    public void setInvalid$runtime(@NotNull SnapshotIdSet snapshotIdSet) {
        Intrinsics.checkNotNullParameter((Object)snapshotIdSet, (String)"<set-?>");
        this.invalid = snapshotIdSet;
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId$runtime(long l) {
        this.snapshotId = l;
    }

    public int getWriteCount$runtime() {
        return 0;
    }

    public void setWriteCount$runtime(int value2) {
        throw new IllegalStateException("Updating write count is not supported for this snapshot".toString());
    }

    public abstract boolean getReadOnly();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disposed = true;
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            this.releasePinnedSnapshotLocked$runtime();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public abstract Snapshot takeNestedSnapshot(@Nullable Function1<Object, Unit> var1);

    @PublishedApi
    @Nullable
    public Snapshot makeCurrent() {
        Snapshot previous = (Snapshot)SnapshotKt.access$getThreadSnapshot$p().get();
        SnapshotKt.access$getThreadSnapshot$p().set(this);
        return previous;
    }

    @PublishedApi
    public void restoreCurrent(@Nullable Snapshot snapshot2) {
        SnapshotKt.access$getThreadSnapshot$p().set(snapshot2);
    }

    public final boolean getDisposed$runtime() {
        return this.disposed;
    }

    public final void setDisposed$runtime(boolean bl) {
        this.disposed = bl;
    }

    @Nullable
    public abstract Function1<Object, Unit> getReadObserver();

    @Nullable
    public abstract Function1<Object, Unit> getWriteObserver$runtime();

    public abstract void nestedActivated$runtime(@NotNull Snapshot var1);

    public abstract void nestedDeactivated$runtime(@NotNull Snapshot var1);

    public abstract void recordModified$runtime(@NotNull StateObject var1);

    public abstract void notifyObjectsInitialized$runtime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeAndReleasePinning$runtime() {
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            this.closeLocked$runtime();
            this.releasePinnedSnapshotsForCloseLocked$runtime();
            Unit unit = Unit.INSTANCE;
        }
    }

    public void closeLocked$runtime() {
        SnapshotKt.access$setOpenSnapshots$p(SnapshotKt.access$getOpenSnapshots$p().clear(this.getSnapshotId()));
    }

    public void releasePinnedSnapshotsForCloseLocked$runtime() {
        this.releasePinnedSnapshotLocked$runtime();
    }

    public final void validateNotDisposed$runtime() {
        boolean value$iv = !this.disposed;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Cannot use a disposed snapshot");
        }
    }

    public final void releasePinnedSnapshotLocked$runtime() {
        if (this.pinningTrackingHandle >= 0) {
            SnapshotKt.releasePinningLocked(this.pinningTrackingHandle);
            this.pinningTrackingHandle = -1;
        }
    }

    public final int takeoverPinnedSnapshot$runtime() {
        int n;
        int it = n = this.pinningTrackingHandle;
        boolean bl = false;
        this.pinningTrackingHandle = -1;
        return n;
    }

    public /* synthetic */ Snapshot(long snapshotId, SnapshotIdSet invalid, DefaultConstructorMarker $constructor_marker) {
        this(snapshotId, invalid);
    }

    public static final /* synthetic */ int access$getPinningTrackingHandle$p(Snapshot $this) {
        return $this.pinningTrackingHandle;
    }

    @SourceDebugExtension(value={"SMAP\nSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot$Companion\n+ 2 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot\n+ 3 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 4 DataSource.kt\nandroidx/compose/runtime/DataSource$Companion\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ObjectList.kt\nandroidx/collection/MutableObjectList\n+ 7 ObjectList.kt\nandroidx/collection/ObjectList\n+ 8 Snapshot.kt\nandroidx/compose/runtime/snapshots/SnapshotKt\n+ 9 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n*L\n1#1,2623:1\n553#1:2629\n553#1:2635\n556#1:2636\n155#2,5:2624\n155#2,5:2630\n49#3,4:2637\n208#4,4:2641\n212#4:2651\n213#4,2:2656\n215#4,4:2659\n220#4:2667\n219#4,4:2668\n223#4:2673\n1#5:2645\n903#6,5:2646\n287#7,4:2652\n292#7:2658\n329#7,4:2663\n334#7:2672\n2031#8:2674\n2031#8:2676\n2031#8:2678\n2031#8:2680\n2031#8:2682\n26#9:2675\n26#9:2677\n26#9:2679\n26#9:2681\n26#9:2683\n*S KotlinDebug\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot$Companion\n*L\n499#1:2629\n561#1:2635\n565#1:2636\n462#1:2624,5\n534#1:2630,5\n594#1:2637,4\n630#1:2641,4\n630#1:2651\n630#1:2656,2\n630#1:2659,4\n630#1:2667\n630#1:2668,4\n630#1:2673\n630#1:2645\n630#1:2646,5\n630#1:2652,4\n630#1:2658\n630#1:2663,4\n630#1:2672\n643#1:2674\n664#1:2676\n698#1:2678\n644#1:2680\n667#1:2682\n643#1:2675\n664#1:2677\n698#1:2679\n644#1:2681\n667#1:2683\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Snapshot getCurrent() {
            return SnapshotKt.currentSnapshot();
        }

        @NotNull
        public final Snapshot takeSnapshot(@Nullable Function1<Object, Unit> readObserver) {
            return SnapshotKt.currentSnapshot().takeNestedSnapshot(readObserver);
        }

        @NotNull
        public final MutableSnapshot takeMutableSnapshot(@Nullable Function1<Object, Unit> readObserver, @Nullable Function1<Object, Unit> writeObserver) {
            Snapshot snapshot2 = SnapshotKt.currentSnapshot();
            MutableSnapshot mutableSnapshot = snapshot2 instanceof MutableSnapshot ? (MutableSnapshot)snapshot2 : null;
            if (mutableSnapshot == null || (mutableSnapshot = mutableSnapshot.takeNestedMutableSnapshot(readObserver, writeObserver)) == null) {
                throw new IllegalStateException("Cannot create a mutable snapshot of a read-only snapshot".toString());
            }
            return mutableSnapshot;
        }

        public static /* synthetic */ MutableSnapshot takeMutableSnapshot$default(Companion companion, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = null;
            }
            if ((n & 2) != 0) {
                function12 = null;
            }
            return companion.takeMutableSnapshot((Function1<Object, Unit>)function1, (Function1<Object, Unit>)function12);
        }

        @Nullable
        public final Snapshot getCurrentThreadSnapshot() {
            return (Snapshot)SnapshotKt.access$getThreadSnapshot$p().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        @PublishedApi
        @NotNull
        public final Snapshot makeCurrentNonObservable(@Nullable Snapshot previous) {
            Object object;
            boolean $i$f$getCanBeReused$runtime;
            Snapshot $this$canBeReused$iv;
            Companion companion;
            if (previous instanceof TransparentObserverMutableSnapshot) {
                companion = this;
                $this$canBeReused$iv = (TransparentObserverMutableSnapshot)previous;
                $i$f$getCanBeReused$runtime = false;
                if (((TransparentObserverMutableSnapshot)$this$canBeReused$iv).getThreadId$runtime() == Thread_jvmKt.currentThreadId()) {
                    ((TransparentObserverMutableSnapshot)previous).getReadObserverStack$runtime().add(null);
                    object = previous;
                    return object;
                }
            }
            if (previous instanceof TransparentObserverSnapshot) {
                Companion this_$iv = this;
                $this$canBeReused$iv = (TransparentObserverSnapshot)previous;
                $i$f$getCanBeReused$runtime = false;
                if (((TransparentObserverSnapshot)$this$canBeReused$iv).getThreadId$runtime() == Thread_jvmKt.currentThreadId()) {
                    ((TransparentObserverSnapshot)previous).getReadObserverStack$runtime().add(null);
                    object = previous;
                    return object;
                }
            }
            Snapshot snapshot2 = SnapshotKt.createTransparentSnapshotWithNoParentReadObserver$default(previous, null, false, 6, null);
            snapshot2.makeCurrent();
            object = companion;
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @PublishedApi
        public final void restoreNonObservable(@Nullable Snapshot previous, @NotNull Snapshot nonObservable) {
            Function1<Object, Unit> function1;
            Intrinsics.checkNotNullParameter((Object)nonObservable, (String)"nonObservable");
            boolean value$iv = nonObservable instanceof TransparentObserverSnapshot || nonObservable instanceof TransparentObserverMutableSnapshot;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                PreconditionsKt.throwIllegalStateException("Cannot restore observation on a non-transparent snapshot; " + nonObservable + " is not the snapshot that was set up while pausing observation.");
            }
            if (previous == nonObservable) {
                Snapshot snapshot2 = previous;
                if (snapshot2 instanceof TransparentObserverMutableSnapshot) {
                    function1 = ExtensionsKt.removeLast(((TransparentObserverMutableSnapshot)previous).getReadObserverStack$runtime());
                    return;
                } else {
                    if (!(snapshot2 instanceof TransparentObserverSnapshot)) throw new IllegalStateException(("Non-transparent snapshot was reused: " + previous).toString());
                    function1 = ExtensionsKt.removeLast(((TransparentObserverSnapshot)previous).getReadObserverStack$runtime());
                }
                return;
            } else {
                nonObservable.restoreCurrent(previous);
                nonObservable.dispose();
                function1 = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ObserverHandle registerApplyObserver(@NotNull Function2<? super Set<? extends Object>, ? super Snapshot, Unit> observer) {
            Intrinsics.checkNotNullParameter(observer, (String)"observer");
            SnapshotKt.access$advanceGlobalSnapshot(SnapshotKt.access$getEmptyLambda$p());
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                SnapshotKt.setApplyObservers(CollectionsKt.plus((Collection)SnapshotKt.getApplyObservers(), observer));
                Unit unit = Unit.INSTANCE;
            }
            return () -> Companion.registerApplyObserver$lambda$4(observer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ObserverHandle registerGlobalWriteObserver(@NotNull Function1<Object, Unit> observer) {
            Intrinsics.checkNotNullParameter(observer, (String)"observer");
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                SnapshotKt.access$setGlobalWriteObservers$p(CollectionsKt.plus((Collection)SnapshotKt.access$getGlobalWriteObservers$p(), observer));
                Unit unit = Unit.INSTANCE;
            }
            SnapshotKt.access$advanceGlobalSnapshot();
            return () -> Companion.registerGlobalWriteObserver$lambda$7(observer);
        }

        public final void notifyObjectsInitialized() {
            SnapshotKt.currentSnapshot().notifyObjectsInitialized$runtime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void sendApplyNotifications() {
            boolean bl;
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl2 = false;
                bl = SnapshotKt.access$getGlobalSnapshot$p().hasPendingChanges();
            }
            boolean changes = bl;
            if (changes) {
                SnapshotKt.access$advanceGlobalSnapshot();
            }
        }

        @NotNull
        public final DataSource<?, ?> getDataSource$runtime() {
            return SnapshotKt.access$getSnapshotDataSource$p();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void registerApplyObserver$lambda$4(Function2 $observer) {
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                SnapshotKt.setApplyObservers(CollectionsKt.minus((Iterable)SnapshotKt.getApplyObservers(), (Object)$observer));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void registerGlobalWriteObserver$lambda$7(Function1 $observer) {
            boolean $i$f$sync = false;
            SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
            boolean $i$f$synchronized = false;
            SynchronizedObject synchronizedObject = lock$iv$iv;
            synchronized (synchronizedObject) {
                boolean bl = false;
                SnapshotKt.access$setGlobalWriteObservers$p(CollectionsKt.minus((Iterable)SnapshotKt.access$getGlobalWriteObservers$p(), (Object)$observer));
                Unit unit = Unit.INSTANCE;
            }
            SnapshotKt.access$advanceGlobalSnapshot();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

