/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable;

import androidx.compose.runtime.external.kotlinx.collections.immutable.ImmutableCollection;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.ListImplementation;
import java.util.List;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

public interface ImmutableList<E>
extends ImmutableCollection<E>,
List<E>,
KMappedMarker {
    @Override
    @NotNull
    default public ImmutableList<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    private static final class SubList<E>
    extends AbstractList<E>
    implements ImmutableList<E> {
        @NotNull
        private final ImmutableList<E> source;
        private final int fromIndex;
        private final int toIndex;
        private int _size;

        public SubList(@NotNull ImmutableList<? extends E> source, int fromIndex, int toIndex) {
            Intrinsics.checkNotNullParameter(source, (String)"source");
            this.source = source;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            ListImplementation.checkRangeIndexes$runtime(this.fromIndex, this.toIndex, this.source.size());
            this._size = this.toIndex - this.fromIndex;
        }

        @Override
        public E get(int index) {
            ListImplementation.checkElementIndex$runtime(index, this._size);
            return (E)this.source.get(this.fromIndex + index);
        }

        public int getSize() {
            return this._size;
        }

        @Override
        @NotNull
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            ListImplementation.checkRangeIndexes$runtime(fromIndex, toIndex, this._size);
            return new SubList<E>(this.source, this.fromIndex + fromIndex, this.fromIndex + toIndex);
        }
    }
}

