/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.collection.MutableVectorKt;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.KotlinNothingValueException;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 2 ArrayUtils.nonAndroid.kt\nandroidx/compose/runtime/collection/ArrayUtils_nonAndroidKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1110:1\n289#1,4:1111\n289#1,4:1115\n289#1,4:1120\n289#1,4:1125\n289#1,4:1131\n289#1,4:1136\n44#1:1145\n472#1:1146\n48#1:1149\n472#1:1150\n44#1:1151\n472#1:1152\n516#1:1154\n332#1:1155\n472#1:1156\n516#1:1157\n472#1:1158\n516#1:1159\n44#1:1160\n472#1:1161\n516#1:1162\n44#1:1163\n472#1:1164\n472#1:1165\n472#1:1166\n44#1:1167\n472#1:1168\n44#1:1171\n44#1:1174\n44#1:1175\n472#1:1176\n23#2:1119\n23#2:1124\n23#2:1129\n23#2:1130\n23#2:1135\n23#2:1140\n23#2:1153\n23#2:1172\n23#2:1173\n1872#3,3:1141\n1863#3,2:1147\n1863#3,2:1169\n1#4:1144\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n55#1:1111,4\n66#1:1115,4\n87#1:1120,4\n111#1:1125,4\n156#1:1131,4\n169#1:1136,4\n234#1:1145\n235#1:1146\n265#1:1149\n266#1:1150\n279#1:1151\n280#1:1152\n309#1:1154\n310#1:1155\n312#1:1156\n340#1:1157\n340#1:1158\n526#1:1159\n529#1:1160\n529#1:1161\n563#1:1162\n563#1:1163\n563#1:1164\n588#1:1165\n598#1:1166\n678#1:1167\n679#1:1168\n700#1:1171\n725#1:1174\n759#1:1175\n760#1:1176\n69#1:1119\n90#1:1124\n114#1:1129\n121#1:1130\n157#1:1135\n172#1:1140\n300#1:1153\n701#1:1172\n717#1:1173\n179#1:1141,3\n256#1:1147,2\n692#1:1169,2\n*E\n"})
public final class MutableVector<T>
implements RandomAccess {
    @JvmField
    @NotNull
    public T[] content;
    @Nullable
    private List<T> list;
    private int size;
    public static final int $stable = 8;

    @PublishedApi
    public MutableVector(@NotNull T[] content2, int size) {
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        this.content = content2;
        this.size = size;
    }

    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(T element) {
        void this_$iv;
        MutableVector mutableVector = this;
        int capacity$iv = this.size + 1;
        boolean $i$f$ensureCapacity = false;
        if (this_$iv.content.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv);
        }
        this.content[this.size] = element;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int index, T element) {
        void this_$iv;
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + 1;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content2 = this.content;
        if (index != this.size) {
            void endIndex$iv;
            void destinationOffset$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content2;
            $i$f$ensureCapacity = index + 1;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content2, (int)destinationOffset$iv, (int)index, (int)endIndex$iv);
        }
        content2[index] = element;
        int n = this.size;
        this.size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, @NotNull List<? extends T> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int elementsSize = elements.size();
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + elementsSize;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content2 = this.content;
        if (index != this.size) {
            void endIndex$iv;
            void destinationOffset$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content2;
            $i$f$ensureCapacity = index + elementsSize;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content2, (int)destinationOffset$iv, (int)index, (int)endIndex$iv);
        }
        int n = ((Collection)elements).size();
        for (int i2 = 0; i2 < n; ++i2) {
            content2[index + i2] = elements.get(i2);
        }
        this.size += elementsSize;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, @NotNull MutableVector<T> elements) {
        void startIndex$iv;
        int destinationOffset$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int elementsSize = elements.size;
        if (elementsSize == 0) {
            return false;
        }
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + elementsSize;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content2 = this.content;
        if (index != this.size) {
            void endIndex$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content2;
            $i$f$ensureCapacity = index + elementsSize;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content2, (int)destinationOffset$iv, (int)index, (int)endIndex$iv);
        }
        Object[] $this$fastCopyInto$iv = elements.content;
        destinationOffset$iv = 0;
        boolean $i$f$fastCopyInto = false;
        ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content2, (int)index, (int)startIndex$iv, (int)elementsSize);
        this.size += elementsSize;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int elementsSize = elements.size();
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + elementsSize;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content2 = this.content;
        if (index != this.size) {
            void endIndex$iv;
            void destinationOffset$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content2;
            $i$f$ensureCapacity = index + elementsSize;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content2, (int)destinationOffset$iv, (int)index, (int)endIndex$iv);
        }
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t2 = item$iv;
            int i2 = n;
            boolean bl = false;
            content2[index + i2] = item2;
        }
        this.size += elementsSize;
        return true;
    }

    public final boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.addAll(this.size, elements);
    }

    @NotNull
    public final List<T> asMutableList() {
        List list2 = this.list;
        if (list2 == null) {
            MutableVectorList mutableVectorList;
            MutableVectorList it = mutableVectorList = new MutableVectorList(this);
            boolean bl = false;
            this.list = it;
            list2 = mutableVectorList;
        }
        return list2;
    }

    public final void clear() {
        T[] content2 = this.content;
        int n = this.size;
        for (int i2 = 0; i2 < n; ++i2) {
            content2[i2] = null;
        }
        this.size = 0;
    }

    public final boolean contains(T element) {
        int i2 = 0;
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv.getSize() - 1;
        if (i2 <= n) {
            while (true) {
                this_$iv = this;
                boolean $i$f$get = false;
                if (Intrinsics.areEqual(this_$iv.content[i2], element)) {
                    return true;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return false;
    }

    public final boolean containsAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if (this.contains(it)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final void resizeStorage(int capacity) {
        void destinationOffset$iv;
        void $this$fastCopyInto$iv;
        T[] oldContent = this.content;
        int oldSize = oldContent.length;
        int newSize = Math.max(capacity, oldSize * 2);
        Object[] newContent = new Object[newSize];
        T[] TArray = oldContent;
        boolean bl = false;
        int startIndex$iv = 0;
        boolean $i$f$fastCopyInto = false;
        ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newContent, (int)destinationOffset$iv, (int)startIndex$iv, (int)oldSize);
        this.content = newContent;
    }

    public final T first() {
        MutableVector this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv.getSize() == 0) {
            this_$iv = this;
            boolean $i$f$throwNoSuchElementException = false;
            this_$iv.throwNoSuchElementException("MutableVector is empty.");
            throw new KotlinNothingValueException();
        }
        this_$iv = this;
        int index$iv = 0;
        boolean $i$f$get = false;
        return this_$iv.content[index$iv];
    }

    @PublishedApi
    @NotNull
    public final Void throwNoSuchElementException(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        throw new NoSuchElementException(message2);
    }

    public final int indexOf(T element) {
        T[] content2 = this.content;
        int size = this.size;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!Intrinsics.areEqual(element, content2[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final T last() {
        MutableVector this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv.getSize() == 0) {
            this.throwNoSuchElementException("MutableVector is empty.");
            throw new KotlinNothingValueException();
        }
        this_$iv = this;
        MutableVector this_$iv2 = this;
        boolean $i$f$getLastIndex = false;
        int index$iv = this_$iv2.getSize() - 1;
        boolean $i$f$get = false;
        return this_$iv.content[index$iv];
    }

    public final int lastIndexOf(T element) {
        T[] content2 = this.content;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (!Intrinsics.areEqual(element, content2[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final boolean remove(T element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int initialSize = this.size;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.remove(it);
        }
        return initialSize != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final T removeAt(int index) {
        Object[] content2 = this.content;
        T item2 = content2[index];
        Object[] this_$iv = this;
        int $i$f$getLastIndex = 0;
        if (index != this_$iv.getSize() - 1) {
            void endIndex$iv;
            void startIndex$iv;
            void $this$fastCopyInto$iv;
            this_$iv = content2;
            $i$f$getLastIndex = index + 1;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content2, (int)index, (int)startIndex$iv, (int)endIndex$iv);
        }
        int n = this.size;
        this.size = n + -1;
        content2[this.size] = null;
        return item2;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeRange(int start2, int end) {
        if (end > start2) {
            int newSize;
            int n;
            if (end < this.size) {
                void endIndex$iv;
                void destination$iv;
                void $this$fastCopyInto$iv;
                T[] TArray = this.content;
                T[] TArray2 = this.content;
                n = this.size;
                boolean $i$f$fastCopyInto = false;
                ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])destination$iv, (int)start2, (int)end, (int)endIndex$iv);
            }
            int i2 = newSize = this.size - (end - start2);
            MutableVector this_$iv = this;
            boolean $i$f$getLastIndex = false;
            n = this_$iv.getSize() - 1;
            if (i2 <= n) {
                while (true) {
                    this.content[i2] = null;
                    if (i2 == n) break;
                    ++i2;
                }
            }
            this.size = newSize;
        }
    }

    @PublishedApi
    public final void setSize(int newSize) {
        this.size = newSize;
    }

    public final boolean retainAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i2 = this_$iv.getSize() - 1; -1 < i2; --i2) {
            MutableVector this_$iv2 = this;
            boolean $i$f$get = false;
            T item2 = this_$iv2.content[i2];
            if (elements.contains(item2)) continue;
            this.removeAt(i2);
        }
        return initialSize != this.size;
    }

    public final T set(int index, T element) {
        T[] content2 = this.content;
        T old2 = content2[index];
        content2[index] = element;
        return old2;
    }

    public final void sortWith(@NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        ArraysKt.sortWith((Object[])this.content, comparator, (int)0, (int)this.size);
    }

    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,1110:1\n472#2:1111\n516#2:1112\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n*L\n850#1:1111\n855#1:1112\n*E\n"})
    private static final class MutableVectorList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final MutableVector<T> vector;

        public MutableVectorList(@NotNull MutableVector<T> vector) {
            Intrinsics.checkNotNullParameter(vector, (String)"vector");
            this.vector = vector;
        }

        public int getSize() {
            return this.vector.getSize();
        }

        @Override
        public boolean contains(Object element) {
            return this.vector.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.containsAll(elements);
        }

        @Override
        public T get(int index) {
            MutableVectorKt.checkIndex(this, index);
            MutableVector<T> this_$iv = this.vector;
            boolean $i$f$get = false;
            return this_$iv.content[index];
        }

        @Override
        public int indexOf(Object element) {
            return this.vector.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            MutableVector<T> this_$iv = this.vector;
            boolean $i$f$isEmpty = false;
            return this_$iv.getSize() == 0;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.vector.lastIndexOf(element);
        }

        @Override
        public boolean add(T element) {
            return this.vector.add(element);
        }

        @Override
        public void add(int index, T element) {
            this.vector.add(index, element);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll(index, elements);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll(elements);
        }

        @Override
        public void clear() {
            this.vector.clear();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new VectorListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            return this.vector.remove(element);
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.removeAll(elements);
        }

        public T removeAt(int index) {
            MutableVectorKt.checkIndex(this, index);
            return this.vector.removeAt(index);
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.retainAll(elements);
        }

        @Override
        public T set(int index, T element) {
            MutableVectorKt.checkIndex(this, index);
            return this.vector.set(index, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            MutableVectorKt.checkSubIndex(this, fromIndex, toIndex);
            return new SubList(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1110:1\n1863#2,2:1111\n1863#2,2:1113\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n*L\n922#1:1111,2\n1006#1:1113,2\n*E\n"})
    private static final class SubList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final List<T> list;
        private final int start;
        private int end;

        public SubList(@NotNull List<T> list2, int start2, int end) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            this.list = list2;
            this.start = start2;
            this.end = end;
        }

        public int getSize() {
            return this.end - this.start;
        }

        @Override
        public boolean contains(Object element) {
            int n = this.end;
            for (int i2 = this.start; i2 < n; ++i2) {
                if (!Intrinsics.areEqual(this.list.get(i2), (Object)element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                if (this.contains(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public T get(int index) {
            MutableVectorKt.checkIndex(this, index);
            return this.list.get(index + this.start);
        }

        @Override
        public int indexOf(Object element) {
            int n = this.end;
            for (int i2 = this.start; i2 < n; ++i2) {
                if (!Intrinsics.areEqual(this.list.get(i2), (Object)element)) continue;
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.end == this.start;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            int n = this.start;
            int i2 = this.end - 1;
            if (n <= i2) {
                while (true) {
                    if (Intrinsics.areEqual(this.list.get(i2), (Object)element)) {
                        return i2 - this.start;
                    }
                    if (i2 == n) break;
                    --i2;
                }
            }
            return -1;
        }

        @Override
        public boolean add(T element) {
            int n = this.end;
            this.end = n + 1;
            this.list.add(n, element);
            return true;
        }

        @Override
        public void add(int index, T element) {
            this.list.add(index + this.start, element);
            int n = this.end;
            this.end = n + 1;
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(index + this.start, elements);
            int size = elements.size();
            this.end += size;
            return size > 0;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(this.end, elements);
            int size = elements.size();
            this.end += size;
            return size > 0;
        }

        @Override
        public void clear() {
            int n = this.start;
            int i2 = this.end - 1;
            if (n <= i2) {
                while (true) {
                    this.list.remove(i2);
                    if (i2 == n) break;
                    --i2;
                }
            }
            this.end = this.start;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new VectorListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            int n = this.end;
            for (int i2 = this.start; i2 < n; ++i2) {
                if (!Intrinsics.areEqual(this.list.get(i2), (Object)element)) continue;
                this.list.remove(i2);
                int n2 = this.end;
                this.end = n2 + -1;
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                this.remove(it);
            }
            return originalEnd != this.end;
        }

        public T removeAt(int index) {
            MutableVectorKt.checkIndex(this, index);
            T item2 = this.list.remove(index + this.start);
            int n = this.end;
            this.end = n + -1;
            return item2;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            int i2 = this.end - 1;
            int n = this.start;
            if (n <= i2) {
                while (true) {
                    T item2;
                    if (!elements.contains(item2 = this.list.get(i2))) {
                        this.list.remove(i2);
                        int n2 = this.end;
                        this.end = n2 + -1;
                    }
                    if (i2 == n) break;
                    --i2;
                }
            }
            return originalEnd != this.end;
        }

        @Override
        public T set(int index, T element) {
            MutableVectorKt.checkIndex(this, index);
            return this.list.set(index + this.start, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            MutableVectorKt.checkSubIndex(this, fromIndex, toIndex);
            return new SubList<T>(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    private static final class VectorListIterator<T>
    implements ListIterator<T>,
    KMutableListIterator {
        @NotNull
        private final List<T> list;
        private int index;

        public VectorListIterator(@NotNull List<T> list2, int index) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            this.list = list2;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public T next() {
            int n = this.index;
            this.index = n + 1;
            return this.list.get(n);
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.list.remove(this.index);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public T previous() {
            int n = this.index;
            this.index = n + -1;
            return this.list.get(this.index);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(T element) {
            this.list.add(this.index, element);
            int n = this.index;
            this.index = n + 1;
        }

        @Override
        public void set(T element) {
            this.list.set(this.index, element);
        }
    }
}

