/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nandroidx/compose/runtime/collection/ExtensionsKt\n+ 2 ObjectList.kt\nandroidx/collection/ObjectList\n+ 3 ObjectList.kt\nandroidx/collection/MutableObjectList\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n36#1:80\n37#1:87\n287#2,4:73\n292#2:79\n287#2,6:81\n287#2,4:88\n292#2:94\n287#2,6:95\n287#2,4:101\n292#2:107\n919#3,2:77\n919#3,2:92\n919#3,2:105\n1#4:108\n1010#5,2:109\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nandroidx/compose/runtime/collection/ExtensionsKt\n*L\n29#1:80\n29#1:87\n24#1:73,4\n24#1:79\n29#1:81,6\n31#1:88,4\n31#1:94\n36#1:95,6\n42#1:101,4\n42#1:107\n24#1:77,2\n31#1:92,2\n42#1:105,2\n64#1:109,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final <T> MutableObjectList<T> toMutableObjectList(@NotNull ObjectList<T> $this$toMutableObjectList) {
        Intrinsics.checkNotNullParameter($this$toMutableObjectList, (String)"<this>");
        MutableObjectList target = new MutableObjectList($this$toMutableObjectList.getSize());
        ObjectList<T> this_$iv = $this$toMutableObjectList;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object it = content$iv[i$iv];
            boolean bl = false;
            MutableObjectList this_$iv2 = target;
            boolean $i$f$plusAssign = false;
            this_$iv2.add(it);
        }
        return target;
    }

    @NotNull
    public static final <T, K extends Comparable<? super K>> ObjectList<T> sortedBy(@NotNull ObjectList<T> $this$sortedBy, @NotNull Function1<? super T, ? extends K> selector) {
        ObjectList objectList;
        Intrinsics.checkNotNullParameter($this$sortedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        if (ExtensionsKt.isSorted($this$sortedBy, selector)) {
            objectList = $this$sortedBy;
        } else {
            MutableObjectList<T> mutableObjectList;
            MutableObjectList<T> it = mutableObjectList = ExtensionsKt.toMutableObjectList($this$sortedBy);
            boolean bl = false;
            ExtensionsKt.sortBy(it, selector);
            objectList = (ObjectList)mutableObjectList;
        }
        return objectList;
    }

    public static final <T, K extends Comparable<? super K>> boolean isSorted(@NotNull ObjectList<T> $this$isSorted, @NotNull Function1<? super T, ? extends K> selector) {
        Intrinsics.checkNotNullParameter($this$isSorted, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        if ($this$isSorted.getSize() <= 1) {
            return true;
        }
        Object previousValue = $this$isSorted.get(0);
        Comparable comparable = (Comparable)selector.invoke(previousValue);
        if (comparable == null) {
            return false;
        }
        Comparable previousKey = comparable;
        int n = $this$isSorted.getSize();
        for (int i2 = 1; i2 < n; ++i2) {
            Comparable key;
            Object value2 = $this$isSorted.get(i2);
            if ((Comparable)selector.invoke(value2) == null) {
                return false;
            }
            if (previousKey.compareTo(key) > 0) {
                return false;
            }
            previousKey = key;
        }
        return true;
    }

    public static final <T, K extends Comparable<? super K>> void sortBy(@NotNull MutableObjectList<T> $this$sortBy, @NotNull Function1<? super T, ? extends K> selector) {
        Intrinsics.checkNotNullParameter($this$sortBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        List $this$sortBy$iv = $this$sortBy.asMutableList();
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(selector){
                final /* synthetic */ Function1 $selector;
                {
                    this.$selector = $selector;
                }

                public final int compare(T a, T b) {
                    Function1 function1 = this.$selector;
                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                }
            });
        }
    }

    public static final <T> T removeLast(@NotNull MutableObjectList<T> $this$removeLast) {
        Object object;
        Intrinsics.checkNotNullParameter($this$removeLast, (String)"<this>");
        if ($this$removeLast.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        int last = $this$removeLast.getSize() - 1;
        Object it = object = $this$removeLast.get(last);
        boolean bl = false;
        $this$removeLast.removeAt(last);
        return (T)object;
    }
}

