/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.changelist;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.Composition;
import androidx.compose.runtime.CompositionContext;
import androidx.compose.runtime.ControlledComposition;
import androidx.compose.runtime.MovableContentState;
import androidx.compose.runtime.MovableContentStateReference;
import androidx.compose.runtime.OffsetApplier;
import androidx.compose.runtime.RecomposeScopeImpl;
import androidx.compose.runtime.RecomposeScopeOwner;
import androidx.compose.runtime.RememberManager;
import androidx.compose.runtime.RememberObserverHolder;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotWriter;
import androidx.compose.runtime.changelist.ChangeList;
import androidx.compose.runtime.changelist.FixupList;
import androidx.compose.runtime.changelist.OperationArgContainer;
import androidx.compose.runtime.changelist.OperationKt;
import androidx.compose.runtime.internal.IntRef;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

public abstract class Operation {
    private final int ints;
    private final int objects;

    private Operation(int ints, int objects) {
        this.ints = ints;
        this.objects = objects;
    }

    public /* synthetic */ Operation(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2, null);
    }

    public final int getInts() {
        return this.ints;
    }

    public final int getObjects() {
        return this.objects;
    }

    @NotNull
    public final String getName() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public abstract void execute(@NotNull OperationArgContainer var1, @NotNull Applier<?> var2, @NotNull SlotWriter var3, @NotNull RememberManager var4);

    @NotNull
    public String toString() {
        return this.getName();
    }

    public /* synthetic */ Operation(int ints, int objects, DefaultConstructorMarker $constructor_marker) {
        this(ints, objects);
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$AdvanceSlotsBy\n*L\n1#1,1057:1\n112#1:1058\n112#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$AdvanceSlotsBy\n*L\n116#1:1058\n125#1:1059\n*E\n"})
    public static final class AdvanceSlotsBy
    extends Operation {
        @NotNull
        public static final AdvanceSlotsBy INSTANCE = new AdvanceSlotsBy();

        private AdvanceSlotsBy() {
            super(1, 0, 2, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            AdvanceSlotsBy this_$iv = this;
            boolean $i$f$getDistance = false;
            slots.advanceBy($this$execute.getInt(0));
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$AppendValue\n*L\n1#1,1057:1\n232#1:1058\n235#1:1059\n232#1:1060\n235#1:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$AppendValue\n*L\n239#1:1058\n240#1:1059\n249#1:1060\n250#1:1061\n*E\n"})
    public static final class AppendValue
    extends Operation {
        @NotNull
        public static final AppendValue INSTANCE = new AppendValue();

        private AppendValue() {
            super(0, 2, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            AppendValue this_$iv = this;
            boolean bl = false;
            Anchor anchor = (Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            AppendValue this_$iv2 = this;
            boolean bl2 = false;
            Object value2 = $this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            if (value2 instanceof RememberObserverHolder) {
                rememberManager.remembering((RememberObserverHolder)value2);
            }
            slots.appendSlot(anchor, value2);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$ApplyChangeList\n*L\n1#1,1057:1\n944#1:1058\n947#1:1059\n947#1:1060\n944#1:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$ApplyChangeList\n*L\n951#1:1058\n952#1:1059\n961#1:1060\n963#1:1061\n*E\n"})
    public static final class ApplyChangeList
    extends Operation {
        @NotNull
        public static final ApplyChangeList INSTANCE = new ApplyChangeList();

        private ApplyChangeList() {
            super(0, 2, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            ApplyChangeList this_$iv = this;
            boolean bl = false;
            IntRef intRef = (IntRef)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            int effectiveNodeIndex = intRef != null ? intRef.getElement() : 0;
            ApplyChangeList this_$iv2 = this;
            boolean bl2 = false;
            ((ChangeList)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0))).executeAndFlushAllPendingChanges(effectiveNodeIndex > 0 ? (Applier)new OffsetApplier(applier, effectiveNodeIndex) : applier, slots, rememberManager);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$CopyNodesToNewAnchorLocation\n+ 2 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n*L\n1#1,1057:1\n807#1:1058\n810#1:1059\n807#1:1060\n810#1:1061\n64#2,5:1062\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$CopyNodesToNewAnchorLocation\n*L\n814#1:1058\n815#1:1059\n824#1:1060\n825#1:1061\n827#1:1062,5\n*E\n"})
    public static final class CopyNodesToNewAnchorLocation
    extends Operation {
        @NotNull
        public static final CopyNodesToNewAnchorLocation INSTANCE = new CopyNodesToNewAnchorLocation();

        private CopyNodesToNewAnchorLocation() {
            super(0, 2, 1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            List nodesToInsert;
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            CopyNodesToNewAnchorLocation this_$iv = this;
            boolean bl = false;
            int effectiveNodeIndex = ((IntRef)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0))).getElement();
            CopyNodesToNewAnchorLocation this_$iv2 = this;
            boolean bl2 = false;
            List $this$fastForEachIndexed$iv = nodesToInsert = (List)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            boolean $i$f$fastForEachIndexed = false;
            int index$iv = 0;
            int n = ((Collection)$this$fastForEachIndexed$iv).size();
            while (index$iv < n) {
                void node2;
                Object item$iv;
                Object e = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
                int i2 = index$iv++;
                boolean bl3 = false;
                applier.insertBottomUp(effectiveNodeIndex + i2, node2);
                applier.insertTopDown(effectiveNodeIndex + i2, node2);
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$CopySlotTableToAnchorLocation\n*L\n1#1,1057:1\n838#1:1058\n841#1:1059\n844#1:1060\n847#1:1061\n844#1:1062\n847#1:1063\n841#1:1064\n838#1:1065\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$CopySlotTableToAnchorLocation\n*L\n851#1:1058\n852#1:1059\n853#1:1060\n854#1:1061\n863#1:1062\n864#1:1063\n865#1:1064\n868#1:1065\n*E\n"})
    public static final class CopySlotTableToAnchorLocation
    extends Operation {
        @NotNull
        public static final CopySlotTableToAnchorLocation INSTANCE = new CopySlotTableToAnchorLocation();

        private CopySlotTableToAnchorLocation() {
            super(0, 4, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            CopySlotTableToAnchorLocation this_$iv = this;
            boolean bl = false;
            MovableContentStateReference from = (MovableContentStateReference)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(2));
            CopySlotTableToAnchorLocation this_$iv2 = this;
            boolean bl2 = false;
            MovableContentStateReference to = (MovableContentStateReference)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(3));
            CopySlotTableToAnchorLocation this_$iv3 = this;
            boolean bl3 = false;
            CompositionContext parentCompositionContext = (CompositionContext)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            CopySlotTableToAnchorLocation this_$iv4 = this;
            boolean bl4 = false;
            MovableContentState movableContentState = (MovableContentState)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            if (movableContentState == null && (movableContentState = parentCompositionContext.movableContentStateResolve$runtime(from)) == null) {
                ComposerKt.composeRuntimeError("Could not resolve state for movable content");
                throw new KotlinNothingValueException();
            }
            MovableContentState resolvedState = movableContentState;
            List<Anchor> anchors = slots.moveIntoGroupFrom(1, resolvedState.getSlotTable$runtime(), 2);
            ControlledComposition controlledComposition = to.getComposition$runtime();
            Intrinsics.checkNotNull((Object)controlledComposition, (String)"null cannot be cast to non-null type androidx.compose.runtime.RecomposeScopeOwner");
            RecomposeScopeImpl.Companion.adoptAnchoredScopes$runtime(slots, anchors, (RecomposeScopeOwner)((Object)controlledComposition));
        }
    }

    public static final class DeactivateCurrentGroup
    extends Operation {
        @NotNull
        public static final DeactivateCurrentGroup INSTANCE = new DeactivateCurrentGroup();

        private DeactivateCurrentGroup() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            ComposerKt.deactivateCurrentGroup(slots, rememberManager);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$DetermineMovableContentNodeIndex\n*L\n1#1,1057:1\n775#1:1058\n778#1:1059\n775#1:1060\n778#1:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$DetermineMovableContentNodeIndex\n*L\n782#1:1058\n783#1:1059\n792#1:1060\n797#1:1061\n*E\n"})
    public static final class DetermineMovableContentNodeIndex
    extends Operation {
        @NotNull
        public static final DetermineMovableContentNodeIndex INSTANCE = new DetermineMovableContentNodeIndex();

        private DetermineMovableContentNodeIndex() {
            super(0, 2, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            DetermineMovableContentNodeIndex this_$iv = this;
            boolean bl = false;
            IntRef effectiveNodeIndexOut = (IntRef)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            this_$iv = this;
            boolean bl2 = false;
            effectiveNodeIndexOut.setElement(OperationKt.access$positionToInsert(slots, (Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1)), applier));
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$Downs\n*L\n1#1,1057:1\n89#1:1058\n89#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$Downs\n*L\n93#1:1058\n103#1:1059\n*E\n"})
    public static final class Downs
    extends Operation {
        @NotNull
        public static final Downs INSTANCE = new Downs();

        private Downs() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            Applier<?> nodeApplier = applier;
            Downs this_$iv = this;
            boolean bl = false;
            Object[] nodes = (Object[])$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            int n = nodes.length;
            for (int index = 0; index < n; ++index) {
                nodeApplier.down(nodes[index]);
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$EndCompositionScope\n*L\n1#1,1057:1\n496#1:1058\n499#1:1059\n496#1:1060\n499#1:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$EndCompositionScope\n*L\n503#1:1058\n504#1:1059\n513#1:1060\n514#1:1061\n*E\n"})
    public static final class EndCompositionScope
    extends Operation {
        @NotNull
        public static final EndCompositionScope INSTANCE = new EndCompositionScope();

        private EndCompositionScope() {
            super(0, 2, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            EndCompositionScope this_$iv = this;
            boolean bl = false;
            Function1 action2 = (Function1)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            EndCompositionScope this_$iv2 = this;
            boolean bl2 = false;
            Composition composition = (Composition)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            action2.invoke((Object)composition);
        }
    }

    public static final class EndCurrentGroup
    extends Operation {
        @NotNull
        public static final EndCurrentGroup INSTANCE = new EndCurrentGroup();

        private EndCurrentGroup() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            slots.endGroup();
        }
    }

    public static final class EndMovableContentPlacement
    extends Operation {
        @NotNull
        public static final EndMovableContentPlacement INSTANCE = new EndMovableContentPlacement();

        private EndMovableContentPlacement() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            OperationKt.access$positionToParentOf(slots, applier, 0);
            slots.endGroup();
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$EndResumingScope\n*L\n1#1,1057:1\n212#1:1058\n212#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$EndResumingScope\n*L\n216#1:1058\n225#1:1059\n*E\n"})
    public static final class EndResumingScope
    extends Operation {
        @NotNull
        public static final EndResumingScope INSTANCE = new EndResumingScope();

        private EndResumingScope() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            EndResumingScope this_$iv = this;
            boolean bl = false;
            RecomposeScopeImpl scope2 = (RecomposeScopeImpl)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            rememberManager.endResumingScope(scope2);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$EnsureGroupStarted\n*L\n1#1,1057:1\n428#1:1058\n428#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$EnsureGroupStarted\n*L\n432#1:1058\n441#1:1059\n*E\n"})
    public static final class EnsureGroupStarted
    extends Operation {
        @NotNull
        public static final EnsureGroupStarted INSTANCE = new EnsureGroupStarted();

        private EnsureGroupStarted() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            EnsureGroupStarted this_$iv = this;
            boolean bl = false;
            slots.ensureStarted((Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0)));
        }
    }

    public static final class EnsureRootGroupStarted
    extends Operation {
        @NotNull
        public static final EnsureRootGroupStarted INSTANCE = new EnsureRootGroupStarted();

        private EnsureRootGroupStarted() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            slots.ensureStarted(0);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$InsertNodeFixup\n*L\n1#1,1057:1\n682#1:1058\n679#1:1059\n685#1:1060\n679#1:1061\n685#1:1062\n682#1:1063\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$InsertNodeFixup\n*L\n689#1:1058\n695#1:1059\n696#1:1060\n705#1:1061\n706#1:1062\n707#1:1063\n*E\n"})
    public static final class InsertNodeFixup
    extends Operation {
        @NotNull
        public static final InsertNodeFixup INSTANCE = new InsertNodeFixup();

        private InsertNodeFixup() {
            super(1, 2, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            InsertNodeFixup this_$iv = this;
            boolean bl = false;
            Object node2 = ((Function0)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0))).invoke();
            InsertNodeFixup this_$iv2 = this;
            boolean bl2 = false;
            Anchor groupAnchor = (Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            InsertNodeFixup this_$iv3 = this;
            boolean $i$f$getInsertIndex = false;
            int insertIndex = $this$execute.getInt(0);
            Applier<?> nodeApplier = applier;
            slots.updateNode(groupAnchor, node2);
            nodeApplier.insertTopDown(insertIndex, node2);
            nodeApplier.down(node2);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$InsertSlots\n*L\n1#1,1057:1\n607#1:1058\n610#1:1059\n610#1:1060\n607#1:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$InsertSlots\n*L\n614#1:1058\n615#1:1059\n624#1:1060\n625#1:1061\n*E\n"})
    public static final class InsertSlots
    extends Operation {
        @NotNull
        public static final InsertSlots INSTANCE = new InsertSlots();

        private InsertSlots() {
            super(0, 2, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            InsertSlots this_$iv = this;
            boolean bl = false;
            SlotTable insertTable = (SlotTable)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            InsertSlots this_$iv2 = this;
            boolean bl2 = false;
            Anchor anchor = (Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            slots.beginInsert();
            slots.moveFrom(insertTable, anchor.toIndexFor(insertTable), false);
            slots.endInsert();
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$InsertSlotsWithFixups\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1057:1\n639#1:1058\n642#1:1059\n645#1:1060\n642#1:1061\n639#1:1062\n645#1:1063\n174#2,4:1064\n179#2,3:1069\n1#3:1068\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$InsertSlotsWithFixups\n*L\n649#1:1058\n650#1:1059\n651#1:1060\n660#1:1061\n661#1:1062\n662#1:1063\n664#1:1064,4\n664#1:1069,3\n664#1:1068\n*E\n"})
    public static final class InsertSlotsWithFixups
    extends Operation {
        @NotNull
        public static final InsertSlotsWithFixups INSTANCE = new InsertSlotsWithFixups();

        private InsertSlotsWithFixups() {
            super(0, 3, 1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            InsertSlotsWithFixups this_$iv = this;
            boolean bl = false;
            SlotTable insertTable = (SlotTable)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            InsertSlotsWithFixups this_$iv2 = this;
            boolean bl2 = false;
            Anchor anchor = (Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            Object this_$iv3 = this;
            boolean bl3 = false;
            FixupList fixups = (FixupList)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(2));
            this_$iv3 = insertTable;
            boolean $i$f$write = false;
            SlotWriter writer$iv = ((SlotTable)this_$iv3).openWriter();
            boolean bl4 = false;
            boolean normalClose$iv = false;
            try {
                Unit unit;
                SlotWriter writer2 = writer$iv;
                boolean bl5 = false;
                fixups.executeAndFlushAllPendingFixups(applier, writer2, rememberManager);
                Unit it$iv = unit = Unit.INSTANCE;
                boolean bl6 = false;
                normalClose$iv = true;
            }
            finally {
                writer$iv.close(normalClose$iv);
            }
            slots.beginInsert();
            slots.moveFrom(insertTable, anchor.toIndexFor(insertTable), false);
            slots.endInsert();
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$MoveCurrentGroup\n*L\n1#1,1057:1\n457#1:1058\n457#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$MoveCurrentGroup\n*L\n461#1:1058\n470#1:1059\n*E\n"})
    public static final class MoveCurrentGroup
    extends Operation {
        @NotNull
        public static final MoveCurrentGroup INSTANCE = new MoveCurrentGroup();

        private MoveCurrentGroup() {
            super(1, 0, 2, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            MoveCurrentGroup this_$iv = this;
            boolean $i$f$getOffset = false;
            slots.moveGroup($this$execute.getInt(0));
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$MoveNode\n*L\n1#1,1057:1\n580#1:1058\n583#1:1059\n586#1:1060\n580#1,7:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$MoveNode\n*L\n590#1:1058\n591#1:1059\n592#1:1060\n601#1:1061,7\n*E\n"})
    public static final class MoveNode
    extends Operation {
        @NotNull
        public static final MoveNode INSTANCE = new MoveNode();

        private MoveNode() {
            super(3, 0, 2, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            MoveNode this_$iv = this;
            boolean $i$f$getFrom = false;
            this_$iv = this;
            boolean $i$f$getTo = false;
            this_$iv = this;
            boolean $i$f$getCount = false;
            applier.move($this$execute.getInt(0), $this$execute.getInt(1), $this$execute.getInt(2));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    public static final class ObjectParameter<T> {
        private final int offset;

        public static String toString-impl(int arg0) {
            return "ObjectParameter(offset=" + arg0 + ")";
        }

        public String toString() {
            return ObjectParameter.toString-impl(this.offset);
        }

        public static int hashCode-impl(int arg0) {
            return Integer.hashCode(arg0);
        }

        public int hashCode() {
            return ObjectParameter.hashCode-impl(this.offset);
        }

        public static boolean equals-impl(int arg0, Object other) {
            if (!(other instanceof ObjectParameter)) {
                return false;
            }
            int n = ((ObjectParameter)other).unbox-impl();
            return arg0 == n;
        }

        public boolean equals(Object other) {
            return ObjectParameter.equals-impl(this.offset, other);
        }

        public static <T> int constructor-impl(int offset) {
            return offset;
        }

        public final /* synthetic */ int unbox-impl() {
            return this.offset;
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$PostInsertNodeFixup\n*L\n1#1,1057:1\n718#1:1058\n721#1:1059\n721#1:1060\n718#1:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$PostInsertNodeFixup\n*L\n725#1:1058\n731#1:1059\n740#1:1060\n741#1:1061\n*E\n"})
    public static final class PostInsertNodeFixup
    extends Operation {
        @NotNull
        public static final PostInsertNodeFixup INSTANCE = new PostInsertNodeFixup();

        private PostInsertNodeFixup() {
            super(1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            PostInsertNodeFixup this_$iv = this;
            boolean bl = false;
            Anchor groupAnchor = (Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            PostInsertNodeFixup this_$iv2 = this;
            boolean $i$f$getInsertIndex = false;
            int insertIndex = $this$execute.getInt(0);
            applier.up();
            Applier<?> nodeApplier = applier;
            Object nodeToInsert = slots.node(groupAnchor);
            nodeApplier.insertBottomUp(insertIndex, nodeToInsert);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$ReleaseMovableGroupAtCurrent\n*L\n1#1,1057:1\n907#1:1058\n910#1:1059\n913#1:1060\n907#1:1061\n913#1:1062\n910#1:1063\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$ReleaseMovableGroupAtCurrent\n*L\n917#1:1058\n918#1:1059\n919#1:1060\n928#1:1061\n929#1:1062\n930#1:1063\n*E\n"})
    public static final class ReleaseMovableGroupAtCurrent
    extends Operation {
        @NotNull
        public static final ReleaseMovableGroupAtCurrent INSTANCE = new ReleaseMovableGroupAtCurrent();

        private ReleaseMovableGroupAtCurrent() {
            super(0, 3, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            ReleaseMovableGroupAtCurrent this_$iv = this;
            boolean bl = false;
            ControlledComposition composition = (ControlledComposition)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            ReleaseMovableGroupAtCurrent this_$iv2 = this;
            boolean bl2 = false;
            MovableContentStateReference reference = (MovableContentStateReference)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(2));
            ReleaseMovableGroupAtCurrent this_$iv3 = this;
            boolean bl3 = false;
            CompositionContext parentContext = (CompositionContext)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            MovableContentState state2 = ComposerKt.extractMovableContentAtCurrent(composition, reference, slots, null);
            parentContext.movableContentStateReleased$runtime(reference, state2, applier);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$Remember\n*L\n1#1,1057:1\n153#1:1058\n153#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$Remember\n*L\n157#1:1058\n166#1:1059\n*E\n"})
    public static final class Remember
    extends Operation {
        @NotNull
        public static final Remember INSTANCE = new Remember();

        private Remember() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            Remember this_$iv = this;
            boolean bl = false;
            rememberManager.remembering((RememberObserverHolder)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0)));
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$RememberPausingScope\n*L\n1#1,1057:1\n172#1:1058\n172#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$RememberPausingScope\n*L\n176#1:1058\n185#1:1059\n*E\n"})
    public static final class RememberPausingScope
    extends Operation {
        @NotNull
        public static final RememberPausingScope INSTANCE = new RememberPausingScope();

        private RememberPausingScope() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            RememberPausingScope this_$iv = this;
            boolean bl = false;
            RecomposeScopeImpl scope2 = (RecomposeScopeImpl)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            rememberManager.rememberPausingScope(scope2);
        }
    }

    public static final class RemoveCurrentGroup
    extends Operation {
        @NotNull
        public static final RemoveCurrentGroup INSTANCE = new RemoveCurrentGroup();

        private RemoveCurrentGroup() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            ComposerKt.removeCurrentGroup(slots, rememberManager);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$RemoveNode\n*L\n1#1,1057:1\n557#1:1058\n560#1:1059\n557#1,4:1060\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$RemoveNode\n*L\n564#1:1058\n565#1:1059\n574#1:1060,4\n*E\n"})
    public static final class RemoveNode
    extends Operation {
        @NotNull
        public static final RemoveNode INSTANCE = new RemoveNode();

        private RemoveNode() {
            super(2, 0, 2, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            RemoveNode this_$iv = this;
            boolean $i$f$getRemoveIndex = false;
            this_$iv = this;
            boolean $i$f$getCount = false;
            applier.remove($this$execute.getInt(0), $this$execute.getInt(1));
        }
    }

    public static final class ResetSlots
    extends Operation {
        @NotNull
        public static final ResetSlots INSTANCE = new ResetSlots();

        private ResetSlots() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            slots.reset();
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$SideEffect\n*L\n1#1,1057:1\n134#1:1058\n134#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$SideEffect\n*L\n138#1:1058\n147#1:1059\n*E\n"})
    public static final class SideEffect
    extends Operation {
        @NotNull
        public static final SideEffect INSTANCE = new SideEffect();

        private SideEffect() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            SideEffect this_$iv = this;
            boolean bl = false;
            rememberManager.sideEffect((Function0<Unit>)((Function0)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0))));
        }
    }

    public static final class SkipToEndOfCurrentGroup
    extends Operation {
        @NotNull
        public static final SkipToEndOfCurrentGroup INSTANCE = new SkipToEndOfCurrentGroup();

        private SkipToEndOfCurrentGroup() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            slots.skipToGroupEnd();
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$StartResumingScope\n*L\n1#1,1057:1\n192#1:1058\n192#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$StartResumingScope\n*L\n196#1:1058\n205#1:1059\n*E\n"})
    public static final class StartResumingScope
    extends Operation {
        @NotNull
        public static final StartResumingScope INSTANCE = new StartResumingScope();

        private StartResumingScope() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            StartResumingScope this_$iv = this;
            boolean bl = false;
            RecomposeScopeImpl scope2 = (RecomposeScopeImpl)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            rememberManager.startResumingScope(scope2);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$TrimParentValues\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotWriter\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,1057:1\n260#1:1058\n260#1:1059\n1678#2,4:1060\n1683#2:1072\n4341#3,8:1064\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$TrimParentValues\n*L\n264#1:1058\n273#1:1059\n275#1:1060,4\n275#1:1072\n281#1:1064,8\n*E\n"})
    public static final class TrimParentValues
    extends Operation {
        @NotNull
        public static final TrimParentValues INSTANCE = new TrimParentValues();

        private TrimParentValues() {
            super(1, 0, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            TrimParentValues this_$iv2 = this;
            boolean $i$f$getCount22 = false;
            int count = $this$execute.getInt(0);
            int slotsSize = slots.getSlotsSize();
            SlotWriter $i$f$getCount22 = slots;
            int groupIndex$iv = slots.getParent();
            boolean $i$f$forEachTailSlot = false;
            int slotsStart$iv = this_$iv.slotsStartIndex$runtime(groupIndex$iv);
            int slotsEnd$iv = this_$iv.slotsEndIndex$runtime(groupIndex$iv);
            for (int slotIndex$iv = Math.max(slotsStart$iv, slotsEnd$iv - count); slotIndex$iv < slotsEnd$iv; ++slotIndex$iv) {
                void value2;
                Object object = SlotWriter.access$getSlots$p((SlotWriter)this_$iv)[SlotWriter.access$dataIndexToDataAddress((SlotWriter)this_$iv, slotIndex$iv)];
                int slotIndex = slotIndex$iv;
                boolean bl = false;
                void var16_18 = value2;
                if (var16_18 instanceof RememberObserverHolder) {
                    void endRelativeAfter;
                    int endRelativeOrder = slotsSize - slotIndex;
                    SlotWriter slotWriter = slots;
                    Anchor anchor$iv = ((RememberObserverHolder)value2).getAfter();
                    boolean $i$f$withAfterAnchorInfo = false;
                    int priority$iv = -1;
                    int endRelativeAfter$iv = -1;
                    if (anchor$iv != null && anchor$iv.getValid()) {
                        void $this$withAfterAnchorInfo$iv;
                        priority$iv = $this$withAfterAnchorInfo$iv.anchorIndex(anchor$iv);
                        endRelativeAfter$iv = $this$withAfterAnchorInfo$iv.getSlotsSize() - $this$withAfterAnchorInfo$iv.slotsEndAllIndex$runtime(priority$iv);
                    }
                    int n = endRelativeAfter$iv;
                    int priority = priority$iv;
                    boolean bl2 = false;
                    rememberManager.forgetting((RememberObserverHolder)value2, endRelativeOrder, priority, (int)endRelativeAfter);
                    continue;
                }
                if (!(var16_18 instanceof RecomposeScopeImpl)) continue;
                ((RecomposeScopeImpl)value2).release();
            }
            slots.trimTailSlots(count);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateAnchoredValue\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,1057:1\n348#1:1058\n342#1:1059\n345#1:1060\n342#1:1061\n345#1:1062\n348#1:1063\n4341#2,8:1064\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateAnchoredValue\n*L\n352#1:1058\n358#1:1059\n359#1:1060\n368#1:1061\n369#1:1062\n370#1:1063\n380#1:1064,8\n*E\n"})
    public static final class UpdateAnchoredValue
    extends Operation {
        @NotNull
        public static final UpdateAnchoredValue INSTANCE = new UpdateAnchoredValue();

        private UpdateAnchoredValue() {
            super(1, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            int groupIndex;
            Object previous;
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            UpdateAnchoredValue this_$iv = this;
            boolean bl = false;
            Object value2 = $this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            UpdateAnchoredValue this_$iv2 = this;
            boolean bl2 = false;
            Anchor anchor = (Anchor)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            UpdateAnchoredValue this_$iv3 = this;
            boolean $i$f$getGroupSlotIndex = false;
            int groupSlotIndex = $this$execute.getInt(0);
            if (value2 instanceof RememberObserverHolder) {
                rememberManager.remembering((RememberObserverHolder)value2);
            }
            if ((previous = slots.set(groupIndex = slots.anchorIndex(anchor), groupSlotIndex, value2)) instanceof RememberObserverHolder) {
                void endRelativeAfter;
                int endRelativeSlotOrder = slots.getSlotsSize() - slots.slotIndexOfGroupSlotIndex(groupIndex, groupSlotIndex);
                SlotWriter slotWriter = slots;
                Anchor anchor$iv = ((RememberObserverHolder)previous).getAfter();
                boolean $i$f$withAfterAnchorInfo = false;
                int priority$iv = -1;
                int endRelativeAfter$iv = -1;
                if (anchor$iv != null && anchor$iv.getValid()) {
                    void $this$withAfterAnchorInfo$iv;
                    priority$iv = $this$withAfterAnchorInfo$iv.anchorIndex(anchor$iv);
                    endRelativeAfter$iv = $this$withAfterAnchorInfo$iv.getSlotsSize() - $this$withAfterAnchorInfo$iv.slotsEndAllIndex$runtime(priority$iv);
                }
                int n = endRelativeAfter$iv;
                int priority = priority$iv;
                boolean bl3 = false;
                rememberManager.forgetting((RememberObserverHolder)previous, endRelativeSlotOrder, priority, (int)endRelativeAfter);
            } else if (previous instanceof RecomposeScopeImpl) {
                ((RecomposeScopeImpl)previous).release();
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateAuxData\n*L\n1#1,1057:1\n399#1:1058\n399#1:1059\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateAuxData\n*L\n403#1:1058\n412#1:1059\n*E\n"})
    public static final class UpdateAuxData
    extends Operation {
        @NotNull
        public static final UpdateAuxData INSTANCE = new UpdateAuxData();

        private UpdateAuxData() {
            super(0, 1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            UpdateAuxData this_$iv = this;
            boolean bl = false;
            slots.updateAux($this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0)));
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateNode\n*L\n1#1,1057:1\n532#1:1058\n535#1:1059\n532#1:1060\n535#1:1061\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateNode\n*L\n539#1:1058\n540#1:1059\n549#1:1060\n550#1:1061\n*E\n"})
    public static final class UpdateNode
    extends Operation {
        @NotNull
        public static final UpdateNode INSTANCE = new UpdateNode();

        private UpdateNode() {
            super(0, 2, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            UpdateNode this_$iv = this;
            boolean bl = false;
            Object value2 = $this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            UpdateNode this_$iv2 = this;
            boolean bl2 = false;
            Function2 block = (Function2)$this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(1));
            applier.apply(block, value2);
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateValue\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotWriter\n*L\n1#1,1057:1\n302#1:1058\n299#1:1059\n299#1:1060\n302#1:1061\n1611#2:1062\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$UpdateValue\n*L\n306#1:1058\n312#1:1059\n321#1:1060\n322#1:1061\n326#1:1062\n*E\n"})
    public static final class UpdateValue
    extends Operation {
        @NotNull
        public static final UpdateValue INSTANCE = new UpdateValue();

        private UpdateValue() {
            super(1, 1, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            UpdateValue this_$iv = this;
            boolean bl = false;
            Object value2 = $this$execute.getObject-31yXWZQ(ObjectParameter.constructor-impl(0));
            UpdateValue this_$iv2 = this;
            boolean $i$f$getGroupSlotIndex = false;
            int groupSlotIndex = $this$execute.getInt(0);
            if (value2 instanceof RememberObserverHolder) {
                rememberManager.remembering((RememberObserverHolder)value2);
            }
            SlotWriter this_$iv3 = slots;
            boolean $i$f$set = false;
            Object previous = this_$iv3.set(this_$iv3.getCurrentGroup(), groupSlotIndex, value2);
            if (previous instanceof RememberObserverHolder) {
                int endRelativeOrder = slots.getSlotsSize() - slots.slotIndexOfGroupSlotIndex(slots.getCurrentGroup(), groupSlotIndex);
                rememberManager.forgetting((RememberObserverHolder)previous, endRelativeOrder, -1, -1);
            } else if (previous instanceof RecomposeScopeImpl) {
                ((RecomposeScopeImpl)previous).release();
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$Ups\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1057:1\n70#1:1058\n70#1:1059\n1#2:1060\n*S KotlinDebug\n*F\n+ 1 Operation.kt\nandroidx/compose/runtime/changelist/Operation$Ups\n*L\n74#1:1058\n83#1:1059\n*E\n"})
    public static final class Ups
    extends Operation {
        @NotNull
        public static final Ups INSTANCE = new Ups();

        private Ups() {
            super(1, 0, 2, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            Ups this_$iv = this;
            boolean $i$f$getCount = false;
            int n = $this$execute.getInt(0);
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                applier.up();
            }
        }
    }

    public static final class UseCurrentNode
    extends Operation {
        @NotNull
        public static final UseCurrentNode INSTANCE = new UseCurrentNode();

        private UseCurrentNode() {
            super(0, 0, 3, null);
        }

        @Override
        public void execute(@NotNull OperationArgContainer $this$execute, @NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
            Intrinsics.checkNotNullParameter(applier, (String)"applier");
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
            applier.reuse();
        }
    }
}

