/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.IntStack;
import androidx.compose.runtime.KeyInfo;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotReader\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 3 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,3963:1\n3746#2:3964\n3666#2:3965\n3666#2:3966\n3732#2:3967\n3732#2:3968\n3666#2:3969\n3726#2:3970\n3726#2:3971\n3672#2:3972\n3672#2:3973\n3726#2:3974\n3689#2:3975\n3698#2:3976\n3732#2:3977\n3746#2:3982\n3777#2:3983\n3777#2:3984\n3746#2:3989\n3777#2:3994\n3666#2:3995\n3666#2:4004\n3732#2:4005\n3746#2:4014\n3746#2:4023\n3777#2:4024\n3726#2:4025\n3666#2:4026\n3732#2:4027\n3825#2,6:4028\n3666#2:4034\n3669#2:4035\n3681#2:4036\n3672#2:4037\n34#3,4:3978\n34#3,4:3985\n34#3,4:3990\n34#3,4:3996\n4644#4,4:4000\n4644#4,4:4006\n4644#4,4:4010\n4644#4,4:4015\n4644#4,4:4019\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotReader\n*L\n873#1:3964\n877#1:3965\n880#1:3966\n887#1:3967\n890#1:3968\n893#1:3969\n924#1:3970\n928#1:3971\n938#1:3972\n941#1:3973\n962#1:3974\n965#1:3975\n971#1:3976\n975#1:3977\n985#1:3982\n994#1:3983\n1011#1:3984\n1062#1:3989\n1080#1:3994\n1087#1:3995\n1095#1:4004\n1095#1:4005\n1112#1:4014\n1140#1:4023\n1151#1:4024\n1168#1:4025\n1171#1:4026\n1171#1:4027\n1185#1:4028,6\n1188#1:4034\n1189#1:4035\n1193#1:4036\n1198#1:4037\n984#1:3978,4\n1044#1:3985,4\n1062#1:3990,4\n1087#1:3996,4\n1094#1:4000,4\n1102#1:4006,4\n1110#1:4010,4\n1125#1:4015,4\n1137#1:4019,4\n*E\n"})
public final class SlotReader {
    @NotNull
    private final SlotTable table;
    @NotNull
    private final int[] groups;
    private final int groupsSize;
    @NotNull
    private final Object[] slots;
    private final int slotsSize;
    @Nullable
    private HashMap<Anchor, GroupSourceInformation> sourceInformationMap;
    private boolean closed;
    private int currentGroup;
    private int currentEnd;
    private int parent;
    @NotNull
    private final IntStack currentSlotStack;
    private int emptyCount;
    private int currentSlot;
    private int currentSlotEnd;
    private boolean hadNext;
    public static final int $stable = 8;

    public SlotReader(@NotNull SlotTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.groups = this.table.getGroups();
        this.groupsSize = this.table.getGroupsSize();
        this.slots = this.table.getSlots();
        this.slotsSize = this.table.getSlotsSize();
        this.currentEnd = this.groupsSize;
        this.parent = -1;
        this.currentSlotStack = new IntStack();
    }

    @NotNull
    public final SlotTable getTable$runtime() {
        return this.table;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getCurrentEnd() {
        return this.currentEnd;
    }

    public final int getParent() {
        return this.parent;
    }

    public final int getSize() {
        return this.groupsSize;
    }

    public final int parent(int index) {
        int[] $this$parentAnchor$iv = this.groups;
        boolean $i$f$parentAnchor = false;
        return $this$parentAnchor$iv[index * 5 + 2];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isNode() {
        void $this$isNode$iv;
        int[] nArray = this.groups;
        int address$iv = this.currentGroup;
        boolean $i$f$isNode = false;
        return ($this$isNode$iv[address$iv * 5 + 1] & 0x40000000) != 0;
    }

    public final boolean isNode(int index) {
        int[] $this$isNode$iv = this.groups;
        boolean $i$f$isNode = false;
        return ($this$isNode$iv[index * 5 + 1] & 0x40000000) != 0;
    }

    public final int nodeCount(int index) {
        int[] $this$nodeCount$iv = this.groups;
        boolean $i$f$nodeCount = false;
        return $this$nodeCount$iv[index * 5 + 1] & 0x3FFFFFF;
    }

    @Nullable
    public final Object node(int index) {
        int[] $this$isNode$iv = this.groups;
        boolean $i$f$isNode = false;
        return ($this$isNode$iv[index * 5 + 1] & 0x40000000) != 0 ? this.node(this.groups, index) : null;
    }

    public final boolean isGroupEnd() {
        return this.getInEmpty() || this.currentGroup == this.currentEnd;
    }

    public final boolean getInEmpty() {
        return this.emptyCount > 0;
    }

    public final int getGroupSize() {
        return SlotTableKt.access$groupSize(this.groups, this.currentGroup);
    }

    public final int groupSize(int index) {
        return SlotTableKt.access$groupSize(this.groups, index);
    }

    public final int getGroupEnd() {
        return this.currentEnd;
    }

    /*
     * WARNING - void declaration
     */
    public final int getGroupKey() {
        int n;
        if (this.currentGroup < this.currentEnd) {
            void $this$key$iv;
            int[] nArray = this.groups;
            int address$iv = this.currentGroup;
            boolean $i$f$key = false;
            n = $this$key$iv[address$iv * 5];
        } else {
            n = 0;
        }
        return n;
    }

    public final int groupKey(int index) {
        int[] $this$key$iv = this.groups;
        boolean $i$f$key = false;
        return $this$key$iv[index * 5];
    }

    public final int getGroupSlotIndex() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final boolean hasObjectKey(int index) {
        int[] $this$hasObjectKey$iv = this.groups;
        boolean $i$f$hasObjectKey = false;
        return ($this$hasObjectKey$iv[index * 5 + 1] & 0x20000000) != 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getHasObjectKey() {
        void $this$hasObjectKey$iv;
        if (this.currentGroup >= this.currentEnd) return false;
        int[] nArray = this.groups;
        int address$iv = this.currentGroup;
        boolean $i$f$hasObjectKey = false;
        if (($this$hasObjectKey$iv[address$iv * 5 + 1] & 0x20000000) == 0) return false;
        return true;
    }

    @Nullable
    public final Object getGroupObjectKey() {
        return this.currentGroup < this.currentEnd ? this.objectKey(this.groups, this.currentGroup) : null;
    }

    @Nullable
    public final Object groupObjectKey(int index) {
        return this.objectKey(this.groups, index);
    }

    @Nullable
    public final Object getGroupAux() {
        return this.currentGroup < this.currentEnd ? this.aux(this.groups, this.currentGroup) : Integer.valueOf(0);
    }

    @Nullable
    public final Object groupAux(int index) {
        return this.aux(this.groups, index);
    }

    public final boolean hasMark(int index) {
        int[] $this$hasMark$iv = this.groups;
        boolean $i$f$hasMark = false;
        return ($this$hasMark$iv[index * 5 + 1] & 0x8000000) != 0;
    }

    public final boolean containsMark(int index) {
        int[] $this$containsMark$iv = this.groups;
        boolean $i$f$containsMark = false;
        return ($this$containsMark$iv[index * 5 + 1] & 0x4000000) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getParentNodes() {
        int n;
        if (this.parent >= 0) {
            void $this$nodeCount$iv;
            int[] nArray = this.groups;
            int address$iv = this.parent;
            boolean $i$f$nodeCount = false;
            n = $this$nodeCount$iv[address$iv * 5 + 1] & 0x3FFFFFF;
        } else {
            n = 0;
        }
        return n;
    }

    public final int getRemainingSlots() {
        return this.currentSlotEnd - this.currentSlot;
    }

    @Nullable
    public final Object groupGet(int index) {
        return this.groupGet(this.currentGroup, index);
    }

    @Nullable
    public final Object groupGet(int group, int index) {
        int n;
        int start2 = SlotTableKt.access$slotAnchor(this.groups, group);
        int next2 = group + 1;
        if (next2 < this.groupsSize) {
            int[] $this$dataAnchor$iv = this.groups;
            boolean $i$f$dataAnchor = false;
            n = $this$dataAnchor$iv[next2 * 5 + 4];
        } else {
            n = this.slotsSize;
        }
        int end = n;
        int address = start2 + index;
        return address < end ? this.slots[address] : Composer.Companion.getEmpty();
    }

    @Nullable
    public final Object next() {
        if (this.emptyCount > 0 || this.currentSlot >= this.currentSlotEnd) {
            this.hadNext = false;
            return Composer.Companion.getEmpty();
        }
        this.hadNext = true;
        int n = this.currentSlot;
        this.currentSlot = n + 1;
        return this.slots[n];
    }

    public final boolean getHadNext() {
        return this.hadNext;
    }

    public final void beginEmpty() {
        int n = this.emptyCount;
        this.emptyCount = n + 1;
    }

    public final void endEmpty() {
        boolean value$iv = this.emptyCount > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Unbalanced begin/end empty");
        }
        int n = this.emptyCount;
        this.emptyCount = n + -1;
    }

    public final void close() {
        this.closed = true;
        this.table.close$runtime(this, this.sourceInformationMap);
    }

    /*
     * WARNING - void declaration
     */
    public final void startGroup() {
        if (this.emptyCount <= 0) {
            int n;
            Object object;
            int parent = this.parent;
            int currentGroup = this.currentGroup;
            int[] $this$parentAnchor$iv = this.groups;
            boolean $i$f$parentAnchor = false;
            boolean value$iv = $this$parentAnchor$iv[currentGroup * 5 + 2] == parent;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                PreconditionsKt.throwIllegalArgumentException("Invalid slot table detected");
            }
            if ((object = this.sourceInformationMap) != null && (object = ((HashMap)object).get(this.anchor(parent))) != null) {
                ((GroupSourceInformation)object).reportGroup(this.table, currentGroup);
            }
            IntStack currentSlotStack = this.currentSlotStack;
            int currentSlot = this.currentSlot;
            int currentEndSlot = this.currentSlotEnd;
            if (currentSlot == 0 && currentEndSlot == 0) {
                currentSlotStack.push(-1);
            } else {
                currentSlotStack.push(currentSlot);
            }
            this.parent = currentGroup;
            this.currentEnd = currentGroup + SlotTableKt.access$groupSize(this.groups, currentGroup);
            this.currentGroup = currentGroup + 1;
            this.currentSlot = SlotTableKt.access$slotAnchor(this.groups, currentGroup);
            if (currentGroup >= this.groupsSize - 1) {
                n = this.slotsSize;
            } else {
                void $this$dataAnchor$iv;
                int[] nArray = this.groups;
                int address$iv = currentGroup + 1;
                boolean $i$f$dataAnchor = false;
                n = $this$dataAnchor$iv[address$iv * 5 + 4];
            }
            this.currentSlotEnd = n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void startNode() {
        if (this.emptyCount <= 0) {
            void $this$isNode$iv;
            int[] nArray = this.groups;
            int address$iv = this.currentGroup;
            boolean $i$f$isNode = false;
            boolean value$iv = ($this$isNode$iv[address$iv * 5 + 1] & 0x40000000) != 0;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                PreconditionsKt.throwIllegalArgumentException("Expected a node group");
            }
            this.startGroup();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int skipGroup() {
        int n;
        int[] $this$isNode$iv;
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck22 = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot skip while in an empty region");
        }
        int[] $i$f$runtimeCheck22 = this.groups;
        int address$iv = this.currentGroup;
        boolean $i$f$isNode = false;
        if (($this$isNode$iv[address$iv * 5 + 1] & 0x40000000) != 0) {
            n = 1;
        } else {
            void $this$nodeCount$iv;
            $this$isNode$iv = this.groups;
            address$iv = this.currentGroup;
            boolean $i$f$nodeCount = false;
            n = $this$nodeCount$iv[address$iv * 5 + 1] & 0x3FFFFFF;
        }
        int count = n;
        this.currentGroup += SlotTableKt.access$groupSize(this.groups, this.currentGroup);
        return count;
    }

    public final void skipToGroupEnd() {
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot skip the enclosing group while in an empty region");
        }
        this.currentGroup = this.currentEnd;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void reposition(int index) {
        int parent;
        int n;
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot reposition while in an empty region");
        }
        this.currentGroup = index;
        if (index < this.groupsSize) {
            int[] $this$parentAnchor$iv = this.groups;
            boolean $i$f$parentAnchor = false;
            n = $this$parentAnchor$iv[index * 5 + 2];
        } else {
            n = -1;
        }
        this.parent = parent = n;
        this.currentEnd = parent < 0 ? this.groupsSize : parent + SlotTableKt.access$groupSize(this.groups, parent);
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void restoreParent(int index) {
        int newCurrentEnd = index + SlotTableKt.access$groupSize(this.groups, index);
        int current = this.currentGroup;
        boolean value$iv = current >= index && current <= newCurrentEnd;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Index " + index + " is not a parent of " + current);
        }
        this.parent = index;
        this.currentEnd = newCurrentEnd;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void endGroup() {
        if (this.emptyCount == 0) {
            void $this$parentAnchor$iv;
            boolean value$iv = this.currentGroup == this.currentEnd;
            boolean $i$f$runtimeCheck22 = false;
            if (!value$iv) {
                boolean bl = false;
                ComposerKt.composeImmediateRuntimeError("endGroup() not called at the end of a group");
            }
            int[] $i$f$runtimeCheck22 = this.groups;
            int address$iv = this.parent;
            boolean $i$f$parentAnchor2 = false;
            void parent = $this$parentAnchor$iv[address$iv * 5 + 2];
            this.parent = parent;
            this.currentEnd = parent < 0 ? this.groupsSize : parent + SlotTableKt.access$groupSize(this.groups, (int)parent);
            IntStack currentSlotStack = this.currentSlotStack;
            int newCurrentSlot = currentSlotStack.pop();
            if (newCurrentSlot < 0) {
                this.currentSlot = 0;
                this.currentSlotEnd = 0;
            } else {
                int n;
                this.currentSlot = newCurrentSlot;
                if (parent >= this.groupsSize - 1) {
                    n = this.slotsSize;
                } else {
                    void $this$dataAnchor$iv;
                    int[] $i$f$parentAnchor2 = this.groups;
                    void address$iv2 = parent + true;
                    boolean $i$f$dataAnchor = false;
                    n = $this$dataAnchor$iv[address$iv2 * 5 + 4];
                }
                this.currentSlotEnd = n;
            }
        }
    }

    @NotNull
    public final List<KeyInfo> extractKeys() {
        List result2 = new ArrayList();
        if (this.emptyCount > 0) {
            return result2;
        }
        int index = 0;
        for (int childIndex = this.currentGroup; childIndex < this.currentEnd; childIndex += SlotTableKt.access$groupSize(this.groups, childIndex)) {
            int n;
            int[] $this$key$iv = this.groups;
            boolean $i$f$key = false;
            int n2 = $this$key$iv[childIndex * 5];
            Object object = this.objectKey(this.groups, childIndex);
            int[] $this$isNode$iv = this.groups;
            boolean $i$f$isNode = false;
            if (($this$isNode$iv[childIndex * 5 + 1] & 0x40000000) != 0) {
                n = 1;
            } else {
                int[] $this$nodeCount$iv = this.groups;
                boolean $i$f$nodeCount = false;
                n = $this$nodeCount$iv[childIndex * 5 + 1] & 0x3FFFFFF;
            }
            result2.add(new KeyInfo(n2, object, childIndex, n, index++));
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return "SlotReader(current=" + this.currentGroup + ", key=" + this.getGroupKey() + ", parent=" + this.parent + ", end=" + this.currentEnd + ")";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        ArrayList<Anchor> arrayList = this.table.getAnchors$runtime();
        int effectiveSize$iv = this.groupsSize;
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index);
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            Object e = $this$getOrAdd$iv.get(location$iv);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    private final Object node(int[] $this$node, int index) {
        Object object;
        int[] $this$isNode$iv = $this$node;
        boolean $i$f$isNode = false;
        if (($this$isNode$iv[index * 5 + 1] & 0x40000000) != 0) {
            int[] $this$nodeIndex$iv = $this$node;
            boolean $i$f$nodeIndex = false;
            object = this.slots[$this$nodeIndex$iv[index * 5 + 4]];
        } else {
            object = Composer.Companion.getEmpty();
        }
        return object;
    }

    private final Object aux(int[] $this$aux, int index) {
        int[] $this$hasAux$iv = $this$aux;
        boolean $i$f$hasAux = false;
        return ($this$hasAux$iv[index * 5 + 1] & 0x10000000) != 0 ? this.slots[SlotTableKt.access$auxIndex($this$aux, index)] : Composer.Companion.getEmpty();
    }

    private final Object objectKey(int[] $this$objectKey, int index) {
        int[] $this$hasObjectKey$iv = $this$objectKey;
        boolean $i$f$hasObjectKey = false;
        return ($this$hasObjectKey$iv[index * 5 + 1] & 0x20000000) != 0 ? this.slots[SlotTableKt.access$objectKeyIndex($this$objectKey, index)] : null;
    }
}

