/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableGroup;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

final class GroupIterator
implements Iterator<CompositionGroup>,
KMappedMarker {
    @NotNull
    private final SlotTable table;
    private final int end;
    private int index;
    private final int version;

    public GroupIterator(@NotNull SlotTable table, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.end = end;
        this.index = start2;
        this.version = this.table.getVersion$runtime();
        if (this.table.getWriter$runtime()) {
            SlotTableKt.throwConcurrentModificationException();
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.end;
    }

    @Override
    @NotNull
    public CompositionGroup next() {
        this.validateRead();
        int group = this.index;
        this.index += SlotTableKt.access$groupSize(this.table.getGroups(), group);
        return new SlotTableGroup(this.table, group, this.version);
    }

    private final void validateRead() {
        if (this.table.getVersion$runtime() != this.version) {
            SlotTableKt.throwConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

