/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.CompositionLocalAccessorScope;
import androidx.compose.runtime.PersistentCompositionLocalMap;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.ValueHolder;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComputedValueHolder<T>
implements ValueHolder<T> {
    @NotNull
    private final Function1<CompositionLocalAccessorScope, T> compute;

    public ComputedValueHolder(@NotNull Function1<? super CompositionLocalAccessorScope, ? extends T> compute) {
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        this.compute = compute;
    }

    @NotNull
    public final Function1<CompositionLocalAccessorScope, T> getCompute() {
        return this.compute;
    }

    @Override
    public T readValue(@NotNull PersistentCompositionLocalMap map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        return (T)this.compute.invoke((Object)map2);
    }

    @Override
    @NotNull
    public ProvidedValue<T> toProvided(@NotNull CompositionLocal<T> local) {
        Intrinsics.checkNotNullParameter(local, (String)"local");
        return new ProvidedValue<Object>(local, null, false, null, null, this.compute, false);
    }

    @NotNull
    public String toString() {
        return "ComputedValueHolder(compute=" + this.compute + ")";
    }

    public int hashCode() {
        return this.compute.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComputedValueHolder)) {
            return false;
        }
        ComputedValueHolder computedValueHolder = (ComputedValueHolder)other;
        return Intrinsics.areEqual(this.compute, computedValueHolder.compute);
    }
}

