/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material.ripple;

import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.foundation.interaction.Interaction;
import androidx.compose.foundation.interaction.InteractionSource;
import androidx.compose.foundation.interaction.PressInteraction;
import androidx.compose.material.ripple.RippleAlpha;
import androidx.compose.material.ripple.RippleAnimationKt;
import androidx.compose.material.ripple.StateLayer;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ColorProducer;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.LayoutAwareModifierNode;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSizeKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nRipple.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ripple.kt\nandroidx/compose/material/ripple/RippleNode\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 4 ObjectList.kt\nandroidx/collection/ObjectList\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,530:1\n1516#2:531\n102#3:532\n287#4,6:533\n1#5:539\n*S KotlinDebug\n*F\n+ 1 Ripple.kt\nandroidx/compose/material/ripple/RippleNode\n*L\n338#1:531\n346#1:532\n358#1:533,6\n*E\n"})
public abstract class RippleNode
extends Modifier.Node
implements CompositionLocalConsumerModifierNode,
DrawModifierNode,
LayoutAwareModifierNode {
    @NotNull
    private final InteractionSource interactionSource;
    private final boolean bounded;
    private final float radius;
    @NotNull
    private final ColorProducer color;
    @NotNull
    private final Function0<RippleAlpha> rippleAlpha;
    private final boolean shouldAutoInvalidate;
    @Nullable
    private StateLayer stateLayer;
    private float targetRadius;
    private long rippleSize;
    private boolean hasValidSize;
    @NotNull
    private final MutableObjectList<PressInteraction> pendingInteractions;
    public static final int $stable = 8;

    private RippleNode(InteractionSource interactionSource, boolean bounded, float radius, ColorProducer color, Function0<RippleAlpha> rippleAlpha) {
        Intrinsics.checkNotNullParameter((Object)interactionSource, (String)"interactionSource");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(rippleAlpha, (String)"rippleAlpha");
        this.interactionSource = interactionSource;
        this.bounded = bounded;
        this.radius = radius;
        this.color = color;
        this.rippleAlpha = rippleAlpha;
        this.rippleSize = Size.Companion.getZero-NH-jbRc();
        boolean $i$f$mutableObjectListOf = false;
        this.pendingInteractions = new MutableObjectList(0, 1, null);
    }

    protected final boolean getBounded() {
        return this.bounded;
    }

    @NotNull
    protected final Function0<RippleAlpha> getRippleAlpha() {
        return this.rippleAlpha;
    }

    @Override
    public final boolean getShouldAutoInvalidate() {
        return this.shouldAutoInvalidate;
    }

    public final long getRippleColor-0d7_KjU() {
        return this.color.invoke-0d7_KjU();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRemeasured-ozmzZPI(long size) {
        void $this$onRemeasured_ozmzZPI_u24lambda_u240;
        this.hasValidSize = true;
        Density density = DelegatableNodeKt.requireDensity(this);
        this.rippleSize = IntSizeKt.toSize-ozmzZPI(size);
        Density density2 = density;
        RippleNode rippleNode = this;
        boolean bl = false;
        float $this$isUnspecified$iv = this.radius;
        boolean bl2 = false;
        float f = Float.isNaN($this$isUnspecified$iv) ? RippleAnimationKt.getRippleEndRadius-cSwnlzA((Density)$this$onRemeasured_ozmzZPI_u24lambda_u240, this.bounded, this.rippleSize) : $this$onRemeasured_ozmzZPI_u24lambda_u240.toPx-0680j_4(this.radius);
        rippleNode.targetRadius = f;
        ObjectList this_$iv = (ObjectList)this.pendingInteractions;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            PressInteraction it = (PressInteraction)content$iv[i$iv];
            boolean bl3 = false;
            this.handlePressInteraction(it);
        }
        this.pendingInteractions.clear();
    }

    @Override
    public void onAttach() {
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RippleNode this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = RippleNode.access$getInteractionSource$p(this.this$0).getInteractions().collect(new FlowCollector(this.this$0, $this$launch){
                            final /* synthetic */ RippleNode this$0;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            {
                                this.this$0 = $receiver;
                                this.$$this$launch = $$this$launch;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(Interaction interaction, Continuation<? super Unit> $completion) {
                                if (interaction instanceof PressInteraction) {
                                    if (RippleNode.access$getHasValidSize$p(this.this$0)) {
                                        RippleNode.access$handlePressInteraction(this.this$0, (PressInteraction)interaction);
                                    } else {
                                        void this_$iv;
                                        MutableObjectList mutableObjectList = RippleNode.access$getPendingInteractions$p(this.this$0);
                                        Interaction element$iv = interaction;
                                        boolean $i$f$plusAssign = false;
                                        this_$iv.add((Object)element$iv);
                                    }
                                } else {
                                    RippleNode.access$updateStateLayer(this.this$0, interaction, this.$$this$launch);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void handlePressInteraction(PressInteraction pressInteraction) {
        PressInteraction pressInteraction2 = pressInteraction;
        if (pressInteraction2 instanceof PressInteraction.Press) {
            this.addRipple-12SF9DM((PressInteraction.Press)pressInteraction, this.rippleSize, this.targetRadius);
        } else if (pressInteraction2 instanceof PressInteraction.Release) {
            this.removeRipple(((PressInteraction.Release)pressInteraction).getPress());
        } else if (pressInteraction2 instanceof PressInteraction.Cancel) {
            this.removeRipple(((PressInteraction.Cancel)pressInteraction).getPress());
        }
    }

    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        $this$draw.drawContent();
        StateLayer stateLayer = this.stateLayer;
        if (stateLayer != null) {
            StateLayer $this$draw_u24lambda_u242 = stateLayer;
            boolean bl = false;
            $this$draw_u24lambda_u242.drawStateLayer-mxwnekA($this$draw, this.targetRadius, this.getRippleColor-0d7_KjU());
        }
        this.drawRipples($this$draw);
    }

    public abstract void drawRipples(@NotNull DrawScope var1);

    public abstract void addRipple-12SF9DM(@NotNull PressInteraction.Press var1, long var2, float var4);

    public abstract void removeRipple(@NotNull PressInteraction.Press var1);

    private final void updateStateLayer(Interaction interaction, CoroutineScope scope2) {
        StateLayer stateLayer = this.stateLayer;
        if (stateLayer == null) {
            StateLayer stateLayer2;
            StateLayer instance2 = stateLayer2 = new StateLayer(this.bounded, this.rippleAlpha);
            boolean bl = false;
            DrawModifierNodeKt.invalidateDraw(this);
            this.stateLayer = instance2;
            stateLayer = stateLayer2;
        }
        StateLayer stateLayer3 = stateLayer;
        stateLayer3.handleInteraction$material_ripple(interaction, scope2);
    }

    public /* synthetic */ RippleNode(InteractionSource interactionSource, boolean bounded, float radius, ColorProducer color, Function0 rippleAlpha, DefaultConstructorMarker $constructor_marker) {
        this(interactionSource, bounded, radius, color, (Function0<RippleAlpha>)rippleAlpha);
    }

    public static final /* synthetic */ InteractionSource access$getInteractionSource$p(RippleNode $this) {
        return $this.interactionSource;
    }

    public static final /* synthetic */ boolean access$getHasValidSize$p(RippleNode $this) {
        return $this.hasValidSize;
    }

    public static final /* synthetic */ void access$handlePressInteraction(RippleNode $this, PressInteraction pressInteraction) {
        $this.handlePressInteraction(pressInteraction);
    }

    public static final /* synthetic */ MutableObjectList access$getPendingInteractions$p(RippleNode $this) {
        return $this.pendingInteractions;
    }

    public static final /* synthetic */ void access$updateStateLayer(RippleNode $this, Interaction interaction, CoroutineScope scope2) {
        $this.updateStateLayer(interaction, scope2);
    }
}

