/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.v2;

import androidx.compose.foundation.v2.ScrollbarAdapter;
import androidx.compose.foundation.v2.Scrollbar_desktopKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nScrollbar.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scrollbar.skiko.kt\nandroidx/compose/foundation/v2/LazyLineContentAdapter\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,501:1\n85#2:502\n*S KotlinDebug\n*F\n+ 1 Scrollbar.skiko.kt\nandroidx/compose/foundation/v2/LazyLineContentAdapter\n*L\n162#1:502\n*E\n"})
public abstract class LazyLineContentAdapter
implements ScrollbarAdapter {
    @NotNull
    private final State averageVisibleLineSize$delegate = SnapshotStateKt.derivedStateOf(() -> LazyLineContentAdapter.averageVisibleLineSize_delegate$lambda$0(this));

    @Nullable
    protected abstract VisibleLine firstVisibleLine();

    protected abstract int totalLineCount();

    protected abstract int contentPadding();

    @Nullable
    protected abstract Object snapToLine(int var1, int var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    protected abstract Object scrollBy(float var1, @NotNull Continuation<? super Unit> var2);

    protected abstract double averageVisibleLineSize();

    protected abstract int getLineSpacing();

    /*
     * WARNING - void declaration
     */
    private final double getAverageVisibleLineSize() {
        void $this$getValue$iv;
        State state2 = this.averageVisibleLineSize$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).doubleValue();
    }

    private final double getAverageVisibleLineSizeWithSpacing() {
        return this.getAverageVisibleLineSize() + (double)this.getLineSpacing();
    }

    @Override
    public double getScrollOffset() {
        VisibleLine firstVisibleLine = this.firstVisibleLine();
        return firstVisibleLine == null ? 0.0 : (double)firstVisibleLine.getIndex() * this.getAverageVisibleLineSizeWithSpacing() - (double)firstVisibleLine.getOffset();
    }

    @Override
    public double getContentSize() {
        int totalLineCount = this.totalLineCount();
        return this.getAverageVisibleLineSize() * (double)totalLineCount + (double)(this.getLineSpacing() * RangesKt.coerceAtLeast((int)(totalLineCount - 1), (int)0)) + (double)this.contentPadding();
    }

    @Override
    @Nullable
    public Object scrollTo(double scrollOffset, @NotNull Continuation<? super Unit> $completion) {
        return LazyLineContentAdapter.scrollTo$suspendImpl(this, scrollOffset, $completion);
    }

    static /* synthetic */ Object scrollTo$suspendImpl(LazyLineContentAdapter $this, double scrollOffset, Continuation<? super Unit> $completion) {
        double distance = scrollOffset - $this.getScrollOffset();
        if (Math.abs(distance) <= $this.getViewportSize()) {
            Object object = $this.scrollBy((float)distance, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = $this.snapTo(scrollOffset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object snapTo(double scrollOffset, Continuation<? super Unit> $completion) {
        double scrollOffsetCoerced = RangesKt.coerceIn((double)scrollOffset, (double)0.0, (double)Scrollbar_desktopKt.getMaxScrollOffset(this));
        int index = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)((int)(scrollOffsetCoerced / this.getAverageVisibleLineSizeWithSpacing())), (int)0), (int)(this.totalLineCount() - 1));
        int offset = RangesKt.coerceAtLeast((int)((int)(scrollOffsetCoerced - (double)index * this.getAverageVisibleLineSizeWithSpacing())), (int)0);
        Object object = this.snapToLine(index, offset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final double averageVisibleLineSize_delegate$lambda$0(LazyLineContentAdapter this$0) {
        return this$0.totalLineCount() == 0 ? 0.0 : this$0.averageVisibleLineSize();
    }

    public static final class VisibleLine {
        private final int index;
        private final int offset;

        public VisibleLine(int index, int offset) {
            this.index = index;
            this.offset = offset;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int getOffset() {
            return this.offset;
        }
    }
}

