/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionAdjustment;
import androidx.compose.foundation.text.selection.SelectionAdjustmentKt;
import androidx.compose.foundation.text.selection.SelectionLayout;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public interface SelectionAdjustment {
    @NotNull
    public static final Companion Companion = androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.$$INSTANCE;

    @NotNull
    public Selection adjust(@NotNull SelectionLayout var1);

    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final SelectionAdjustment None;
        @NotNull
        private static final SelectionAdjustment Character;
        @NotNull
        private static final SelectionAdjustment Word;
        @NotNull
        private static final SelectionAdjustment Paragraph;
        @NotNull
        private static final SelectionAdjustment CharacterWithWordAccelerate;

        private Companion() {
        }

        @NotNull
        public final SelectionAdjustment getNone() {
            return None;
        }

        @NotNull
        public final SelectionAdjustment getWord() {
            return Word;
        }

        @NotNull
        public final SelectionAdjustment getParagraph() {
            return Paragraph;
        }

        @NotNull
        public final SelectionAdjustment getCharacterWithWordAccelerate() {
            return CharacterWithWordAccelerate;
        }

        private static final Selection None$lambda$0(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return new Selection(layout2.getStartInfo().anchorForOffset(layout2.getStartInfo().getRawStartHandleOffset()), layout2.getEndInfo().anchorForOffset(layout2.getEndInfo().getRawEndHandleOffset()), layout2.getCrossStatus() == CrossStatus.CROSSED);
        }

        private static final Selection Character$lambda$1(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return SelectionAdjustmentKt.ensureAtLeastOneChar(None.adjust(layout2), layout2);
        }

        private static final Selection Word$lambda$2(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return SelectionAdjustmentKt.access$adjustToBoundaries(layout2, Word.1.1.INSTANCE);
        }

        private static final Selection Paragraph$lambda$3(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return SelectionAdjustmentKt.access$adjustToBoundaries(layout2, Paragraph.1.1.INSTANCE);
        }

        private static final Selection CharacterWithWordAccelerate$lambda$4(SelectionLayout layout2) {
            Selection selection;
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            Selection selection2 = layout2.getPreviousSelection();
            if (selection2 == null) {
                return Word.adjust(layout2);
            }
            Selection previousSelection = selection2;
            Selection.AnchorInfo previousAnchor = null;
            Selection.AnchorInfo newAnchor = null;
            Selection.AnchorInfo startAnchor = null;
            Selection.AnchorInfo endAnchor = null;
            if (layout2.isStartHandle()) {
                previousAnchor = previousSelection.getStart();
                startAnchor = newAnchor = SelectionAdjustmentKt.access$updateSelectionBoundary(layout2, layout2.getStartInfo(), previousAnchor);
                endAnchor = previousSelection.getEnd();
            } else {
                previousAnchor = previousSelection.getEnd();
                newAnchor = SelectionAdjustmentKt.access$updateSelectionBoundary(layout2, layout2.getEndInfo(), previousAnchor);
                startAnchor = previousSelection.getStart();
                endAnchor = newAnchor;
            }
            if (Intrinsics.areEqual((Object)newAnchor, (Object)previousAnchor)) {
                selection = previousSelection;
            } else {
                boolean crossed = layout2.getCrossStatus() == CrossStatus.CROSSED || layout2.getCrossStatus() == CrossStatus.COLLAPSED && startAnchor.getOffset() > endAnchor.getOffset();
                selection = SelectionAdjustmentKt.ensureAtLeastOneChar(new Selection(startAnchor, endAnchor, crossed), layout2);
            }
            return selection;
        }

        static {
            $$INSTANCE = new Companion();
            None = Companion::None$lambda$0;
            Character = Companion::Character$lambda$1;
            Word = Companion::Word$lambda$2;
            Paragraph = Companion::Paragraph$lambda$3;
            CharacterWithWordAccelerate = Companion::CharacterWithWordAccelerate$lambda$4;
        }
    }
}

