/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Selection {
    @NotNull
    private final AnchorInfo start;
    @NotNull
    private final AnchorInfo end;
    private final boolean handlesCrossed;

    public Selection(@NotNull AnchorInfo start2, @NotNull AnchorInfo end, boolean handlesCrossed) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start2;
        this.end = end;
        this.handlesCrossed = handlesCrossed;
    }

    @NotNull
    public final AnchorInfo getStart() {
        return this.start;
    }

    @NotNull
    public final AnchorInfo getEnd() {
        return this.end;
    }

    public final boolean getHandlesCrossed() {
        return this.handlesCrossed;
    }

    @NotNull
    public final Selection merge(@Nullable Selection other) {
        if (other == null) {
            return this;
        }
        Selection selection = this;
        return this.handlesCrossed || other.handlesCrossed ? new Selection(other.handlesCrossed ? other.start : other.end, this.handlesCrossed ? this.end : this.start, true) : Selection.copy$default(selection, null, other.end, false, 5, null);
    }

    public final long toTextRange-d9O1mEE() {
        return TextRangeKt.TextRange(this.start.getOffset(), this.end.getOffset());
    }

    @NotNull
    public final Selection copy(@NotNull AnchorInfo start2, @NotNull AnchorInfo end, boolean handlesCrossed) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new Selection(start2, end, handlesCrossed);
    }

    public static /* synthetic */ Selection copy$default(Selection selection, AnchorInfo anchorInfo, AnchorInfo anchorInfo2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            anchorInfo = selection.start;
        }
        if ((n & 2) != 0) {
            anchorInfo2 = selection.end;
        }
        if ((n & 4) != 0) {
            bl = selection.handlesCrossed;
        }
        return selection.copy(anchorInfo, anchorInfo2, bl);
    }

    @NotNull
    public String toString() {
        return "Selection(start=" + this.start + ", end=" + this.end + ", handlesCrossed=" + this.handlesCrossed + ")";
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + this.end.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.handlesCrossed);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Selection)) {
            return false;
        }
        Selection selection = (Selection)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)selection.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)selection.end)) {
            return false;
        }
        return this.handlesCrossed == selection.handlesCrossed;
    }

    public static final class AnchorInfo {
        @NotNull
        private final ResolvedTextDirection direction;
        private final int offset;
        private final long selectableId;

        public AnchorInfo(@NotNull ResolvedTextDirection direction, int offset, long selectableId) {
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            this.direction = direction;
            this.offset = offset;
            this.selectableId = selectableId;
        }

        @NotNull
        public final ResolvedTextDirection getDirection() {
            return this.direction;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final long getSelectableId() {
            return this.selectableId;
        }

        @NotNull
        public final AnchorInfo copy(@NotNull ResolvedTextDirection direction, int offset, long selectableId) {
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            return new AnchorInfo(direction, offset, selectableId);
        }

        public static /* synthetic */ AnchorInfo copy$default(AnchorInfo anchorInfo, ResolvedTextDirection resolvedTextDirection, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                resolvedTextDirection = anchorInfo.direction;
            }
            if ((n2 & 2) != 0) {
                n = anchorInfo.offset;
            }
            if ((n2 & 4) != 0) {
                l = anchorInfo.selectableId;
            }
            return anchorInfo.copy(resolvedTextDirection, n, l);
        }

        @NotNull
        public String toString() {
            return "AnchorInfo(direction=" + this.direction + ", offset=" + this.offset + ", selectableId=" + this.selectableId + ")";
        }

        public int hashCode() {
            int result2 = this.direction.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.offset);
            result2 = result2 * 31 + Long.hashCode(this.selectableId);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnchorInfo)) {
                return false;
            }
            AnchorInfo anchorInfo = (AnchorInfo)other;
            if (this.direction != anchorInfo.direction) {
                return false;
            }
            if (this.offset != anchorInfo.offset) {
                return false;
            }
            return this.selectableId == anchorInfo.selectableId;
        }
    }
}

