/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.modifiers.TextStringSimpleNode;
import androidx.compose.ui.graphics.ColorProducer;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextStringSimpleElement
extends ModifierNodeElement<TextStringSimpleNode> {
    @NotNull
    private final String text;
    @NotNull
    private final TextStyle style;
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    private final int overflow;
    private final boolean softWrap;
    private final int maxLines;
    private final int minLines;
    @Nullable
    private final ColorProducer color;

    private TextStringSimpleElement(String text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, int overflow, boolean softWrap, int maxLines, int minLines, ColorProducer color) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.style = style;
        this.fontFamilyResolver = fontFamilyResolver;
        this.overflow = overflow;
        this.softWrap = softWrap;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.color = color;
    }

    @Override
    @NotNull
    public TextStringSimpleNode create() {
        return new TextStringSimpleNode(this.text, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines, this.color, null);
    }

    @Override
    public void update(@NotNull TextStringSimpleNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.doInvalidations(node2.updateDraw(this.color, this.style), node2.updateText(this.text), node2.updateLayoutRelatedArgs-HuAbxIM(this.style, this.minLines, this.maxLines, this.softWrap, this.fontFamilyResolver, this.overflow));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextStringSimpleElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.color, (Object)((TextStringSimpleElement)other).color)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((TextStringSimpleElement)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.style, (Object)((TextStringSimpleElement)other).style)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontFamilyResolver, (Object)((TextStringSimpleElement)other).fontFamilyResolver)) {
            return false;
        }
        if (!TextOverflow.equals-impl0(this.overflow, ((TextStringSimpleElement)other).overflow)) {
            return false;
        }
        if (this.softWrap != ((TextStringSimpleElement)other).softWrap) {
            return false;
        }
        if (this.maxLines != ((TextStringSimpleElement)other).maxLines) {
            return false;
        }
        return this.minLines == ((TextStringSimpleElement)other).minLines;
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = 31 * result2 + this.style.hashCode();
        result2 = 31 * result2 + this.fontFamilyResolver.hashCode();
        result2 = 31 * result2 + TextOverflow.hashCode-impl(this.overflow);
        result2 = 31 * result2 + Boolean.hashCode(this.softWrap);
        result2 = 31 * result2 + this.maxLines;
        result2 = 31 * result2 + this.minLines;
        ColorProducer colorProducer2 = this.color;
        result2 = 31 * result2 + (colorProducer2 != null ? colorProducer2.hashCode() : 0);
        return result2;
    }

    public /* synthetic */ TextStringSimpleElement(String text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, int overflow, boolean softWrap, int maxLines, int minLines, ColorProducer color, DefaultConstructorMarker $constructor_marker) {
        this(text2, style, fontFamilyResolver, overflow, softWrap, maxLines, minLines, color);
    }
}

