/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.TextPointerIcon_skikoKt;
import androidx.compose.foundation.text.modifiers.SelectionController_jvmKt;
import androidx.compose.foundation.text.modifiers.StaticTextSelectionParams;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegate;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.input.pointer.PointerIconKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,358:1\n202#2,4:359\n206#2:366\n207#2,3:369\n249#2,14:372\n57#3:363\n61#3:367\n60#4:364\n70#4:368\n22#5:365\n*S KotlinDebug\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n*L\n162#1:359,4\n162#1:366\n162#1:369,3\n162#1:372,14\n162#1:363\n162#1:367\n162#1:364\n162#1:368\n162#1:365\n*E\n"})
public final class SelectionController
implements RememberObserver {
    private final long selectableId;
    @NotNull
    private final SelectionRegistrar selectionRegistrar;
    private final long backgroundSelectionColor;
    @NotNull
    private StaticTextSelectionParams params;
    @Nullable
    private Selectable selectable;
    @NotNull
    private final Modifier modifier;
    public static final int $stable = 8;

    private SelectionController(long selectableId, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params2) {
        Intrinsics.checkNotNullParameter((Object)selectionRegistrar, (String)"selectionRegistrar");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        this.selectableId = selectableId;
        this.selectionRegistrar = selectionRegistrar;
        this.backgroundSelectionColor = backgroundSelectionColor;
        this.params = params2;
        this.modifier = PointerIconKt.pointerHoverIcon$default(SelectionController_jvmKt.makeSelectionModifier(this.selectionRegistrar, this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)() -> SelectionController.modifier$lambda$0(this))), TextPointerIcon_skikoKt.getTextPointerIcon(), false, 2, null);
    }

    public /* synthetic */ SelectionController(long l, SelectionRegistrar selectionRegistrar, long l2, StaticTextSelectionParams staticTextSelectionParams, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            staticTextSelectionParams = StaticTextSelectionParams.Companion.getEmpty();
        }
        this(l, selectionRegistrar, l2, staticTextSelectionParams, null);
    }

    @NotNull
    public final Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public void onRemembered() {
        this.selectable = this.selectionRegistrar.subscribe(new MultiWidgetSelectionDelegate(this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)() -> SelectionController.onRemembered$lambda$1(this)), (Function0<TextLayoutResult>)((Function0)() -> SelectionController.onRemembered$lambda$2(this))));
    }

    @Override
    public void onForgotten() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            this.selectionRegistrar.unsubscribe(localSelectable);
            this.selectable = null;
        }
    }

    @Override
    public void onAbandoned() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            this.selectionRegistrar.unsubscribe(localSelectable);
            this.selectable = null;
        }
    }

    public final void updateTextLayout(@NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        TextLayoutResult prevTextLayoutResult = this.params.getTextLayoutResult();
        if (prevTextLayoutResult != null && !Intrinsics.areEqual((Object)prevTextLayoutResult.getLayoutInput().getText(), (Object)textLayoutResult.getLayoutInput().getText())) {
            this.selectionRegistrar.notifySelectableChange(this.selectableId);
        }
        this.params = StaticTextSelectionParams.copy$default(this.params, null, textLayoutResult, 1, null);
    }

    public final void updateGlobalPosition(@NotNull LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.params = StaticTextSelectionParams.copy$default(this.params, coordinates, null, 2, null);
        this.selectionRegistrar.notifyPositionChange(this.selectableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(@NotNull DrawScope drawScope) {
        int end;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Selection selection = (Selection)this.selectionRegistrar.getSubselections().get(this.selectableId);
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        int start2 = !selection2.getHandlesCrossed() ? selection2.getStart().getOffset() : selection2.getEnd().getOffset();
        int n = end = !selection2.getHandlesCrossed() ? selection2.getEnd().getOffset() : selection2.getStart().getOffset();
        if (start2 == end) {
            return;
        }
        Selectable selectable = this.selectable;
        int lastOffset = selectable != null ? selectable.getLastVisibleOffset() : 0;
        int clippedStart = RangesKt.coerceAtMost((int)start2, (int)lastOffset);
        int clippedEnd = RangesKt.coerceAtMost((int)end, (int)lastOffset);
        Path path2 = this.params.getPathForRange(clippedStart, clippedEnd);
        if (path2 == null) {
            return;
        }
        Path selectionPath = path2;
        DrawScope $this$draw_u24lambda_u244 = drawScope;
        boolean bl = false;
        if (this.params.getShouldClip()) {
            DrawScope $this$clipRect_u2drOu3jXo_u24default$iv = $this$draw_u24lambda_u244;
            float left$iv = 0.0f;
            float top$iv = 0.0f;
            long arg0$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc();
            boolean bl2 = false;
            long value$iv$iv$iv = arg0$iv$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv$iv = (int)(value$iv$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float right$iv = Float.intBitsToFloat(bits$iv$iv$iv$iv);
            arg0$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc();
            boolean bl3 = false;
            value$iv$iv$iv = arg0$iv$iv;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv$iv = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            float bottom$iv = Float.intBitsToFloat(bits$iv$iv$iv$iv);
            int clipOp$iv = ClipOp.Companion.getIntersect-rtfAjoo();
            boolean bl4 = false;
            DrawScope $this$withTransform$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv;
            boolean $i$f$withTransform = false;
            DrawContext $this$withTransform_u24lambda_u246$iv$iv = $this$withTransform$iv$iv.getDrawContext();
            boolean bl5 = false;
            long previousSize$iv$iv = $this$withTransform_u24lambda_u246$iv$iv.getSize-NH-jbRc();
            $this$withTransform_u24lambda_u246$iv$iv.getCanvas().save();
            try {
                DrawTransform $this$clipRect_rOu3jXo_u24lambda_u244$iv = $this$withTransform_u24lambda_u246$iv$iv.getTransform();
                boolean bl6 = false;
                $this$clipRect_rOu3jXo_u24lambda_u244$iv.clipRect-N_I0leg(left$iv, top$iv, right$iv, bottom$iv, clipOp$iv);
                DrawScope $this$draw_u24lambda_u244_u24lambda_u243 = $this$withTransform$iv$iv;
                boolean bl7 = false;
                DrawScope.drawPath-LG529CI$default($this$draw_u24lambda_u244_u24lambda_u243, selectionPath, this.backgroundSelectionColor, 0.0f, null, null, 0, 60, null);
            }
            finally {
                $this$withTransform_u24lambda_u246$iv$iv.getCanvas().restore();
                $this$withTransform_u24lambda_u246$iv$iv.setSize-uvyYCjk(previousSize$iv$iv);
            }
        } else {
            DrawScope.drawPath-LG529CI$default($this$draw_u24lambda_u244, selectionPath, this.backgroundSelectionColor, 0.0f, null, null, 0, 60, null);
        }
    }

    private static final LayoutCoordinates modifier$lambda$0(SelectionController this$0) {
        return this$0.params.getLayoutCoordinates();
    }

    private static final LayoutCoordinates onRemembered$lambda$1(SelectionController this$0) {
        return this$0.params.getLayoutCoordinates();
    }

    private static final TextLayoutResult onRemembered$lambda$2(SelectionController this$0) {
        return this$0.params.getTextLayoutResult();
    }

    public /* synthetic */ SelectionController(long selectableId, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params2, DefaultConstructorMarker $constructor_marker) {
        this(selectableId, selectionRegistrar, backgroundSelectionColor, params2);
    }
}

