/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.LegacyTextFieldState;
import androidx.compose.foundation.text.input.internal.CoreTextFieldSemanticsModifierNode;
import androidx.compose.foundation.text.selection.TextFieldSelectionManager;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TransformedText;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoreTextFieldSemanticsModifier
extends ModifierNodeElement<CoreTextFieldSemanticsModifierNode> {
    @NotNull
    private final TransformedText transformedText;
    @NotNull
    private final TextFieldValue value;
    @NotNull
    private final LegacyTextFieldState state;
    private final boolean readOnly;
    private final boolean enabled;
    private final boolean isPassword;
    @NotNull
    private final OffsetMapping offsetMapping;
    @NotNull
    private final TextFieldSelectionManager manager;
    @NotNull
    private final ImeOptions imeOptions;
    @NotNull
    private final FocusRequester focusRequester;

    public CoreTextFieldSemanticsModifier(@NotNull TransformedText transformedText, @NotNull TextFieldValue value2, @NotNull LegacyTextFieldState state2, boolean readOnly, boolean enabled, boolean isPassword, @NotNull OffsetMapping offsetMapping, @NotNull TextFieldSelectionManager manager2, @NotNull ImeOptions imeOptions, @NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        this.transformedText = transformedText;
        this.value = value2;
        this.state = state2;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.isPassword = isPassword;
        this.offsetMapping = offsetMapping;
        this.manager = manager2;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
    }

    @Override
    @NotNull
    public CoreTextFieldSemanticsModifierNode create() {
        return new CoreTextFieldSemanticsModifierNode(this.transformedText, this.value, this.state, this.readOnly, this.enabled, this.isPassword, this.offsetMapping, this.manager, this.imeOptions, this.focusRequester);
    }

    @Override
    public void update(@NotNull CoreTextFieldSemanticsModifierNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.updateNodeSemantics(this.transformedText, this.value, this.state, this.readOnly, this.enabled, this.isPassword, this.offsetMapping, this.manager, this.imeOptions, this.focusRequester);
    }

    @NotNull
    public String toString() {
        return "CoreTextFieldSemanticsModifier(transformedText=" + this.transformedText + ", value=" + this.value + ", state=" + this.state + ", readOnly=" + this.readOnly + ", enabled=" + this.enabled + ", isPassword=" + this.isPassword + ", offsetMapping=" + this.offsetMapping + ", manager=" + this.manager + ", imeOptions=" + this.imeOptions + ", focusRequester=" + this.focusRequester + ")";
    }

    public int hashCode() {
        int result2 = this.transformedText.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        result2 = result2 * 31 + this.state.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.readOnly);
        result2 = result2 * 31 + Boolean.hashCode(this.enabled);
        result2 = result2 * 31 + Boolean.hashCode(this.isPassword);
        result2 = result2 * 31 + this.offsetMapping.hashCode();
        result2 = result2 * 31 + this.manager.hashCode();
        result2 = result2 * 31 + this.imeOptions.hashCode();
        result2 = result2 * 31 + this.focusRequester.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CoreTextFieldSemanticsModifier)) {
            return false;
        }
        CoreTextFieldSemanticsModifier coreTextFieldSemanticsModifier = (CoreTextFieldSemanticsModifier)other;
        if (!Intrinsics.areEqual((Object)this.transformedText, (Object)coreTextFieldSemanticsModifier.transformedText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)coreTextFieldSemanticsModifier.value)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)coreTextFieldSemanticsModifier.state)) {
            return false;
        }
        if (this.readOnly != coreTextFieldSemanticsModifier.readOnly) {
            return false;
        }
        if (this.enabled != coreTextFieldSemanticsModifier.enabled) {
            return false;
        }
        if (this.isPassword != coreTextFieldSemanticsModifier.isPassword) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.offsetMapping, (Object)coreTextFieldSemanticsModifier.offsetMapping)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.manager, (Object)coreTextFieldSemanticsModifier.manager)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.imeOptions, (Object)coreTextFieldSemanticsModifier.imeOptions)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.focusRequester, (Object)coreTextFieldSemanticsModifier.focusRequester);
    }
}

