/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.TextDelegate;
import androidx.compose.foundation.text.TextFieldDelegateKt;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.SelectionManagerKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextPainter;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditProcessor;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputService;
import androidx.compose.ui.text.input.TextInputSession;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextFieldDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @SourceDebugExtension(value={"SMAP\nTextFieldDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldDelegate.kt\nandroidx/compose/foundation/text/TextFieldDelegate$Companion\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n*L\n1#1,455:1\n54#2:456\n59#2:458\n85#3:457\n90#3:459\n1#4:460\n640#5:461\n*S KotlinDebug\n*F\n+ 1 TextFieldDelegate.kt\nandroidx/compose/foundation/text/TextFieldDelegate$Companion\n*L\n111#1:456\n111#1:458\n111#1:457\n111#1:459\n150#1:461\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Triple<Integer, Integer, TextLayoutResult> layout-_EkL_-Y$foundation(@NotNull TextDelegate textDelegate, long constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText) {
            Intrinsics.checkNotNullParameter((Object)textDelegate, (String)"textDelegate");
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            TextLayoutResult layoutResult = textDelegate.layout-NN6Ew-U(constraints, layoutDirection, prevResultText);
            long arg0$iv = layoutResult.getSize-YbymL2g();
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            Integer n = (int)(value$iv$iv >> 32);
            arg0$iv = layoutResult.getSize-YbymL2g();
            boolean bl2 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            return new Triple((Object)n, (Object)((int)(value$iv$iv & 0xFFFFFFFFL)), (Object)layoutResult);
        }

        @JvmStatic
        public final void draw-Q1vqE60$foundation(@NotNull Canvas canvas, @NotNull TextFieldValue value2, long selectionPreviewHighlightRange, long deletionPreviewHighlightRange, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Paint highlightPaint, long selectionBackgroundColor) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            Intrinsics.checkNotNullParameter((Object)highlightPaint, (String)"highlightPaint");
            if (!TextRange.getCollapsed-impl(selectionPreviewHighlightRange)) {
                highlightPaint.setColor-8_81llA(selectionBackgroundColor);
                this.drawHighlight-Le-punE(canvas, selectionPreviewHighlightRange, offsetMapping, textLayoutResult, highlightPaint);
            } else if (!TextRange.getCollapsed-impl(deletionPreviewHighlightRange)) {
                Color color = Color.box-impl(textLayoutResult.getLayoutInput().getStyle().getColor-0d7_KjU());
                long it = color.unbox-impl();
                boolean bl = false;
                long $this$isUnspecified$iv = it;
                boolean bl2 = false;
                Color color2 = !($this$isUnspecified$iv == 16L) ? color : null;
                long textColor = color2 != null ? color2.unbox-impl() : Color.Companion.getBlack-0d7_KjU();
                highlightPaint.setColor-8_81llA(Color.copy-wmQWz5c$default(textColor, Color.getAlpha-impl(textColor) * 0.2f, 0.0f, 0.0f, 0.0f, 14, null));
                this.drawHighlight-Le-punE(canvas, deletionPreviewHighlightRange, offsetMapping, textLayoutResult, highlightPaint);
            } else if (!TextRange.getCollapsed-impl(value2.getSelection-d9O1mEE())) {
                highlightPaint.setColor-8_81llA(selectionBackgroundColor);
                this.drawHighlight-Le-punE(canvas, value2.getSelection-d9O1mEE(), offsetMapping, textLayoutResult, highlightPaint);
            }
            TextPainter.INSTANCE.paint(canvas, textLayoutResult);
        }

        private final void drawHighlight-Le-punE(Canvas canvas, long range, OffsetMapping offsetMapping, TextLayoutResult textLayoutResult, Paint paint) {
            int end;
            int start2 = offsetMapping.originalToTransformed(TextRange.getMin-impl(range));
            if (start2 != (end = offsetMapping.originalToTransformed(TextRange.getMax-impl(range)))) {
                Path selectionPath = textLayoutResult.getPathForRange(start2, end);
                canvas.drawPath(selectionPath, paint);
            }
        }

        @JvmStatic
        public final void notifyFocusedRect$foundation(@NotNull TextFieldValue value2, @NotNull TextDelegate textDelegate, @NotNull TextLayoutResult textLayoutResult, @NotNull LayoutCoordinates layoutCoordinates, @NotNull TextInputSession textInputSession2, boolean hasFocus, @NotNull OffsetMapping offsetMapping) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)textDelegate, (String)"textDelegate");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"layoutCoordinates");
            Intrinsics.checkNotNullParameter((Object)textInputSession2, (String)"textInputSession");
            Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
            if (!hasFocus) {
                return;
            }
            int n = offsetMapping.originalToTransformed(TextRange.getMax-impl(value2.getSelection-d9O1mEE()));
            KFunction kFunction = (KFunction)new Function1<Offset, Offset>((Object)layoutCoordinates){

                public final long invoke-MK-Hz9U(long p0) {
                    return ((LayoutCoordinates)this.receiver).localToRoot-MK-Hz9U(p0);
                }
            };
            textInputSession2.notifyFocusedRect(TextFieldDelegateKt.focusedRectInRoot(textLayoutResult, n, (Function1<? super Offset, Offset>)((Function1)kFunction), (Function0<IntSize>)((Function0)() -> Companion.notifyFocusedRect$lambda$1(textDelegate))));
        }

        @JvmStatic
        public final void updateTextLayoutResult$foundation(@NotNull TextInputSession textInputSession2, @NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResultProxy textLayoutResult) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)textInputSession2, (String)"textInputSession");
                Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
                Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
                Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
                LayoutCoordinates layoutCoordinates = textLayoutResult.getInnerTextFieldCoordinates();
                if (layoutCoordinates == null) break block2;
                LayoutCoordinates innerTextFieldCoordinates = layoutCoordinates;
                boolean bl = false;
                if (!innerTextFieldCoordinates.isAttached()) {
                    return;
                }
                LayoutCoordinates layoutCoordinates2 = textLayoutResult.getDecorationBoxCoordinates();
                if (layoutCoordinates2 != null) {
                    LayoutCoordinates decorationBoxCoordinates = layoutCoordinates2;
                    boolean bl2 = false;
                    textInputSession2.updateTextLayoutResult(textFieldValue, offsetMapping, textLayoutResult.getValue(), (Function1<? super Matrix, Unit>)((Function1)new Function1<Matrix, Unit>(innerTextFieldCoordinates){
                        final /* synthetic */ LayoutCoordinates $innerTextFieldCoordinates;
                        {
                            this.$innerTextFieldCoordinates = $innerTextFieldCoordinates;
                        }

                        public final void invoke-58bKbWc(float[] matrix) {
                            Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
                            if (this.$innerTextFieldCoordinates.isAttached()) {
                                LayoutCoordinatesKt.findRootCoordinates(this.$innerTextFieldCoordinates).transformFrom-EL8BTi8(this.$innerTextFieldCoordinates, matrix);
                            }
                        }
                    }), SelectionManagerKt.visibleBounds(innerTextFieldCoordinates), innerTextFieldCoordinates.localBoundingBoxOf(decorationBoxCoordinates, false));
                }
            }
        }

        @JvmStatic
        public final void onEditCommand$foundation(@NotNull List<? extends EditCommand> ops, @NotNull EditProcessor editProcessor, @NotNull Function1<? super TextFieldValue, Unit> onValueChange, @Nullable TextInputSession session2) {
            Intrinsics.checkNotNullParameter(ops, (String)"ops");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            TextFieldValue newValue = editProcessor.apply(ops);
            TextInputSession textInputSession2 = session2;
            if (textInputSession2 != null) {
                textInputSession2.updateState(null, newValue);
            }
            onValueChange.invoke((Object)newValue);
        }

        @JvmStatic
        public final void setCursorOffset-ULxng0E$foundation(long position, @NotNull TextLayoutResultProxy textLayoutResult, @NotNull EditProcessor editProcessor, @NotNull OffsetMapping offsetMapping, @NotNull Function1<? super TextFieldValue, Unit> onValueChange) {
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            int offset = offsetMapping.transformedToOriginal(TextLayoutResultProxy.getOffsetForPosition-3MmeM6k$default(textLayoutResult, position, false, 2, null));
            onValueChange.invoke((Object)TextFieldValue.copy-3r_uNRQ$default(editProcessor.toTextFieldValue(), null, TextRangeKt.TextRange(offset), null, 5, null));
        }

        @JvmStatic
        @NotNull
        public final TextInputSession restartInput$foundation(@NotNull TextInputService textInputService, @NotNull TextFieldValue value2, @NotNull EditProcessor editProcessor, @NotNull ImeOptions imeOptions, @NotNull Function1<? super TextFieldValue, Unit> onValueChange, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
            Intrinsics.checkNotNullParameter((Object)textInputService, (String)"textInputService");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            Ref.ObjectRef session2 = new Ref.ObjectRef();
            session2.element = textInputService.startInput(value2, imeOptions, (Function1<? super List<? extends EditCommand>, Unit>)((Function1)arg_0 -> Companion.restartInput$lambda$4(editProcessor, onValueChange, session2, arg_0)), onImeActionPerformed);
            return (TextInputSession)session2.element;
        }

        @JvmStatic
        @NotNull
        public final TextInputSession onFocus$foundation(@NotNull TextInputService textInputService, @NotNull TextFieldValue value2, @NotNull EditProcessor editProcessor, @NotNull ImeOptions imeOptions, @NotNull Function1<? super TextFieldValue, Unit> onValueChange, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
            Intrinsics.checkNotNullParameter((Object)textInputService, (String)"textInputService");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            return this.restartInput$foundation(textInputService, value2, editProcessor, imeOptions, onValueChange, onImeActionPerformed);
        }

        @JvmStatic
        public final void onBlur$foundation(@NotNull TextInputSession textInputSession2, @NotNull EditProcessor editProcessor, @NotNull Function1<? super TextFieldValue, Unit> onValueChange) {
            Intrinsics.checkNotNullParameter((Object)textInputSession2, (String)"textInputSession");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            onValueChange.invoke((Object)TextFieldValue.copy-3r_uNRQ$default(editProcessor.toTextFieldValue(), null, 0L, null, 3, null));
            textInputSession2.dispose();
        }

        @NotNull
        public final TransformedText applyCompositionDecoration-72CqOWE(long compositionRange, @NotNull TransformedText transformed2) {
            AnnotatedString.Builder builder;
            Intrinsics.checkNotNullParameter((Object)transformed2, (String)"transformed");
            int startPositionTransformed = transformed2.getOffsetMapping().originalToTransformed(TextRange.getStart-impl(compositionRange));
            int endPositionTransformed = transformed2.getOffsetMapping().originalToTransformed(TextRange.getEnd-impl(compositionRange));
            int start2 = Math.min(startPositionTransformed, endPositionTransformed);
            int coercedEnd = Math.max(startPositionTransformed, endPositionTransformed);
            AnnotatedString.Builder $this$applyCompositionDecoration_72CqOWE_u24lambda_u245 = builder = new AnnotatedString.Builder(transformed2.getText());
            boolean bl = false;
            $this$applyCompositionDecoration_72CqOWE_u24lambda_u245.addStyle(new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, TextDecoration.Companion.getUnderline(), null, null, null, 61439, null), start2, coercedEnd);
            OffsetMapping offsetMapping = transformed2.getOffsetMapping();
            AnnotatedString annotatedString = builder.toAnnotatedString();
            return new TransformedText(annotatedString, offsetMapping);
        }

        private static final IntSize notifyFocusedRect$lambda$1(TextDelegate $textDelegate) {
            return IntSize.box-impl(TextFieldDelegateKt.computeSizeForDefaultText$default($textDelegate.getStyle(), $textDelegate.getDensity(), $textDelegate.getFontFamilyResolver(), null, 0, 24, null));
        }

        private static final Unit restartInput$lambda$4(EditProcessor $editProcessor, Function1 $onValueChange, Ref.ObjectRef $session, List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.onEditCommand$foundation(it, $editProcessor, (Function1<? super TextFieldValue, Unit>)$onValueChange, (TextInputSession)$session.element);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

