/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.SpanStyle;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextAnnotatorScope {
    @NotNull
    private final AnnotatedString initialText;
    @NotNull
    private AnnotatedString styledText;

    public TextAnnotatorScope(@NotNull AnnotatedString initialText) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        this.styledText = this.initialText = initialText;
    }

    @NotNull
    public final AnnotatedString getStyledText() {
        return this.styledText;
    }

    public final void replaceStyle(@NotNull AnnotatedString.Range<LinkAnnotation> linkRange, @Nullable SpanStyle newStyle) {
        Intrinsics.checkNotNullParameter(linkRange, (String)"linkRange");
        Ref.BooleanRef linkFound = new Ref.BooleanRef();
        this.styledText = this.initialText.mapAnnotations((Function1<? super AnnotatedString.Range<? extends AnnotatedString.Annotation>, ? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>>)((Function1)arg_0 -> TextAnnotatorScope.replaceStyle$lambda$0(linkFound, linkRange, newStyle, arg_0)));
    }

    private static final AnnotatedString.Range replaceStyle$lambda$0(Ref.BooleanRef $linkFound, AnnotatedString.Range $linkRange, SpanStyle $newStyle, AnnotatedString.Range it) {
        AnnotatedString.Range range;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($linkFound.element && it.getItem() instanceof SpanStyle && it.getStart() == $linkRange.getStart() && it.getEnd() == $linkRange.getEnd()) {
            SpanStyle spanStyle = $newStyle;
            if (spanStyle == null) {
                spanStyle = new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65535, null);
            }
            range = new AnnotatedString.Range<SpanStyle>(spanStyle, it.getStart(), it.getEnd());
        } else {
            range = it;
        }
        AnnotatedString.Range annotation = range;
        $linkFound.element = Intrinsics.areEqual((Object)$linkRange, (Object)it);
        return annotation;
    }
}

