/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy;

import androidx.compose.foundation.gestures.snapping.LazyListSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfoKt;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.foundation.lazy.layout.LazyLayoutBeyondBoundsState;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

public final class LazyListBeyondBoundsState
implements LazyLayoutBeyondBoundsState {
    @NotNull
    private final LazyListState state;
    private final int beyondBoundsItemCount;

    public LazyListBeyondBoundsState(@NotNull LazyListState state2, int beyondBoundsItemCount) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.state = state2;
        this.beyondBoundsItemCount = beyondBoundsItemCount;
    }

    @Override
    public int getItemCount() {
        return this.state.getLayoutInfo().getTotalItemsCount();
    }

    @Override
    public boolean getHasVisibleItems() {
        return !((Collection)this.state.getLayoutInfo().getVisibleItemsInfo()).isEmpty();
    }

    @Override
    public int getFirstPlacedIndex() {
        return Math.max(0, this.state.getFirstVisibleItemIndex() - this.beyondBoundsItemCount);
    }

    @Override
    public int getLastPlacedIndex() {
        return Math.min(this.getItemCount() - 1, ((LazyListItemInfo)CollectionsKt.last(this.state.getLayoutInfo().getVisibleItemsInfo())).getIndex() + this.beyondBoundsItemCount);
    }

    @Override
    public int itemsPerViewport() {
        if (this.state.getLayoutInfo().getVisibleItemsInfo().isEmpty()) {
            return 0;
        }
        int viewportSize = LazyListSnapLayoutInfoProviderKt.getSingleAxisViewportSize(this.state.getLayoutInfo());
        int averageItemSize = LazyListLayoutInfoKt.visibleItemsAverageSize(this.state.getLayoutInfo());
        return RangesKt.coerceAtLeast((int)(viewportSize / averageItemSize), (int)1);
    }
}

