/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.AlignmentLineProvider;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CrossAxisAlignment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CrossAxisAlignment Center = CenterCrossAxisAlignment.INSTANCE;
    @NotNull
    private static final CrossAxisAlignment Start = StartCrossAxisAlignment.INSTANCE;
    @NotNull
    private static final CrossAxisAlignment End = EndCrossAxisAlignment.INSTANCE;

    private CrossAxisAlignment() {
    }

    public abstract int align$foundation_layout(int var1, @NotNull LayoutDirection var2, @NotNull Placeable var3, int var4);

    public boolean isRelative$foundation_layout() {
        return false;
    }

    @Nullable
    public Integer calculateAlignmentLinePosition$foundation_layout(@NotNull Placeable placeable) {
        Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
        return null;
    }

    public /* synthetic */ CrossAxisAlignment(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    private static final class AlignmentLineCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        private final AlignmentLineProvider alignmentLineProvider;

        public AlignmentLineCrossAxisAlignment(@NotNull AlignmentLineProvider alignmentLineProvider) {
            Intrinsics.checkNotNullParameter((Object)alignmentLineProvider, (String)"alignmentLineProvider");
            super(null);
            this.alignmentLineProvider = alignmentLineProvider;
        }

        @Override
        public boolean isRelative$foundation_layout() {
            return true;
        }

        @Override
        @NotNull
        public Integer calculateAlignmentLinePosition$foundation_layout(@NotNull Placeable placeable) {
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return this.alignmentLineProvider.calculateAlignmentLinePosition(placeable);
        }

        @Override
        public int align$foundation_layout(int size, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            int alignmentLinePosition = this.alignmentLineProvider.calculateAlignmentLinePosition(placeable);
            if (alignmentLinePosition != Integer.MIN_VALUE) {
                int line = beforeCrossAxisAlignmentLine - alignmentLinePosition;
                n = layoutDirection == LayoutDirection.Rtl ? size - line : line;
            } else {
                n = 0;
            }
            return n;
        }
    }

    private static final class CenterCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        public static final CenterCrossAxisAlignment INSTANCE = new CenterCrossAxisAlignment();

        private CenterCrossAxisAlignment() {
            super(null);
        }

        @Override
        public int align$foundation_layout(int size, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return size / 2;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CrossAxisAlignment Relative$foundation_layout(@NotNull AlignmentLineProvider alignmentLineProvider) {
            Intrinsics.checkNotNullParameter((Object)alignmentLineProvider, (String)"alignmentLineProvider");
            return new AlignmentLineCrossAxisAlignment(alignmentLineProvider);
        }

        @NotNull
        public final CrossAxisAlignment vertical$foundation_layout(@NotNull Alignment.Vertical vertical) {
            Intrinsics.checkNotNullParameter((Object)vertical, (String)"vertical");
            return new VerticalCrossAxisAlignment(vertical);
        }

        @NotNull
        public final CrossAxisAlignment horizontal$foundation_layout(@NotNull Alignment.Horizontal horizontal) {
            Intrinsics.checkNotNullParameter((Object)horizontal, (String)"horizontal");
            return new HorizontalCrossAxisAlignment(horizontal);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class EndCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        public static final EndCrossAxisAlignment INSTANCE = new EndCrossAxisAlignment();

        private EndCrossAxisAlignment() {
            super(null);
        }

        @Override
        public int align$foundation_layout(int size, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return layoutDirection == LayoutDirection.Ltr ? size : 0;
        }
    }

    private static final class HorizontalCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        private final Alignment.Horizontal horizontal;

        public HorizontalCrossAxisAlignment(@NotNull Alignment.Horizontal horizontal) {
            Intrinsics.checkNotNullParameter((Object)horizontal, (String)"horizontal");
            super(null);
            this.horizontal = horizontal;
        }

        @Override
        public int align$foundation_layout(int size, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return this.horizontal.align(0, size, layoutDirection);
        }

        @NotNull
        public String toString() {
            return "HorizontalCrossAxisAlignment(horizontal=" + this.horizontal + ")";
        }

        public int hashCode() {
            return this.horizontal.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HorizontalCrossAxisAlignment)) {
                return false;
            }
            HorizontalCrossAxisAlignment horizontalCrossAxisAlignment = (HorizontalCrossAxisAlignment)other;
            return Intrinsics.areEqual((Object)this.horizontal, (Object)horizontalCrossAxisAlignment.horizontal);
        }
    }

    private static final class StartCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        public static final StartCrossAxisAlignment INSTANCE = new StartCrossAxisAlignment();

        private StartCrossAxisAlignment() {
            super(null);
        }

        @Override
        public int align$foundation_layout(int size, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return layoutDirection == LayoutDirection.Ltr ? 0 : size;
        }
    }

    private static final class VerticalCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        private final Alignment.Vertical vertical;

        public VerticalCrossAxisAlignment(@NotNull Alignment.Vertical vertical) {
            Intrinsics.checkNotNullParameter((Object)vertical, (String)"vertical");
            super(null);
            this.vertical = vertical;
        }

        @Override
        public int align$foundation_layout(int size, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return this.vertical.align(0, size);
        }

        @NotNull
        public String toString() {
            return "VerticalCrossAxisAlignment(vertical=" + this.vertical + ")";
        }

        public int hashCode() {
            return this.vertical.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerticalCrossAxisAlignment)) {
                return false;
            }
            VerticalCrossAxisAlignment verticalCrossAxisAlignment = (VerticalCrossAxisAlignment)other;
            return Intrinsics.areEqual((Object)this.vertical, (Object)verticalCrossAxisAlignment.vertical);
        }
    }
}

