/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import androidx.compose.foundation.ScrollNode;
import androidx.compose.foundation.ScrollState;
import androidx.compose.ui.node.ModifierNodeElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScrollingLayoutElement
extends ModifierNodeElement<ScrollNode> {
    @NotNull
    private final ScrollState scrollState;
    private final boolean reverseScrolling;
    private final boolean isVertical;

    public ScrollingLayoutElement(@NotNull ScrollState scrollState, boolean reverseScrolling, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
        this.scrollState = scrollState;
        this.reverseScrolling = reverseScrolling;
        this.isVertical = isVertical;
    }

    @Override
    @NotNull
    public ScrollNode create() {
        return new ScrollNode(this.scrollState, this.reverseScrolling, this.isVertical);
    }

    @Override
    public void update(@NotNull ScrollNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setState(this.scrollState);
        node2.setReverseScrolling(this.reverseScrolling);
        node2.setVertical(this.isVertical);
    }

    public int hashCode() {
        int result2 = this.scrollState.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.reverseScrolling);
        result2 = 31 * result2 + Boolean.hashCode(this.isVertical);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ScrollingLayoutElement)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.scrollState, (Object)((ScrollingLayoutElement)other).scrollState) && this.reverseScrolling == ((ScrollingLayoutElement)other).reverseScrolling && this.isVertical == ((ScrollingLayoutElement)other).isVertical;
    }
}

