/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import androidx.compose.foundation.CheckScrollableContainerConstraintsKt;
import androidx.compose.foundation.ScrollState;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.node.LayoutModifierNode;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.unit.Constraints;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scroll.kt\nandroidx/compose/foundation/ScrollNode\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,485:1\n101#2,10:486\n*S KotlinDebug\n*F\n+ 1 Scroll.kt\nandroidx/compose/foundation/ScrollNode\n*L\n428#1:486,10\n*E\n"})
public final class ScrollNode
extends Modifier.Node
implements LayoutModifierNode,
SemanticsModifierNode {
    @NotNull
    private ScrollState state;
    private boolean reverseScrolling;
    private boolean isVertical;
    public static final int $stable = 8;

    public ScrollNode(@NotNull ScrollState state2, boolean reverseScrolling, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.state = state2;
        this.reverseScrolling = reverseScrolling;
        this.isVertical = isVertical;
    }

    public final void setState(@NotNull ScrollState scrollState) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"<set-?>");
        this.state = scrollState;
    }

    public final void setReverseScrolling(boolean bl) {
        this.reverseScrolling = bl;
    }

    public final void setVertical(boolean bl) {
        this.isVertical = bl;
    }

    @Override
    @NotNull
    public MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$measure_u2d3p2s80s, @NotNull Measurable measurable, long constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$this$measure");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        CheckScrollableContainerConstraintsKt.checkScrollableContainerConstraints-K40F9xA(constraints, this.isVertical ? Orientation.Vertical : Orientation.Horizontal);
        int n = this.isVertical ? Integer.MAX_VALUE : Constraints.getMaxHeight-impl(constraints);
        int n2 = this.isVertical ? Constraints.getMaxWidth-impl(constraints) : Integer.MAX_VALUE;
        long childConstraints = Constraints.copy-Zbe2FdA$default(constraints, 0, n2, 0, n, 5, null);
        Placeable placeable = measurable.measure-BRTryo0(childConstraints);
        int width = RangesKt.coerceAtMost((int)placeable.getWidth(), (int)Constraints.getMaxWidth-impl(constraints));
        int height = RangesKt.coerceAtMost((int)placeable.getHeight(), (int)Constraints.getMaxHeight-impl(constraints));
        int scrollHeight = placeable.getHeight() - height;
        int scrollWidth = placeable.getWidth() - width;
        int side = this.isVertical ? scrollHeight : scrollWidth;
        this.state.setMaxValue$foundation(side);
        this.state.setViewportSize$foundation(this.isVertical ? height : width);
        return MeasureScope.layout$default($this$measure_u2d3p2s80s, width, height, null, arg_0 -> ScrollNode.measure_3p2s80s$lambda$1(this, side, placeable, arg_0), 4, null);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return measurable.minIntrinsicWidth(this.isVertical ? Integer.MAX_VALUE : height);
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return measurable.minIntrinsicHeight(this.isVertical ? width : Integer.MAX_VALUE);
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return measurable.maxIntrinsicWidth(this.isVertical ? Integer.MAX_VALUE : height);
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return measurable.maxIntrinsicHeight(this.isVertical ? width : Integer.MAX_VALUE);
    }

    @Override
    public void applySemantics(@NotNull SemanticsPropertyReceiver $this$applySemantics) {
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        SemanticsPropertiesKt.setTraversalGroup($this$applySemantics, true);
        ScrollAxisRange accessibilityScrollState = new ScrollAxisRange((Function0<Float>)((Function0)() -> ScrollNode.applySemantics$lambda$2(this)), (Function0<Float>)((Function0)() -> ScrollNode.applySemantics$lambda$3(this)), this.reverseScrolling);
        if (this.isVertical) {
            SemanticsPropertiesKt.setVerticalScrollAxisRange($this$applySemantics, accessibilityScrollState);
        } else {
            SemanticsPropertiesKt.setHorizontalScrollAxisRange($this$applySemantics, accessibilityScrollState);
        }
    }

    private static final Unit measure_3p2s80s$lambda$1$lambda$0(Placeable $placeable, int $xOffset, int $yOffset, Placeable.PlacementScope $this$withMotionFrameOfReferencePlacement) {
        Intrinsics.checkNotNullParameter((Object)$this$withMotionFrameOfReferencePlacement, (String)"$this$withMotionFrameOfReferencePlacement");
        Placeable.PlacementScope.placeRelativeWithLayer$default($this$withMotionFrameOfReferencePlacement, $placeable, $xOffset, $yOffset, 0.0f, null, 12, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit measure_3p2s80s$lambda$1(ScrollNode this$0, int $side, Placeable $placeable, Placeable.PlacementScope $this$layout) {
        void $this$fastCoerceAtMost$iv$iv;
        void $this$fastCoerceIn$iv;
        Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
        int n = this$0.state.getValue();
        int minimumValue$iv = 0;
        boolean $i$f$fastCoerceIn = false;
        int $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < 0 ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        int scroll2 = $this$fastCoerceAtMost$iv$iv > $side ? $side : $this$fastCoerceAtMost$iv$iv;
        int absScroll = this$0.reverseScrolling ? scroll2 - $side : -scroll2;
        int xOffset = this$0.isVertical ? 0 : absScroll;
        int yOffset = this$0.isVertical ? absScroll : 0;
        $this$layout.withMotionFrameOfReferencePlacement((Function1<? super Placeable.PlacementScope, Unit>)((Function1)arg_0 -> ScrollNode.measure_3p2s80s$lambda$1$lambda$0($placeable, xOffset, yOffset, arg_0)));
        return Unit.INSTANCE;
    }

    private static final float applySemantics$lambda$2(ScrollNode this$0) {
        return this$0.state.getValue();
    }

    private static final float applySemantics$lambda$3(ScrollNode this$0) {
        return this$0.state.getMaxValue();
    }
}

