/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationKt;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animation.kt\nandroidx/compose/animation/core/TargetBasedAnimation\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,497:1\n53#2,4:498\n1#3:502\n*S KotlinDebug\n*F\n+ 1 Animation.kt\nandroidx/compose/animation/core/TargetBasedAnimation\n*L\n274#1:498,4\n*E\n"})
public final class TargetBasedAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    @NotNull
    private final VectorizedAnimationSpec<V> animationSpec;
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    private T mutableTargetValue;
    private T mutableInitialValue;
    @NotNull
    private V initialValueVector;
    @NotNull
    private V targetValueVector;
    @NotNull
    private final V initialVelocityVector;
    private long _durationNanos;
    @Nullable
    private V _endVelocity;
    public static final int $stable = 8;

    public TargetBasedAnimation(@NotNull VectorizedAnimationSpec<V> animationSpec, @NotNull TwoWayConverter<T, V> typeConverter, T initialValue, T targetValue, @Nullable V initialVelocityVector) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        this.animationSpec = animationSpec;
        this.typeConverter = typeConverter;
        this.mutableTargetValue = targetValue;
        this.mutableInitialValue = initialValue;
        this.initialValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke(initialValue);
        this.targetValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke(targetValue);
        Object object = initialVelocityVector;
        if (object == null || (object = AnimationVectorsKt.copy(object)) == null) {
            object = AnimationVectorsKt.newInstance((AnimationVector)this.getTypeConverter().getConvertToVector().invoke(initialValue));
        }
        this.initialVelocityVector = object;
        this._durationNanos = -1L;
    }

    @Override
    @NotNull
    public TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    public final T getInitialValue() {
        return this.mutableInitialValue;
    }

    @Override
    public T getTargetValue() {
        return this.mutableTargetValue;
    }

    public TargetBasedAnimation(@NotNull AnimationSpec<T> animationSpec, @NotNull TwoWayConverter<T, V> typeConverter, T initialValue, T targetValue, @Nullable V initialVelocityVector) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        this(animationSpec.vectorize(typeConverter), typeConverter, initialValue, targetValue, initialVelocityVector);
    }

    public /* synthetic */ TargetBasedAnimation(AnimationSpec animationSpec, TwoWayConverter twoWayConverter, Object object, Object object2, AnimationVector animationVector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            animationVector = null;
        }
        this(animationSpec, twoWayConverter, object, object2, animationVector);
    }

    @Override
    public boolean isInfinite() {
        return this.animationSpec.isInfinite();
    }

    @Override
    public T getValueFromNanos(long playTimeNanos) {
        Object object;
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            V it = this.animationSpec.getValueFromNanos(playTimeNanos, this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
            boolean bl = false;
            int n = ((AnimationVector)it).getSize$animation_core();
            for (int i2 = 0; i2 < n; ++i2) {
                boolean value$iv = !Float.isNaN(((AnimationVector)it).get$animation_core(i2));
                boolean $i$f$checkPrecondition = false;
                if (value$iv) continue;
                boolean bl2 = false;
                PreconditionsKt.throwIllegalStateException("AnimationVector cannot contain a NaN. " + it + ". Animation: " + this + ", playTimeNanos: " + playTimeNanos);
            }
            object = this.getTypeConverter().getConvertFromVector().invoke(it);
        } else {
            object = this.getTargetValue();
        }
        return object;
    }

    @Override
    public long getDurationNanos() {
        if (this._durationNanos < 0L) {
            this._durationNanos = this.animationSpec.getDurationNanos(this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
        }
        return this._durationNanos;
    }

    private final V getEndVelocity() {
        V v = this._endVelocity;
        if (v == null) {
            V v2;
            V it = v2 = this.animationSpec.getEndVelocity(this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
            boolean bl = false;
            this._endVelocity = it;
            v = v2;
        }
        return v;
    }

    @Override
    @NotNull
    public V getVelocityVectorFromNanos(long playTimeNanos) {
        return !this.isFinishedFromNanos(playTimeNanos) ? this.animationSpec.getVelocityFromNanos(playTimeNanos, this.initialValueVector, this.targetValueVector, this.initialVelocityVector) : this.getEndVelocity();
    }

    @NotNull
    public String toString() {
        return "TargetBasedAnimation: " + this.getInitialValue() + " -> " + this.getTargetValue() + ",initial velocity: " + this.initialVelocityVector + ", duration: " + AnimationKt.getDurationMillis(this) + " ms,animationSpec: " + this.animationSpec;
    }
}

