/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedSpringSpec;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringSpec<T>
implements FiniteAnimationSpec<T> {
    private final float dampingRatio;
    private final float stiffness;
    @Nullable
    private final T visibilityThreshold;

    public SpringSpec(float dampingRatio, float stiffness, @Nullable T visibilityThreshold) {
        this.dampingRatio = dampingRatio;
        this.stiffness = stiffness;
        this.visibilityThreshold = visibilityThreshold;
    }

    public /* synthetic */ SpringSpec(float f, float f2, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1500.0f;
        }
        if ((n & 4) != 0) {
            object = null;
        }
        this(f, f2, object);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final float getStiffness() {
        return this.stiffness;
    }

    @Nullable
    public final T getVisibilityThreshold() {
        return this.visibilityThreshold;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedSpringSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new VectorizedSpringSpec<AnimationVector>(this.dampingRatio, this.stiffness, AnimationSpecKt.access$convert(converter, this.visibilityThreshold));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof SpringSpec ? ((SpringSpec)other).dampingRatio == this.dampingRatio && ((SpringSpec)other).stiffness == this.stiffness && Intrinsics.areEqual(((SpringSpec)other).visibilityThreshold, this.visibilityThreshold) : false;
    }

    public int hashCode() {
        T t2 = this.visibilityThreshold;
        return ((t2 != null ? t2.hashCode() : 0) * 31 + Float.hashCode(this.dampingRatio)) * 31 + Float.hashCode(this.stiffness);
    }

    public SpringSpec() {
        this(0.0f, 0.0f, null, 7, null);
    }
}

