/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Motion;
import androidx.compose.animation.core.PreconditionsKt;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nSpringSimulation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulation\n+ 2 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulationKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,152:1\n38#2:153\n53#3,3:154\n*S KotlinDebug\n*F\n+ 1 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulation\n*L\n149#1:153\n149#1:154,3\n*E\n"})
public final class SpringSimulation {
    private float finalPosition;
    private double naturalFreq;
    private float dampingRatio;
    public static final int $stable = 8;

    public SpringSimulation(float finalPosition) {
        this.finalPosition = finalPosition;
        this.naturalFreq = Math.sqrt(50.0);
        this.dampingRatio = 1.0f;
    }

    public final void setFinalPosition(float f) {
        this.finalPosition = f;
    }

    public final float getStiffness() {
        return (float)(this.naturalFreq * this.naturalFreq);
    }

    public final void setStiffness(float value2) {
        if (this.getStiffness() <= 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.naturalFreq = Math.sqrt(value2);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final void setDampingRatio(float value2) {
        if (value2 < 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Damping ratio must be non-negative");
        }
        this.dampingRatio = value2;
    }

    public final long updateValues-IJZedt4$animation_core(float lastDisplacement, float lastVelocity, long timeElapsed) {
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double deltaT = (double)timeElapsed / 1000.0;
        double dampingRatioSquared = (double)this.dampingRatio * (double)this.dampingRatio;
        double r = (double)(-this.dampingRatio) * this.naturalFreq;
        double displacement = 0.0;
        double currentVelocity = 0.0;
        if (this.dampingRatio > 1.0f) {
            double s = this.naturalFreq * Math.sqrt(dampingRatioSquared - 1.0);
            double gammaPlus = r + s;
            double gammaMinus = r - s;
            double coeffB = (gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (gammaMinus - gammaPlus);
            double coeffA = (double)adjustedDisplacement - coeffB;
            displacement = coeffA * Math.exp(gammaMinus * deltaT) + coeffB * Math.exp(gammaPlus * deltaT);
            currentVelocity = coeffA * gammaMinus * Math.exp(gammaMinus * deltaT) + coeffB * gammaPlus * Math.exp(gammaPlus * deltaT);
        } else if (this.dampingRatio == 1.0f) {
            float coeffA = adjustedDisplacement;
            double coeffB = (double)lastVelocity + this.naturalFreq * (double)adjustedDisplacement;
            double nFdT = -this.naturalFreq * deltaT;
            displacement = ((double)coeffA + coeffB * deltaT) * Math.exp(nFdT);
            currentVelocity = ((double)coeffA + coeffB * deltaT) * Math.exp(nFdT) * -this.naturalFreq + coeffB * Math.exp(nFdT);
        } else {
            double dampedFreq = this.naturalFreq * Math.sqrt(1.0 - dampingRatioSquared);
            float cosCoeff = adjustedDisplacement;
            double sinCoeff = 1.0 / dampedFreq * (-r * (double)adjustedDisplacement + (double)lastVelocity);
            double dFdT = dampedFreq * deltaT;
            displacement = Math.exp(r * deltaT) * ((double)cosCoeff * Math.cos(dFdT) + sinCoeff * Math.sin(dFdT));
            currentVelocity = displacement * r + Math.exp(r * deltaT) * (-dampedFreq * (double)cosCoeff * Math.sin(dFdT) + dampedFreq * sinCoeff * Math.cos(dFdT));
        }
        float newValue = (float)(displacement + (double)this.finalPosition);
        float newVelocity = (float)currentVelocity;
        boolean $i$f$Motion = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits(newValue);
        long v2$iv$iv = Float.floatToRawIntBits(newVelocity);
        return Motion.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }
}

