/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.RestrictTo;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nSpringEstimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,347:1\n346#1:348\n346#1:350\n343#1:352\n346#1:353\n346#1:355\n343#1:357\n150#2:349\n150#2:351\n150#2:354\n150#2:356\n150#2:358\n*S KotlinDebug\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n*L\n172#1:348\n173#1:350\n213#1:352\n247#1:353\n248#1:355\n293#1:357\n172#1:349\n173#1:351\n247#1:354\n248#1:356\n346#1:358\n*E\n"})
public final class SpringEstimationKt {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final long estimateAnimationDurationMillis(float stiffness, float dampingRatio, float initialVelocity, float initialDisplacement, float delta) {
        if (dampingRatio == 0.0f) {
            return 9223372036854L;
        }
        return SpringEstimationKt.estimateAnimationDurationMillis((double)stiffness, (double)dampingRatio, (double)initialVelocity, (double)initialDisplacement, (double)delta);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialDisplacement, double delta) {
        double dampingCoefficient = 2.0 * dampingRatio * Math.sqrt(stiffness);
        double partialRoot = dampingCoefficient * dampingCoefficient - 4.0 * stiffness;
        double partialRootReal = partialRoot < 0.0 ? 0.0 : Math.sqrt(partialRoot);
        double partialRootImaginary = partialRoot < 0.0 ? Math.sqrt(Math.abs(partialRoot)) : 0.0;
        double firstRootReal = (-dampingCoefficient + partialRootReal) * 0.5;
        double firstRootImaginary = partialRootImaginary * 0.5;
        double secondRootReal = (-dampingCoefficient - partialRootReal) * 0.5;
        return SpringEstimationKt.estimateDurationInternal(firstRootReal, firstRootImaginary, secondRootReal, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    private static final double estimateUnderDamped(double firstRootReal, double firstRootImaginary, double p0, double v0, double delta) {
        double r = firstRootReal;
        double c1 = p0;
        double c2 = (v0 - r * c1) / firstRootImaginary;
        double c = Math.sqrt(c1 * c1 + c2 * c2);
        return Math.log(delta / c) / r;
    }

    private static final double estimateCriticallyDamped(double firstRootReal, double p0, double v0, double delta) {
        double d;
        double d2;
        double guess;
        double r = firstRootReal;
        double c1 = p0;
        double c2 = v0 - r * c1;
        double t1 = Math.log(Math.abs(delta / c1)) / r;
        boolean bl = false;
        double t2 = guess = Math.log(Math.abs(delta / c2));
        for (int i2 = 0; i2 < 6; ++i2) {
            t2 = guess - Math.log(Math.abs(t2 / r));
        }
        double t22 = t2 / r;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
        boolean $i$f$fastIsFinite = false;
        if (!((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L)) {
            d2 = t22;
        } else {
            $this$isNotFinite$iv = t22;
            $i$f$isNotFinite = false;
            $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
            $i$f$fastIsFinite = false;
            d2 = !((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? t1 : Math.max(t1, t22);
        }
        double tCurr = d2;
        double tInflection = -(r * c1 + c2) / (r * c2);
        double xInflection = c1 * Math.exp(r * tInflection) + c2 * tInflection * Math.exp(r * tInflection);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -xInflection < delta) {
            if (c2 < 0.0 && c1 > 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            double tConcavChange;
            tCurr = tConcavChange = -(2.0 / r) - c1 / c2;
            d = delta;
        }
        double signedDelta = d;
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t3;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            double d3 = tCurr;
            double d4 = tCurr;
            boolean bl2 = false;
            double d5 = (c1 + c2 * t3) * Math.exp(r * t3) + signedDelta;
            t3 = tCurr;
            boolean bl3 = false;
            double d6 = (c2 * (r * t3 + 1.0) + c1 * r) * Math.exp(r * t3);
            tCurr = d4 - d5 / d6;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final double estimateOverDamped(double firstRootReal, double secondRootReal, double p0, double v0, double delta) {
        double signedDelta;
        double d;
        double d2;
        double r1 = firstRootReal;
        double r2 = secondRootReal;
        double c2 = (r1 * p0 - v0) / (r1 - r2);
        double c1 = p0 - c2;
        double t1 = Math.log(Math.abs(delta / c1)) / r1;
        double t2 = Math.log(Math.abs(delta / c2)) / r2;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
        boolean $i$f$fastIsFinite = false;
        if (!((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L)) {
            d2 = t2;
        } else {
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            $this$fastIsFinite$iv$iv = $this$isNotFinite$iv;
            $i$f$fastIsFinite = false;
            d2 = !((Double.doubleToRawLongBits($this$fastIsFinite$iv$iv) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = Math.log(c1 * r1 / (-c2 * r2)) / (r2 - r1);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -SpringEstimationKt.estimateOverDamped$xInflection(c1, r1, tInflection, c2, r2) < delta) {
            if (c2 > 0.0 && c1 < 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            tCurr = Math.log(-(c2 * r2 * r2) / (c1 * r1 * r1)) / (r1 - r2);
            d = signedDelta = delta;
        }
        if (Math.abs(c1 * r1 * Math.exp(r1 * tCurr) + c2 * r2 * Math.exp(r2 * tCurr)) < 1.0E-4) {
            return tCurr;
        }
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t3;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            double d3 = tCurr;
            double d4 = tCurr;
            boolean bl = false;
            double d5 = c1 * Math.exp(r1 * t3) + c2 * Math.exp(r2 * t3) + signedDelta;
            t3 = tCurr;
            boolean bl2 = false;
            double d6 = c1 * r1 * Math.exp(r1 * t3) + c2 * r2 * Math.exp(r2 * t3);
            tCurr = d4 - d5 / d6;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final long estimateDurationInternal(double firstRootReal, double firstRootImaginary, double secondRootReal, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : initialVelocity;
        double p0 = Math.abs(initialPosition);
        return (long)((dampingRatio > 1.0 ? SpringEstimationKt.estimateOverDamped(firstRootReal, secondRootReal, p0, v0, delta) : (dampingRatio < 1.0 ? SpringEstimationKt.estimateUnderDamped(firstRootReal, firstRootImaginary, p0, v0, delta) : SpringEstimationKt.estimateCriticallyDamped(firstRootReal, p0, v0, delta))) * 1000.0);
    }

    private static final double estimateOverDamped$xInflection(double c1, double r1, double tInflection, double c2, double r2) {
        return c1 * Math.exp(r1 * tInflection) + c2 * Math.exp(r2 * tInflection);
    }
}

