/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

public final class DecayAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    @NotNull
    private final VectorizedDecayAnimationSpec<V> animationSpec;
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    private final T initialValue;
    @NotNull
    private final V initialValueVector;
    @NotNull
    private final V initialVelocityVector;
    @NotNull
    private final V endVelocity;
    private final T targetValue;
    private final long durationNanos;
    private final boolean isInfinite;

    public DecayAnimation(@NotNull VectorizedDecayAnimationSpec<V> animationSpec, @NotNull TwoWayConverter<T, V> typeConverter, T initialValue, @NotNull V initialVelocityVector) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
        this.animationSpec = animationSpec;
        this.typeConverter = typeConverter;
        this.initialValue = initialValue;
        this.initialValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke(this.initialValue);
        this.initialVelocityVector = AnimationVectorsKt.copy(initialVelocityVector);
        this.targetValue = this.getTypeConverter().getConvertFromVector().invoke(this.animationSpec.getTargetValue(this.initialValueVector, initialVelocityVector));
        this.durationNanos = this.animationSpec.getDurationNanos(this.initialValueVector, initialVelocityVector);
        this.endVelocity = AnimationVectorsKt.copy(this.animationSpec.getVelocityFromNanos(this.getDurationNanos(), this.initialValueVector, initialVelocityVector));
        int n = ((AnimationVector)this.endVelocity).getSize$animation_core();
        for (int i2 = 0; i2 < n; ++i2) {
            ((AnimationVector)this.endVelocity).set$animation_core(i2, RangesKt.coerceIn((float)((AnimationVector)this.endVelocity).get$animation_core(i2), (float)(-this.animationSpec.getAbsVelocityThreshold()), (float)this.animationSpec.getAbsVelocityThreshold()));
        }
    }

    @Override
    @NotNull
    public TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public T getTargetValue() {
        return this.targetValue;
    }

    @Override
    public long getDurationNanos() {
        return this.durationNanos;
    }

    @Override
    public boolean isInfinite() {
        return this.isInfinite;
    }

    public DecayAnimation(@NotNull DecayAnimationSpec<T> animationSpec, @NotNull TwoWayConverter<T, V> typeConverter, T initialValue, @NotNull V initialVelocityVector) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
        this(animationSpec.vectorize(typeConverter), typeConverter, initialValue, initialVelocityVector);
    }

    @Override
    public T getValueFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            return (T)this.getTypeConverter().getConvertFromVector().invoke(this.animationSpec.getValueFromNanos(playTimeNanos, this.initialValueVector, this.initialVelocityVector));
        }
        return this.getTargetValue();
    }

    @Override
    @NotNull
    public V getVelocityVectorFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            return this.animationSpec.getVelocityFromNanos(playTimeNanos, this.initialValueVector, this.initialVelocityVector);
        }
        return this.endVelocity;
    }
}

