/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.ArcSplineKt;
import androidx.compose.animation.core.internal.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nArcSpline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline\n+ 2 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n+ 3 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,393:1\n223#2:394\n226#2:395\n274#2:396\n278#2:397\n274#2:398\n278#2:399\n223#2:410\n226#2:411\n65#3,10:400\n*S KotlinDebug\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline\n*L\n116#1:394\n117#1:395\n120#1:396\n121#1:397\n146#1:398\n147#1:399\n175#1:410\n176#1:411\n163#1:400,10\n*E\n"})
public final class ArcSpline {
    @NotNull
    private final Arc[][] arcs;
    private final boolean isExtrapolate;
    public static final int $stable = 8;

    public ArcSpline(@NotNull int[] arcModes, @NotNull float[] timePoints, @NotNull float[][] y) {
        Intrinsics.checkNotNullParameter((Object)arcModes, (String)"arcModes");
        Intrinsics.checkNotNullParameter((Object)timePoints, (String)"timePoints");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.isExtrapolate = true;
        int mode = 1;
        int last = 1;
        int n = timePoints.length - 1;
        Arc[][] arcArrayArray = new Arc[n][];
        ArcSpline arcSpline = this;
        for (int j = 0; j < n; ++j) {
            int n2 = j;
            switch (arcModes[n2]) {
                case 1: {
                    last = mode = 1;
                    break;
                }
                case 2: {
                    last = mode = 2;
                    break;
                }
                case 3: {
                    last = mode = last == 1 ? 2 : 1;
                    break;
                }
                case 0: {
                    mode = 3;
                    break;
                }
                case 5: {
                    mode = 5;
                    break;
                }
                case 4: {
                    mode = 4;
                }
            }
            float[] yArray = y[n2];
            float[] yArray1 = y[n2 + 1];
            float timeArray = timePoints[n2];
            float timeArray1 = timePoints[n2 + 1];
            int dim = yArray.length / 2 + yArray.length % 2;
            int n3 = 0;
            Arc[] arcArray = new Arc[dim];
            int n4 = n2;
            Arc[][] arcArrayArray2 = arcArrayArray;
            while (n3 < dim) {
                int n5 = n3++;
                int k = n5 * 2;
                arcArray[n5] = new Arc(mode, timeArray, timeArray1, yArray[k], yArray[k + 1], yArray1[k], yArray1[k + 1]);
            }
            arcArrayArray2[n4] = arcArray;
        }
        arcSpline.arcs = arcArrayArray;
    }

    public final void getPos(float time2, @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float t2 = time2;
        Arc[][] arcs = this.arcs;
        int lastIndex = ((Object[])arcs).length - 1;
        float start2 = arcs[0][0].getTime1();
        float end = arcs[lastIndex][0].getTime2();
        int size = v.length;
        if (this.isExtrapolate) {
            if (t2 < start2 || t2 > end) {
                int p = 0;
                float t0 = 0.0f;
                if (t2 > end) {
                    p = lastIndex;
                    t0 = end;
                } else {
                    p = 0;
                    t0 = start2;
                }
                float dt = t2 - t0;
                int i2 = 0;
                int j = 0;
                while (i2 < size - 1) {
                    Arc this_$iv;
                    Arc arc = arcs[p][j];
                    if (arc.isLinear) {
                        this_$iv = arc;
                        boolean $i$f$getLinearDX$animation_core = false;
                        v[i2] = arc.getLinearX(t0) + dt * this_$iv.ellipseCenterX;
                        this_$iv = arc;
                        boolean $i$f$getLinearDY$animation_core = false;
                        v[i2 + 1] = arc.getLinearY(t0) + dt * this_$iv.ellipseCenterY;
                    } else {
                        arc.setPoint(t0);
                        this_$iv = arc;
                        boolean $i$f$calcX = false;
                        v[i2] = this_$iv.ellipseCenterX + this_$iv.ellipseA * this_$iv.tmpSinAngle + dt * arc.calcDX();
                        this_$iv = arc;
                        boolean $i$f$calcY = false;
                        v[i2 + 1] = this_$iv.ellipseCenterY + this_$iv.ellipseB * this_$iv.tmpCosAngle + dt * arc.calcDY();
                    }
                    i2 += 2;
                    ++j;
                }
                return;
            }
        } else {
            t2 = Math.max(t2, start2);
            t2 = Math.min(t2, end);
        }
        boolean populated = false;
        int n = ((Object[])arcs).length;
        for (int i3 = 0; i3 < n; ++i3) {
            int k = 0;
            int j = 0;
            while (j < size - 1) {
                Arc arc = arcs[i3][k];
                if (t2 <= arc.getTime2()) {
                    if (arc.isLinear) {
                        v[j] = arc.getLinearX(t2);
                        v[j + 1] = arc.getLinearY(t2);
                    } else {
                        arc.setPoint(t2);
                        Arc this_$iv = arc;
                        boolean $i$f$calcX = false;
                        v[j] = this_$iv.ellipseCenterX + this_$iv.ellipseA * this_$iv.tmpSinAngle;
                        this_$iv = arc;
                        boolean $i$f$calcY = false;
                        v[j + 1] = this_$iv.ellipseCenterY + this_$iv.ellipseB * this_$iv.tmpCosAngle;
                    }
                    populated = true;
                }
                j += 2;
                ++k;
            }
            if (!populated) continue;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void getSlope(float time2, @NotNull float[] v) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Arc[][] arcs = this.arcs;
        float f = time2;
        float f2 = arcs[0][0].getTime1();
        float maximumValue$iv = arcs[((Object[])arcs).length - 1][0].getTime2();
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float t2 = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
        int size = v.length;
        boolean populated = false;
        int n = ((Object[])arcs).length;
        for (int i2 = 0; i2 < n; ++i2) {
            int j = 0;
            int k = 0;
            while (j < size - 1) {
                Arc arc = arcs[i2][k];
                if (t2 <= arc.getTime2()) {
                    if (arc.isLinear) {
                        Arc this_$iv = arc;
                        boolean $i$f$getLinearDX$animation_core = false;
                        v[j] = this_$iv.ellipseCenterX;
                        this_$iv = arc;
                        boolean $i$f$getLinearDY$animation_core = false;
                        v[j + 1] = this_$iv.ellipseCenterY;
                    } else {
                        arc.setPoint(t2);
                        v[j] = arc.calcDX();
                        v[j + 1] = arc.calcDY();
                    }
                    populated = true;
                }
                j += 2;
                ++k;
            }
            if (!populated) continue;
            return;
        }
    }

    @SourceDebugExtension(value={"SMAP\nArcSpline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n+ 2 ArcSpline.kt\nandroidx/compose/animation/core/ArcSplineKt\n*L\n1#1,393:1\n269#1,2:394\n392#2:396\n*S KotlinDebug\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n*L\n263#1:394,2\n335#1:396\n*E\n"})
    public static final class Arc {
        private final float time1;
        private final float time2;
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private float arcDistance;
        private float tmpSinAngle;
        private float tmpCosAngle;
        @NotNull
        private final float[] lut;
        private final float oneOverDeltaTime;
        private final float arcVelocity;
        private final float vertical;
        @JvmField
        public final float ellipseA;
        @JvmField
        public final float ellipseB;
        @JvmField
        public final boolean isLinear;
        @JvmField
        public final float ellipseCenterX;
        @JvmField
        public final float ellipseCenterY;
        public static final int $stable = 8;

        public Arc(int mode, float time1, float time2, float x1, float y1, float x2, float y2) {
            boolean isLinear;
            boolean bl;
            this.time1 = time1;
            this.time2 = time2;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            float dx = this.x2 - this.x1;
            float dy = this.y2 - this.y1;
            switch (mode) {
                case 1: {
                    bl = true;
                    break;
                }
                case 5: {
                    if (dy < 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (dy > 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean isVertical = bl;
            this.vertical = isVertical ? -1.0f : 1.0f;
            this.oneOverDeltaTime = 1.0f / (this.time2 - this.time1);
            this.lut = new float[101];
            boolean bl2 = isLinear = mode == 3;
            if (isLinear || Math.abs(dx) < 0.001f || Math.abs(dy) < 0.001f) {
                isLinear = true;
                this.arcDistance = (float)Math.hypot(dy, dx);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
                this.ellipseCenterX = dx * this.oneOverDeltaTime;
                this.ellipseCenterY = dy * this.oneOverDeltaTime;
                this.ellipseA = Float.NaN;
                this.ellipseB = Float.NaN;
            } else {
                this.ellipseA = dx * this.vertical;
                this.ellipseB = dy * -this.vertical;
                this.ellipseCenterX = isVertical ? this.x2 : this.x1;
                this.ellipseCenterY = isVertical ? this.y1 : this.y2;
                this.buildTable$animation_core(this.x1, this.y1, this.x2, this.y2);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
            }
            this.isLinear = isLinear;
        }

        public final float getTime1() {
            return this.time1;
        }

        public final float getTime2() {
            return this.time2;
        }

        public final void setPoint(float time2) {
            Arc this_$iv = this;
            boolean $i$f$calcAngle = false;
            float percent$iv = (this_$iv.vertical == -1.0f ? this_$iv.time2 - time2 : time2 - this_$iv.time1) * this_$iv.oneOverDeltaTime;
            float angle = 1.5707964f * this_$iv.lookup(percent$iv);
            this.tmpSinAngle = (float)Math.sin(angle);
            this.tmpCosAngle = (float)Math.cos(angle);
        }

        public final float calcDX() {
            float vx = this.ellipseA * this.tmpCosAngle;
            float vy = -this.ellipseB * this.tmpSinAngle;
            float norm = this.arcVelocity / (float)Math.hypot(vx, vy);
            return vx * this.vertical * norm;
        }

        public final float calcDY() {
            float vx = this.ellipseA * this.tmpCosAngle;
            float vy = -this.ellipseB * this.tmpSinAngle;
            float norm = this.arcVelocity / (float)Math.hypot(vx, vy);
            return vy * this.vertical * norm;
        }

        public final float getLinearX(float time2) {
            float t2 = time2;
            t2 = (t2 - this.time1) * this.oneOverDeltaTime;
            return this.x1 + t2 * (this.x2 - this.x1);
        }

        public final float getLinearY(float time2) {
            float t2 = time2;
            t2 = (t2 - this.time1) * this.oneOverDeltaTime;
            return this.y1 + t2 * (this.y2 - this.y1);
        }

        private final float lookup(float v) {
            if (v <= 0.0f) {
                return 0.0f;
            }
            if (v >= 1.0f) {
                return 1.0f;
            }
            float pos = v * (float)100;
            int iv = (int)pos;
            float off = pos - (float)((int)pos);
            return this.lut[iv] + off * (this.lut[iv + 1] - this.lut[iv]);
        }

        public final void buildTable$animation_core(float x1, float y1, float x2, float y2) {
            float a = x2 - x1;
            float b = y1 - y2;
            float lx = 0.0f;
            float ly = b;
            float dist = 0.0f;
            float[] ourPercent = ArcSplineKt.access$getOurPercentCache$p();
            int lastIndex = ourPercent.length - 1;
            float lastIndexFloat = lastIndex;
            float[] lut = this.lut;
            int i2 = 1;
            if (i2 <= lastIndex) {
                while (true) {
                    double value$iv = 90.0 * (double)i2 / (double)lastIndex;
                    boolean $i$f$toRadians = false;
                    float angle = (float)(value$iv * (Math.PI / 180));
                    float s = (float)Math.sin(angle);
                    float c = (float)Math.cos(angle);
                    float px = a * s;
                    float py = b * c;
                    ourPercent[i2] = dist += (float)Math.hypot(px - lx, py - ly);
                    lx = px;
                    ly = py;
                    if (i2 == lastIndex) break;
                    ++i2;
                }
            }
            this.arcDistance = dist;
            i2 = 1;
            if (i2 <= lastIndex) {
                do {
                    int angle = ++i2;
                    ourPercent[angle] = ourPercent[angle] / dist;
                } while (i2 != lastIndex);
            }
            float lutLastIndex = 100.0f;
            int n = lut.length;
            for (int i3 = 0; i3 < n; ++i3) {
                float ans;
                float pos = (float)i3 / lutLastIndex;
                int index = ArraysKt.binarySearch$default(ourPercent, pos, 0, 0, 6, null);
                if (index >= 0) {
                    lut[i3] = (float)index / lastIndexFloat;
                    continue;
                }
                if (index == -1) {
                    lut[i3] = 0.0f;
                    continue;
                }
                int p1 = -index - 2;
                int p2 = -index - 1;
                lut[i3] = ans = ((float)p1 + (pos - ourPercent[p1]) / (ourPercent[p2] - ourPercent[p1])) / lastIndexFloat;
            }
        }
    }
}

